/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.formplugin.business;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListColumn;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.bd.util.ObjectCloneUtils;

public class BusinessItemListPlugin
extends AbstractTreeListPlugin
implements IConfirmCallBack {
    private static Map<String, String> permissionMap = new HashMap<String, String>(3);

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setButtonVisible();
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)this.getSelectedFirstRowKey();
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        if (permissionMap.containsKey(itemKey)) {
            if (selectedRows == null || selectedRows.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"BusinessItemListPlugin_2", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!this.permission(itemKey)) {
                if (itemKey.equals("bar_reldept")) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5f53\u524d\u7ec4\u7ec7\u4e0b\u201c\u62a5\u8d26\u4e1a\u52a1\u7c7b\u578b\u201d\u7684\u201c\u5173\u8054\u90e8\u95e8\u201d\u7684\u6743\u9650\u3002", (String)"BusinessItemListPlugin_3", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                }
                if (itemKey.equals("bar_setrelation")) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5f53\u524d\u7ec4\u7ec7\u4e0b\u201c\u62a5\u8d26\u4e1a\u52a1\u7c7b\u578b\u201d\u7684\u201c\u5173\u8054\u5355\u636e\u201d\u7684\u6743\u9650\u3002", (String)"BusinessItemListPlugin_4", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                }
                if (itemKey.equals("bar_relexpenseitem")) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5f53\u524d\u7ec4\u7ec7\u4e0b\u201c\u62a5\u8d26\u4e1a\u52a1\u7c7b\u578b\u201d\u7684\u201c\u5173\u8054\u4e1a\u52a1\u9879\u76ee\u201d\u7684\u6743\u9650\u3002", (String)"BusinessItemListPlugin_5", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                }
                return;
            }
        }
        FormShowParameter showParameter = new FormShowParameter();
        switch (itemKey) {
            case "bar_relexpenseitem": {
                this.createFormShowParameter("bd_busitemrelexp_setting", showParameter, selectedRows);
                showParameter.setCustomParam("useorg", (Object)this.getPageCache().get("useorg"));
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bd_busitemrelexp_setting"));
                this.getView().showForm(showParameter);
                break;
            }
            case "bar_reldept": {
                this.createFormShowParameter("bd_busitemreldept_setting", showParameter, selectedRows);
                this.addOrgToParam(showParameter, rootOrgId);
                this.getView().showForm(showParameter);
                break;
            }
            case "bar_setrelation": {
                this.createFormShowParameter("bd_busitembill_setting", showParameter, selectedRows);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bd_busitembill_setting"));
                showParameter.setStatus(OperationStatus.EDIT);
                this.getView().showForm(showParameter);
                break;
            }
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        final String useOrg = this.getPageCache().get("useorg");
        if (this.isRelExpenseItem() && StringUtils.isNotEmpty((CharSequence)useOrg)) {
            super.beforeCreateListDataProvider(args);
            args.setListDataProvider((IListDataProvider)new ListDataProvider(){

                public DynamicObjectCollection getData(int start, int limit) {
                    DynamicObjectCollection dynObjs = super.getData(start, limit);
                    dynObjs.getDynamicObjectType().addProperty((DynamicProperty)new DynamicSimpleProperty("relexpenseitem", String.class, null));
                    HashMap data = new HashMap(16);
                    dynObjs.forEach(v -> data.put(v.getPkValue(), v));
                    if (data.size() > 0) {
                        Map relation = BusinessItemListPlugin.this.setRelExpenseItem(data.keySet(), useOrg);
                        dynObjs.forEach(busItem -> {
                            StringBuilder expenseSBuilder = (StringBuilder)relation.get(busItem.getPkValue());
                            if (expenseSBuilder != null && expenseSBuilder.length() > 0) {
                                expenseSBuilder.deleteCharAt(expenseSBuilder.length() - 1);
                                busItem.set("relexpenseitem", (Object)expenseSBuilder.toString());
                            }
                        });
                    }
                    return dynObjs;
                }
            });
        }
    }

    private Map<Object, StringBuilder> setRelExpenseItem(Set<Object> busItemIds, String useOrg) {
        QFilter qFilters = BaseDataServiceHelper.getBaseDataFilter((String)"er_expenseitemedit", (Long)Long.parseLong(useOrg));
        List expItemIds = QueryServiceHelper.queryPrimaryKeys((String)"er_expenseitemedit", (QFilter[])new QFilter[]{qFilters}, null, (int)-1);
        QFilter filter = new QFilter("businessitem.id", "in", busItemIds);
        filter.and("expenseitem.id", "in", (Object)expItemIds);
        DynamicObject[] relExpenseItems = BusinessDataServiceHelper.load((String)"bd_busitemrelexpitem_", (String)"businessitem,expenseitem", (QFilter[])new QFilter[]{filter});
        HashMap<Object, StringBuilder> relation = new HashMap<Object, StringBuilder>(16);
        for (DynamicObject relItem : relExpenseItems) {
            DynamicObject businessItem = (DynamicObject)relItem.get("businessitem");
            DynamicObject expenseItem = (DynamicObject)relItem.get("expenseitem");
            Object businessItemId = businessItem.getPkValue();
            StringBuilder expenseSBuilder = (StringBuilder)relation.get(businessItemId);
            if (expenseSBuilder == null) {
                expenseSBuilder = new StringBuilder();
                relation.put(businessItemId, expenseSBuilder);
            }
            expenseSBuilder.append(expenseItem.get("name")).append(',');
        }
        return relation;
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        if (this.isRelExpenseItem()) {
            List columns = args.getListColumns();
            List columns_bak = (List)ObjectCloneUtils.cloneObject((Object)columns);
            columns_bak.forEach(column -> {
                if (column.getListFieldKey().equals("relbilltype") || column.getListFieldKey().equals("createorg.name")) {
                    columns.remove(column);
                }
                if (column.getListFieldKey().equals("number")) {
                    column.setHyperlink(false);
                }
            });
            ListColumn relExpenseItem = this.createListColumn("relexpenseitem", ResManager.loadKDString((String)"\u5173\u8054\u4e1a\u52a1\u9879\u76ee", (String)"BusinessItemListPlugin_1", (String)"fi-bd-formplugin", (Object[])new Object[0]), 3);
            columns.add(3, relExpenseItem);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("bd_busitembill_setting".equals(actionId) || "bd_busitemrelexp_setting".equals(actionId)) {
            IListView view = (IListView)this.getView();
            view.refresh();
        }
    }

    public void refreshNode(RefreshNodeEvent e) {
        super.refreshNode(e);
        Object treeFilterObj = this.getView().getFormShowParameter().getCustomParam("treeFilter");
        if (treeFilterObj != null) {
            QFilter treeFilter = QFilter.fromSerializedString((String)treeFilterObj.toString());
            List treeFilters = this.getTreeModel().getTreeFilter();
            treeFilters.add(treeFilter);
        }
        TreeListModel treeListModel = (TreeListModel)e.getSource();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("order", "number asc");
        treeListModel.setQueryParas(map);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        if (this.isRelExpenseItem()) {
            e.getQFilters().add(QFilter.of((String)"isleaf=?", (Object[])new Object[]{Boolean.TRUE}));
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List filterColumns;
        super.filterContainerInit(args);
        if (!this.isRelExpenseItem()) {
            filterColumns = args.getSchemeFilterColumns();
            for (FilterColumn filterColumn : filterColumns) {
                if (!filterColumn.getFieldName().equals("relexpenseitem")) continue;
                args.getSchemeFilterColumns().remove(filterColumn);
                break;
            }
        }
        filterColumns = args.getCommonFilterColumns();
        for (FilterColumn filterColumn : filterColumns) {
            if (!"useorg.id".equals(filterColumn.getFieldName())) continue;
            List values = filterColumn.getDefaultValues();
            if (values == null || values.size() <= 0) break;
            this.getPageCache().put("useorg", values.get(0) + "");
            break;
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        List value;
        List fieldName;
        Map filters;
        super.filterContainerSearchClick(args);
        List schemeFilters = (List)args.getFilterValues().get("schemefilter");
        if (schemeFilters != null && schemeFilters.size() > 0) {
            List schemeFilter_bak = (List)ObjectCloneUtils.cloneObject((Object)schemeFilters);
            schemeFilter_bak.forEach(schemeFilter -> {
                if (((List)schemeFilter.get("FieldName")).contains("relexpenseitem")) {
                    QFilter qFilter = args.getQFilter("relexpenseitem");
                    qFilter.__setProperty("expenseitem.name");
                    qFilter.getNests(true).forEach(qFilterNest -> qFilterNest.getFilter().__setProperty("expenseitem.name"));
                    DynamicObject[] relExpenseItems = BusinessDataServiceHelper.load((String)"bd_busitemrelexpitem_", (String)"businessitem", (QFilter[])new QFilter[]{qFilter});
                    HashSet<String> busItemIds = new HashSet<String>(16);
                    busItemIds.add("null");
                    for (DynamicObject item : relExpenseItems) {
                        busItemIds.add(item.get("businessitem.number") + "");
                    }
                    schemeFilters.remove(schemeFilter);
                    schemeFilters.add(this.getNewSchemeFilter(busItemIds));
                }
            });
        }
        if (this.isRelExpenseItem() && (filters = args.getCurrentCommonFilter()) != null && (fieldName = (List)filters.get("FieldName")) != null && fieldName.size() > 0 && "useorg.id".equals(fieldName.get(0)) && (value = (List)filters.get("Value")) != null && value.size() > 0) {
            this.getPageCache().put("useorg", value.get(0) + "");
        }
    }

    private void createFormShowParameter(String formId, FormShowParameter showParameter, ListSelectedRowCollection selectedRows) {
        ArrayList busItems = new ArrayList(8);
        if (null != selectedRows) {
            selectedRows.forEach(selectedRow -> busItems.add(selectedRow.getPrimaryKeyValue().toString()));
        }
        showParameter.setCustomParam("busitems", busItems);
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
    }

    private void addOrgToParam(FormShowParameter showParameter, long rootOrgId) {
        String org;
        ListView list = (ListView)this.getView();
        ControlFilters filters = list.getControlFilters();
        List orgs = filters.getFilter("useorg.id");
        if (orgs != null && orgs.size() != 0) {
            org = orgs.get(0).toString();
        } else {
            long orgId = RequestContext.get().getOrgId();
            org = (orgId == 0L ? rootOrgId : orgId) + "";
        }
        showParameter.setCustomParam("org", (Object)org);
    }

    private <T> T getSelectedFirstRowKey() {
        IFormView iFormView = this.getView();
        if (!(iFormView instanceof IListView)) {
            return null;
        }
        IListView listView = (IListView)iFormView;
        return (T)listView.getSelectedRows();
    }

    private Set<Long> getSelectDataCreateOrg(ListSelectedRowCollection selectedRows) {
        List pks = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        Map loadFromCache = BusinessDataServiceHelper.loadFromCache((String)"bd_businessitem", (String)"createorg", (QFilter[])new QFilter[]{new QFilter("id", "in", pks)});
        return loadFromCache.values().stream().map(v -> v.getLong("createorg.id")).collect(Collectors.toSet());
    }

    private Map<String, List<Object>> getNewSchemeFilter(Set<String> busItemIds) {
        HashMap<String, List<Object>> newFilter = new HashMap<String, List<Object>>();
        newFilter.put("FieldName", Collections.singletonList("number"));
        newFilter.put("Compare", Collections.singletonList(CompareTypeEnum.IN.getId()));
        newFilter.put("Value", new ArrayList<String>(busItemIds));
        newFilter.put("Left", Collections.singletonList(""));
        newFilter.put("Right", Collections.singletonList(""));
        newFilter.put("Logic", Collections.singletonList(0));
        return newFilter;
    }

    private boolean isRelExpenseItem() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String formFlag = (String)showParameter.getCustomParam("formFlag");
        return StringUtils.isNotEmpty((CharSequence)formFlag) && formFlag.equals("relexpenseitem");
    }

    private ListColumn createListColumn(String key, String caption, int colIndex) {
        ListColumn col = new ListColumn();
        col.setCaption(new LocaleString(caption));
        col.setKey(key);
        col.setListFieldKey(key);
        col.setFieldName(key);
        col.setSeq(colIndex);
        col.setVisible(11);
        return col;
    }

    private boolean permission(String operationKey) {
        String appId = AppMetadataCache.getAppInfo((String)"fibd").getId();
        long userId = Long.parseLong(RequestContext.get().getUserId());
        long sscId = Long.parseLong(this.getPageCache().get("useorg"));
        String permissionId = permissionMap.get(operationKey);
        int result = PermissionServiceHelper.checkPermission((Long)userId, (Long)sscId, (String)appId, (String)"bd_businessitem", (String)permissionId);
        return result == 1;
    }

    private void setButtonVisible() {
        if (this.isRelExpenseItem()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblnew", "tbldel", "tblassign", "tbldisable", "bar_manage", "bar_reldept", "bar_setrelation", "baritemap"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_relexpenseitem"});
        }
    }

    static {
        permissionMap.put("bar_relexpenseitem", "179RJS1F50K1");
        permissionMap.put("bar_reldept", "16GQ/V1JKINU");
        permissionMap.put("bar_setrelation", "16GPR4V8UBYN");
    }
}

