/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.formplugin.ext;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.bd.accversion.AccountAddingAssistValidateTaskImpl;
import kd.fi.bd.accversion.AssistAddingContext;
import kd.fi.bd.consts.AccountOperationType;
import kd.fi.bd.consts.OperationLogEntry;
import kd.fi.bd.enhance.treetask.AccountContext;
import kd.fi.bd.formplugin.consts.FormpluginResource;
import kd.fi.bd.util.AccountOperationLogUtil;
import kd.fi.bd.util.AccountVersionOpVars;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.BatchProcessHelper;
import kd.fi.bd.util.BiTreeNode;
import kd.fi.bd.util.TaskExecutionResult;
import kd.fi.bd.vo.AccountOrgPairVO;
import kd.fi.bd.vo.AccountVO;
import kd.fi.bd.vo.AssistEntryVO;

public class AccountAddingAssistTaskImpl
extends AccountAddingAssistValidateTaskImpl {
    private static final Log LOG = LogFactory.getLog(AccountAddingAssistTaskImpl.class);

    public List<TaskExecutionResult<AccountOrgPairVO>> batchExecute(List<AccountContext> taskContexts) {
        if (CollectionUtils.isEmpty(taskContexts)) {
            return Collections.EMPTY_LIST;
        }
        long tick = System.currentTimeMillis();
        List results = BatchProcessHelper.batchHandle((TaskType)TaskType.FIBD_ACCOUNT_ADDING_ASSIST_TASK, taskContexts, x -> x.stream().map(this::execute).collect(Collectors.toList()));
        LOG.info("adding_assist_batch size: " + taskContexts.size() + " cost: " + (System.currentTimeMillis() - tick));
        return results;
    }

    public TaskExecutionResult<AccountOrgPairVO> execute(AccountContext taskContext) {
        long oneTick = System.currentTimeMillis();
        DynamicObject operationData = this.getOperationData(taskContext);
        AccountOperationLogUtil.setOperationLog(operationLog -> operationLog.getAccountIds().add(operationData.getLong("id")));
        AccountOrgPairVO accountOrgPairVo = new AccountOrgPairVO(operationData.getString("number"), operationData.getLong("useorg_id")).setAccountId(Long.valueOf(operationData.getLong("id")));
        OperateOption option = OperateOption.create();
        OperationResult executeResult = this.executeOperation(option, operationData);
        LOG.info("adding_assist_one cost: " + (System.currentTimeMillis() - oneTick));
        OperationLogEntry entry = new OperationLogEntry(Long.valueOf(operationData.getLong("useorg_id")), Long.valueOf(operationData.getLong("id")), AccountOperationType.VERSION_ADD_ASSIST, Boolean.TRUE.booleanValue());
        AccountOperationLogUtil.addLogEntryRow((OperationLogEntry)entry);
        if (!executeResult.isSuccess()) {
            String failedMsg = BDUtil.buildOperationResultFailedMsg((OperationResult)executeResult, (boolean)false);
            LOG.info(String.format("adding_assist_one node is : %s, execute failed msg is : %s", accountOrgPairVo.toString(), failedMsg));
            entry.setSuccess(Boolean.FALSE.booleanValue());
            entry.setLog(failedMsg);
            return TaskExecutionResult.failed((Object)accountOrgPairVo, (String)failedMsg);
        }
        LOG.info(String.format("adding_assist_one node is : %s, execute success", accountOrgPairVo.toString()));
        return TaskExecutionResult.succeed((Object)accountOrgPairVo, (String)FormpluginResource.getExecuteSuccessText());
    }

    private OperationResult executeOperation(OperateOption option, DynamicObject ... accDynArray) {
        AccountVersionOpVars.setVersioning((OperateOption)option, (boolean)Boolean.TRUE);
        AccountVersionOpVars.setAddingAssist((OperateOption)option, (boolean)Boolean.TRUE);
        AccountVersionOpVars.setIsBatchAddingAssist((OperateOption)option, (boolean)Boolean.TRUE);
        return OperationServiceHelper.executeOperate((String)"save", (String)"bd_accountview", (DynamicObject[])accDynArray, (OperateOption)option);
    }

    private DynamicObject getOperationData(AccountContext taskContext) {
        Tuple data = taskContext.getData();
        BiTreeNode accountNode = (BiTreeNode)data.item1;
        BiTreeNode orgNode = (BiTreeNode)data.item2;
        AssistAddingContext context = taskContext.getAssistAddingContext();
        Long orgId = (Long)orgNode.getId();
        Optional accDyn = this.getCurrentAccountDynObj(((AccountVO)accountNode.getData()).getNumber(), orgId, context);
        Preconditions.checkState((boolean)accDyn.isPresent());
        DynamicObject operationAccDyn = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)accDyn.get()).getPkValue(), (String)"bd_accountview");
        List addingAssitList = context.getAddingAssitList();
        DynamicObjectCollection assistEntryCollection = operationAccDyn.getDynamicObjectCollection("checkitementry");
        Map<Long, DynamicObject> assistIdEntryMap = assistEntryCollection.stream().collect(Collectors.toMap(x -> x.getLong("asstactitem.id"), x -> x));
        boolean isAssist = false;
        boolean isAc = false;
        int seq = assistEntryCollection.size();
        for (AssistEntryVO assistEntry : addingAssitList) {
            long assistId = assistEntry.getId();
            DynamicObject assistDynObj = (DynamicObject)context.getAssistIdDynObjMap().get(assistId);
            if (assistDynObj == null) continue;
            DynamicObject entryDynObj = assistIdEntryMap.get(assistId);
            if (entryDynObj == null) {
                entryDynObj = assistEntryCollection.addNew();
                entryDynObj.set("seq", (Object)(++seq));
                entryDynObj.set("asstactitem", (Object)assistDynObj);
                entryDynObj.set("enaccheck", (Object)assistEntry.isAc());
                entryDynObj.set("isrequire", (Object)assistEntry.isMustInput());
                entryDynObj.set("isdetail", (Object)assistEntry.isLeaf());
            } else {
                entryDynObj.set("enaccheck", (Object)this.selectFirst(entryDynObj.getBoolean("enaccheck"), assistEntry.isAc()));
                entryDynObj.set("isrequire", (Object)this.selectFirst(entryDynObj.getBoolean("isrequire"), assistEntry.isMustInput()));
                entryDynObj.set("isdetail", (Object)this.selectFirst(entryDynObj.getBoolean("isdetail"), assistEntry.isLeaf()));
            }
            if (assistEntry.isAc()) {
                isAc = true;
            }
            isAssist = true;
        }
        if (isAc) {
            operationAccDyn.set("accheck", (Object)Boolean.TRUE);
        }
        if (isAssist) {
            operationAccDyn.set("isassist", (Object)Boolean.TRUE);
        }
        DynamicObject orgDynObj = (DynamicObject)context.getOrgIdDynObjMap().get(orgId);
        operationAccDyn.set("useorg", (Object)orgDynObj);
        operationAccDyn.set("startdate", (Object)context.getVersionDate());
        LOG.info(String.format("call_adding_assist on org: %s, account(%s, %s) with: %s", orgDynObj.getLong("id"), operationAccDyn.getLong("id"), operationAccDyn.getString("number"), StringUtils.join((Object[])new DynamicObjectCollection[]{operationAccDyn.getDynamicObjectCollection("checkitementry")})));
        return operationAccDyn;
    }

    private boolean selectFirst(boolean originValue, boolean waitingUpdateValue) {
        return originValue ? originValue : waitingUpdateValue;
    }
}

