/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.formplugin.utils;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.formplugin.model.OrgTreeSearchParam;

public class AccountingSysOrgTreeUtil {
    public static void removeAllSearchTreeNodeCache(IPageCache pageCache) {
        pageCache.remove("_searchNodes");
        pageCache.remove("_oldSearchText");
        pageCache.remove("_oldSearchViewSchema");
        pageCache.remove("_resultTotalCacheKey");
    }

    public static void searchFromLazyOrgTree(OrgTreeSearchParam searchParam) {
        if (searchParam == null) {
            return;
        }
        String searchText = searchParam.getSearchText();
        if (StringUtils.isBlank((CharSequence)searchText)) {
            return;
        }
        String orgViewNumber = searchParam.getOrgViewNumber();
        List treeNodes = Collections.EMPTY_LIST;
        IPageCache pageCache = searchParam.getPageCache();
        if (!orgViewNumber.equals(pageCache.get("_oldSearchViewSchema"))) {
            AccountingSysOrgTreeUtil.removeAllSearchTreeNodeCache(pageCache);
        }
        pageCache.put("_oldSearchViewSchema", orgViewNumber);
        String oldSearchText = pageCache.get("_oldSearchText");
        pageCache.put("_oldSearchText", searchText);
        if (searchText.equals(oldSearchText)) {
            String searchNodesCache = pageCache.get("_searchNodes");
            if (StringUtils.isNotBlank((CharSequence)searchNodesCache)) {
                treeNodes = SerializationUtils.fromJsonStringToList((String)searchNodesCache, TreeNode.class);
            }
        } else {
            pageCache.remove("_searchNodes");
            treeNodes = AccountingSysOrgTreeUtil.searchTreeNode(searchParam);
            if (AccountingSysOrgTreeUtil.finishSearch(searchParam, treeNodes, true)) {
                return;
            }
            pageCache.put("_resultTotalCacheKey", Integer.toString(treeNodes.size()));
        }
        if (CollectionUtils.isEmpty(treeNodes)) {
            AccountingSysOrgTreeUtil.finishSearch(searchParam, treeNodes, false);
        } else {
            AccountingSysOrgTreeUtil.searchFromLazyOrgTree(searchParam, treeNodes);
        }
    }

    private static void searchFromLazyOrgTree(OrgTreeSearchParam searchParam, List<TreeNode> treeNodes) {
        IPageCache pageCache = searchParam.getPageCache();
        String resultTotal = pageCache.get("_resultTotalCacheKey");
        boolean firstTimeCheck = StringUtils.isNotBlank((CharSequence)resultTotal) && Integer.parseInt(resultTotal) == treeNodes.size();
        TreeView treeView = searchParam.getTreeView();
        treeView.uncheckNodes(treeView.getTreeState().getSelectedNodeId());
        TreeNode node = AccountingSysOrgTreeUtil.searchExistsNodeFromLazyOrgTree(searchParam, treeNodes);
        if (node == null) {
            AccountingSysOrgTreeUtil.finishSearch(searchParam, treeNodes, firstTimeCheck);
        } else {
            treeView.expand(searchParam.getRootNode().getId());
            treeView.expand(node.getId());
            treeView.checkNode(node);
            treeView.focusNode(node);
            if (treeNodes != null && !treeNodes.isEmpty()) {
                treeNodes.remove(0);
            }
        }
        pageCache.put("_searchNodes", SerializationUtils.toJsonString(treeNodes));
    }

    private static boolean finishSearch(OrgTreeSearchParam searchParam, List<TreeNode> treeNodes, boolean noResult) {
        if (!CollectionUtils.isEmpty(treeNodes)) {
            return false;
        }
        TreeView treeView = searchParam.getTreeView();
        searchParam.getPageCache().put("_searchNodes", "");
        searchParam.getPageCache().remove("_oldSearchText");
        if (noResult) {
            treeView.uncheckNodes(treeView.getTreeState().getSelectedNodeId());
            searchParam.getFormView().showTipNotification(ResManager.loadKDString((String)"\u641c\u7d22\u4e0d\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u3002", (String)"AccountingSysAddViewEdit_7", (String)"fi-bd-formplugin", (Object[])new Object[0]));
        } else {
            searchParam.getFormView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22\u3002", (String)"AccountingSysAddViewEdit_8", (String)"fi-bd-formplugin", (Object[])new Object[0]));
        }
        TreeNode rootNode = searchParam.getRootNode();
        if (!rootNode.getId().equals(treeView.getTreeState().getFocusNodeId())) {
            treeView.uncheckNodes(treeView.getTreeState().getSelectedNodeId());
            treeView.treeNodeClick(rootNode.getParentid(), rootNode.getId());
            treeView.focusNode(rootNode);
        }
        return true;
    }

    private static TreeNode searchExistsNodeFromLazyOrgTree(OrgTreeSearchParam searchParam, List<TreeNode> treeNodes) {
        if (CollectionUtils.isEmpty(treeNodes)) {
            return null;
        }
        TreeNode node = treeNodes.get(0);
        String parentId = node.getParentid();
        TreeNode parentNode = AccountingSysOrgTreeUtil.getNode(searchParam.getRootNode(), parentId);
        if (AccountingSysOrgTreeUtil.isChildNode(parentNode, node)) {
            ArrayList<String> loopController = new ArrayList<String>();
            AccountingSysOrgTreeUtil.expandParentNode(searchParam, parentId, loopController);
        } else {
            AccountingSysOrgTreeUtil.queryTreeNodeWithParent(searchParam, node);
        }
        node = AccountingSysOrgTreeUtil.getNode(searchParam.getRootNode(), node.getId());
        if (node == null) {
            TreeNode removeNode = treeNodes.remove(0);
            String subNodeLongNumber = removeNode.getLongNumber() + "!";
            ArrayList<TreeNode> removeSubNodes = new ArrayList<TreeNode>(treeNodes.size());
            for (TreeNode subNode : treeNodes) {
                if (subNode.getLongNumber() == null || !subNode.getLongNumber().startsWith(subNodeLongNumber)) continue;
                removeSubNodes.add(subNode);
            }
            treeNodes.removeAll(removeSubNodes);
            return AccountingSysOrgTreeUtil.searchExistsNodeFromLazyOrgTree(searchParam, treeNodes);
        }
        return node;
    }

    private static boolean isChildNode(TreeNode parentNode, TreeNode node) {
        if (parentNode == null || CollectionUtils.isEmpty((Collection)parentNode.getChildren())) {
            return false;
        }
        for (TreeNode child : parentNode.getChildren()) {
            if (!node.getId().equals(child.getId())) continue;
            return true;
        }
        return false;
    }

    public static void expandParentNode(OrgTreeSearchParam searchParam, String nodeId, List<String> loopController) {
        if (searchParam == null || StringUtils.isBlank((CharSequence)nodeId)) {
            return;
        }
        if (loopController == null || loopController.contains(nodeId)) {
            return;
        }
        TreeNode rootNode = searchParam.getRootNode();
        if (rootNode == null) {
            return;
        }
        loopController.add(nodeId);
        TreeNode treeNode = AccountingSysOrgTreeUtil.getNode(rootNode, nodeId);
        if (treeNode != null && !treeNode.isExpend()) {
            searchParam.getTreeView().expand(nodeId);
            treeNode.setExpend(true);
            AccountingSysOrgTreeUtil.expandParentNode(searchParam, treeNode.getParentid(), loopController);
        }
    }

    private static List<TreeNode> searchTreeNode(OrgTreeSearchParam searchParam) {
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>();
        String searchText = searchParam.getSearchText();
        String orgViewNumber = searchParam.getOrgViewNumber();
        String selectFields = "id,org,org.name name,parent,longnumber";
        QFilter viewFilter = new QFilter("view.number", "=", (Object)orgViewNumber);
        QFilter nameFilter = new QFilter("org.name", "like", (Object)("%" + searchText + "%"));
        viewFilter = viewFilter.and(nameFilter);
        if (null != searchParam.getOrgFilter()) {
            viewFilter.and(searchParam.getOrgFilter());
        }
        QFilter[] filters = new QFilter[]{viewFilter};
        String orderBy = "level,longnumber";
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)(AccountingSysOrgTreeUtil.class.getName() + "searchTreeNode"), (String)"bos_org_structure", (String)selectFields, (QFilter[])filters, (String)orderBy);){
            for (Row structObj : ds) {
                String orgId = structObj.getString("org");
                TreeNode treeNode = new TreeNode(structObj.getString("parent"), orgId, structObj.getString("name"));
                treeNode.setExpend(true);
                treeNode.setLongNumber(structObj.getString("longnumber"));
                treeNodes.add(treeNode);
            }
        }
        return treeNodes;
    }

    private static void queryTreeNodeWithParent(OrgTreeSearchParam searchParam, TreeNode node) {
        TreeView treeView = searchParam.getTreeView();
        String orgViewNumber = searchParam.getOrgViewNumber();
        QFilter viewFilter = new QFilter("view.number", "=", (Object)orgViewNumber);
        List<String> longNumList = AccountingSysOrgTreeUtil.getParentNumbers(searchParam, node, viewFilter);
        if (longNumList.isEmpty()) {
            return;
        }
        String selectFields = "id,org,parent";
        QFilter numberFilter = new QFilter("org.number", "in", longNumList);
        QFilter[] filters = new QFilter[]{numberFilter, viewFilter};
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"OrgTreeUtils.queryTreeNodeWithParent", (String)"bos_org_structure", (String)selectFields, (QFilter[])filters, (String)"longnumber");){
            TreeNode parentNode = searchParam.getRootNode();
            for (Row row : ds) {
                String orgId = row.getString("org");
                if ((parentNode = AccountingSysOrgTreeUtil.getNode(parentNode, orgId)) == null || parentNode.getChildren() == null || parentNode.getChildren().isEmpty() || node.getParentid().equals(orgId)) {
                    String parentId = row.getString("parent");
                    treeView.queryTreeNodeChildren(parentId, orgId);
                }
                treeView.expand(orgId);
            }
        }
    }

    private static List<String> getParentNumbers(OrgTreeSearchParam searchParam, TreeNode node, QFilter viewFilter) {
        QFilter orgFilter;
        QFilter[] filters;
        DynamicObject structObj;
        ArrayList<String> longNumList = new ArrayList<String>();
        String longNumber = node.getLongNumber();
        if (StringUtils.isBlank((CharSequence)longNumber) && (structObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org_structure", (String)"longnumber", (QFilter[])(filters = new QFilter[]{viewFilter, orgFilter = new QFilter("org", "=", (Object)Long.valueOf(node.getId()))}))) != null) {
            longNumber = structObj.getString("longnumber");
            node.setLongNumber(longNumber);
        }
        if (StringUtils.isNotBlank((CharSequence)longNumber)) {
            int i;
            String[] numbers = longNumber.split("!");
            int n = i = searchParam.getRootNode().getId().equals(node.getParentid()) ? 0 : 1;
            while (i < numbers.length - 1) {
                longNumList.add(numbers[i]);
                ++i;
            }
        }
        return longNumList;
    }

    public static TreeNode getNode(TreeNode rootNode, Object nodeId) {
        if (rootNode == null || StringUtils.isBlank((Object)nodeId)) {
            return null;
        }
        return rootNode.getTreeNode(nodeId.toString(), 20);
    }

    public static void preTravel(TreeNode node, Consumer<TreeNode> consumer) {
        consumer.accept(node);
        if (!CollectionUtils.isEmpty((Collection)node.getChildren())) {
            ArrayList childClone = new ArrayList(node.getChildren());
            for (TreeNode c : childClone) {
                AccountingSysOrgTreeUtil.preTravel(c, consumer);
            }
        }
    }

    public static ListMultimap<Integer, TreeNode> tagNodeWithLevel(TreeNode rootNode, Map<String, TreeNode> idNodeMap) {
        LinkedListMultimap levelNodeMap = LinkedListMultimap.create();
        AccountingSysOrgTreeUtil.preTravel(rootNode, x -> {
            if (Objects.equals(rootNode, x)) {
                ((Map)x.getData()).put("level", "1");
            } else {
                ((Map)x.getData()).put("level", String.valueOf(Integer.parseInt((String)((Map)((TreeNode)idNodeMap.get(x.getParentid())).getData()).get("level")) + 1));
            }
            int curLevel = Integer.parseInt((String)((Map)x.getData()).get("level"));
            levelNodeMap.put((Object)curLevel, x);
        });
        return levelNodeMap;
    }
}

