/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.formplugin.utils;

import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.entity.property.AccountProp;
import kd.bos.ext.fi.metadata.field.AccountField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.fi.bd.formplugin.info.AccountFieldInfo;
import kd.fi.bd.formplugin.info.FieldInfo;

public class DynamicModifyViewAndModelUtil {
    public static EntryAp createDynamicEntryAp4Act(String entryKey, List<AccountFieldInfo> actFieldList) {
        EntryAp entryAp = new EntryAp();
        entryAp.setKey(entryKey);
        for (AccountFieldInfo actField : actFieldList) {
            EntryFieldAp entryFieldAp = new EntryFieldAp();
            String columnKey = actField.getFieldKey();
            entryFieldAp.setId(columnKey);
            entryFieldAp.setKey(columnKey);
            entryFieldAp.setName(actField.getFieldName());
            entryFieldAp.setWidth(new LocaleString("260px"));
            entryFieldAp.setFireUpdEvt(false);
            entryFieldAp.setFreeze(false);
            entryFieldAp.setLock("");
            entryFieldAp.setQuickAddNew(false);
            AccountField field = new AccountField();
            field.setId(columnKey);
            field.setKey(columnKey);
            field.setViewDetail(true);
            field.setDisplayFullname(true);
            field.setDisplayProp("number,name");
            entryFieldAp.setField((Field)field);
            entryAp.getItems().add(entryFieldAp);
        }
        return entryAp;
    }

    public static EntryAp createDynamicEntryAp4Text(String entryKey, List<FieldInfo> textFieldList) {
        EntryAp entryAp = new EntryAp();
        entryAp.setKey(entryKey);
        for (FieldInfo textField : textFieldList) {
            EntryFieldAp entryFieldAp = new EntryFieldAp();
            String columnKey = textField.getFieldKey();
            entryFieldAp.setId(columnKey);
            entryFieldAp.setKey(columnKey);
            entryFieldAp.setName(textField.getFieldName());
            entryFieldAp.setWidth(new LocaleString("80px"));
            entryFieldAp.setFireUpdEvt(false);
            entryFieldAp.setFreeze(false);
            entryFieldAp.setLock("new,edit,view,submit,audit");
            entryFieldAp.setFieldTextAlign("center");
            TextField field = new TextField();
            field.setId(columnKey);
            field.setKey(columnKey);
            entryFieldAp.setField((Field)field);
            entryAp.getItems().add(entryFieldAp);
        }
        return entryAp;
    }

    public static void rebuildEntityType(MainEntityType mainEntityType, String entryKey, List<AccountFieldInfo> actFieldList, List<FieldInfo> textFieldList) {
        DynamicProperty property;
        String fieldKey;
        EntryProp entry = (EntryProp)mainEntityType.getProperty(entryKey);
        DynamicObjectType entryType = entry.getDynamicCollectionItemPropertyType();
        for (AccountFieldInfo accountFieldInfo : actFieldList) {
            DynamicProperty propRefId;
            fieldKey = accountFieldInfo.getFieldKey();
            property = entryType.getProperty(fieldKey);
            if (property != null) {
                entryType.getProperties().remove((Object)property);
            }
            if ((propRefId = entryType.getProperty(fieldKey + "_id")) == null) continue;
            entryType.getProperties().remove((Object)propRefId);
        }
        for (FieldInfo fieldInfo : textFieldList) {
            fieldKey = fieldInfo.getFieldKey();
            property = entryType.getProperty(fieldKey);
            if (property == null) continue;
            entryType.getProperties().remove((Object)property);
        }
        DataEntityPropertyCollection propColl = entryType.getProperties();
        Iterator iterator = propColl.iterator();
        while (iterator.hasNext()) {
            IDataEntityProperty prop = (IDataEntityProperty)iterator.next();
            String propName = prop.getName();
            if (!propName.startsWith("src_act") && !propName.startsWith("goal_act") && !propName.startsWith("ismapping")) continue;
            iterator.remove();
        }
        DynamicModifyViewAndModelUtil.rebuildEntityType4Act(mainEntityType, entryKey, actFieldList);
        DynamicModifyViewAndModelUtil.rebuildEntryType4Text(mainEntityType, entryKey, textFieldList);
        mainEntityType.createPropIndexsNoCache();
    }

    private static MainEntityType rebuildEntityType4Act(MainEntityType mainEntityType, String entryKey, List<AccountFieldInfo> actFieldList) {
        EntryProp entry = (EntryProp)mainEntityType.getProperty(entryKey);
        DynamicObjectType entryType = entry.getDynamicCollectionItemPropertyType();
        AccountProp baseDataProp = (AccountProp)entryType.getProperty("actfieldshow");
        for (AccountFieldInfo field : actFieldList) {
            AccountProp accProp;
            String columnKey = field.getFieldKey();
            LocaleString name = field.getFieldName();
            try {
                accProp = (AccountProp)baseDataProp.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new KDBizException(e.getMessage());
            }
            accProp.setBaseEntityId("bd_accountview");
            accProp.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bd_accountview"));
            accProp.setAlias(columnKey);
            accProp.setName(columnKey);
            accProp.setDisplayName(name);
            accProp.setDisplayProp("number,name");
            accProp.setDisplayFullname(true);
            entryType.addProperty((DynamicProperty)accProp);
            DynamicModifyViewAndModelUtil.addRefIdProp(field, (BasedataProp)accProp, entryType);
        }
        return mainEntityType;
    }

    private static MainEntityType rebuildEntryType4Text(MainEntityType mainEntityType, String entryKey, List<FieldInfo> fieldInfoList) {
        EntryProp entry = (EntryProp)mainEntityType.getProperty(entryKey);
        DynamicObjectType entryType = entry.getDynamicCollectionItemPropertyType();
        TextProp textDataProp = (TextProp)entryType.getProperty("textfieldshow");
        for (FieldInfo field : fieldInfoList) {
            TextProp isMappingProp;
            String columnKey = field.getFieldKey();
            LocaleString name = field.getFieldName();
            try {
                isMappingProp = (TextProp)textDataProp.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new KDBizException(e.getMessage());
            }
            isMappingProp.setAlias(columnKey);
            isMappingProp.setName(columnKey);
            isMappingProp.setDisplayName(name);
            entryType.addProperty((DynamicProperty)isMappingProp);
        }
        return mainEntityType;
    }

    private static void addRefIdProp(FieldInfo entryField, BasedataProp dp, DynamicObjectType entryType) {
        BasedataEntityType baseEntityType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)entryField.getEntityId());
        String refPropName = dp.getName() + "_id";
        if (baseEntityType.getPrimaryKey().getPropertyType() == String.class) {
            VarcharProp pRefId = new VarcharProp(true);
            pRefId.setPrimaryKey(false);
            pRefId.setDbIgnore(true);
            pRefId.setName(refPropName);
            dp.setRefIdPropName(refPropName);
            dp.setRefIdProp((IDataEntityProperty)pRefId);
            entryType.addProperty((DynamicProperty)pRefId);
        } else {
            LongProp pRefId2 = new LongProp(true);
            pRefId2.setPrimaryKey(false);
            pRefId2.setDbIgnore(true);
            pRefId2.setName(refPropName);
            dp.setRefIdPropName(refPropName);
            dp.setRefIdProp((IDataEntityProperty)pRefId2);
            entryType.addProperty((DynamicProperty)pRefId2);
        }
    }
}

