/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.bd.accountversion;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.ext.fi.entity.property.AccountProp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class BaseDataupForAccver {
    private static final String NUMBER = "number";
    private static final String TYPE = "type";
    private static final String MASTER = "master";
    private static final String BD_ACCOUNT_UPDATERECORD = "bd_account_updaterecord";
    private static final String METADATA = "metadata";
    private static final String DATAID = "dataid";
    private static final String DATAENTRYID = "dataentryid";
    private static final String ENTRYNAME = "entryname";
    private static final String FIELDNAME = "fieldname";
    private static final String REACCOUNTID = "reaccountid";
    private static final String AFACCOUNTID = "afaccountid";
    private static final String CREATER = "creater";
    private static final String CREATEDATE = "createdate";
    private static final String POINTID = ".id";
    private static final String ID = "id";
    private static final String _ID = "_id";
    private static final String HEAD_FILED = "headfield";
    private static final String ENTRY_FILED = "entryfield";

    public static Boolean batchReplaceAccountId(Long oldAcctId, Long newAcctId) {
        Set<String> entityNumbers = BaseDataupForAccver.getAllMetadatas();
        for (String entityNumber : entityNumbers) {
            if (BaseDataupForAccver.replaceAccountId(oldAcctId, newAcctId, entityNumber).booleanValue()) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static Boolean batchReplaceAccountId(Long oldAcctId, Long newAcctId, List<String> entityNumbers) {
        for (String entityNumber : entityNumbers) {
            if (BaseDataupForAccver.replaceAccountId(oldAcctId, newAcctId, entityNumber).booleanValue()) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static Boolean replaceAccountId(Long oldAcctId, Long newAcctId, String entityNumber) {
        MainEntityType et = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        DataEntityPropertyCollection collection = et.getProperties();
        for (IDataEntityProperty property : collection) {
            if (property instanceof AccountProp) {
                String fieldName = property.getName() + _ID;
                QFilter qfilter = new QFilter(fieldName, "=", (Object)oldAcctId);
                String selectField = "id," + fieldName;
                DynamicObject[] dyns = BusinessDataServiceHelper.load((String)entityNumber, (String)selectField, (QFilter[])qfilter.toArray());
                ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(dyns.length);
                for (Object dyn : dyns) {
                    dyn.set(fieldName, (Object)newAcctId);
                    Long dataid = dyn.getLong(ID);
                    DynamicObject updateRecord = BaseDataupForAccver.buildUpdateRecord(entityNumber, dataid, 0L, property.getName(), oldAcctId, newAcctId, null);
                    list.add(updateRecord);
                }
                TXHandle handle = TX.requiresNew((String)"replaceAccountId");
                Throwable throwable = null;
                try {
                    try {
                        SaveServiceHelper.save((DynamicObject[])dyns);
                        SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
                        continue;
                    }
                    catch (Exception e) {
                        Object dyn;
                        handle.markRollback();
                        dyn = Boolean.FALSE;
                        if (handle != null) {
                            if (throwable != null) {
                                try {
                                    handle.close();
                                }
                                catch (Throwable dataid) {
                                    throwable.addSuppressed(dataid);
                                }
                            } else {
                                handle.close();
                            }
                        }
                        return dyn;
                    }
                }
                catch (Throwable e) {
                    throwable = e;
                    throw e;
                }
                finally {
                    if (handle == null) continue;
                    if (throwable != null) {
                        try {
                            handle.close();
                        }
                        catch (Throwable e) {
                            throwable.addSuppressed(e);
                        }
                        continue;
                    }
                    handle.close();
                    continue;
                }
            }
            if (!(property instanceof EntryProp)) continue;
            EntryProp entryProp = (EntryProp)property;
            DataEntityPropertyCollection entrycollection = entryProp._collectionItemPropertyType.getProperties();
            for (IDataEntityProperty entryproperty : entrycollection) {
                if (!(entryproperty instanceof AccountProp)) continue;
                String entryEntityName = entryProp.getName();
                String entryproname = entryproperty.getName();
                String fieldName = entryEntityName + "." + entryproname + POINTID;
                QFilter qfilter = new QFilter(fieldName, "=", (Object)oldAcctId);
                Map map = BusinessDataServiceHelper.loadFromCache((String)entityNumber, (QFilter[])qfilter.toArray());
                ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(map.size());
                ArrayList<DynamicObject> dyns = new ArrayList<DynamicObject>(map.size());
                if (map == null || map.isEmpty()) continue;
                for (DynamicObject dyn : map.values()) {
                    Long dataid = dyn.getLong(ID);
                    DynamicObjectCollection entities = dyn.getDynamicObjectCollection(entryEntityName);
                    for (DynamicObject entity : entities) {
                        if (!oldAcctId.equals(entity.getLong(entryproname + POINTID))) continue;
                        Long entrydataid = (Long)entity.getPkValue();
                        entity.set(entryproname + _ID, (Object)newAcctId);
                        DynamicObject updateRecord = BaseDataupForAccver.buildUpdateRecord(entityNumber, dataid, entrydataid, entryproname, oldAcctId, newAcctId, entryEntityName);
                        list.add(updateRecord);
                    }
                    dyns.add(dyn);
                }
                TXHandle handle = TX.requiresNew((String)"replaceAccountId");
                Throwable throwable = null;
                try {
                    try {
                        SaveServiceHelper.save((DynamicObject[])dyns.toArray(new DynamicObject[0]));
                        SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
                    }
                    catch (Exception e) {
                        handle.markRollback();
                        Boolean bl = Boolean.FALSE;
                        if (handle != null) {
                            if (throwable != null) {
                                try {
                                    handle.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            } else {
                                handle.close();
                            }
                        }
                        return bl;
                    }
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    if (handle == null) continue;
                    if (throwable != null) {
                        try {
                            handle.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    handle.close();
                }
            }
        }
        return Boolean.TRUE;
    }

    public static Boolean batchDelSingleAccountVersion(Long oldAcctId, Long newAcctId) {
        Set<String> entityNumbers = BaseDataupForAccver.getAllMetadatas();
        for (String entityNumber : entityNumbers) {
            if (BaseDataupForAccver.deleteSingleAccountVersion(newAcctId, oldAcctId, entityNumber).booleanValue()) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static Boolean batchDelSingleAccountVersion(Long oldAcctId, Long newAcctId, List<String> entityNumbers) {
        for (String entityNumber : entityNumbers) {
            if (BaseDataupForAccver.deleteSingleAccountVersion(newAcctId, oldAcctId, entityNumber).booleanValue()) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static Boolean deleteSingleAccountVersion(Long newAcctId, Long oldAcctId, String entityNumber) {
        DynamicObject[] basedatas;
        QFilter mataFilter = new QFilter(METADATA, "=", (Object)entityNumber);
        QFilter afaccountFilter = new QFilter(AFACCOUNTID, "=", (Object)newAcctId);
        QFilter reaccountFilter = new QFilter(REACCOUNTID, "=", (Object)oldAcctId);
        String selectField = "id,metadata,dataid,dataentryid,entryname,fieldname,reaccountid,afaccountid";
        DynamicObject[] records = BusinessDataServiceHelper.load((String)BD_ACCOUNT_UPDATERECORD, (String)selectField, (QFilter[])new QFilter[]{mataFilter, afaccountFilter, reaccountFilter});
        ArrayList<Long> ids = new ArrayList<Long>(records.length);
        ArrayList<Long> recordIds = new ArrayList<Long>(records.length);
        for (DynamicObject record : records) {
            ids.add(record.getLong(DATAID));
            recordIds.add(record.getLong(ID));
        }
        Map<Long, Map<String, Object>> updateInfos = BaseDataupForAccver.getUpdateRecordInfo(records);
        for (DynamicObject basedata : basedatas = BusinessDataServiceHelper.load((Object[])ids.toArray(new Long[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityNumber))) {
            Long id = basedata.getLong(ID);
            Map<String, Object> dataMap = updateInfos.get(id);
            if (dataMap.containsKey(HEAD_FILED)) {
                List fields = (List)dataMap.get(HEAD_FILED);
                for (String string : fields) {
                    basedata.set(string + _ID, (Object)oldAcctId);
                }
            }
            if (!dataMap.containsKey(ENTRY_FILED)) continue;
            Map entryMap = (Map)dataMap.get(ENTRY_FILED);
            for (Map.Entry entry : entryMap.entrySet()) {
                String entityname = (String)entry.getKey();
                DynamicObjectCollection entities = basedata.getDynamicObjectCollection(entityname);
                Map entryinfos = (Map)entry.getValue();
                for (DynamicObject entity : entities) {
                    Long entityId = (Long)entity.getPkValue();
                    if (!entryinfos.containsKey(entityId)) continue;
                    List fields = (List)entryinfos.get(entityId);
                    for (String field : fields) {
                        entity.set(field + _ID, (Object)oldAcctId);
                    }
                }
            }
        }
        try (TXHandle handle = TX.requiresNew((String)"deleteSingleAccountVersion");){
            try {
                SaveServiceHelper.save((DynamicObject[])basedatas);
                DeleteServiceHelper.delete((String)BD_ACCOUNT_UPDATERECORD, (QFilter[])new QFilter(ID, "in", recordIds).toArray());
            }
            catch (Exception e) {
                handle.markRollback();
                Boolean bl = Boolean.FALSE;
                if (handle != null) {
                    if (var13_17 != null) {
                        try {
                            handle.close();
                        }
                        catch (Throwable throwable) {
                            var13_17.addSuppressed(throwable);
                        }
                    } else {
                        handle.close();
                    }
                }
                return bl;
            }
        }
        return Boolean.TRUE;
    }

    private static Map<Long, Map<String, Object>> getUpdateRecordInfo(DynamicObject[] records) {
        HashMap<Long, Map<String, Object>> map = new HashMap<Long, Map<String, Object>>(records.length);
        for (DynamicObject record : records) {
            Long entryId;
            Long dataid = record.getLong(DATAID);
            Map dataMap = new HashMap(3);
            if (map.containsKey(dataid)) {
                dataMap = (Map)map.get(dataid);
            }
            if ((entryId = Long.valueOf(record.getLong(DATAENTRYID))) == 0L) {
                List<String> fields = new ArrayList<String>(2);
                if (dataMap.containsKey(HEAD_FILED)) {
                    fields = (List)dataMap.get(HEAD_FILED);
                }
                fields.add(record.getString(FIELDNAME));
                dataMap.put(HEAD_FILED, fields);
                map.put(dataid, dataMap);
                continue;
            }
            Map entryMap = new HashMap();
            if (dataMap.containsKey(ENTRY_FILED)) {
                entryMap = (Map)dataMap.get(ENTRY_FILED);
            }
            String entryname = record.getString(ENTRYNAME);
            Map entryDataMap = new HashMap();
            if (entryMap.containsKey(entryname)) {
                entryDataMap = (Map)entryMap.get(entryname);
            }
            List<String> fields = new ArrayList<String>();
            if (entryDataMap.containsKey(entryId)) {
                fields = (List)entryDataMap.get(entryId);
            }
            fields.add(record.getString(FIELDNAME));
            entryDataMap.put(entryId, fields);
            entryMap.put(entryname, entryDataMap);
            dataMap.put(ENTRY_FILED, entryMap);
            map.put(dataid, dataMap);
        }
        return map;
    }

    private static DynamicObject buildUpdateRecord(String entityNumber, Long dataid, Long entrydataid, String filedName, Long oldAcctId, Long newAcctId, String entryName) {
        DynamicObject updateRecord = BusinessDataServiceHelper.newDynamicObject((String)BD_ACCOUNT_UPDATERECORD);
        updateRecord.set(METADATA, (Object)entityNumber);
        updateRecord.set(DATAID, (Object)dataid);
        updateRecord.set(DATAENTRYID, (Object)entrydataid);
        updateRecord.set(ENTRYNAME, (Object)entryName);
        updateRecord.set(FIELDNAME, (Object)filedName);
        updateRecord.set(REACCOUNTID, (Object)oldAcctId);
        updateRecord.set(AFACCOUNTID, (Object)newAcctId);
        updateRecord.set(CREATER, (Object)Long.valueOf(RequestContext.get().getUserId()));
        updateRecord.set(CREATEDATE, (Object)new Date());
        return updateRecord;
    }

    private static Set<String> getAllMetadatas() {
        List<Map<String, String>> metaInfos = BaseDataupForAccver.getAllMetaInfos();
        Set<String> set = BaseDataupForAccver.getMasterNumber(metaInfos);
        for (Map<String, String> metaInfo : metaInfos) {
            if (!"0".equals(metaInfo.get(TYPE))) continue;
            set.add(metaInfo.get(NUMBER));
        }
        return set;
    }

    private static Set<String> getMasterNumber(List<Map<String, String>> metaInfos) {
        HashSet<String> set = new HashSet<String>(metaInfos.size());
        for (Map<String, String> map : metaInfos) {
            set.add(map.get(MASTER));
        }
        Object[] array = set.toArray();
        String param = StringUtils.arrayToDelimitedString((Object[])array, (String)",");
        String sql = String.format("select fnumber number,ftype type,fmasterid master from t_meta_entitydesign where ftype = '0' and fid in ('%s')", param);
        set.clear();
        try (DataSet dataset = DB.queryDataSet((String)"kd.fi.bd.util.BaseDataupForAccountVersion.getAllMetadatas", (DBRoute)DBRoute.of((String)"sys.meta"), (String)sql);){
            while (dataset.hasNext()) {
                Row row = dataset.next();
                set.add(row.getString(NUMBER));
            }
        }
        return set;
    }

    private static List<Map<String, String>> getAllMetaInfos() {
        String sql = String.format("select fnumber number,ftype type,fmasterid master from t_meta_entitydesign where fdata like %s and fmodeltype in %s", "'%AccountField%'", "('BaseFormModel','BillFormModel')");
        ArrayList<Map<String, String>> metaInfos = new ArrayList<Map<String, String>>(16);
        try (DataSet set = DB.queryDataSet((String)"kd.fi.bd.util.BaseDataupForAccountVersion.getAllMetadatas", (DBRoute)DBRoute.of((String)"sys.meta"), (String)sql);){
            while (set.hasNext()) {
                Row row = set.next();
                HashMap<String, String> map = new HashMap<String, String>(3);
                map.put(NUMBER, row.getString(NUMBER));
                map.put(TYPE, row.getString(TYPE));
                map.put(MASTER, row.getString(MASTER));
                metaInfos.add(map);
            }
        }
        return metaInfos;
    }
}

