/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.opplugin;

import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.operate.webapi.AbstractOperateWebApi;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.HeartBeat;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.fi.bd.cache.CacheHelper;
import kd.fi.bd.cache.CacheModule;
import kd.fi.bd.opplugin.AccountBatchImportSheetHandler;
import kd.fi.bd.opplugin.accountimport.AccountBatchUpdateImportSavePlugin;
import kd.fi.bd.opplugin.accountimport.AccountImportContext;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.util.DebugTraceHelper;

public class AccountBatchImportPlugin
extends BatchImportPlugin {
    private static final Log LOGGER = LogFactory.getLog(AccountBatchImportPlugin.class);
    private String PREFIX_LOG = "AccountBatchImportPlugin_";

    public List<String> getDefaultLockUIs() {
        ArrayList<String> lockUIs = new ArrayList<String>(2);
        lockUIs.add("radiofield2");
        return lockUIs;
    }

    protected boolean isForceBatch() {
        return true;
    }

    protected int getBatchImportSize() {
        return 10000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resolveExcel() {
        boolean impByLine = this.ctx.getAllUrls().stream().anyMatch(url -> url.contains(ResManager.loadKDString((String)"\u6309\u5217\u5bfc\u5165", (String)"AccountBatchImportPlugin_2", (String)"fi-bd-opplugin", (Object[])new Object[0])) || url.contains(ResManager.loadKDString((String)"\u6309\u5217\u5f15\u5165", (String)"AccountBatchImportPlugin_5", (String)"fi-bd-opplugin", (Object[])new Object[0])));
        String columntoline = BillParamUtil.getStringValue((String)"P9H6JC5EVP1", (String)"fi.bd.account.batchimport.columntoline", (String)"true");
        if (!columntoline.equals("true") || !impByLine) {
            if (DebugTrace.enable()) {
                LOGGER.info(this.PREFIX_LOG + "columntoline");
            }
            super.resolveExcel();
        } else {
            FileService service = FileServiceFactory.getAttachmentFileService();
            ExcelReader reader = new ExcelReader();
            Map option = this.ctx.getOption();
            for (String url2 : this.ctx.getAllUrls()) {
                try {
                    InputStream in = service.getInputStream(url2);
                    Throwable throwable = null;
                    try {
                        MainEntityType mainEntityType = this.buildMainEntityType(null);
                        if (mainEntityType instanceof QueryEntityType) {
                            mainEntityType = ((QueryEntityType)mainEntityType).getMainEntityType();
                        }
                        HeartBeat heartbeat = new HeartBeat();
                        reader.read(in, (SheetHandler)new AccountBatchImportSheetHandler(this.ctx, mainEntityType, url2, option, heartbeat));
                    }
                    catch (Throwable mainEntityType) {
                        throwable = mainEntityType;
                        throw mainEntityType;
                    }
                    finally {
                        if (in == null) continue;
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable mainEntityType) {
                                throwable.addSuppressed(mainEntityType);
                            }
                            continue;
                        }
                        in.close();
                    }
                }
                catch (Exception e) {
                    if (SystemParamServiceHelper.isShowStackTrace()) {
                        this.ctx.getLogger(url2).log(Integer.valueOf(0), (Throwable)e);
                    } else {
                        Throwable cause = e.getCause();
                        String importErrMsg = cause instanceof KDBizException ? e.getMessage() : ResManager.loadKDString((String)"\u89e3\u6790\u5f02\u5e38\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790", (String)"BatchImportPlugin_1", (String)"bos-import", (Object[])new Object[0]);
                        this.ctx.getLogger(url2).log(Integer.valueOf(0), importErrMsg);
                    }
                    this.ctx.addBillData(url2, new ImportBillData(new JSONObject(), 0, 0));
                }
                finally {
                    this.ctx.setResolveComplete(url2);
                }
            }
        }
    }

    public AbstractOperateWebApi getSaveWebApi() {
        AccountBatchUpdateImportSavePlugin saveWebApi = new AccountBatchUpdateImportSavePlugin();
        saveWebApi.setOperationNumber("update_import");
        return saveWebApi;
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        for (ImportBillData rowdata : rowdatas) {
            JSONObject data = rowdata.getData();
            data.put("update_import", (Object)"1");
        }
        ArrayList<ApiResult> apiResults = new ArrayList<ApiResult>(8);
        Map<String, List<ImportBillData>> accTableBillDatas = this.groupByAccTableData(rowdatas, logger);
        for (Map.Entry entry : accTableBillDatas.entrySet()) {
            List rowDatas = (List)entry.getValue();
            for (ImportBillData rowData : rowDatas) {
                ApiResult apiResult;
                AbstractOperateWebApi saveWebApi = this.getSaveWebApi();
                saveWebApi.setOperationNumber("update_import");
                if (DebugTrace.enable()) {
                    LOGGER.info("begin to process data: {}", (Object)DebugTraceHelper.toString((Object)rowData));
                }
                if (null == (apiResult = super.save(Collections.singletonList(rowData), logger))) continue;
                apiResults.add(apiResult);
            }
        }
        ApiResult result = this.getApiResult(apiResults);
        return result;
    }

    private ApiResult getApiResult(List<ApiResult> apiResults) {
        ApiResult result = new ApiResult();
        ArrayList datas = new ArrayList(8);
        StringBuilder msg = new StringBuilder();
        for (ApiResult apiResult : apiResults) {
            Object data;
            if (apiResult.getSuccess()) {
                result.setErrorCode(apiResult.getErrorCode());
                result.setSuccess(apiResult.getSuccess());
            } else {
                msg.append(apiResult.getMessage()).append(";");
                result.setSuccess(apiResult.getSuccess());
            }
            if (!Objects.nonNull(data = apiResult.getData())) continue;
            datas.addAll((List)data);
        }
        result.setMessage(msg.toString());
        result.setData(datas);
        return result;
    }

    private Map<String, List<ImportBillData>> groupByAccTableData(List<ImportBillData> dataEntities, ImportLogger logger) {
        HashMap<String, Map<String, List<String>>> currEntry = new HashMap<String, Map<String, List<String>>>(8);
        HashMap<String, List<ImportBillData>> accTableBillDatas = new HashMap<String, List<ImportBillData>>(8);
        for (int i = 0; i < dataEntities.size(); ++i) {
            ImportBillData billdata = dataEntities.get(i);
            JSONObject data = billdata.getData();
            JSONObject createOrg = data.getJSONObject("createorg");
            JSONObject accountTable = data.getJSONObject("accounttable");
            JSONObject accountType = data.getJSONObject("accounttype");
            if (createOrg == null || accountTable == null || accountType == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6a21\u677f\u4e2d(\u7b2c%s\u884c)\u5fc5\u987b\u5305\u542b\u521b\u5efa\u7ec4\u7ec7\uff0c\u79d1\u76ee\u8868\uff0c\u79d1\u76ee\u7c7b\u578b\u3002", (String)"AccountBatchImportPlugin_0", (String)"fi-bd-opplugin", (Object[])new Object[0]), data.get((Object)"rowNum")));
            }
            if (!(accountType.containsKey((Object)"number") && accountTable.containsKey((Object)"number") && createOrg.containsKey((Object)"number"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6a21\u677f(\u7b2c%s\u884c)\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u4f7f\u7528\u6b63\u786e\u7684\u6a21\u677f\u5bfc\u5165\u3002", (String)"AccountBatchImportPlugin_1", (String)"fi-bd-opplugin", (Object[])new Object[0]), data.get((Object)"rowNum")));
            }
            Map<Integer, String> errorMessageMap = AccountImportContext.setImportAccAssist(data, currEntry);
            if (DebugTrace.enable()) {
                LOGGER.info(this.PREFIX_LOG + data.get((Object)"number"), (Object)data.toJSONString());
            }
            if (!CollectionUtil.isEmpty(errorMessageMap)) {
                for (Map.Entry<Integer, String> erryMessageEntry : errorMessageMap.entrySet()) {
                    logger.log(erryMessageEntry.getKey(), erryMessageEntry.getValue());
                }
                logger.setFailed(logger.getFailed() + 1);
                continue;
            }
            accTableBillDatas.computeIfAbsent(accountTable.getString("number"), k -> new ArrayList(8)).add(billdata);
        }
        String cacheKey = "accountupdateimport_" + RequestContext.get().getGlobalSessionId();
        String currEntryInfo = SerializationUtils.toJsonString(currEntry);
        if (DebugTrace.enable()) {
            LOGGER.info("requestId: {}; accountImportEntryVo: {}", (Object)cacheKey, (Object)currEntryInfo);
        }
        CacheHelper.getDistributeCache((CacheModule)CacheModule.report).put(cacheKey, currEntryInfo);
        return accTableBillDatas;
    }
}

