/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.opplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.BDUtil;

public class AccountSaveParam {
    private static int INITSIZE = 10;
    private Set<Object> acctIds;
    private Map<Object, List<DynamicObject>> orgIdBookMap;
    private Map<Object, List<DynamicObject>> tableIdBizBookMap;
    private Map<String, List<DynamicObject>> periodTypeDatePeriodMap;
    private Map<String, Integer> orgBooktypeExistVoucherMap;
    private Map<String, Integer> rootorgBookExistVoucherMap;
    private Map<String, List<Long>> orgIdSubOrgIdsMap;
    private Map<Long, List<Long>> acctIdUseOrgIdsMap;
    private Map<String, List<DynamicObject>> orgTableAllSubAcctsMap;
    private Map<String, List<DynamicObject>> acctOrgTableAllSubAcctsMap;
    private Map<Long, Set<Long>> orgIdleafUpdateParentIds;
    private List<Map<String, Object>> balanceCarriedIntoLeafList;
    private Set<Long> periodTypeIds;

    protected static AccountSaveParam getInstance() {
        return new AccountSaveParam();
    }

    private AccountSaveParam() {
        this.initParams();
    }

    private void initParams() {
        this.orgIdBookMap = new HashMap<Object, List<DynamicObject>>(INITSIZE);
        this.tableIdBizBookMap = new HashMap<Object, List<DynamicObject>>(INITSIZE * 10);
        this.periodTypeDatePeriodMap = new HashMap<String, List<DynamicObject>>(INITSIZE);
        this.orgBooktypeExistVoucherMap = new HashMap<String, Integer>(INITSIZE);
        this.rootorgBookExistVoucherMap = new HashMap<String, Integer>(INITSIZE);
        this.orgIdSubOrgIdsMap = new HashMap<String, List<Long>>(INITSIZE * 10);
        this.acctIdUseOrgIdsMap = new HashMap<Long, List<Long>>(INITSIZE * 10);
        this.orgTableAllSubAcctsMap = new HashMap<String, List<DynamicObject>>(INITSIZE);
        this.acctOrgTableAllSubAcctsMap = new HashMap<String, List<DynamicObject>>(INITSIZE);
        this.acctIds = new HashSet<Object>(INITSIZE * 5);
        this.orgIdleafUpdateParentIds = new HashMap<Long, Set<Long>>(INITSIZE * 5);
        this.balanceCarriedIntoLeafList = new ArrayList<Map<String, Object>>(INITSIZE * 10);
        this.periodTypeIds = BDUtil.getPeriodType();
    }

    protected Set<Object> getAcctIds() {
        return this.acctIds;
    }

    protected void setAcctIds(Set<Object> acctIds) {
        this.acctIds = acctIds;
    }

    public Map<Object, List<DynamicObject>> getOrgIdBookMap() {
        return this.orgIdBookMap;
    }

    public void setOrgIdBookMap(Map<Object, List<DynamicObject>> orgIdBookMap) {
        this.orgIdBookMap = orgIdBookMap;
    }

    protected Map<Object, List<DynamicObject>> getTableIdBizBookMap() {
        return this.tableIdBizBookMap;
    }

    protected void setTableIdBizBookMap(Map<Object, List<DynamicObject>> tableIdBizBookMap) {
        this.tableIdBizBookMap = tableIdBizBookMap;
    }

    protected Map<String, List<DynamicObject>> getPeriodTypeDatePeriodMap() {
        return this.periodTypeDatePeriodMap;
    }

    protected void setPeriodTypeDatePeriodMap(Map<String, List<DynamicObject>> periodTypeDatePeriodMap) {
        this.periodTypeDatePeriodMap = periodTypeDatePeriodMap;
    }

    protected Map<String, Integer> getOrgBooktypeExistVoucherMap() {
        return this.orgBooktypeExistVoucherMap;
    }

    protected void setOrgBooktypeExistVoucherMap(Map<String, Integer> orgBooktypeExistVoucherMap) {
        this.orgBooktypeExistVoucherMap = orgBooktypeExistVoucherMap;
    }

    protected Map<String, Integer> getRootorgBookExistVoucherMap() {
        return this.rootorgBookExistVoucherMap;
    }

    protected void setRootorgBookExistVoucherMap(Map<String, Integer> rootorgBookExistVoucherMap) {
        this.rootorgBookExistVoucherMap = rootorgBookExistVoucherMap;
    }

    protected Map<String, List<Long>> getOrgIdSubOrgIdsMap() {
        return this.orgIdSubOrgIdsMap;
    }

    protected void setOrgIdSubOrgIdsMap(Map<String, List<Long>> orgIdSubOrgIdsMap) {
        this.orgIdSubOrgIdsMap = orgIdSubOrgIdsMap;
    }

    protected Map<Long, List<Long>> getAcctIdUseOrgIdsMap() {
        return this.acctIdUseOrgIdsMap;
    }

    protected void setAcctIdUseOrgIdsMap(Map<Long, List<Long>> acctIdUseOrgIdsMap) {
        this.acctIdUseOrgIdsMap = acctIdUseOrgIdsMap;
    }

    protected Map<String, List<DynamicObject>> getOrgTableAllSubAcctsMap() {
        return this.orgTableAllSubAcctsMap;
    }

    protected void setOrgTableAllSubAcctsMap(Map<String, List<DynamicObject>> orgTableAllSubAcctsMap) {
        this.orgTableAllSubAcctsMap = orgTableAllSubAcctsMap;
    }

    protected Map<String, List<DynamicObject>> getAcctOrgTableAllSubAcctsMap() {
        return this.acctOrgTableAllSubAcctsMap;
    }

    protected void setAcctOrgTableAllSubAcctsMap(Map<String, List<DynamicObject>> acctOrgTableAllSubAcctsMap) {
        this.acctOrgTableAllSubAcctsMap = acctOrgTableAllSubAcctsMap;
    }

    protected Map<Long, Set<Long>> getOrgIdleafUpdateParentIds() {
        return this.orgIdleafUpdateParentIds;
    }

    protected void setOrgIdleafUpdateParentIds(Map<Long, Set<Long>> orgIdleafUpdateParentIds) {
        this.orgIdleafUpdateParentIds = orgIdleafUpdateParentIds;
    }

    protected List<Map<String, Object>> getBalanceCarriedIntoLeafList() {
        return this.balanceCarriedIntoLeafList;
    }

    protected void setBalanceCarriedIntoLeafList(List<Map<String, Object>> balanceCarriedIntoLeafList) {
        this.balanceCarriedIntoLeafList = balanceCarriedIntoLeafList;
    }

    public Set<Long> getPeriodTypeIds() {
        return this.periodTypeIds;
    }

    protected List<DynamicObject> getBooks(long useorgId) {
        Map<Object, List<DynamicObject>> orgIdBookMap = this.getOrgIdBookMap();
        List<DynamicObject> books = orgIdBookMap.get(useorgId);
        if (books == null) {
            QFilter qf = new QFilter("org", "=", (Object)useorgId);
            DynamicObjectCollection bookColl = QueryServiceHelper.query((String)"gl_accountbook", (String)"id,isbizunit,periodtype.id,bookstype,startperiod.id", (QFilter[])qf.toArray(), (String)"bookstype.accounttype", (int)-1);
            books = new ArrayList<DynamicObject>((Collection<DynamicObject>)bookColl);
            orgIdBookMap.put(useorgId, books);
        }
        return books;
    }

    protected List<DynamicObject> getBizBooksOfTableId(long tableId) {
        Map<Object, List<DynamicObject>> tableIdBizBookMap = this.getTableIdBizBookMap();
        List<DynamicObject> books = tableIdBizBookMap.get(tableId);
        if (books == null) {
            QFilter qf = new QFilter("accounttable", "=", (Object)tableId);
            QFilter qf1 = new QFilter("isbizunit", "=", (Object)true);
            DynamicObjectCollection bookColl = QueryServiceHelper.query((String)"gl_accountbook", (String)"id,isbizunit,org,periodtype,bookstype,startperiod.id", (QFilter[])new QFilter[]{qf, qf1}, (String)"bookstype.accounttype", (int)-1);
            books = new ArrayList<DynamicObject>((Collection<DynamicObject>)bookColl);
            tableIdBizBookMap.put(tableId, books);
        }
        return books;
    }

    protected List<Long> getOrgIdSubOrgIds(long useorgId, boolean isIncludeCur) {
        String key = StringUtils.join((Object[])new Object[]{useorgId, isIncludeCur}, (char)'-');
        List subOrgIds = this.getOrgIdSubOrgIdsMap().get(key);
        if (subOrgIds == null) {
            subOrgIds = BDUtil.getAllSubordinateOrgs((Object)useorgId, (boolean)isIncludeCur);
            this.getOrgIdSubOrgIdsMap().put(key, subOrgIds);
        }
        return subOrgIds;
    }

    protected static Tuple<Boolean, DynamicObject> isAssistItemAdd(DynamicObject acctInDB, DynamicObject account) {
        DynamicObjectCollection itemEntry = account.getDynamicObjectCollection("checkitementry");
        DynamicObjectCollection DBitemEntry = acctInDB.getDynamicObjectCollection("checkitementry");
        HashMap<Object, DynamicObject> DBitemMap = new HashMap<Object, DynamicObject>();
        for (DynamicObject entryRow : DBitemEntry) {
            DynamicObject item = entryRow.getDynamicObject("asstactitem");
            if (item == null) continue;
            DBitemMap.put(item.getPkValue(), entryRow);
        }
        HashMap<Object, DynamicObject> itemMap = new HashMap<Object, DynamicObject>();
        for (DynamicObject entryRow : itemEntry) {
            DynamicObject item = entryRow.getDynamicObject("asstactitem");
            if (item == null) continue;
            itemMap.put(item.getPkValue(), entryRow);
        }
        for (Map.Entry entry : itemMap.entrySet()) {
            Object itemId = entry.getKey();
            DynamicObject entryRow = (DynamicObject)entry.getValue();
            DynamicObject DBentryRow = (DynamicObject)DBitemMap.get(itemId);
            if (DBentryRow != null) continue;
            return new Tuple((Object)Boolean.TRUE, (Object)entryRow.getDynamicObject("asstactitem"));
        }
        return new Tuple((Object)Boolean.FALSE, null);
    }

    protected static Map<String, Object> getBalanceCarriedIntoLeafMap(Object orgId, Object acctMasterid, Object pacctMasterid) {
        HashMap<String, Object> param = new HashMap<String, Object>(3);
        param.put("orgid", orgId);
        param.put("acctid", acctMasterid);
        param.put("parentacctid", pacctMasterid);
        return param;
    }
}

