/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.opplugin;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class AccountTypeSaveValidator
extends AbstractValidator {
    private static final String ENTITY_NAME = "bd_accounttype";

    public void initializeConfiguration() {
        super.initializeConfiguration();
        this.setEntityKey(ENTITY_NAME);
    }

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            QFilter queryName;
            String errorMess;
            Object accounttype = dataEntity.getValue("accounttype");
            Object parentId = dataEntity.getValue("parent_id");
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)ENTITY_NAME);
            String name = dataEntity.getValue("name").toString();
            DynamicObject typeDy = dataEntity.getDataEntity();
            DynamicObject accounttable = typeDy.getDynamicObject("accounttableid");
            if (accounttable == null) break;
            QFilter qf = new QFilter("accounttableid", "=", accounttable.getPkValue());
            Object id = dataEntity.getBillPkId();
            if (!id.equals("0")) {
                qf.and(new QFilter("id", "<>", id));
            }
            String string = errorMess = QueryServiceHelper.exists((String)ENTITY_NAME, (QFilter[])(queryName = new QFilter("name", "=", (Object)name).and(qf)).toArray()) ? ResManager.loadKDString((String)"\u8be5\u79d1\u76ee\u8868\u4e0b\u540d\u79f0\u5df2\u5b58\u5728\u3002", (String)"AccountTypeSaveValidator_0", (String)"fi-bd-opplugin", (Object[])new Object[0]) : "";
            if (!StringUtils.isBlank((CharSequence)errorMess)) {
                this.addErrorMessage(dataEntity, errorMess);
            }
            Optional<String> checkRes = this.checkNumber(dataEntity);
            if (!typeDy.getDataEntityState().getFromDatabase() && checkRes.isPresent()) {
                this.addErrorMessage(dataEntity, checkRes.get());
            }
            if (!"0".equals(parentId.toString())) {
                DynamicObject accountType = BusinessDataReader.loadSingle((Object)parentId, (DynamicObjectType)type);
                String parentAccountType = accountType.getString("accountType");
                if (accounttype == null || accounttype.toString().equals(parentAccountType)) continue;
                errorMess = ResManager.loadKDString((String)"\u79d1\u76ee\u5c5e\u6027\u4e0e\u4e0a\u7ea7\u4e0d\u7b26\u3002", (String)"AccountTypeSaveValidator_1", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, errorMess);
                continue;
            }
            int level = Integer.parseInt(String.valueOf(dataEntity.getValue("level")));
            QFilter queryType = new QFilter("accounttype", "=", accounttype).and(qf).and(new QFilter("level", "=", (Object)level));
            String string2 = errorMess = QueryServiceHelper.exists((String)ENTITY_NAME, (QFilter[])queryType.toArray()) ? ResManager.loadKDString((String)"\u8be5\u79d1\u76ee\u8868\u4e0b\u79d1\u76ee\u5c5e\u6027\u5df2\u5b58\u5728\u3002", (String)"AccountTypeSaveValidator_2", (String)"fi-bd-opplugin", (Object[])new Object[0]) : "";
            if (StringUtils.isBlank((CharSequence)errorMess)) continue;
            this.addErrorMessage(dataEntity, errorMess);
        }
    }

    private Optional<String> checkNumber(ExtendedDataEntity dataEntity) {
        String number = dataEntity.getValue("number").toString();
        QFilter numberFilter = new QFilter("number", "=", (Object)number);
        Map accountTypeMap = BusinessDataServiceHelper.loadFromCache((String)ENTITY_NAME, (QFilter[])numberFilter.toArray());
        if (!CollectionUtils.isEmpty((Map)accountTypeMap)) {
            List tableNames = accountTypeMap.entrySet().stream().map(x -> ((DynamicObject)x.getValue()).getDynamicObject("accounttableid").getString("name")).collect(Collectors.toList());
            String tableName = tableNames.toString();
            return Optional.of(String.format(ResManager.loadKDString((String)"\u79d1\u76ee\u7c7b\u578b\u7f16\u7801\u9700\u552f\u4e00\uff1a\u79d1\u76ee\u8868\uff08%1s\uff09\u4e0b\u5df2\u7ecf\u5b58\u5728\u79d1\u76ee\u7c7b\u578b\u7f16\u7801\u4e3a%2s\u7684\u6570\u636e\uff0c\u8bf7\u4fee\u6539\u5f53\u524d\u79d1\u76ee\u7c7b\u578b\u7f16\u7801\u3002", (String)"AccountTypeSaveValidator_3", (String)"fi-bd-opplugin", (Object[])new Object[0]), tableNames.toString().substring(1, tableName.length() - 1), number));
        }
        return Optional.empty();
    }
}

