/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.ext.fi.accountref.AccountRef;
import kd.bos.ext.fi.util.DateUtils;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.session.ec.ECGlobalSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataService;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.bd.accounttableref.AccountTableRefServiceParam;
import kd.fi.bd.consts.AccountOperationType;
import kd.fi.bd.consts.OperationLogEntry;
import kd.fi.bd.opplugin.AccountOpContext;
import kd.fi.bd.util.AccountOperationLogUtil;
import kd.fi.bd.util.AccountUtils;
import kd.fi.bd.util.AccountVersionControlChecker;
import kd.fi.bd.util.AccountVersionUtil;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.BdBusinessDataServiceHelper;
import kd.fi.bd.util.BizHappenUtils;
import kd.fi.bd.util.Dates;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.util.PerformanceMonitor;

public class AccountVersionDeletePlugin
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(AccountVersionDeletePlugin.class);
    private static final DBRoute DB_ROUTE = DBRoute.of((String)"gl");

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("accounttable");
        e.getFieldKeys().add("longnumber");
        e.getFieldKeys().add("level");
        e.getFieldKeys().add("parent");
        e.getFieldKeys().add("startdate");
        e.getFieldKeys().add("enddate");
        e.getFieldKeys().add("ctrlstrategy");
        e.getFieldKeys().add("useorg");
        e.getFieldKeys().add("createorg");
        e.getFieldKeys().add("isleaf");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        long startValidateTime = System.currentTimeMillis();
        log.info("\u5220\u9664\u7248\u672c\u5316\u6821\u9a8c\u5f00\u59cb\u65f6\u95f4\uff1a" + startValidateTime);
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                ArrayList<OperationLogEntry> entryList = new ArrayList<OperationLogEntry>(10);
                for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
                    DynamicObject account = extendedDataEntity.getDataEntity();
                    OperationLogEntry entry = new OperationLogEntry(Long.valueOf(account.getLong("createorg_id")), Long.valueOf(account.getLong("id")), AccountOperationType.VERSION_DELETE, Boolean.TRUE.booleanValue());
                    entry.setNumber(account.getString("number"));
                    entry.setAccountName(account.getString("name"));
                    entryList.add(entry);
                }
                long accountTableId = this.getDataEntities()[0].getDataEntity().getLong("accounttable_id");
                AccountOperationLogUtil.addLogEntryRow(entryList);
                long startInitTime = System.currentTimeMillis();
                log.info("AccountOpContext.init()\u5f00\u59cb\u65f6\u95f4\uff1a" + startInitTime);
                AccountOpContext.init();
                long endInitTime = System.currentTimeMillis();
                log.info("AccountOpContext.init()\u8017\u65f6\uff1a" + (endInitTime - startInitTime));
                AccountOpContext ctx = AccountOpContext.getContext();
                AccountOpContext.initPidSubIds(ctx, this.getDataEntities());
                DynamicObject acct = null;
                DynamicObject createorg = null;
                String baseDataTableName = null;
                Long useOrgID = Long.parseLong(this.getOption().getVariableValue("createOrg"));
                HashSet<Long> pids = new HashSet<Long>();
                long startForTime = System.currentTimeMillis();
                log.info("for\u5faa\u73af\u5f00\u59cb\u65f6\u95f4\uff1a" + startForTime);
                for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
                    acct = extendedDataEntity.getDataEntity();
                    long accId = acct.getLong("id");
                    long accMasterId = acct.getLong("masterid");
                    String accNumber = acct.getString("number");
                    createorg = acct.getDynamicObject("createorg");
                    if (createorg == null) {
                        AccountVersionDeletePlugin.log("creator org is null", accId, accNumber);
                        continue;
                    }
                    if (!useOrgID.equals(createorg.getPkValue())) {
                        AccountVersionDeletePlugin.log(" operator org is not creator org ", accId, accNumber);
                        this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u4e1a\u52a1\u7ec4\u7ec7\u4e0d\u662f\u57fa\u7840\u6570\u636e\u7684\u521b\u5efa\u7ec4\u7ec7\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"AccountVersionDeletePlugin_0", (String)"fi-bd-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    if (baseDataTableName == null) {
                        baseDataTableName = acct.getDataEntityType().getAlias();
                    }
                    if (baseDataTableName == null) {
                        baseDataTableName = acct.getDataEntityType().getAlias();
                    }
                    if (0 != AccountVersionUtil.compareDate((Date)acct.getDate("enddate"), (Date)AccountVersionUtil.getEndDate())) {
                        AccountVersionDeletePlugin.log(" the version is not the latest version, not allow del ", accId, accNumber);
                        this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u7248\u672c\u4e0d\u662f\u8be5\u79d1\u76ee\u7684\u6700\u65b0\u7248\u672c\u5316\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"AccountVersionDeletePlugin_5", (String)"fi-bd-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                        continue;
                    }
                    if (QueryServiceHelper.exists((String)"bd_accountview", (QFilter[])new QFilter("parent", "=", (Object)accId).toArray())) {
                        this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u4e0b\u7ea7\u79d1\u76ee\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664\u7248\u672c\u5316\u8bb0\u5f55\u30021. \u5982\u679c\u8981\u5220\u9664\u8be5\u79d1\u76ee\uff0c\u8bf7\u5148\u5220\u9664\u5176\u4e0b\u7ea7\u79d1\u76ee\uff1b 2. \u5982\u679c\u8981\u4fee\u6539\u79d1\u76ee\u5185\u5bb9\uff0c\u8bf7\u70b9\u51fb\u79d1\u76ee\u79d1\u76ee\u7248\u672c\u5316\u6309\u94ae\uff0c\u8fdb\u5165\u79d1\u76ee\u7f16\u8f91\u754c\u9762\u8fdb\u884c\u4fee\u6539\u3002", (String)"AccountviewDeleteValidator_9", (String)"fi-bd-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                        continue;
                    }
                    long creatorOrgId = createorg.getLong("id");
                    Set customizedOrg = AccountVersionUtil.getCustomizedOrgInfos((long)accId, null);
                    if (!customizedOrg.isEmpty()) {
                        String errTip = String.join((CharSequence)",", customizedOrg);
                        this.addMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u5220\u9664\u4e0b\u7ea7\u6838\u7b97\u7ec4\u7ec7\u8be5\u79d1\u76ee\u7684\u4e2a\u6027\u5316\u6570\u636e\u3002\u4e2a\u6027\u5316\u8fc7\u8be5\u79d1\u76ee\u7684\u7ec4\u7ec7\u4e3a\uff1a%s\u3002", (String)"AccountVersionDeletePlugin_21", (String)"fi-bd-opplugin", (Object[])new Object[0]), errTip), ErrorLevel.Error);
                        continue;
                    }
                    Set orgIds = null;
                    orgIds = AccountVersionUtil.CTRL_SHARE_STRATEGY.contains(acct.getString("ctrlstrategy")) ? Collections.EMPTY_SET : AccountVersionDeletePlugin.this.queryUseOrgIdsIncludeSelf(Collections.singleton(accId), creatorOrgId);
                    if (BizHappenUtils.existOnLaterPeriods((long)accId, (Set)orgIds, (Date)acct.getDate("startdate"))) {
                        this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7684\u7248\u672c\u5316\u8bb0\u5f55\u5b58\u5728\u51ed\u8bc1\u3001\u4f59\u989d\u6216\u521d\u59cb\u5316\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"AccountVersionDeletePlugin_22", (String)"fi-bd-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                        continue;
                    }
                    if (BizHappenUtils.existsOnOrgDomain((long)accMasterId, (long)useOrgID, (Date)acct.getDate("startdate"))) {
                        AccountVersionDeletePlugin.log(" exist balance during current period or later, not allow del ", accId, accNumber);
                        this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7684\u7248\u672c\u5316\u8bb0\u5f55\u5b58\u5728\u51ed\u8bc1\u3001\u521d\u59cb\u5316\u6216\u79d1\u76ee\u8868\u7248\u672c\u5316\u5bf9\u7167\u4ea7\u751f\u7684\u4f59\u989d\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"AccountVersionDeletePlugin_8", (String)"fi-bd-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                        continue;
                    }
                    boolean isInitVersion = AccountVersionUtil.isAccountInitVersion((DynamicObject)acct, (long)useOrgID);
                    if (isInitVersion && accId == acct.getLong("masterid")) {
                        Set customizedChildOrgs = AccountVersionUtil.getCustomizedOrgInfos((long)accId, null);
                        if (!customizedChildOrgs.isEmpty()) {
                            AccountVersionDeletePlugin.log(" is customized by sub orgs, not allow del ", accId, accNumber);
                            String errTip = String.join((CharSequence)",", customizedChildOrgs);
                            this.addMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u5220\u9664\u4e0b\u7ea7\u6838\u7b97\u7ec4\u7ec7\u8be5\u79d1\u76ee\u7684\u4e2a\u6027\u5316\u6570\u636e\u3002\u4e2a\u6027\u5316\u8fc7\u8be5\u79d1\u76ee\u7684\u7ec4\u7ec7\u4e3a\uff1a%s\u3002", (String)"AccountVersionDeletePlugin_21", (String)"fi-bd-opplugin", (Object[])new Object[0]), errTip), ErrorLevel.Error);
                            continue;
                        }
                        if (AccountVersionUtil.isAccountCustomizedByOrgs((long)accId, Collections.singleton(creatorOrgId))) {
                            AccountVersionDeletePlugin.log(" is customized on current org, not allow del ", accId, accNumber);
                            this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u5148\u5220\u9664\u4e2a\u6027\u5316\u6570\u636e\uff0c\u518d\u5220\u9664\u7248\u672c\u5316\u8bb0\u5f55\u3002", (String)"AccountVersionDeletePlugin_11", (String)"fi-bd-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                            continue;
                        }
                        AccountVersionDeletePlugin.log(" is init record, pls delete on account list ", accId, accNumber);
                        this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u5728\u4f1a\u8ba1\u79d1\u76ee\u5217\u8868\u4e2d\u5220\u9664\u4f1a\u8ba1\u79d1\u76ee\u7684\u521d\u59cb\u8bb0\u5f55\u3002", (String)"AccountVersionDeletePlugin_15", (String)"fi-bd-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                        continue;
                    }
                    if (!this.getOption().containsVariable("isassign")) {
                        Optional lastAccountVersion = AccountVersionUtil.findPreviousAccountVersion((DynamicObject)acct, (long)useOrgID);
                        if (lastAccountVersion.isPresent()) {
                            AccountVersionControlChecker.Result ctrolResult;
                            long _accCreateOrg = ((DynamicObject)lastAccountVersion.get()).getLong("createorg_id");
                            if (_accCreateOrg != useOrgID) {
                                DynamicObjectCollection usingAccVersions = AccountVersionUtil.listAccountFullVersion((long)accId, (long)accMasterId, (String)accNumber, (long)useOrgID, (String)"id,number,startdate,enddate");
                                usingAccVersions.removeIf(x -> x.getLong("id") == accId);
                                ArrayList<Tuple> versionDates = new ArrayList<Tuple>(2);
                                for (DynamicObject usingAccVersion : usingAccVersions) {
                                    versionDates.add(Tuple.create((Object)usingAccVersion.getDate("startdate"), (Object)usingAccVersion.getDate("enddate")));
                                }
                                versionDates.add(Tuple.create((Object)((DynamicObject)lastAccountVersion.get()).getDate("startdate"), (Object)((DynamicObject)lastAccountVersion.get()).getDate("enddate")));
                                if (!AccountVersionDeletePlugin.this.checkVersionDates(versionDates)) {
                                    log.info("AccountVersionDeletePlugin wrong_dates:" + String.join((CharSequence)", ", versionDates.stream().map(x -> String.format("[%s,%s]", x.item1, x.item2)).collect(Collectors.toList())));
                                    String candiateOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)_accCreateOrg, (String)"bos_org", (String)"name").getString("name");
                                    String startDate = DateUtils.formatString((Date)((DynamicObject)lastAccountVersion.get()).getDate("startdate"), (String)"yyyy-MM-dd");
                                    String endDate = DateUtils.formatString((Date)((DynamicObject)lastAccountVersion.get()).getDate("enddate"), (String)"yyyy-MM-dd");
                                    this.addMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u79d1\u76ee\u7684\u7248\u672c\u5316\u8bb0\u5f55\u5df2\u7ecf\u4e0d\u53ef\u9006\uff0c\u8bf7\u901a\u8fc7\u53d6\u6d88\u5206\u914d\u6216\u5728\u5f53\u524d\u79d1\u76ee\u4e0a\u7248\u672c\u5316\u4fee\u6539\u5b9e\u73b0\u79d1\u76ee\u9700\u6c42\u3002", (String)"AccountVersionDeletePlugin_24", (String)"fi-bd-opplugin", (Object[])new Object[0]), candiateOrg, startDate, endDate), ErrorLevel.Error);
                                    if (!DebugTrace.enable()) continue;
                                    log.error("preAccountInfo: createOrg: {}, startDate:{}, endDate: {}", new Object[]{candiateOrg, startDate, endDate});
                                    continue;
                                }
                            }
                            if (AccountVersionControlChecker.Status.SUCCESS != (ctrolResult = AccountVersionControlChecker.checkAccountControl((DynamicObject)((DynamicObject)lastAccountVersion.get()), (long)useOrgID, (AccountVersionControlChecker.RetrieveOrgAccountFunction)new AccountVersionControlChecker.DelRevisionOrgAccountFunction(), (boolean)true, (long)accId, (int)AccountVersionControlChecker.CheckType.allTypes(), (int)AccountVersionControlChecker.AccPropType.allTypes(), (OperateOption)this.getOption())).getStatus()) {
                                AccountVersionDeletePlugin.log(" it could not fulfull the ctrol strategy after deleting: " + ctrolResult.getStatus(), accId, accNumber);
                                String msgTempate = null;
                                if (AccountVersionControlChecker.Status.ACC_UP_FAIL == ctrolResult.getStatus()) {
                                    msgTempate = ResManager.loadKDString((String)"\u5220\u9664\u5f53\u524d\u7248\u672c\u540e\uff0c\u4e0d\u6ee1\u8db3\u5f53\u524d\u7ec4\u7ec7\u79d1\u76ee\u4e0a\u4e0b\u7ea7\u7ba1\u63a7\u6821\u9a8c\uff1a%s", (String)"AccountVersionDeletePlugin_17", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                                } else if (AccountVersionControlChecker.Status.PARTENT_ORG_FAIL == ctrolResult.getStatus()) {
                                    msgTempate = ResManager.loadKDString((String)"\u5220\u9664\u5f53\u524d\u7248\u672c\u540e\uff0c\u4e0d\u6ee1\u8db3\u4e0a\u7ea7\u7ec4\u7ec7\u540c\u4e00\u79d1\u76ee\u4e0a\u4e0b\u7ea7\u7ba1\u63a7\u6821\u9a8c\uff1a%s", (String)"AccountVersionDeletePlugin_18", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                                } else if (AccountVersionControlChecker.Status.CHILD_ORG_FAIL == ctrolResult.getStatus()) {
                                    msgTempate = ResManager.loadKDString((String)"\u5220\u9664\u5f53\u524d\u7248\u672c\u540e\uff0c\u4e0d\u6ee1\u8db3\u4e0b\u7ea7\u7ec4\u7ec7\u540c\u4e00\u79d1\u76ee\u4e0a\u4e0b\u7ea7\u7ba1\u63a7\u6821\u9a8c\uff1a%s", (String)"AccountVersionDeletePlugin_19", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                                } else if (AccountVersionControlChecker.Status.ASSGIN_ACC_FAIL == ctrolResult.getStatus()) {
                                    msgTempate = ResManager.loadKDString((String)"\u5220\u9664\u5f53\u524d\u7248\u672c\u540e\uff0c\u4e0d\u6ee1\u8db3\u5206\u914d\u79d1\u76ee\u7684\u4e0a\u4e0b\u7ea7\u7ba1\u63a7\u6821\u9a8c\uff1a%s", (String)"AccountVersionDeletePlugin_20", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                                } else {
                                    throw new IllegalStateException("not implemented check control type: " + ctrolResult.getStatus());
                                }
                                this.addMessage(extendedDataEntity, String.format(msgTempate, ctrolResult.getErrMsg()), ErrorLevel.Error);
                                continue;
                            }
                            AccountVersionDeletePlugin.log("is ready to delete", accId, accNumber);
                        } else {
                            DynamicObject parent = acct.getDynamicObject("parent");
                            if (parent != null && acct.getDate("startdate").compareTo(AccountVersionUtil.getInitBeginDate()) != 0) {
                                DynamicObject pAccount;
                                AccountVersionControlChecker.Result ctrolResult;
                                QFilter fcreateOrg;
                                QFilter fnumber;
                                DynamicObjectCollection objects;
                                QFilter fNum;
                                QFilter fOrg;
                                QFilter fLevel;
                                String longNum = acct.getString("longnumber");
                                String pLongNumber = longNum.substring(0, longNum.lastIndexOf("_"));
                                long userOrgId = acct.getLong("createorg_id");
                                QFilter fnum_like = new QFilter("longnumber", "like", (Object)(pLongNumber + "_%"));
                                boolean isExistLeaf = QueryServiceHelper.exists((String)"bd_accountview", (QFilter[])new QFilter[]{fnum_like, fLevel = new QFilter("level", "=", (Object)acct.getInt("level")), fOrg = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)userOrgId), fNum = new QFilter("number", "!=", (Object)acct.getString("number"))});
                                if (!isExistLeaf && (objects = QueryServiceHelper.query((String)"AccountVersionDeletePlugin_validate", (String)"bd_accountview", (String)"id,startdate", (QFilter[])new QFilter[]{fnumber = new QFilter("number", "=", (Object)parent.getString("number")), fcreateOrg = new QFilter("createorg", "=", (Object)userOrgId)}, (String)"startdate")).size() > 1 && AccountVersionControlChecker.Status.SUCCESS != (ctrolResult = AccountVersionControlChecker.checkAccountControl((DynamicObject)(pAccount = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)objects.get(objects.size() - 2)).getLong("id"), (String)"bd_accountview")), (long)useOrgID, (AccountVersionControlChecker.RetrieveOrgAccountFunction)new AccountVersionControlChecker.DelRevisionOrgAccountFunction(), (boolean)true, (long)parent.getLong("id"), (int)(AccountVersionControlChecker.CheckType.ACC_UP.getValue() | AccountVersionControlChecker.CheckType.PARTENT_ORG.getValue()), (int)AccountVersionControlChecker.AccPropType.allTypes(), (OperateOption)this.getOption())).getStatus()) {
                                    String msg = "";
                                    switch (ctrolResult.getStatus()) {
                                        case ACC_UP_FAIL: {
                                            msg = ResManager.loadKDString((String)"\u5220\u9664\u5f53\u524d\u7248\u672c\u540e\uff0c\u4e0a\u7ea7\u79d1\u76ee:%1$s\u4e0d\u6ee1\u8db3\u5f53\u524d\u7ec4\u7ec7\u79d1\u76ee\u4e0a\u4e0b\u7ea7\u7ba1\u63a7\u6821\u9a8c\uff1a%2$s", (String)"AccountVersionDeletePlugin_28", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                                            break;
                                        }
                                        case PARTENT_ORG_FAIL: {
                                            msg = ResManager.loadKDString((String)"\u5220\u9664\u5f53\u524d\u7248\u672c\u540e\uff0c\u4e0a\u7ea7\u79d1\u76ee:%1$s\u4e0d\u6ee1\u8db3\u4e0a\u7ea7\u7ec4\u7ec7\u540c\u4e00\u79d1\u76ee\u4e0a\u4e0b\u7ea7\u7ba1\u63a7\u6821\u9a8c\uff1a%2$s", (String)"AccountVersionDeletePlugin_29", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                                            break;
                                        }
                                    }
                                    this.addMessage(extendedDataEntity, String.format(msg, parent.getString("number"), ctrolResult.getErrMsg()), ErrorLevel.Error);
                                }
                            }
                        }
                    }
                    if (acct.getLong("parent_id") == 0L) continue;
                    pids.add(acct.getLong("parent_id"));
                }
                long endForTime = System.currentTimeMillis();
                log.info("for\u5faa\u73af\u6821\u9a8c\u7ed3\u675f\u65f6\u95f4\uff1a" + (endForTime - startForTime));
                Map parentIdSubIds = AccountVersionUtil.filterAccountsNoChildVersioning(pids, (long)useOrgID);
                Map parentIdAddsubIds = AccountVersionUtil.filterAccountsWithBalanceDown(pids, (long)useOrgID);
                for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
                    if (this.getFalseDataEntities().contains(extendedDataEntity)) continue;
                    acct = extendedDataEntity.getDataEntity();
                    if (BizHappenUtils.existsOnOrgDomain((long)acct.getLong("masterid"), (long)acct.getLong("createorg_id"), (Date)acct.getDate("startdate"))) {
                        this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u79d1\u76ee\u8be5\u7248\u672c\u5df2\u6709\u4e1a\u52a1\u53d1\u751f\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"AccountVersionDeletePlugin_6", (String)"fi-bd-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                        continue;
                    }
                    long parentId = acct.getLong("parent_id");
                    if (parentId == 0L) continue;
                    long id = acct.getLong("id");
                    Set subIds = (Set)parentIdSubIds.get(parentId);
                    if (subIds == null || subIds.isEmpty()) {
                        ctx.prepareServiceParam(acct.getLong("createorg_id"), acct.getLong("accounttable_id"), acct.getDate("startdate"), id, parentId);
                        AccountVersionDeletePlugin.this.refrectAccountNewToOldFunc(ctx, id, acct.getLong("createorg_id"), acct.getLong("accounttable_id"), acct.getDate("startdate"), parentId);
                        continue;
                    }
                    Set subAddIds = (Set)parentIdAddsubIds.get(parentId);
                    if (subIds.size() <= 1 || !subIds.contains(id) || subAddIds == null || !subAddIds.contains(id)) continue;
                    this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u79d1\u76ee\u4e3a\u4e0a\u7ea7\u79d1\u76ee\u7248\u672c\u5316\u65b0\u589e\u7684\u7b2c\u4e00\u4e2a\u4e0b\u7ea7\u79d1\u76ee\uff0c\u8bf7\u5148\u5220\u9664\u5176\u4ed6\u540c\u7ea7\u79d1\u76ee\u3002", (String)"AccountVersionDeletePlugin_16", (String)"fi-bd-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                }
            }
        });
        long endValidateTime = System.currentTimeMillis();
        log.info("\u5220\u9664\u7248\u672c\u5316\u6821\u9a8c\u8017\u65f6\uff1a" + (endValidateTime - startValidateTime));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        long startBeginOpTranTime = System.currentTimeMillis();
        super.beginOperationTransaction(e);
        AccountOpContext ctx = AccountOpContext.getContext();
        ArrayList<Long> latestVersionAcctIds = new ArrayList<Long>(e.getDataEntities().length);
        for (DynamicObject acct : e.getDataEntities()) {
            if (0 != AccountVersionUtil.compareDate((Date)acct.getDate("enddate"), (Date)AccountVersionUtil.getEndDate())) continue;
            latestVersionAcctIds.add(acct.getLong("id"));
        }
        if (!latestVersionAcctIds.isEmpty()) {
            Object object;
            HashMap<Long, Set> newIdOldInfos = new HashMap<Long, Set>();
            boolean addParentId = false;
            StringBuilder sql = new StringBuilder("select t1.fid newacctid, t1.flevel newlevel, t1.fparentid newparentid, t2.fid oldacctid, t2.flevel oldlevel, t1.fcreateorgid createorgid,t1.faccounttableid tableid,t1.fstartdate startdate,t2.fstartdate oldstartdate from t_bd_account t1,t_bd_account t2 where t1.fmasterid=t2.fmasterid and t1.fcreateorgid=t2.fcreateorgid and t1.fstartdate=t2.fenddate and t1.fid in (").append(AccountVersionUtil.getIds(latestVersionAcctIds)).append(')');
            Throwable throwable = null;
            try (DataSet dt = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DB_ROUTE, (String)sql.toString());){
                object = dt.iterator();
                while (object.hasNext()) {
                    Row row = (Row)object.next();
                    if (row.getInteger("newlevel") == row.getInteger("oldlevel") + 1) {
                        addParentId = true;
                    }
                    Set oldInfos = newIdOldInfos.computeIfAbsent(row.getLong("newacctid"), k -> new HashSet());
                    HashMap<String, Comparable<Date>> oldInfo = new HashMap<String, Comparable<Date>>(2);
                    oldInfo.put("startdate", row.getDate("startdate"));
                    oldInfo.put("oldstartdate", row.getDate("oldstartdate"));
                    oldInfo.put("createorgid", row.getLong("createorgid"));
                    oldInfo.put("tableid", row.getLong("tableid"));
                    oldInfo.put("oldacctid", row.getLong("oldacctid"));
                    oldInfo.put("newparentid", row.getLong("newparentid"));
                    oldInfo.put("exlevel", Integer.valueOf(row.getInteger("newlevel") - row.getInteger("oldlevel")));
                    oldInfos.add(oldInfo);
                }
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            for (Map.Entry entry : newIdOldInfos.entrySet()) {
                long newacctid = (Long)entry.getKey();
                long createOrgId = 0L;
                long tableid = 0L;
                long newparentid = 0L;
                Date startdate = null;
                Date maxDate = null;
                long maxoldacctid = 0L;
                Set oldInfos = (Set)entry.getValue();
                for (Map oldInfo : oldInfos) {
                    if (addParentId && (Integer)oldInfo.get("exlevel") != 1) continue;
                    Date oldstartdate = (Date)oldInfo.get("oldstartdate");
                    if (maxDate == null) {
                        maxDate = oldstartdate;
                        newparentid = (Long)oldInfo.get("newparentid");
                        createOrgId = (Long)oldInfo.get("createorgid");
                        tableid = (Long)oldInfo.get("tableid");
                        startdate = (Date)oldInfo.get("startdate");
                        maxoldacctid = (Long)oldInfo.get("oldacctid");
                        continue;
                    }
                    if (-1 != AccountVersionUtil.compareDate((Date)maxDate, (Date)oldstartdate)) continue;
                    maxoldacctid = (Long)oldInfo.get("oldacctid");
                }
                if (maxDate == null) continue;
                if (addParentId) {
                    ctx.getDeletePids().add(newparentid);
                    ctx.prepareServiceParam(createOrgId, tableid, startdate, newparentid, maxoldacctid);
                    this.refrectAccountNewToOldFunc(ctx, newparentid, createOrgId, tableid, startdate, maxoldacctid);
                } else {
                    this.refrectAccountNewToOldFunc(ctx, newacctid, createOrgId, tableid, startdate, maxoldacctid);
                }
                ctx.prepareServiceParam(createOrgId, tableid, startdate, newacctid, maxoldacctid);
            }
            HashMap<Long, Object[]> personIdParams = new HashMap<Long, Object[]>();
            for (Long id : latestVersionAcctIds) {
                boolean hasLatestVersion = false;
                for (Map.Entry<String, AccountTableRefServiceParam> paramEntry : ctx.getRefServiceParam().entrySet()) {
                    AccountTableRefServiceParam param = paramEntry.getValue();
                    if (!param.getAccountTableRef().getNewAccountIdSet().contains(id)) continue;
                    hasLatestVersion = true;
                    break;
                }
                if (hasLatestVersion) continue;
                personIdParams.put(id, null);
            }
            if (!personIdParams.isEmpty()) {
                DataSet dataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DB_ROUTE, (String)StringUtils.join((Object[])new Object[]{"SELECT t1.fid newid,t2.fid oldid,t1.fcreateorgid neworgid,t1.faccounttableid accounttable,t1.fstartdate versiondate,t2.fcreatetime createtime FROM t_bd_account t1,t_bd_account t2,t_bd_accountexc t3 WHERE t1.fmasterid=t2.fmasterid AND t1.fcreateorgid<>t2.fcreateorgid AND t2.fid=t3.FDATAID AND t1.fcreateorgid=t3.FUSEORGID and t1.flevel=t2.flevel and t1.fid in (", this.getSufFixSql(personIdParams.keySet())}));
                object = null;
                try {
                    for (Row row : dataSet) {
                        Date createtime = row.getDate("createtime");
                        long newId = row.getLong("newid");
                        long oldId = row.getLong("oldid");
                        long createorgId = row.getLong("neworgid");
                        long accounttableId = row.getLong("accounttable");
                        Date versiondate = row.getDate("versiondate");
                        Object[] params = (Object[])personIdParams.get(newId);
                        if (params == null) {
                            params = new Object[]{createtime, createorgId, accounttableId, versiondate, newId, oldId};
                        } else if (createtime.after((Date)params[0])) {
                            params = new Object[]{createtime, createorgId, accounttableId, versiondate, newId, oldId};
                        }
                        personIdParams.put(newId, params);
                    }
                }
                catch (Throwable hasLatestVersion) {
                    object = hasLatestVersion;
                    throw hasLatestVersion;
                }
                finally {
                    if (dataSet != null) {
                        if (object != null) {
                            try {
                                dataSet.close();
                            }
                            catch (Throwable hasLatestVersion) {
                                ((Throwable)object).addSuppressed(hasLatestVersion);
                            }
                        } else {
                            dataSet.close();
                        }
                    }
                }
                long l = System.currentTimeMillis();
                for (Map.Entry personIdParamsEntry : personIdParams.entrySet()) {
                    Object[] params = (Object[])personIdParamsEntry.getValue();
                    if (params == null) continue;
                    ctx.getSelfDomParams().add(new Object[]{params[5], params[1]});
                    ctx.prepareServiceParam((Long)params[1], (Long)params[2], (Date)params[3], (Long)params[4], (Long)params[5]);
                    this.refrectAccountNewToOldFunc(ctx, (Long)params[4], (Long)params[1], (Long)params[2], (Date)params[3], (Long)params[5]);
                }
                long endPrepareTime = System.currentTimeMillis();
                log.info("\u7ed3\u8f6c\u79d1\u76ee\u5173\u7cfb\u8017\u65f6\uff1a" + (endPrepareTime - l));
            }
            this.excuteNonTxService(ctx.getRefServiceParam());
        }
        long endBeginOpTranTime = System.currentTimeMillis();
        log.info("beginOperationTransaction\u8017\u65f6\uff1a" + (endBeginOpTranTime - startBeginOpTranTime));
    }

    private void refrectAccountNewToOldFunc(AccountOpContext ctx, long newacctid, long createOrgId, long tableid, Date startdate, long maxoldacctid) {
        Set childrenOrgIds = BDUtil.listAllChildOrgs((long)createOrgId, (boolean)true);
        if (Objects.nonNull(childrenOrgIds)) {
            for (Long childOrgId : childrenOrgIds) {
                ctx.prepareServiceParam(childOrgId, tableid, startdate, newacctid, maxoldacctid);
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        long startAfterTime = System.currentTimeMillis();
        super.afterExecuteOperationTransaction(e);
        long accountTableId = e.getDataEntities()[0].getDynamicObject("accounttable").getLong("id");
        AccountOpContext ctx = AccountOpContext.getContext();
        Map<String, AccountTableRefServiceParam> refServiceParamMap = ctx.getRefServiceParam();
        long useOrgID = Long.parseLong(this.getOption().getVariableValue("createOrg"));
        HashSet<Long> useorgIdSet = new HashSet(10);
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                HashSet<Long> updateIds = new HashSet<Long>();
                HashSet<Long> delIds = new HashSet<Long>();
                for (Map.Entry<String, AccountTableRefServiceParam> refServiceParamMapEntry : refServiceParamMap.entrySet()) {
                    AccountTableRefServiceParam param = refServiceParamMapEntry.getValue();
                    AccountRef accountRef = param.getAccountTableRef().getAccountRef();
                    updateIds.addAll(accountRef.getOldAndNewAccountRef().keySet());
                    delIds.addAll(accountRef.getOldAndNewAccountRef().values());
                }
                delIds.addAll(ctx.getDeletePids());
                if (delIds.isEmpty()) {
                    for (DynamicObject obj : e.getDataEntities()) {
                        delIds.add(obj.getLong("id"));
                    }
                }
                useorgIdSet = this.queryUseOrgids(delIds);
                this.updateEndDate4LastAccount(updateIds, useOrgID);
                if (!delIds.isEmpty()) {
                    Map delAccMap = BdBusinessDataServiceHelper.loadFromCache((Object[])delIds.toArray(new Long[0]), (String)String.join((CharSequence)",", "masterid", "id", "number"), (String)"bd_accountview");
                    this.deleteAndUpdateParentAccount(delIds, useOrgID, accountTableId);
                    delAccMap.values().forEach(this::delRelateExcRecord);
                    this.updateControlTable(ctx, delIds);
                    this.updateAccountTableRef(delIds);
                }
            }
            catch (Exception exception) {
                txHandle.markRollback();
                throw exception;
            }
        }
        if (AccountVersionUtil.isRebuildDataUseRangeSystemProperty()) {
            PerformanceMonitor.watch((Supplier)new ClearControlCache(useOrgID, useorgIdSet), (int)10, useorgIdSet);
        }
        long endAfterTime = System.currentTimeMillis();
        log.info("afterExecuteOperationTransaction\u8017\u65f6\uff1a" + (endAfterTime - startAfterTime));
    }

    private Set<Long> queryUseOrgids(Set<Long> delIds) {
        if (delIds == null || delIds.size() == 0) {
            return delIds;
        }
        ArrayList<Long> acctountSqlParams = new ArrayList<Long>(10);
        StringBuilder acctountSql = new StringBuilder();
        acctountSql.append(" select fuseorgid from t_bd_accountusereg where fdataid in ( ");
        delIds.forEach(k -> acctountSql.append("?,"));
        acctountSqlParams.addAll(delIds);
        acctountSql.deleteCharAt(acctountSql.length() - 1).append(" ) ");
        Set useorgIdSet = (Set)DB.query((DBRoute)DB_ROUTE, (String)acctountSql.toString(), (Object[])acctountSqlParams.toArray(), rs -> {
            HashSet<Long> returnObjs = new HashSet<Long>(10);
            while (rs.next()) {
                returnObjs.add(rs.getLong("fuseorgid"));
            }
            return returnObjs;
        });
        return useorgIdSet;
    }

    private Set<Long> queryUseOrgIdsIncludeSelf(Set<Long> delIds, long creatorOrgId) {
        Set<Long> useOrgIdSet = this.queryUseOrgids(delIds);
        if (useOrgIdSet != null) {
            useOrgIdSet.add(creatorOrgId);
        }
        return useOrgIdSet;
    }

    private void delRelateExcRecord(DynamicObject dyo) {
        long useOrgId = Long.parseLong(this.getOption().getVariableValue("createOrg"));
        long masterId = dyo.getLong("masterid");
        long accId = dyo.getLong("id");
        String number = dyo.getString("number");
        if (AccountVersionUtil.personalize((Long)useOrgId, (Long)masterId, (Long)accId, (String)number)) {
            HashSet<Long> delDataIds = new HashSet<Long>();
            Set<Long> sameMasterDataIds = QueryServiceHelper.query((String)"bd_accountview", (String)"id", (QFilter[])new QFilter[]{new QFilter("masterid", "=", (Object)masterId), new QFilter("number", "=", (Object)number)}).stream().map(d -> d.getLong("id")).collect(Collectors.toSet());
            if (!sameMasterDataIds.isEmpty()) {
                this.constructDelData(sameMasterDataIds, delDataIds, useOrgId, useOrgId);
                if (!delDataIds.isEmpty()) {
                    SqlBuilder sql = new SqlBuilder();
                    sql.append("select fuseorgid from t_bd_accountusereg where fdataid = ?", new Object[]{accId});
                    ArrayList<Long> assignOrgIds = new ArrayList<Long>(8);
                    try (DataSet dt = DB.queryDataSet((String)AccountVersionUtil.class.getName(), (DBRoute)DB_ROUTE, (SqlBuilder)sql);){
                        Row row = null;
                        while (dt.hasNext()) {
                            row = dt.next();
                            assignOrgIds.add(row.getLong("fuseorgid"));
                        }
                    }
                    if (!assignOrgIds.isEmpty()) {
                        sql = new SqlBuilder();
                        sql.appendIn("delete from t_bd_accountexc where fdataid", delDataIds.toArray());
                        sql.appendIn("AND fuseorgid", assignOrgIds.toArray());
                        DB.execute((DBRoute)DB_ROUTE, (SqlBuilder)sql);
                        List insertParams = assignOrgIds.stream().map(orgId -> delDataIds.stream().map(dataid -> new Object[]{dataid, orgId}).collect(Collectors.toList())).collect(ArrayList::new, (r, x) -> r.addAll(x), ArrayList::addAll);
                        if (!insertParams.isEmpty()) {
                            DB.executeBatch((DBRoute)DB_ROUTE, (String)"delete from t_bd_account_u where fdataid = ? and fuseorgid = ?", (List)insertParams);
                            DB.executeBatch((DBRoute)DB_ROUTE, (String)"insert into t_bd_account_u(fdataid,fuseorgid) values(?,?)", (List)insertParams);
                        }
                    }
                } else {
                    StringBuilder dataUseRangeSqlStr = new StringBuilder();
                    dataUseRangeSqlStr.append("delRelateExcRecord : can't find delDataIds, delete other releation datas : ");
                    SqlBuilder dataUseRangeSql = new SqlBuilder();
                    dataUseRangeSql.appendIn("delete from t_bd_accountusereg where fdataid", sameMasterDataIds.toArray());
                    dataUseRangeSql.append("and fuseorgid = ?", new Object[]{useOrgId});
                    dataUseRangeSqlStr.append(dataUseRangeSql.toString());
                    DB.execute((DBRoute)DB_ROUTE, (SqlBuilder)dataUseRangeSql);
                    dataUseRangeSql = new SqlBuilder();
                    dataUseRangeSql.appendIn("delete from t_bd_accountexc where fdataid", sameMasterDataIds.toArray());
                    dataUseRangeSql.append("and fuseorgid = ?", new Object[]{useOrgId});
                    dataUseRangeSqlStr.append(dataUseRangeSql.toString());
                    DB.execute((DBRoute)DB_ROUTE, (SqlBuilder)dataUseRangeSql);
                    dataUseRangeSql = new SqlBuilder();
                    dataUseRangeSql.appendIn("delete from t_bd_account_u where fdataid", sameMasterDataIds.toArray());
                    dataUseRangeSql.append("and fuseorgid = ?", new Object[]{useOrgId});
                    dataUseRangeSqlStr.append(dataUseRangeSql.toString());
                    DB.execute((DBRoute)DB_ROUTE, (SqlBuilder)dataUseRangeSql);
                    ArrayList<OperationLogEntry> entryList = new ArrayList<OperationLogEntry>(10);
                    OperationLogEntry entry = new OperationLogEntry(Long.valueOf(useOrgId), Long.valueOf(accId), AccountOperationType.VERSION_DELETE, Boolean.TRUE.booleanValue());
                    entry.setNumber(number);
                    entry.setAccountName(dyo.getString("name"));
                    entry.setLog(dataUseRangeSqlStr.toString());
                    entryList.add(entry);
                    AccountOperationLogUtil.addLogEntryRow(entryList);
                }
            }
        }
    }

    private void constructDelData(Set<Long> sameMasterDataIds, Set<Long> delDataIds, long iterUseOrgId, long useOrgId) {
        long parentOrg = this.getParentOrg(iterUseOrgId);
        if (parentOrg == 0L) {
            return;
        }
        SqlBuilder sql = new SqlBuilder();
        sql.appendIn("select fdataid id from t_bd_accountexc where fdataid", sameMasterDataIds.toArray());
        sql.append("and fcreateorgid = ?", new Object[]{parentOrg});
        HashSet<Long> accountId = new HashSet<Long>(10);
        try (DataSet dt = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DB_ROUTE, (SqlBuilder)sql);){
            for (Row row : dt) {
                accountId.add(row.getLong("id"));
            }
        }
        if (accountId.size() == 0) {
            this.constructDelData(sameMasterDataIds, delDataIds, parentOrg, useOrgId);
        } else {
            sql = new SqlBuilder();
            sql.appendIn("select count(fdataid) count from t_bd_accountusereg where fdataid", accountId.toArray());
            sql.append("and fuseorgid = ?", new Object[]{useOrgId});
            int count = 0;
            DataSet dt = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DB_ROUTE, (SqlBuilder)sql);
            Object object = null;
            try {
                for (Row row : dt) {
                    count = row.getInteger("count");
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (dt != null) {
                    if (object != null) {
                        try {
                            dt.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        dt.close();
                    }
                }
            }
            if (count == 0) {
                this.constructDelData(sameMasterDataIds, delDataIds, parentOrg, useOrgId);
            } else {
                delDataIds.addAll(accountId);
            }
        }
    }

    private Long getParentOrg(long useOrgId) {
        QFilter q1 = new QFilter("org", "=", (Object)useOrgId);
        QFilter q2 = new QFilter("view", "=", (Object)10);
        DynamicObject dyo = QueryServiceHelper.queryOne((String)"bos_org_structure", (String)"parent", (QFilter[])new QFilter[]{q1, q2});
        if (dyo != null) {
            return dyo.getLong("parent");
        }
        return 0L;
    }

    private void updateAccountTableRef(Set<Long> delIds) {
        SqlBuilder newAccountSql = new SqlBuilder();
        String newAccount = "update t_bd_accounttablerefentry set fnewaccountid = 0 where fnewaccountid ";
        newAccountSql.appendIn(newAccount, delIds.toArray());
        DB.execute((DBRoute)DB_ROUTE, (SqlBuilder)newAccountSql);
        SqlBuilder oldAccountSql = new SqlBuilder();
        String oldAccount = "update t_bd_accounttablerefentry set foldaccountid = 0 where foldaccountid ";
        oldAccountSql.appendIn(oldAccount, delIds.toArray());
        DB.execute((DBRoute)DB_ROUTE, (SqlBuilder)oldAccountSql);
    }

    private void updateControlTable(AccountOpContext ctx, Set<Long> delIds) {
        SqlBuilder dataUseRangeSql = new SqlBuilder();
        dataUseRangeSql.appendIn("delete from t_bd_accountusereg where fdataid", delIds.toArray());
        DB.execute((DBRoute)DB_ROUTE, (SqlBuilder)dataUseRangeSql);
        dataUseRangeSql = new SqlBuilder();
        dataUseRangeSql.appendIn("delete from t_bd_accountexc where fdataid", delIds.toArray());
        DB.execute((DBRoute)DB_ROUTE, (SqlBuilder)dataUseRangeSql);
        dataUseRangeSql = new SqlBuilder();
        dataUseRangeSql.appendIn("delete from t_bd_account_u where fdataid", delIds.toArray());
        DB.execute((DBRoute)DB_ROUTE, (SqlBuilder)dataUseRangeSql);
        dataUseRangeSql = new SqlBuilder();
        dataUseRangeSql.appendIn("delete from t_bd_account_r2 where fid", delIds.toArray());
        DB.execute((DBRoute)DB_ROUTE, (SqlBuilder)dataUseRangeSql);
        dataUseRangeSql = new SqlBuilder();
        dataUseRangeSql.appendIn("delete from t_bd_account_r3 where fid", delIds.toArray());
        DB.execute((DBRoute)DB_ROUTE, (SqlBuilder)dataUseRangeSql);
    }

    private void deleteAndUpdateParentAccount(Set<Long> delIds, long useOrgID, long accountTableId) {
        Object row;
        HashSet<Long> parentIds = new HashSet<Long>();
        try (DataSet dt = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_accountview", (String)"parent", (QFilter[])new QFilter[]{new QFilter("id", "in", delIds), new QFilter("parent", "!=", (Object)0)}, null);){
            row = null;
            while (dt.hasNext()) {
                row = dt.next();
                parentIds.add(row.getLong("parent"));
            }
        }
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bd_accountview"), (Object[])delIds.toArray());
        HashSet<Long> hasSubIds = new HashSet<Long>();
        DataSet dt = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_accountview", (String)"parent", (QFilter[])new QFilter[]{new QFilter("parent", "in", parentIds)}, null);
        row = null;
        try {
            Row row2 = null;
            while (dt.hasNext()) {
                row2 = dt.next();
                hasSubIds.add(row2.getLong("parent"));
            }
        }
        catch (Throwable row2) {
            row = row2;
            throw row2;
        }
        finally {
            if (dt != null) {
                if (row != null) {
                    try {
                        dt.close();
                    }
                    catch (Throwable row2) {
                        ((Throwable)row).addSuppressed(row2);
                    }
                } else {
                    dt.close();
                }
            }
        }
        parentIds.removeAll(hasSubIds);
        if (!parentIds.isEmpty()) {
            DynamicObject[] parentDyos = BusinessDataServiceHelper.load((Object[])parentIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountview"));
            List supOrgIds = OrgUnitServiceHelper.getSuperiorOrgs((String)"10", (long)useOrgID);
            Set numbers = Arrays.stream(parentDyos).map(dynamicObject -> dynamicObject.getString("number")).collect(Collectors.toSet());
            ArrayList<QFilter> orgFilter = new ArrayList<QFilter>(10);
            orgFilter.add(new QFilter("number", "in", numbers));
            orgFilter.add(new QFilter("isleaf", "=", (Object)Boolean.FALSE));
            HashSet<String> pNumber = new HashSet<String>(8);
            try (DataSet dataSet = AccountUtils.queryAccountDataSet(new HashSet(supOrgIds), (long)accountTableId, (String)"number", orgFilter, null);){
                for (Row row3 : dataSet) {
                    pNumber.add(row3.getString("number"));
                }
            }
            for (DynamicObject parentDyo : parentDyos) {
                if (pNumber.contains(parentDyo.getString("number"))) continue;
                parentDyo.set("isleaf", (Object)true);
            }
            SaveServiceHelper.update((DynamicObject[])parentDyos);
        }
    }

    private void updateEndDate4LastAccount(Set<Long> updateIds, long useOrgID) {
        if (!updateIds.isEmpty()) {
            DynamicObject[] parentDyos;
            for (DynamicObject parentDyo : parentDyos = BusinessDataServiceHelper.load((Object[])updateIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountview"))) {
                if (useOrgID != parentDyo.getLong("createorg_id")) continue;
                parentDyo.set("enddate", (Object)AccountVersionUtil.getEndDate());
            }
            SaveServiceHelper.update((DynamicObject[])parentDyos);
        }
    }

    private String getSufFixSql(Set<Long> ids) {
        StringBuilder sb = new StringBuilder();
        for (Long id : ids) {
            if (sb.length() != 0) {
                sb.append(',');
            }
            sb.append(id);
        }
        sb.append(')');
        return sb.toString();
    }

    private String getSql(String prefixSql, String suffixSql) {
        return prefixSql + suffixSql;
    }

    private void excuteNonTxService(Map<String, AccountTableRefServiceParam> refServiceParamMap) {
        if (CollectionUtils.isEmpty(refServiceParamMap)) {
            log.info("excuteNonTxService_refServiceParamMap:" + refServiceParamMap);
            return;
        }
        log.info("excuteNonTxService_refServiceParamMap:" + refServiceParamMap.toString());
        ECGlobalSession.begin((String)"refrence_accountversion", (DBRoute)DBRoute.of((String)"fi"), (boolean)true);
        ECGlobalSession.setBusinessType((String)"bd_accountview");
        ECGlobalSession.setAsync((boolean)true);
        CommonParam param = new CommonParam();
        param.put((Object)"refserviceparammap", refServiceParamMap);
        param.put((Object)"op", (Object)"disable");
        ECGlobalSession.register((String)"fi", (String)"fibd", (String)"DtxAccountRefService", (Param)param);
    }

    private static void log(String opMsg, long accId, String accNumber) {
        log.info(String.format("account_version_del %s on %s [%s]", opMsg, accId, accNumber));
    }

    private boolean checkVersionDates(List<Tuple<Date, Date>> versionDates) {
        int i;
        if (CollectionUtils.isEmpty(versionDates)) {
            return true;
        }
        for (i = 0; i < versionDates.size(); ++i) {
            Tuple<Date, Date> curVersionDates = versionDates.get(i);
            for (int j = 0; j < versionDates.size() && j != i; ++j) {
                Tuple<Date, Date> oneDates = versionDates.get(j);
                if (((Date)curVersionDates.item1).compareTo((Date)oneDates.item2) >= 0 && ((Date)curVersionDates.item2).compareTo((Date)oneDates.item1) >= 0) continue;
                return false;
            }
        }
        Collections.sort(versionDates, new Comparator<Tuple<Date, Date>>(){

            @Override
            public int compare(Tuple<Date, Date> o1, Tuple<Date, Date> o2) {
                return ((Date)o1.item1).compareTo((Date)o2.item1);
            }
        });
        if (Dates.notEquals((Date)((Date)versionDates.get((int)0).item1), (Date)AccountVersionUtil.getInitBeginDate(), (boolean)true)) {
            return false;
        }
        if (Dates.notEquals((Date)((Date)versionDates.get((int)(versionDates.size() - 1)).item2), (Date)AccountVersionUtil.getEndDate(), (boolean)true)) {
            return false;
        }
        for (i = 1; i < versionDates.size(); ++i) {
            Tuple<Date, Date> previsouDate = versionDates.get(i - 1);
            Tuple<Date, Date> curDate = versionDates.get(i);
            if (!Dates.notEquals((Date)((Date)previsouDate.item2), (Date)((Date)curDate.item1), (boolean)true)) continue;
            return false;
        }
        return true;
    }

    private static class ClearControlCache
    implements Supplier {
        private long useOrgId;
        private Set<Long> useorgIdSet;

        public ClearControlCache(long useOrgId, Set<Long> useorgIdSet) {
            this.useOrgId = useOrgId;
            this.useorgIdSet = useorgIdSet;
        }

        public Boolean get() {
            this.clearControlCache(this.useOrgId, this.useorgIdSet);
            return Boolean.TRUE;
        }

        private void clearControlCache(long useOrgId, Set<Long> useorgIdSet) {
            long startBeginOpTranTime = System.currentTimeMillis();
            Set childOrg = BDUtil.getAllChildrenOrgIds((long)useOrgId, (boolean)true);
            if (useorgIdSet != null && useorgIdSet.size() > 0) {
                childOrg.addAll(useorgIdSet);
            }
            BaseDataService baseDataService = new BaseDataService();
            ArrayList<Long> singletonList = new ArrayList<Long>(1);
            for (Long orgId : childOrg) {
                singletonList.clear();
                singletonList.add(orgId);
                baseDataService.clearBaseDataFilterCache("bd_accountview", orgId);
                BaseDataServiceHelper.refreshBaseDataUseRange((String)"bd_accountview", singletonList);
            }
            if (DebugTrace.enable()) {
                log.info("clearControlCache finish times\uff1a" + (System.currentTimeMillis() - startBeginOpTranTime));
            }
        }
    }
}

