/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.opplugin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.form.plugin.bdctrl.BaseDataEnableValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.bd.opplugin.AccountViewEnableValidator;
import kd.fi.bd.util.AccountUtils;

public class AccountViewEnablePlugin
extends AbstractOperationServicePlugIn {
    private HashSet<Object> accountIds;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("parent");
        e.getFieldKeys().add("disabler");
        e.getFieldKeys().add("disabledate");
        e.getFieldKeys().add("masterid");
        e.getFieldKeys().add("createorg");
        e.getFieldKeys().add("longnumber");
        e.getFieldKeys().add("accounttable");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        BaseDataEnableValidator validator = new BaseDataEnableValidator();
        String entityKey = this.billEntityType.getName();
        validator.setEntityKey(entityKey);
        e.addValidator((AbstractValidator)validator);
        e.addValidator((AbstractValidator)new AccountViewEnableValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        ArrayList<Object> subAcctList = new ArrayList<Object>();
        for (DynamicObject object : e.getDataEntities()) {
            Long accountId = object.getLong("id");
            DynamicObject accountObj = BusinessDataServiceHelper.loadSingle((Object)accountId, (String)"bd_accountview");
            Long userOrgId = accountObj.getLong("createorg_id");
            subAcctList.addAll(this.getAllSubAccts(accountObj, userOrgId));
        }
        this.accountIds = subAcctList.stream().collect(Collectors.toCollection(HashSet::new));
        this.enabledAccount(this.accountIds);
    }

    private List<Object> getAllSubAccts(DynamicObject curAcct, long curOrgId) {
        ArrayList<Long> paramOrg = new ArrayList<Long>();
        paramOrg.add(curOrgId);
        List orgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((String)"10", paramOrg, (boolean)true);
        QFilter qnumber = new QFilter("longnumber", "like", (Object)(curAcct.get("longnumber") + "%"));
        QFilter qaccttable = new QFilter("accounttable", "=", curAcct.get("accounttable.id"));
        QFilter qorg = new QFilter("createorg", "in", (Object)orgIds);
        return QueryServiceHelper.queryPrimaryKeys((String)"bd_accountview", (QFilter[])new QFilter[]{qorg, qaccttable, qnumber}, null, (int)-1);
    }

    private void enabledAccount(HashSet<Object> objectHashSet) {
        DynamicObject[] accList = BusinessDataServiceHelper.load((Object[])objectHashSet.toArray(new Long[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountview"));
        ArrayList<DynamicObject> recordList = new ArrayList<DynamicObject>(accList.length);
        for (DynamicObject entity : accList) {
            entity.set("enable", (Object)"1");
            recordList.add(entity);
        }
        BusinessDataWriter.update((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bd_accountview"), (Object[])recordList.toArray(new DynamicObject[0]));
        this.operationResult.setSuccess(true);
    }

    private boolean checkOriAccount(String entityID, DynamicObject[] objs) {
        DynamicObject[] loadObjList;
        HashSet<Long> idSet = new HashSet<Long>();
        for (DynamicObject obj : objs) {
            long masterId = obj.getLong("masterid");
            long id = obj.getLong("id");
            if (id == masterId) continue;
            idSet.add(masterId);
        }
        for (DynamicObject loadObj : loadObjList = BusinessDataServiceHelper.load((String)entityID, (String)"enable,disabler,disabledate", (QFilter[])new QFilter[]{new QFilter("id", "in", idSet)})) {
            if (loadObj.getBoolean("enable")) continue;
            return false;
        }
        return true;
    }

    private void checkParentAccount(BeforeOperationArgs e) {
        HashSet<Long> diffIds = new HashSet<Long>();
        HashSet<Long> parentIdSet = new HashSet<Long>();
        HashSet<Long> thisObjIds = new HashSet<Long>();
        for (DynamicObject obj : e.getDataEntities()) {
            thisObjIds.add(obj.getLong("id"));
            DynamicObject account = this.queryParentAccountByNum(obj);
            if (account == null) continue;
            parentIdSet.add(account.getLong("id"));
        }
        if (parentIdSet.size() > 0) {
            for (Long parentId : parentIdSet) {
                if (thisObjIds.contains(parentId)) continue;
                diffIds.add(parentId);
            }
        }
        if (!diffIds.isEmpty()) {
            DynamicObject[] dyList;
            StringBuilder accountNumber = new StringBuilder();
            for (DynamicObject dy : dyList = BusinessDataServiceHelper.load((Object[])diffIds.toArray(new Long[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountview"))) {
                accountNumber.append("\u3010");
                accountNumber.append(dy.getString("number"));
                accountNumber.append("\u3011,");
            }
            e.cancel = true;
            e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u6709\u672a\u542f\u7528\u7684\u4e0a\u7ea7\u79d1\u76ee%s\u8bf7\u5148\u542f\u7528\u4e0a\u7ea7\u79d1\u76ee\u3002", (String)"BaseDataEnablePlugin_0", (String)"bos-form-business", (Object[])new Object[0]), accountNumber));
        }
    }

    private DynamicObject queryParentAccountByNum(DynamicObject curAcct) {
        Long orgId = curAcct.getLong("createorg_id");
        String longNum = curAcct.getString("longnumber");
        int index = longNum.lastIndexOf("_");
        if (index < 0) {
            return null;
        }
        String parentNumber = longNum.substring(0, longNum.lastIndexOf("_"));
        QFilter qaccttable = new QFilter("accounttable", "=", curAcct.get("accounttable.id"));
        QFilter qparentNumber = new QFilter("longnumber", "=", (Object)parentNumber);
        QFilter qenabled = new QFilter("enable", "=", (Object)"0");
        QFilter orgfilter = AccountUtils.getBaseDataFilter((long)orgId);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bd_accountview", (String)"id", (QFilter[])new QFilter[]{qaccttable, qparentNumber, qenabled, orgfilter});
        return dynamicObject;
    }
}

