/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.opplugin;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.bdctrl.BaseDataSavePlugin;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.session.ec.ECGlobalSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bd.accounttableref.AccountTableRefServiceParam;
import kd.fi.bd.opplugin.AccountOpContext;
import kd.fi.bd.opplugin.AccountViewSaveValidator;
import kd.fi.bd.util.AccountUtils;
import kd.fi.bd.util.AccountVersionOpVars;
import kd.fi.bd.util.AccountVersionPersonalizeUtil;
import kd.fi.bd.util.AccountVersionUtil;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.BatchProcessUtil;
import kd.fi.bd.util.BizHappenUtils;
import kd.fi.bd.util.DebugTrace;

public class AccountViewSavePlugin
extends BaseDataSavePlugin {
    private static final Log log = LogFactory.getLog(AccountViewSavePlugin.class);

    protected String checkFieldRule(ExtendedDataEntity dataEntity, DynamicObject obj, DynamicObject objFromDb) {
        return null;
    }

    private void addOperateErrorInfo(ExtendedDataEntity dataEntity, String msg) {
        OperateErrorInfo info = new OperateErrorInfo();
        info.setLevel(ErrorLevel.Error);
        info.setMessage(msg);
        this.operationResult.addErrorInfo(info);
        AccountVersionOpVars.addMessageToOption((OperateOption)this.getOption(), (ExtendedDataEntity)dataEntity, (String)msg);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities.length == 1) {
            log.info(dataEntities[0].toString());
        }
        e.getValidators().add(new AccountViewSaveValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        if (AccountVersionOpVars.isOnlyValidatorWork((OperateOption)this.getOption())) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u672c\u6b21\u6267\u884c\u4ec5\u6267\u884c\u6821\u9a8c\uff0c\u4e0d\u6267\u884c\u6570\u636e\u64cd\u4f5c\u3002", (String)"AccountViewSavePlugin_4", (String)"fi-bd-opplugin", (Object[])new Object[0]));
            return;
        }
        AccountOpContext ctx = AccountOpContext.getContext();
        List objs = e.getValidExtDataEntities();
        Iterator iter = objs.iterator();
        boolean isVersioning = AccountVersionOpVars.isVersioning((OperateOption)this.getOption());
        while (iter.hasNext()) {
            Throwable throwable;
            TXHandle txHandle;
            DynamicObject parentAcct;
            ExtendedDataEntity entity = (ExtendedDataEntity)iter.next();
            DynamicObject account = entity.getDataEntity();
            long createOrgId = this.getCreateOrgId(account);
            long useOrgId = this.getUseOrgId(account);
            if (isVersioning && !AccountVersionUtil.isShareCtrlStrategy((DynamicObject)account) && createOrgId == useOrgId) {
                long acct = 0L;
                AccountOpContext context = ctx;
                acct = AccountVersionUtil.isVersionAddLeaf((boolean)isVersioning, (DynamicObject)account) || AccountVersionOpVars.isVersionAddLeaf((OperateOption)this.getOption()) ? account.getDynamicObject("parent").getLong("id") : account.getLong("id");
                Optional failedMsg = AccountVersionPersonalizeUtil.autoPersonalizedAccountOnOuterOrg((long)acct);
                if (failedMsg.isPresent()) {
                    this.addOperateErrorInfo(entity, (String)failedMsg.get());
                    iter.remove();
                    continue;
                }
                ctx.setContext(context);
            }
            if (null != (parentAcct = account.getDynamicObject("parent"))) {
                account.set("ctrlstrategy", parentAcct.get("ctrlstrategy"));
            }
            Object oldPk = account.getPkValue();
            boolean fromDataBase = account.getDataEntityState().getFromDatabase();
            if (fromDataBase && AccountVersionOpVars.isVersioning((OperateOption)this.getOption())) {
                txHandle = TX.requiresNew();
                throwable = null;
                try {
                    try {
                        DynamicObject afterAccount;
                        boolean isExitBiz;
                        DynamicObject dbObj = ctx.getDbDyos().get(account.getPkValue());
                        String ctrlstrategy = dbObj.getString("ctrlstrategy");
                        if (ctrlstrategy.equals("5")) {
                            // empty if block
                        }
                        boolean isNameChanged = AccountVersionUtil.isNameChanged((DynamicObject)account, (DynamicObject)dbObj);
                        HashMap<String, Boolean> changetypeMap = new HashMap<String, Boolean>(3);
                        changetypeMap.put("isNameChanged", isNameChanged);
                        if (isNameChanged) {
                            this.handleChangedVersion(changetypeMap, account, useOrgId);
                        }
                        SimpleDateFormat dt = new SimpleDateFormat("yyyy-MM-dd");
                        Date startDate = null;
                        try {
                            startDate = dt.parse(dt.format(account.getDate("startdate")));
                        }
                        catch (ParseException ex) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u89e3\u6790\u5f02\u5e38", (String)"AccountRefUtils_105", (String)"fi-bd-opplugin", (Object[])new Object[0]));
                        }
                        DynamicObject acctInDB = BusinessDataServiceHelper.loadSingle((Object)account.get("id"), (String)"bd_accountview", (String)"startdate,isleaf");
                        if (account.getDate("startdate").compareTo(acctInDB.getDate("startdate")) == 0) {
                            isExitBiz = false;
                            if (DebugTrace.enable()) {
                                log.info("account is same period version curDate:{}", account.get("startdate"));
                            }
                        } else {
                            boolean bl = isExitBiz = AccountVersionUtil.isAccountVersionalized((DynamicObject)acctInDB) && acctInDB.getBoolean("isleaf");
                            if (!isExitBiz) {
                                isExitBiz = BizHappenUtils.existsOnOrgDomain((long)account.getLong("masterid"), (long)useOrgId, null);
                            }
                        }
                        boolean isVersionAddLeaf = AccountVersionOpVars.isVersionAddLeaf((OperateOption)this.getOption());
                        if (isExitBiz || isVersionAddLeaf) {
                            ctx.getCustAccount(dbObj, useOrgId, startDate, isExitBiz, null);
                            afterAccount = ctx.getVersAccount(account, useOrgId, startDate, account.getLong("id"));
                        } else {
                            afterAccount = ctx.getCustAccount(account, useOrgId, startDate, isExitBiz, dbObj);
                            ctx.prepareServiceParam(useOrgId, account.getLong("accounttable_id"), afterAccount.getDate("startdate"), afterAccount.getLong("id"), account.getLong("id"));
                        }
                        if (isNameChanged) {
                            ILocaleString name = afterAccount.getLocaleString("name");
                            ILocaleString fullname = afterAccount.getLocaleString("fullname");
                            if (name != null) {
                                DynamicObject parent = afterAccount.getDynamicObject("parent");
                                if (parent != null) {
                                    ILocaleString pcurrentFullName = parent.getLocaleString("fullname");
                                    for (Map.Entry nameEntry : fullname.entrySet()) {
                                        String key = (String)nameEntry.getKey();
                                        String value = (String)nameEntry.getValue();
                                        if (StringUtils.isEmpty((CharSequence)value)) continue;
                                        fullname.put((Object)key, (Object)StringUtils.join((Object[])new Object[]{pcurrentFullName.get((Object)key), name.get((Object)key)}, (String)"_"));
                                    }
                                } else {
                                    for (Map.Entry nameEntry : fullname.entrySet()) {
                                        String key = (String)nameEntry.getKey();
                                        fullname.put((Object)key, name.get((Object)key));
                                    }
                                }
                            }
                            afterAccount.set("fullname", (Object)fullname);
                        }
                        this.saveCustAndVersAccounts(ctx);
                        this.afterHandleVersionedNoTx(ctx.getRefServiceParam());
                        ctx.getRefServiceParam().clear();
                        AccountVersionUtil.clearBaseDataCache((boolean)false, Collections.singleton(useOrgId));
                        this.getOption().setVariableValue("dataId", String.valueOf(account.getPkValue()));
                        iter.remove();
                        this.getOperationResult().addSuccessPkId(oldPk);
                        e.setCancelMessage(ResManager.loadKDString((String)"\u521b\u5efa\u7248\u672c\u5316\u8bb0\u5f55", (String)"AccountViewSavePlugin_1", (String)"fi-bd-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    catch (Exception exception) {
                        txHandle.markRollback();
                        throw exception;
                    }
                }
                catch (Throwable exception) {
                    throwable = exception;
                    throw exception;
                }
                finally {
                    if (txHandle == null) continue;
                    if (throwable != null) {
                        try {
                            txHandle.close();
                        }
                        catch (Throwable exception) {
                            throwable.addSuppressed(exception);
                        }
                        continue;
                    }
                    txHandle.close();
                    continue;
                }
            }
            if (useOrgId != createOrgId && fromDataBase && AccountVersionOpVars.isViewSave((OperateOption)this.getOption())) {
                this.addOperateErrorInfo(entity, ResManager.loadKDString((String)"\u4e0d\u80fd\u4fee\u6539\u975e\u672c\u7ec4\u7ec7\u521b\u5efa\u7684\u6570\u636e\u3002", (String)"AccountViewSavePlugin_2", (String)"bos-form-business", (Object[])new Object[0]));
                iter.remove();
                continue;
            }
            if (useOrgId == createOrgId || !fromDataBase) continue;
            txHandle = TX.requiresNew();
            throwable = null;
            try {
                try {
                    DynamicObject customizedAcc = ctx.getCustAccount(account, useOrgId, null, false, null);
                    ctx.prepareServiceParam(useOrgId, account.getLong("accounttable_id"), customizedAcc.getDate("startdate"), customizedAcc.getLong("id"), account.getLong("id"));
                    this.saveCustAndVersAccounts(ctx);
                    this.afterHandleVersionedNoTx(ctx.getRefServiceParam());
                    ctx.getRefServiceParam().clear();
                    AccountVersionUtil.clearBaseDataCache((boolean)false, Collections.singleton(useOrgId));
                    this.getOption().setVariableValue("dataId", String.valueOf(account.getPkValue()));
                    iter.remove();
                    this.getOperationResult().addSuccessPkId(oldPk);
                    e.setCancelMessage(ResManager.loadKDString((String)"\u4f7f\u7528\u7ec4\u7ec7\u4e0e\u521b\u5efa\u7ec4\u7ec7\u4e0d\u4e00\u81f4\uff0c\u521b\u5efa\u4e2a\u6027\u5316\u8bb0\u5f55\u3002", (String)"AccountViewSavePlugin_3", (String)"fi-bd-opplugin", (Object[])new Object[0]));
                }
                catch (Exception exception) {
                    txHandle.markRollback();
                    throw exception;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (txHandle == null) continue;
                if (throwable != null) {
                    try {
                        txHandle.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                txHandle.close();
            }
        }
    }

    private long getUseOrgId(DynamicObject obj) {
        long useOrgId = 0L;
        if (obj.get("useorg") instanceof DynamicObject) {
            DynamicObject useorg = obj.getDynamicObject("useorg");
            useOrgId = (Long)useorg.getPkValue();
        } else if (obj.get("useorg") instanceof Long) {
            useOrgId = (Long)obj.get("useorg");
        }
        if (useOrgId == 0L && this.getOption().getVariables().containsKey("useOrgID")) {
            String useOrgID = this.getOption().getVariableValue("useOrgID", "0");
            useOrgId = Long.parseLong(useOrgID);
        }
        return useOrgId;
    }

    private long getCreateOrgId(DynamicObject obj) {
        long createOrgId = 0L;
        if (obj.get("createorg") instanceof DynamicObject) {
            DynamicObject createorg = obj.getDynamicObject("createorg");
            createOrgId = (Long)createorg.getPkValue();
        } else if (obj.get("createorg") instanceof Long) {
            createOrgId = (Long)obj.get("createorg");
        }
        return createOrgId;
    }

    private void handleChangedVersion(Map<String, Boolean> changeTypeMap, DynamicObject obj, long useOrgId) {
        DynamicObject[] subAccts;
        SimpleDateFormat dt = new SimpleDateFormat("yyyy-MM-dd");
        Date startDate = null;
        try {
            startDate = dt.parse(dt.format(obj.getDate("startdate")));
        }
        catch (ParseException ex) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u89e3\u6790\u5f02\u5e38", (String)"AccountRefUtils_105", (String)"fi-bd-opplugin", (Object[])new Object[0]));
        }
        QFilter qtable = new QFilter("accounttable", "=", obj.get("accounttable_id"));
        QFilter qlongnumber = new QFilter("longnumber", "like", (Object)(obj.getString("longnumber") + "%")).and(new QFilter("level", ">", obj.get("level")));
        QFilter qdate = new QFilter("enddate", "=", (Object)AccountVersionUtil.getEndDate());
        QFilter qcurIds = AccountUtils.getBaseDataFilter((long)useOrgId);
        List ids = QueryServiceHelper.queryPrimaryKeys((String)"bd_accountview", (QFilter[])new QFilter[]{qcurIds, qtable, qlongnumber, qdate}, null, (int)-1);
        DynamicObject[] dyos = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountview"));
        HashMap<Object, DynamicObject> cursubAcctsMap = new HashMap<Object, DynamicObject>(dyos.length);
        for (DynamicObject dyo : dyos) {
            cursubAcctsMap.put(dyo.get("id"), dyo);
        }
        HashMap<Integer, List> levelAscSubAcctsMap = new HashMap<Integer, List>(5);
        ArrayList<Integer> sortLevelLists = new ArrayList<Integer>(5);
        for (Map.Entry cursubAcctsEntry : cursubAcctsMap.entrySet()) {
            DynamicObject entryVal = (DynamicObject)cursubAcctsEntry.getValue();
            int vallevel = entryVal.getInt("level");
            if (!sortLevelLists.contains(vallevel)) {
                sortLevelLists.add(vallevel);
            }
            List levelAcctLists = levelAscSubAcctsMap.computeIfAbsent(vallevel, k -> new ArrayList());
            levelAcctLists.add(entryVal);
        }
        Collections.sort(sortLevelLists);
        AccountOpContext ctx = AccountOpContext.getContext();
        HashMap<String, Object> numFullnameMap = new HashMap<String, Object>();
        numFullnameMap.put(obj.getString("number"), obj.getLocaleString("fullname"));
        for (Integer level : sortLevelLists) {
            for (DynamicObject subAcct : (List)levelAscSubAcctsMap.get(level)) {
                DynamicObject newSubAcct = ctx.getCustAccount(subAcct, useOrgId, startDate, false, subAcct);
                ILocaleString parentFullName = (ILocaleString)numFullnameMap.get(subAcct.getDynamicObject("parent").getString("number"));
                HashMap<String, LocaleString> fieldValueMap = new HashMap<String, LocaleString>(1);
                if (changeTypeMap.get("isNameChanged").booleanValue() && parentFullName != null) {
                    LocaleString newFullName = new LocaleString();
                    ILocaleString iLocaleString = subAcct.getLocaleString("name");
                    parentFullName.forEach((arg_0, arg_1) -> AccountViewSavePlugin.lambda$handleChangedVersion$1(iLocaleString, parentFullName, (ILocaleString)newFullName, arg_0, arg_1));
                    fieldValueMap.put("fullname", newFullName);
                    numFullnameMap.put(subAcct.getString("number"), newFullName);
                }
                for (Map.Entry entry : fieldValueMap.entrySet()) {
                    newSubAcct.set((String)entry.getKey(), entry.getValue());
                }
            }
        }
        Set subOrgIds = BDUtil.listAllChildOrgs((long)useOrgId, (boolean)false);
        QFilter qnumber = new QFilter("number", "=", (Object)obj.getString("number"));
        HashSet<Long> excOrgIds = new HashSet<Long>();
        DynamicObject[] dynamicObjectArray = null;
        try (DataSet dataset = BatchProcessUtil.batchQueryDataSet((Collection)subOrgIds, batchOrgs -> QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_accountview", (String)"createorg", (QFilter[])new QFilter[]{qtable, qnumber, qdate, new QFilter("createorg", "in", batchOrgs)}, null));){
            while (dataset.hasNext()) {
                excOrgIds.add(dataset.next().getLong("createorg"));
            }
        }
        catch (Throwable object) {
            dynamicObjectArray = object;
            throw object;
        }
        subOrgIds.removeAll(excOrgIds);
        for (DynamicObject subAcct : subAccts = BusinessDataServiceHelper.load((String)"bd_accountview", (String)"parent,name,fullname", (QFilter[])new QFilter[]{qtable, new QFilter("createorg", "in", (Object)subOrgIds), qlongnumber, qdate}, (String)"level")) {
            ILocaleString iLocaleString = (ILocaleString)numFullnameMap.get(subAcct.getDynamicObject("parent").getString("number"));
            HashMap<String, LocaleString> fieldValueMap = new HashMap<String, LocaleString>(1);
            if (changeTypeMap.get("isNameChanged").booleanValue() && iLocaleString != null) {
                LocaleString newFullName = new LocaleString();
                ILocaleString currentName = subAcct.getLocaleString("name");
                iLocaleString.forEach((arg_0, arg_1) -> AccountViewSavePlugin.lambda$handleChangedVersion$3(currentName, iLocaleString, (ILocaleString)newFullName, arg_0, arg_1));
                fieldValueMap.put("fullname", newFullName);
                numFullnameMap.put(subAcct.getString("number"), newFullName);
            }
            for (Map.Entry fieldValEntry : fieldValueMap.entrySet()) {
                subAcct.set((String)fieldValEntry.getKey(), fieldValEntry.getValue());
            }
            ctx.getUpdFullNameAccounts().add(subAcct);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        AccountOpContext ctx = AccountOpContext.getContext();
        for (DynamicObject account : e.getDataEntities()) {
            boolean isNameChanged;
            if (account.getDataEntityState().getFromDatabase() && (isNameChanged = AccountVersionUtil.isNameChanged((DynamicObject)account, (DynamicObject)ctx.getDbDyos().get(account.getPkValue())))) {
                DynamicObject[] subAccts = BusinessDataServiceHelper.load((String)"bd_accountview", (String)"id,parent.id,name,fullname", (QFilter[])new QFilter("id", "in", (Object)AccountVersionUtil.getAllSubAccts((Object)account.getPkValue())).toArray(), (String)"level");
                HashMap<Long, DynamicObject> idDyoMap = new HashMap<Long, DynamicObject>(subAccts.length);
                idDyoMap.put(account.getLong("id"), account);
                for (DynamicObject subAcct : subAccts) {
                    idDyoMap.put(subAcct.getLong("id"), subAcct);
                }
                for (DynamicObject subAcct : subAccts) {
                    ILocaleString currentName = subAcct.getLocaleString("name");
                    DynamicObject subAcctParent = (DynamicObject)idDyoMap.get(subAcct.getLong("parent.id"));
                    ILocaleString parentFullName = subAcctParent.getLocaleString("fullname");
                    LocaleString currentFullName = new LocaleString();
                    for (Map.Entry nameEntry : parentFullName.entrySet()) {
                        String key = (String)nameEntry.getKey();
                        String value = (String)nameEntry.getValue();
                        if (StringUtils.isEmpty((CharSequence)value)) continue;
                        currentFullName.put((Object)key, (Object)StringUtils.join((Object[])new Object[]{value, StringUtils.isEmpty((CharSequence)((CharSequence)currentName.get((Object)key))) ? currentName.getDefaultItem() : currentName.get((Object)key)}, (String)"_"));
                    }
                    subAcct.set("fullname", (Object)currentFullName);
                }
                SaveServiceHelper.save((DynamicObject[])subAccts);
            }
            this.setHiddenProperty(account);
            this.resetLongStr(account);
        }
        boolean isVersionAddLeaf = AccountVersionOpVars.isVersionAddLeaf((OperateOption)this.getOption());
        Map<Object, DynamicObject> parents = ctx.getParentAccounts();
        for (DynamicObject account : e.getDataEntities()) {
            if (account.getDataEntityState().getFromDatabase()) continue;
            DynamicObject parent = account.getDynamicObject("parent");
            if (isVersionAddLeaf && parent.getLong("createorg_id") != account.getLong("useorg_id")) {
                ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
                filters.add(new QFilter("number", "=", (Object)parent.getString("number")));
                filters.add(new QFilter("enddate", "=", (Object)AccountVersionUtil.getEndDate()));
                Set parentIds = AccountUtils.queryAccountIds((long)account.getLong("useorg_id"), (long)account.getLong("accounttable_id"), filters);
                if (!parentIds.isEmpty() && !parentIds.contains(parent.getLong("id")) && (parent = BusinessDataServiceHelper.loadSingle(parentIds.iterator().next(), (String)"bd_accountview")) != null) {
                    parents.put(parent.get("id"), parent);
                }
            }
            if (parent != null && parent.getBoolean("isleaf")) {
                parent = parents.get(parent.get("id"));
                ctx.custVersAccount(parent, account.getLong("useorg_id"), account, account.getDate("startdate"), isVersionAddLeaf);
                ctx.getNewLeafParentNum().add(parent.getString("number"));
                continue;
            }
            if (parent != null && !parent.getBoolean("isleaf")) {
                account.set("startdate", parent.get("startdate"));
                continue;
            }
            if (parent != null) continue;
            account.set("startdate", (Object)AccountVersionUtil.getInitBeginDate());
        }
        this.saveCustAndVersAccounts(ctx);
        this.afterHandleVersionedNoTx(ctx.getRefServiceParam());
        ctx.getRefServiceParam().clear();
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        AccountOpContext ctx = AccountOpContext.getContext();
        if (AccountVersionUtil.isRebuildDataUseRangeSystemProperty()) {
            AccountVersionUtil.clearBaseDataCache((boolean)true, new HashSet());
            ArrayList<Long> clearCacheOrgs = new ArrayList<Long>(ctx.getClearCacheOrgs());
            ArrayList<Long> singletonList = new ArrayList<Long>(1);
            for (Long orgId : clearCacheOrgs) {
                singletonList.clear();
                singletonList.add(orgId);
                BaseDataServiceHelper.refreshBaseDataUseRange((String)"bd_accountview", singletonList);
            }
        }
    }

    private void saveCustAndVersAccounts(AccountOpContext ctx) {
        Map<Long, DynamicObject> custAccountMap;
        List<DynamicObject> updFullNameAccounts;
        List<DynamicObject> accounts = ctx.getCustVersAccounts();
        List<DynamicObject> upateAccounts = ctx.getUpdateAccounts();
        HashSet<Long> clearCacheOrgIds = new HashSet<Long>();
        ArrayList useRegs = new ArrayList(10);
        ArrayList excRegs = new ArrayList(10);
        if (!upateAccounts.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])upateAccounts.toArray(new DynamicObject[0]));
        }
        if (!(updFullNameAccounts = ctx.getUpdFullNameAccounts()).isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])updFullNameAccounts.toArray(new DynamicObject[0]));
        }
        boolean isAutoAssignChild = AccountVersionOpVars.isAutoAssignChildAfterVersioned((OperateOption)this.getOption());
        ArrayList<Object[]> shareUparams = new ArrayList<Object[]>();
        if (!accounts.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])accounts.toArray(new DynamicObject[0]));
            for (DynamicObject account : accounts) {
                Object useRegParams;
                Map<Long, Long> childOrgToAssignOrgMap;
                long useOrgId = account.getLong("createorg_id");
                Long checkAssignAcctId = ctx.getNewAcctOldAcctId().get(account.getLong("id"));
                if (checkAssignAcctId == null) {
                    checkAssignAcctId = account.getLong("masterid");
                }
                String ctrlStrategy = account.getString("ctrlstrategy");
                Set<Long> childrenOrgIds = null;
                if ("5".equals(ctrlStrategy) || "6".equals(ctrlStrategy)) {
                    childrenOrgIds = BDUtil.listAllChildOrgs((long)useOrgId, (boolean)true);
                    shareUparams.add(new Object[]{account.getLong("id"), checkAssignAcctId, childrenOrgIds});
                } else if (isAutoAssignChild) {
                    childOrgToAssignOrgMap = AccountVersionUtil.getAssignAcctUseOrgId((Object)checkAssignAcctId, (Set)BDUtil.listAllChildOrgs((long)useOrgId, (boolean)true));
                    if (childOrgToAssignOrgMap.get(useOrgId) == null) {
                        Object[] useRegParam = new Object[]{useOrgId, account.getLong("id"), useOrgId, useOrgId, account.get("ctrlstrategy"), "0", 0};
                        ctx.getUseRegParams().add(useRegParam);
                    }
                    childrenOrgIds = childOrgToAssignOrgMap.keySet();
                    useRegParams = AccountVersionUtil.getUseregParams(null, childOrgToAssignOrgMap, (Object)account.getLong("id"), (Object)useOrgId, (String)account.getString("ctrlstrategy"), (boolean)false);
                    ctx.getUseRegParams().addAll((Collection<Object[]>)useRegParams);
                } else {
                    childrenOrgIds = Collections.singleton(useOrgId);
                    childOrgToAssignOrgMap = Collections.singletonMap(useOrgId, account.getLong("id"));
                    useRegParams = AccountVersionUtil.getUseregParams(null, childOrgToAssignOrgMap, (Object)account.getLong("id"), (Object)useOrgId, (String)account.getString("ctrlstrategy"), (boolean)true);
                    ctx.getUseRegParams().addAll((Collection<Object[]>)useRegParams);
                }
                clearCacheOrgIds.add(useOrgId);
                if (!Objects.nonNull(childrenOrgIds)) continue;
                clearCacheOrgIds.addAll(childrenOrgIds);
                Long oldId = ctx.getNewAcctOldAcctId().get(account.getLong("id"));
                if (oldId == null) continue;
                for (Long childOrgId : childrenOrgIds) {
                    boolean isExistBiz = BizHappenUtils.exist((long)oldId, Collections.singleton(childOrgId));
                    if (!isExistBiz) continue;
                    ctx.prepareServiceParam(childOrgId, account.getLong("accounttable_id"), account.getDate("startdate"), account.getLong("id"), ctx.getNewAcctOldAcctId().get(account.getLong("id")));
                }
            }
        }
        if (!(custAccountMap = ctx.getCustAccountMap()).isEmpty()) {
            Map<Long, Long> accCreateOrgIds = ctx.getAccCreateOrgIds();
            for (Map.Entry<Long, DynamicObject> entry : custAccountMap.entrySet()) {
                Object[] excParam = new Object[]{entry.getKey(), accCreateOrgIds.get(entry.getKey()), entry.getValue().getLong("createorg_id")};
                ctx.getExcParams().add(excParam);
                if (!isAutoAssignChild) continue;
                Map childOrgToAssignOrgMap = AccountVersionUtil.getAssignAcctUseOrgId((Object)entry.getKey(), (Set)BDUtil.listAllChildOrgs((long)entry.getValue().getLong("createorg_id"), (boolean)false));
                Set childrenOrgIds = childOrgToAssignOrgMap.keySet();
                clearCacheOrgIds.addAll(childrenOrgIds);
                String ctrlStrategy = entry.getValue().getString("ctrlstrategy");
                List excParams = AccountVersionUtil.getExcParams(null, childrenOrgIds, (Object)entry.getKey(), (Object)accCreateOrgIds.get(entry.getKey()));
                if ("1".equals(ctrlStrategy) || "3".equals(ctrlStrategy)) {
                    ctx.getExcParams().addAll(excParams);
                    continue;
                }
                excRegs.addAll(excParams);
            }
        }
        AccountVersionUtil.doAssign(ctx.getExcParams(), ctx.getUseRegParams());
        AccountVersionUtil.refreshBaseDataUseRange(excRegs, useRegs);
        AccountVersionUtil.refreshBaseDataUseRange(shareUparams);
        AccountVersionUtil.clearBaseDataCache((boolean)true, clearCacheOrgIds);
        ctx.setClearCacheOrgs(clearCacheOrgIds);
    }

    private void resetLongStr(DynamicObject account) {
        ILocaleString name = (ILocaleString)account.get("name");
        ILocaleString fullname = (ILocaleString)account.get("fullname");
        if (name != null) {
            DynamicObject parent = account.getDynamicObject("parent");
            if (parent != null) {
                ILocaleString pcurrentFullName = parent.getLocaleString("fullname");
                for (Map.Entry nameEntry : pcurrentFullName.entrySet()) {
                    String key = (String)nameEntry.getKey();
                    String value = (String)nameEntry.getValue();
                    if (StringUtils.isEmpty((CharSequence)value)) continue;
                    fullname.put((Object)key, (Object)StringUtils.join((Object[])new Object[]{pcurrentFullName.get((Object)key), name.get((Object)key)}, (String)"_"));
                }
                String parentLongnumber = parent.getString("longnumber");
                String currentLongnumber = parentLongnumber + "_" + account.getString("number");
                account.set("longnumber", (Object)currentLongnumber);
            } else {
                for (Map.Entry nameEntry : name.entrySet()) {
                    String key = (String)nameEntry.getKey();
                    String value = (String)nameEntry.getValue();
                    if (StringUtils.isEmpty((CharSequence)value)) continue;
                    fullname.put((Object)key, name.get((Object)key));
                }
                account.set("longnumber", account.get("number"));
            }
            account.set("fullname", (Object)fullname);
        }
    }

    private void setHiddenProperty(DynamicObject account) {
        DynamicObjectCollection checkitems = account.getDynamicObjectCollection("checkitementry");
        boolean isAccheck = false;
        if (!checkitems.isEmpty() && this.clearEmptyEntity(checkitems)) {
            account.set("isassist", (Object)Boolean.TRUE);
        }
        for (DynamicObject entry : checkitems) {
            DynamicObject item = entry.getDynamicObject("asstactitem");
            if (item == null || !entry.getBoolean("enaccheck")) continue;
            isAccheck = true;
        }
        account.set("accheck", (Object)isAccheck);
        if ("5".equals(account.getDynamicObject("accounttype").getString("accounttype"))) {
            account.set("bw", (Object)true);
        }
    }

    private boolean clearEmptyEntity(DynamicObjectCollection account) {
        boolean isHasData = false;
        Iterator iterator = account.iterator();
        while (iterator.hasNext()) {
            if (((DynamicObject)iterator.next()).get("asstactitem") == null) {
                iterator.remove();
                continue;
            }
            isHasData = true;
        }
        return isHasData;
    }

    private void afterHandleVersionedNoTx(Map<String, AccountTableRefServiceParam> refServiceParamMap) {
        if (CollectionUtils.isEmpty(refServiceParamMap)) {
            log.info("afterHandleVersionedNoTx_refServiceParamMap:" + refServiceParamMap);
            return;
        }
        if (DebugTrace.enable()) {
            log.info("afterHandleVersionedNoTx_refServiceParamMap:" + refServiceParamMap.toString());
        }
        ECGlobalSession.begin((String)"refrence_accountversion", (DBRoute)DBRoute.of((String)"fi"), (boolean)true);
        ECGlobalSession.setBusinessType((String)"bd_accountview");
        ECGlobalSession.setAsync((boolean)true);
        CommonParam param = new CommonParam();
        param.put((Object)"refserviceparammap", refServiceParamMap);
        param.put((Object)"op", (Object)"enable");
        ECGlobalSession.register((String)"fi", (String)"fibd", (String)"DtxAccountRefService", (Param)param);
    }

    private static /* synthetic */ void lambda$handleChangedVersion$3(ILocaleString currentName, ILocaleString parentFullName, ILocaleString newFullName, String k, String v) {
        String curfull = (String)currentName.get((Object)k);
        StringBuilder resetFulName = new StringBuilder();
        if (!StringUtils.isEmpty((CharSequence)curfull)) {
            resetFulName.append((String)parentFullName.get((Object)k)).append('_').append(curfull);
            newFullName.put((Object)k, (Object)resetFulName.toString());
        }
    }

    private static /* synthetic */ void lambda$handleChangedVersion$1(ILocaleString currentName, ILocaleString parentFullName, ILocaleString newFullName, String k, String v) {
        String curfull = (String)currentName.get((Object)k);
        StringBuilder resetFulName = new StringBuilder();
        if (!StringUtils.isEmpty((CharSequence)curfull)) {
            resetFulName.append((String)parentFullName.get((Object)k)).append('_').append(curfull);
            newFullName.put((Object)k, (Object)resetFulName.toString());
        }
    }
}

