/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.PkSnapshotSet;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.ext.fi.accountref.AccountTableRefUtils;
import kd.bos.ext.fi.util.DateUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.bd.consts.Account;
import kd.fi.bd.consts.AccountType;
import kd.fi.bd.enums.PeriodStateEnum;
import kd.fi.bd.opplugin.AccountOpContext;
import kd.fi.bd.opplugin.AccountSaveParam;
import kd.fi.bd.util.AccountUtils;
import kd.fi.bd.util.AccountVersionControlChecker;
import kd.fi.bd.util.AccountVersionOpVars;
import kd.fi.bd.util.AccountVersionUtil;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.BatchProcessUtil;
import kd.fi.bd.util.BiTreeNode;
import kd.fi.bd.util.BizHappenUtils;
import kd.fi.bd.util.DebugTrace;

public class AccountViewSaveValidator
extends AbstractValidator {
    private static final Log LOGGER = LogFactory.getLog(AccountViewSaveValidator.class);
    private Map<Long, List<Long>> porgsMap = new HashMap<Long, List<Long>>();
    private Map<Long, Map<Long, List<Map<String, String>>>> acctsMap = new HashMap<Long, Map<Long, List<Map<String, String>>>>();
    private static String[] fieldKeys = new String[]{"acnotice", "ischangecurrency", "bw", "isqty"};
    private static String[] fieldNames = new String[]{ResManager.loadKDString((String)"\u5f80\u6765\u901a\u77e5", (String)"AccountViewSaveValidator_26", (String)"fi-bd-opplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u671f\u672b\u8c03\u6c47", (String)"AccountViewSaveValidator_27", (String)"fi-bd-opplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8868\u5916\u79d1\u76ee", (String)"AccountViewSaveValidator_28", (String)"fi-bd-opplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6570\u91cf\u6838\u7b97", (String)"AccountViewSaveValidator_29", (String)"fi-bd-opplugin", (Object[])new Object[0])};
    private static String[] entryFields = new String[]{"isrequire", "isdetail", "enaccheck"};
    private static String[] entryFieldNames = new String[]{ResManager.loadKDString((String)"\u5fc5\u5f55", (String)"AccountViewSaveValidator_30", (String)"fi-bd-opplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u660e\u7ec6", (String)"AccountViewSaveValidator_31", (String)"fi-bd-opplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5f80\u6765\u6838\u7b97", (String)"AccountViewSaveValidator_32", (String)"fi-bd-opplugin", (Object[])new Object[0])};
    private static final String ITEMCHECK_SUB = "SUB";
    private static final String ITEMCHECK_PAR = "PAR";

    public void validate() {
        AccountSaveParam param = AccountSaveParam.getInstance();
        AccountOpContext.init(this.dataEntities, this.getOption());
        HashMap dataEntitiesMap = BDUtil.getDynamicDatas((ExtendedDataEntity[])this.dataEntities);
        Object[] prepareData = this.getPrepareData(this.dataEntities);
        Map<Object, DynamicObject> parentMaps = AccountOpContext.getContext().getParentAccounts();
        Map numberMapInImportList = (Map)prepareData[0];
        for (ExtendedDataEntity entity : this.dataEntities) {
            DynamicObject account = entity.getDataEntity();
            if (this.validateEmpty(account)) continue;
            String errorMesg = this.validate(param, account, dataEntitiesMap, numberMapInImportList, parentMaps);
            if (StringUtils.isEmpty((CharSequence)errorMesg)) {
                errorMesg = this.bussinessValidate(account, dataEntitiesMap, parentMaps, prepareData[1]);
            }
            if (!StringUtils.isNotBlank((CharSequence)errorMesg)) continue;
            this.addMessage(entity, errorMesg, ErrorLevel.Error);
            dataEntitiesMap.remove(account.get("id"));
        }
        this.checkParentExsit(this.dataEntities, parentMaps, dataEntitiesMap);
        long tick = System.currentTimeMillis();
        this.editValidate(param);
        LOGGER.info("account_view_save validate cost: " + (System.currentTimeMillis() - tick));
    }

    private boolean validateEmpty(DynamicObject account) {
        return account.getLong("accounttype_id") == 0L || account.getLong("accounttable_id") == 0L || account.getLong("createorg_id") == 0L;
    }

    private void checkParentExsit(ExtendedDataEntity[] dataEntities, Map<Object, DynamicObject> parentMaps, HashMap<Long, DynamicObject> dataEntitiesMap) {
        for (ExtendedDataEntity entity : dataEntities) {
            DynamicObject parent;
            long parentId;
            DynamicObject account = entity.getDataEntity();
            if (account.getDataEntityState().getFromDatabase() || (parentId = account.getLong("parent_id")) == 0L) continue;
            DynamicObject dynamicObject = parent = parentMaps.get(parentId) == null ? dataEntitiesMap.get(parentId) : parentMaps.get(parentId);
            if (parent != null) continue;
            this.addMessage(entity, ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\uff08\u4e0a\u7ea7\uff09\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"AccountViewSaveValidator_0", (String)"fi-bd-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
            dataEntitiesMap.remove(account.get("id"));
        }
    }

    private String validate(AccountSaveParam param, DynamicObject account, HashMap<Long, DynamicObject> dataEntitiesMap, Map<String, Integer> numberMapInImportList, Map<Object, DynamicObject> parentMaps) {
        DynamicObjectCollection currencys;
        boolean isFromRepairOrAssignOp = AccountVersionOpVars.isFromRepairOrAssignView((OperateOption)this.getOption());
        long parentId = account.getLong("parent_id");
        String number = account.getString("number");
        if (number.contains("_")) {
            return String.format(ResManager.loadKDString((String)"\u79d1\u76ee\u7f16\u7801(%s)\u4e2d\u4e0d\u80fd\u5305\u542b\u7279\u6b8a\u7b26\u53f7\u4e0b\u5212\u7ebf\u3002", (String)"AccountViewSaveValidator_166", (String)"fi-bd-opplugin", (Object[])new Object[0]), number);
        }
        long createOrgId = account.getLong("createorg_id");
        if (parentId != 0L) {
            DynamicObject parent;
            DynamicObject dynamicObject = parent = parentMaps.get(parentId) == null ? dataEntitiesMap.get(parentId) : parentMaps.get(parentId);
            if (parent == null) {
                return "";
            }
            if (0 != AccountVersionUtil.compareDate((Date)parent.getDate("enddate"), (Date)AccountVersionUtil.getEndDate())) {
                return ResManager.loadKDString((String)"\u4e0a\u7ea7\u79d1\u76ee\u4e0d\u662f\u6700\u65b0\u7248\u672c\u79d1\u76ee\uff0c\u65e0\u6cd5\u65b0\u589e\uff0c\u8bf7\u5237\u65b0\u79d1\u76ee\u5217\u8868\u540e\u518d\u70b9\u51fb\u65b0\u589e\u3002", (String)"AccountViewSaveValidator_152", (String)"fi-bd-opplugin", (Object[])new Object[0]);
            }
            String pnumber = parent.getString("number");
            if (number != null && number.equals(pnumber)) {
                return ResManager.loadKDString((String)"\u79d1\u76ee\u7f16\u7801\u4e0d\u80fd\u4e0e\u4e0a\u7ea7\u79d1\u76ee\u7f16\u7801\u76f8\u540c\u3002", (String)"AccountViewSaveValidator_1", (String)"fi-bd-opplugin", (Object[])new Object[0]);
            }
            if (!(isFromRepairOrAssignOp || "nocontrol".equals(parent.get("accrualdirection")) || parent.getString("accrualdirection").equals(account.getString("accrualdirection")))) {
                return ResManager.loadKDString((String)"\u4e0a\u7ea7\u79d1\u76ee\u5f55\u5165\u65b9\u5411\u4e3a\u501f\u65b9\uff08\u8d37\u65b9\uff09\uff0c\u4e0b\u7ea7\u79d1\u76ee\u4e0d\u80fd\u6539\u4e3a\u8d37\u65b9\uff08\u501f\u65b9\uff09\u6216\u4e0d\u63a7\u5236\u3002", (String)"AccountVersionControlChecker_1", (String)"fi-bd-opplugin", (Object[])new Object[0]);
            }
            if (!account.getDataEntityState().getFromDatabase() && parent != null) {
                boolean isVerAddLeafOnDomain;
                boolean isExitBiz;
                boolean isVersion;
                String pctrlstrategy = parent.getString("ctrlstrategy");
                if (createOrgId != parent.getLong("createorg_id") && ("5".equals(pctrlstrategy) || "6".equals(pctrlstrategy))) {
                    return ResManager.loadKDString((String)"\u4e0a\u7ea7\u79d1\u76ee\u662f\u5171\u4eab\u7b56\u7565\uff0c\u53ea\u80fd\u5728\u4e0a\u7ea7\u79d1\u76ee\u7684\u521b\u5efa\u7ec4\u7ec7\u65b0\u589e\u4e0b\u7ea7\u3002", (String)"AccountViewSaveValidator_2", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                }
                Date startDate = parent.getDate("startdate");
                Date curDate = account.getDate("startdate");
                LOGGER.info("AccountViewSaveValidator_validate_parentstartdate:" + startDate + " ,curDatestartdate:" + curDate);
                if (-1 == AccountVersionUtil.compareDate((Date)curDate, (Date)startDate)) {
                    return ResManager.loadKDString((String)"\u4e0a\u7ea7\u79d1\u76ee\u5728\u540e\u7eed\u671f\u95f4\u5df2\u7ecf\u8fdb\u884c\u8fc7\u7248\u672c\u5316\uff0c\u65e0\u6cd5\u5728\u5386\u53f2\u671f\u95f4\u65b0\u589e\u79d1\u76ee\u3002", (String)"AccountViewSaveValidator_92", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                }
                if (!this.getOption().containsVariable("isassign")) {
                    Map<String, Set<Long>> accounts;
                    long tableId = account.getLong("accounttable_id");
                    Map<Long, Map<Long, Map<String, Set<Long>>>> atOrgAccounts = AccountOpContext.getContext().getAtOrgAccounts();
                    Map<Long, Map<String, Set<Long>>> orgAccounts = atOrgAccounts.get(tableId);
                    if (orgAccounts != null && (accounts = orgAccounts.get(createOrgId)) != null && accounts.containsKey(number)) {
                        return String.format(ResManager.loadKDString((String)"\u65b0\u589e\u7684%s\u79d1\u76ee\u7f16\u7801\u548c\u4e0a\u7ea7\u7ec4\u7ec7\u4e00\u81f4\uff0c\u8bf7\u4ece\u4e0a\u7ea7\u5206\u914d\u3002", (String)"AccountViewSaveValidator_107", (String)"fi-bd-opplugin", (Object[])new Object[0]), number);
                    }
                }
                boolean isFromVersionAddLeaf = parent.getBoolean("isleaf");
                boolean isExistonOrgDomain = false;
                if (isFromVersionAddLeaf) {
                    isExistonOrgDomain = BizHappenUtils.existsOnOrgDomain((long)parent.getLong("masterid"), (long)createOrgId, (Date)curDate);
                    if (BizHappenUtils.existsOnOrgDomain((long)parent.getLong("masterid"), (long)createOrgId, (Date)curDate)) {
                        return String.format(ResManager.loadKDString((String)"%s\u79d1\u76ee\u5728\u5f53\u524d\u7ec4\u7ec7\u6216\u4e0b\u7ea7\u7ec4\u7ec7\u6709\u51ed\u8bc1\u6216\u521d\u59cb\u5316\u4f59\u989d\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u76f4\u63a5\u65b0\u589e\u4e0b\u7ea7\uff0c\u8bf7\u5148\u5220\u9664\u51ed\u8bc1\u6216\u521d\u59cb\u5316\u4f59\u989d\u6570\u636e\u540e\u518d\u65b0\u589e\uff0c\u6216\u901a\u8fc7\u7248\u672c\u5316\u65b0\u589e\u4e0b\u7ea7\u79d1\u76ee\u3002", (String)"AccountViewSaveValidator_4", (String)"fi-bd-opplugin", (Object[])new Object[0]), parent.getString("number"));
                    }
                }
                if (!(isVersion = this.getOption().containsVariable("isversion")) && parent.getBoolean("isleaf") && (isExitBiz = BizHappenUtils.existsOnOrgDomain((long)parent.getLong("masterid"), (long)createOrgId, null))) {
                    return ResManager.loadKDString((String)"%s\u79d1\u76ee\u5df2\u505a\u8d26\uff0c\u8bf7\u901a\u8fc7\u7248\u672c\u5316\u64cd\u4f5c\u65b0\u589e\u4e0b\u7ea7\u3002", (String)"AccountViewSaveValidator_109", (String)"fi-bd-opplugin", (Object[])new Object[]{parent.getString("number")});
                }
                if (!isExistonOrgDomain) {
                    isExistonOrgDomain = BizHappenUtils.existsOnOrgDomain((long)parent.getLong("masterid"), (long)createOrgId, null);
                }
                boolean bl = isVerAddLeafOnDomain = isVersion && isFromVersionAddLeaf && isExistonOrgDomain;
                if (isFromVersionAddLeaf && AccountTableRefUtils.checkAccountTableReference((DynamicObject)account, (boolean)isVerAddLeafOnDomain, (long)parentId)) {
                    if (isVerAddLeafOnDomain) {
                        return String.format(ResManager.loadKDString((String)"%s\u79d1\u76ee\u5df2\u88ab\u79d1\u76ee\u8868\u7248\u672c\u5316\u4e2d\u7684\u5bf9\u7167\u4fe1\u606f\u5f15\u7528\uff0c\u8bf7\u5148\u5220\u9664\u5bf9\u7167\u4fe1\u606f\u540e\u518d\u8fdb\u884c\u7248\u672c\u5316\u3002", (String)"AccountViewSaveValidator_178", (String)"fi-bd-opplugin", (Object[])new Object[0]), pnumber);
                    }
                    return String.format(ResManager.loadKDString((String)"%s\u79d1\u76ee\u5df2\u88ab\u79d1\u76ee\u8868\u7248\u672c\u5316\u4e2d\u7684\u5bf9\u7167\u4fe1\u606f\u5f15\u7528\uff0c\u8bf7\u5148\u5220\u9664\u5bf9\u7167\u4fe1\u606f\u540e\u518d\u4fee\u6539\u3002", (String)"AccountViewSaveValidator_176", (String)"fi-bd-opplugin", (Object[])new Object[0]), pnumber);
                }
            }
        }
        long curaccttableid = account.getDynamicObject("accounttable") == null ? account.getLong("accounttable_id") : account.getDynamicObject("accounttable").getLong("id");
        Set<Long> typeIds = AccountOpContext.getContext().getTableIdTypeIds().get(curaccttableid);
        if (!typeIds.contains(account.getLong("accounttype_id"))) {
            return String.format(ResManager.loadKDString((String)"\u5f53\u524d\u79d1\u76ee\u7684\u79d1\u76ee\u8868\u6ca1\u6709\u7f16\u7801\u4e3a%s\u7684\u79d1\u76ee\u7c7b\u578b\u3002", (String)"AccountViewSaveValidator_94", (String)"fi-bd-opplugin", (Object[])new Object[0]), account.getDynamicObject("accounttype").getString("number"));
        }
        Set<String> numberList = AccountOpContext.getContext().getAccountNumbers(curaccttableid, createOrgId);
        int repiteNumCountInImportList = numberMapInImportList.get(curaccttableid + "+" + createOrgId + number);
        numberMapInImportList.put(curaccttableid + "+" + createOrgId + number, repiteNumCountInImportList + 1);
        String error = this.isNumRepetition(account, numberList, repiteNumCountInImportList);
        if (!StringUtils.isBlank((CharSequence)error)) {
            return error;
        }
        error = this.checkNumberByTable(account, parentMaps);
        if (!StringUtils.isBlank((CharSequence)error)) {
            return error;
        }
        String acctcurrency = account.getString("acctcurrency");
        if ("descurrency".equals(acctcurrency) && (currencys = account.getDynamicObjectCollection("currencyentry")).size() == 0) {
            return ResManager.loadKDString((String)"\u5e01\u79cd\u4e3a\u6307\u5b9a\u5e01\u79cd\u6838\u7b97\u65f6\uff0c\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AccountViewSaveValidator_134", (String)"fi-bd-opplugin", (Object[])new Object[0]);
        }
        String accTypeProperty = account.getString("accounttype.accounttype");
        String pltypeValue = account.getString("pltype");
        if ("4".equals(accTypeProperty) && "0".equals(pltypeValue)) {
            return ResManager.loadKDString((String)"\u79d1\u76ee\u7c7b\u578b\u4e3a\u635f\u76ca\u7c7b\uff0c\u635f\u76ca\u7c7b\u578b\u4e0d\u80fd\u4e3a\u975e\u635f\u76ca\u7c7b\u79d1\u76ee\u3002", (String)"AccountViewSaveValidator_7", (String)"fi-bd-opplugin", (Object[])new Object[0]);
        }
        if (!accTypeProperty.equals("4") && !"0".equals(pltypeValue)) {
            return ResManager.loadKDString((String)"\u79d1\u76ee\u7c7b\u578b\u4e3a\u975e\u635f\u76ca\u7c7b\uff0c\u635f\u76ca\u7c7b\u578b\u5fc5\u987b\u4e3a\u975e\u635f\u76ca\u7c7b\u79d1\u76ee\u3002", (String)"AccountViewSaveValidator_172", (String)"fi-bd-opplugin", (Object[])new Object[0]);
        }
        return "";
    }

    public boolean isSubOrgAcctVersion(DynamicObject account) {
        String firstNumber = account.getInt("level") == 1 ? account.getString("number") : this.queryFirstAcct(account.getLong("id"), 0);
        if (firstNumber.isEmpty()) {
            return true;
        }
        QFilter fnumber = new QFilter("longnumber", "like", (Object)(account.getString("longnumber") + "%"));
        QFilter[] filters = new QFilter[]{fnumber};
        return this.isSubOrgCreateAcct(filters, account.getLong("accounttable_id"), account.getLong("useorg_id"));
    }

    private String queryFirstAcct(long id, int index) {
        if (index > 20) {
            return "";
        }
        QFilter fid = new QFilter("id", "=", (Object)id);
        long pid = 0L;
        DataSet pacctSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_accountview", (String)"number, level, parent", (QFilter[])new QFilter[]{fid}, null);
        for (Row row : pacctSet) {
            int level = row.getInteger("level");
            if (level == 1) {
                return row.getString("number");
            }
            pid = row.getLong("parent");
        }
        ++index;
        if (pid != 0L) {
            return this.queryFirstAcct(pid, index);
        }
        return "";
    }

    public boolean isSubOrgCreateAcct(QFilter[] filters, long acctableId, long useOrgId) {
        Set childOrgIds = BDUtil.getAllChildrenOrgIds((long)useOrgId, (boolean)false);
        QFilter accTableFilter = new QFilter("accounttable", "=", (Object)acctableId);
        DataSet accountDt = BatchProcessUtil.batchQueryDataSet((Collection)childOrgIds, batchOrgs -> {
            ArrayList<QFilter> list = new ArrayList<QFilter>();
            QFilter createOrgsfilter = new QFilter("createorg_id", "in", batchOrgs);
            list.add(createOrgsfilter);
            list.add(accTableFilter);
            list.addAll(Arrays.asList(filters));
            return QueryServiceHelper.queryDataSet((String)"kd.fi.bd.opplugin.AccountOpContext.getAccout", (String)"bd_accountview", (String)"number", (QFilter[])list.toArray(new QFilter[0]), null);
        });
        return accountDt.hasNext();
    }

    private boolean isReversion(AccountSaveParam param, List<DynamicObject> books, Date startDate, Date subAcctStartDate) {
        Map<String, List<DynamicObject>> periodTypeDatePeriodMap = param.getPeriodTypeDatePeriodMap();
        if (books.isEmpty()) {
            Calendar c = Calendar.getInstance();
            c.setTime(startDate);
            int curTime = c.get(1) * 100 + c.get(2);
            c.setTime(subAcctStartDate);
            int lastVersionTime = c.get(1) * 100 + c.get(2);
            if (curTime == lastVersionTime) {
                return true;
            }
        }
        for (DynamicObject book : books) {
            long periodTypeId = book.getLong("periodtype.id");
            String periodTypeDatePeriodMapkey = StringUtils.join((Object[])new Object[]{periodTypeId, startDate.getTime()}, (char)'-');
            List<DynamicObject> periodLists = periodTypeDatePeriodMap.get(periodTypeDatePeriodMapkey);
            if (periodLists == null) {
                QFilter qdate = new QFilter("begindate", "<=", (Object)startDate).and(new QFilter("enddate", ">", (Object)startDate));
                DynamicObjectCollection periodDyos = QueryServiceHelper.query((String)"bd_period", (String)"begindate,enddate", (QFilter[])new QFilter[]{new QFilter("periodtype", "=", (Object)periodTypeId), qdate}, (String)"id desc");
                periodLists = new ArrayList<DynamicObject>((Collection<DynamicObject>)periodDyos);
                periodTypeDatePeriodMap.put(periodTypeDatePeriodMapkey, periodLists);
            }
            for (DynamicObject period : periodLists) {
                if (subAcctStartDate.before(period.getDate("begindate")) || subAcctStartDate.after(period.getDate("enddate"))) continue;
                return true;
            }
        }
        return false;
    }

    private String checkNumberByTable(DynamicObject account, Map<Object, DynamicObject> parentMaps) {
        String parentNum;
        DynamicObject parentAcct;
        String[] accountlevels;
        DynamicObject accountTable = account.getDynamicObject("accounttable");
        boolean isinternational = accountTable.getBoolean("isinternational");
        boolean isextendpnum = accountTable.getBoolean("isextendpnum");
        String seperator = accountTable.getString("seperator");
        String number = account.getString("number");
        int level = account.getInt("level");
        String accountlevel = accountTable.getString("accountlevel");
        if (StringUtils.isEmpty((CharSequence)seperator)) {
            if (number.contains(".")) {
                return ResManager.loadKDString((String)"\u5f53\u524d\u79d1\u76ee\u8868\u672a\u8bbe\u7f6e\u5206\u9694\u7b26\uff0c\u79d1\u76ee\u4e0d\u5141\u8bb8\u5305\u542b\u5206\u9694\u7b26\u3002", (String)"AccountViewSaveValidator_135", (String)"fi-bd-opplugin", (Object[])new Object[0]);
            }
        } else if (level != 1 && !number.contains(seperator)) {
            return String.format(ResManager.loadKDString((String)"\u5f53\u524d\u79d1\u76ee\u8868\u5206\u9694\u7b26\u4e3a\u201c%s\u201d\uff0c\u975e\u4e00\u7ea7\u79d1\u76ee\u8bf7\u8bbe\u7f6e\u5206\u9694\u7b26\u3002", (String)"AccountViewSaveValidator_136", (String)"fi-bd-opplugin", (Object[])new Object[0]), seperator);
        }
        if (isinternational) {
            accountlevels = accountlevel.split("-");
            if (!StringUtils.isEmpty((CharSequence)seperator)) {
                String[] splitNumbers = number.split("\\" + seperator);
                for (int i = 0; i < splitNumbers.length; ++i) {
                    if (splitNumbers[i].length() <= Integer.parseInt(accountlevels[i])) continue;
                    return ResManager.loadKDString((String)"\u56fd\u9645\u51c6\u5219\u4e0b\uff0c\u6bcf\u7ea7\u79d1\u76ee\u7f16\u7801\u8bbe\u7f6e\u4e0d\u80fd\u8d85\u8fc7\u5bf9\u5e94\u7ea7\u6b21\u7684\u79d1\u76ee\u8868\u7ea7\u6b21\u8bbe\u7f6e\u3002", (String)"AccountViewSaveValidator_11", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                }
            }
        } else {
            accountlevels = accountlevel.split("-");
            String noneSplitNumber = number;
            if (!StringUtils.isEmpty((CharSequence)seperator)) {
                noneSplitNumber = number.replaceAll("\\" + seperator, "");
            }
            int curLength = noneSplitNumber.length();
            int rightLength = 0;
            if (accountlevels.length < level) {
                return String.format(ResManager.loadKDString((String)"\u79d1\u76ee\u8868\u8bbe\u7f6e\u7684\u6700\u5927\u7ea7\u6b21\u662f%d\u7ea7\uff0c\u5f53\u524d\u79d1\u76ee\u7f16\u7801\u8d85\u8fc7\u8be5\u7ea7\u6b21\uff0c\u8bf7\u68c0\u67e5\u79d1\u76ee\u7f16\u7801\u7684\u8bbe\u7f6e\u3002", (String)"AccountViewSaveValidator_137", (String)"fi-bd-opplugin", (Object[])new Object[0]), accountlevels.length);
            }
            for (int i = 0; i < level; ++i) {
                rightLength += Integer.parseInt(accountlevels[i]);
            }
            if (rightLength != curLength) {
                return String.format(ResManager.loadKDString((String)"\u5f53\u524d\u79d1\u76ee\u8868\u7ea7\u6b21\u4e3a'%1$s'\uff0c%2$d\u7ea7\u79d1\u76ee\u7f16\u7801\u4f4d\u6570\u4e0d\u7b26\u5408\u79d1\u76ee\u8868\u7684\u8bbe\u7f6e\u3002", (String)"AccountViewSaveValidator_138", (String)"fi-bd-opplugin", (Object[])new Object[0]), accountlevel, level);
            }
            int maxLength = 0;
            for (String perlevel : accountlevels) {
                maxLength += Integer.parseInt(perlevel);
            }
            if (curLength > maxLength) {
                return String.format(ResManager.loadKDString((String)"\u79d1\u76ee\u8868\u8bbe\u7f6e\u7684\u6700\u5927\u7ea7\u6b21\u662f%d\u7ea7\uff0c\u5f53\u524d\u79d1\u76ee\u7f16\u7801\u8d85\u8fc7\u8be5\u7ea7\u6b21\uff0c\u8bf7\u68c0\u67e5\u79d1\u76ee\u7f16\u7801\u7684\u8bbe\u7f6e\u3002", (String)"AccountViewSaveValidator_137", (String)"fi-bd-opplugin", (Object[])new Object[0]), accountlevels.length);
            }
            if (!StringUtils.isEmpty((CharSequence)seperator)) {
                String[] splitNumbers = number.split("\\" + seperator);
                for (int i = 0; i < splitNumbers.length; ++i) {
                    if (splitNumbers[i].length() == Integer.parseInt(accountlevels[i])) continue;
                    return String.format(ResManager.loadKDString((String)"\u5f53\u524d\u79d1\u76ee\u8868\u7ea7\u6b21\u4e3a'%1$s'\uff0c%2$d\u7ea7\u79d1\u76ee\u7f16\u7801\u4f4d\u6570\u4e0d\u7b26\u5408\u79d1\u76ee\u8868\u7684\u8bbe\u7f6e\u3002", (String)"AccountViewSaveValidator_138", (String)"fi-bd-opplugin", (Object[])new Object[0]), accountlevel, level);
                }
            }
        }
        DynamicObject dynamicObject = parentAcct = account.getLong("parent_id") == 0L ? null : parentMaps.get(account.getLong("parent_id"));
        if (parentAcct != null && isextendpnum && !number.startsWith(parentNum = parentAcct.getString("number"))) {
            return ResManager.loadKDString((String)"\u7f16\u7801\u524d\u7f00\u4e0e\u4e0a\u7ea7\u7f16\u7801\u4e0d\u4e00\u81f4\u3002", (String)"AccountViewSaveValidator_14", (String)"fi-bd-opplugin", (Object[])new Object[0]);
        }
        return "";
    }

    private Object[] getPrepareData(ExtendedDataEntity[] dataEntities) {
        Object[] r = new Object[2];
        HashMap<String, Integer> numberMapInImportList = new HashMap<String, Integer>();
        ArrayList<Long> idsInDB = new ArrayList<Long>();
        for (ExtendedDataEntity entity : dataEntities) {
            DynamicObject acct = entity.getDataEntity();
            DynamicObject accttable = acct.getDynamicObject("accounttable");
            long accttableid = accttable == null ? acct.getLong("accounttable_id") : accttable.getLong("id");
            long createorgid = acct.getLong("createorg_id");
            String number = acct.getString("number");
            if (numberMapInImportList.get(accttableid + "+" + createorgid + number) == null) {
                numberMapInImportList.put(accttableid + "+" + createorgid + number, 0);
            }
            if (!acct.getDataEntityState().getFromDatabase()) continue;
            idsInDB.add(acct.getLong("id"));
        }
        r[0] = numberMapInImportList;
        if (!idsInDB.isEmpty()) {
            Map acctsInDB = BusinessDataServiceHelper.loadFromCache((Object[])idsInDB.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountview"));
            r[1] = acctsInDB;
        }
        return r;
    }

    private String isNumRepetition(DynamicObject account, Set<String> numberList, int repiteNumCountInImportList) {
        String number = account.getString("number");
        long masterid = account.getLong("masterid");
        if (masterid == 0L) {
            if (numberList.contains(number)) {
                return ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"AccountViewSaveValidator_15", (String)"fi-bd-opplugin", (Object[])new Object[0]);
            }
            if (repiteNumCountInImportList != 0) {
                return ResManager.loadKDString((String)"\u7f16\u7801\u5728\u5bfc\u5165\u5217\u8868\u4e2d\u5df2\u5b58\u5728\u3002", (String)"AccountViewSaveValidator_16", (String)"fi-bd-opplugin", (Object[])new Object[0]);
            }
        }
        return "";
    }

    private Map<String, String> getCtrlAcct(Map<Long, Map<Long, List<Map<String, String>>>> acctsMap, Long tableId, Long useorgId, String number) {
        List<Map<String, String>> orgAcctList;
        Map<String, String> result = null;
        Map<Long, List<Map<String, String>>> tableAcctMap = acctsMap.get(tableId);
        if (tableAcctMap != null && (orgAcctList = tableAcctMap.get(useorgId)) != null) {
            long maxOrgCtrlLevel = 0L;
            for (Map<String, String> map : orgAcctList) {
                long cctrllevel;
                String cnum = map.get("number");
                if (!cnum.equals(number) || (cctrllevel = Long.parseLong(map.get("orgcontrollevel"))) < maxOrgCtrlLevel) continue;
                maxOrgCtrlLevel = cctrllevel;
                result = map;
            }
        }
        return result;
    }

    private void cacheAccts(Map<Long, Map<Long, List<Map<String, String>>>> acctsMap, long useorgId, long accounttableId) {
        Map tableAcctMap;
        ArrayList orgAcctList;
        List porgIds = this.porgsMap.get(useorgId);
        if (porgIds == null) {
            porgIds = BDUtil.getAllSuperiorOrgIds((Object)useorgId, (boolean)false);
            this.porgsMap.put(useorgId, porgIds);
        }
        if (!porgIds.isEmpty() && (orgAcctList = (ArrayList)(tableAcctMap = acctsMap.computeIfAbsent(accounttableId, f -> new HashMap())).get(useorgId)) == null) {
            orgAcctList = new ArrayList();
            QFilter q1 = new QFilter("accounttable", "=", (Object)accounttableId);
            QFilter q2 = new QFilter("createorg", "in", (Object)porgIds);
            try (DataSet dt = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_accountview", (String)"id,masterid,number,createorg,isallowca,orgcontrollevel", (QFilter[])new QFilter[]{q1, q2}, null);){
                Row row = null;
                while (dt.hasNext()) {
                    row = dt.next();
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("number", row.getString("number"));
                    map.put("orgcontrollevel", row.getString("orgcontrollevel"));
                    map.put("isallowca", String.valueOf(row.get("isallowca")));
                    orgAcctList.add(map);
                }
            }
            tableAcctMap.put(useorgId, orgAcctList);
        }
    }

    private String checkOrgControllevel(DynamicObject account, Map<Long, DynamicObject> dataEntitiesMap, Map<Object, DynamicObject> parentMaps, Object acctsInDB, boolean isEdit) {
        boolean isFromRepairOrAssignOp = AccountVersionOpVars.isFromRepairOrAssignView((OperateOption)this.getOption());
        long parentId = account.getLong("parent_id");
        long masterid = account.getLong("masterid");
        long useorgId = account.getLong("useorg_id");
        long accounttableId = account.getLong("accounttable_id");
        long tableOrgId = account.getDynamicObject("accounttable").getLong("org_id");
        boolean isallowca = account.getBoolean("isallowca");
        int controllevel = Integer.parseInt(account.getString("orgcontrollevel"));
        Map<String, String> ctrlAcct = null;
        boolean isAssign = this.getOption().containsVariable("isassign");
        if (!isEdit && !isAssign) {
            if (useorgId != tableOrgId && masterid == 0L && parentId == 0L) {
                return ResManager.loadKDString((String)"\u4e00\u7ea7\u79d1\u76ee\u53ea\u80fd\u7531\u79d1\u76ee\u8868\u7684\u521b\u5efa\u7ec4\u7ec7\u521b\u5efa\u3002", (String)"AccountViewSaveValidator_17", (String)"fi-bd-opplugin", (Object[])new Object[0]);
            }
            if (parentId != 0L) {
                DynamicObject parent;
                DynamicObject dynamicObject = parent = parentMaps.get(parentId) == null ? dataEntitiesMap.get(parentId) : parentMaps.get(parentId);
                if (parent != null) {
                    this.cacheAccts(this.acctsMap, useorgId, accounttableId);
                    ctrlAcct = this.getCtrlAcct(this.acctsMap, accounttableId, useorgId, parent.getString("number"));
                    if (ctrlAcct != null) {
                        boolean ctrlIsallowca = parent.getBoolean("isallowca");
                        if (!ctrlIsallowca) {
                            return String.format(ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7%s\u79d1\u76ee\u52fe\u9009\u4e86'\u4e0d\u5141\u8bb8\u4e0b\u7ea7\u7ec4\u7ec7\u589e\u52a0\u79d1\u76ee'\u9009\u9879\uff0c\u4e0b\u7ea7\u7ec4\u7ec7\u4e0d\u5141\u8bb8\u589e\u52a0\u8be5\u79d1\u76ee\u7684\u4e0b\u7ea7\u79d1\u76ee\u3002", (String)"AccountViewSaveValidator_139", (String)"fi-bd-opplugin", (Object[])new Object[0]), ctrlAcct.get("number"));
                        }
                        int ctrlOrgcontrollevel = Integer.parseInt(ctrlAcct.get("orgcontrollevel"));
                        int level = account.getInt("level");
                        if (level <= ctrlOrgcontrollevel) {
                            return String.format(ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7%1$s\u79d1\u76ee\u63a7\u5236\u5230%2$d\u7ea7\uff0c\u5f53\u524d\u79d1\u76ee\u7ea7\u6b21\u4e3a%3$d\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\u3002", (String)"AccountViewSaveValidator_19", (String)"fi-bd-opplugin", (Object[])new Object[0]), ctrlAcct.get("number"), Integer.parseInt(ctrlAcct.get("orgcontrollevel")), account.getInt("level"));
                        }
                    }
                    if (!isAssign) {
                        QFilter flevel;
                        int level = account.getInt("level");
                        List<Long> porgIds = this.porgsMap.get(useorgId);
                        QFilter forgId = new QFilter("org", "in", porgIds);
                        QFilter facctTableId = new QFilter("accounttable", "=", (Object)accounttableId);
                        QFilter fnumber = QFilter.like((String)"longnumber", (String)(parent.getString("longnumber") + "%"));
                        DynamicObject dyn = QueryServiceHelper.queryOne((String)"bd_accountview", (String)"id", (QFilter[])new QFilter[]{forgId, fnumber, flevel = new QFilter("level", "=", (Object)level), facctTableId});
                        if (Objects.nonNull(dyn)) {
                            return String.format(ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7\u521b\u5efa\u4e86%s\u7ea7\u79d1\u76ee\uff0c\u5f53\u524d\u7ec4\u7ec7\u4e0d\u80fd\u518d\u521b\u5efa\u540c\u7ea7\u6b21\u79d1\u76ee\u3002", (String)"AccountViewSaveValidator_173", (String)"fi-bd-opplugin", (Object[])new Object[0]), level, level);
                        }
                        List subOrgIds = BDUtil.getAllSubordinateOrgs((Object)useorgId, (boolean)false);
                        subOrgIds.add(useorgId);
                        DataSet ds11 = BatchProcessUtil.batchQueryDataSet((Collection)subOrgIds, batchOrgs -> QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass() + ".add"), (String)"bd_accountview", (String)"number,org.id", (QFilter[])new QFilter[]{new QFilter("org", "in", batchOrgs), fnumber, flevel, facctTableId}, null));
                        HashSet<String> mid1 = new HashSet<String>(10);
                        HashSet<String> mid2 = new HashSet<String>(10);
                        for (Row row : ds11) {
                            if (row.getLong("org.id") == useorgId) {
                                mid1.add(row.getString("number"));
                                continue;
                            }
                            mid2.add(row.getString("number"));
                        }
                        mid2.removeAll(mid1);
                        if (!mid2.isEmpty()) {
                            return String.format(ResManager.loadKDString((String)"\u4e0b\u7ea7\u7ec4\u7ec7\u521b\u5efa\u4e86%s\u7ea7\u79d1\u76ee\uff0c\u5f53\u524d\u7ec4\u7ec7\u4e0d\u80fd\u518d\u521b\u5efa\u540c\u7ea7\u6b21\u79d1\u76ee\u3002", (String)"AccountViewSaveValidator_110", (String)"fi-bd-opplugin", (Object[])new Object[0]), level, level);
                        }
                        boolean pisallowca = parent.getBoolean("isallowca");
                        int pcontrollevel = Integer.parseInt(parent.getString("orgcontrollevel"));
                        if (!isFromRepairOrAssignOp && !pisallowca && isallowca) {
                            return ResManager.loadKDString((String)"\u4e0a\u7ea7\u79d1\u76ee\u4e0d\u5141\u8bb8\u516c\u53f8\u589e\u52a0\u4e0b\u7ea7\u79d1\u76ee\u65f6\uff0c\u4e0b\u7ea7\u79d1\u76ee\u4e5f\u4e0d\u5141\u8bb8\u3002", (String)"AccountViewSaveValidator_20", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                        }
                        if (pisallowca && isallowca && controllevel < pcontrollevel) {
                            return ResManager.loadKDString((String)"\u4e0a\u7ea7\u79d1\u76ee\u63a7\u5236\u7ea7\u6b21\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u4e0b\u7ea7\u79d1\u76ee\u7684\u63a7\u5236\u7ea7\u6b21\u3002", (String)"AccountViewSaveValidator_140", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                        }
                    }
                }
            }
        } else {
            Iterable it = account.getDataEntityState().getBizChangedProperties();
            boolean checkFlag = false;
            for (IDataEntityProperty iDataEntityProperty : it) {
                String changeKey = iDataEntityProperty.getName();
                if (!changeKey.equals("isallowca") && !changeKey.equals("orgcontrollevel")) continue;
                checkFlag = true;
                break;
            }
            if (checkFlag) {
                int controllevelDB;
                long id = account.getLong("id");
                DynamicObject acctInDB = (DynamicObject)((Map)acctsInDB).get(id);
                boolean isallowcaDB = acctInDB.getBoolean("isallowca");
                if (isallowca && !isallowcaDB) {
                    boolean ctrlIsallowca;
                    this.cacheAccts(this.acctsMap, useorgId, accounttableId);
                    ctrlAcct = this.getCtrlAcct(this.acctsMap, accounttableId, useorgId, account.getString("number"));
                    if (ctrlAcct != null && !(ctrlIsallowca = Boolean.parseBoolean(ctrlAcct.get("isallowca"))) && !isFromRepairOrAssignOp) {
                        return ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7\u4e0d\u52fe\u9009\u5141\u8bb8\u516c\u53f8\u589e\u52a0\u4e0b\u7ea7\u79d1\u76ee\u65f6\uff0c\u4e0b\u7ea7\u7ec4\u7ec7\u4e5f\u4e0d\u80fd\u52fe\u9009\u3002", (String)"AccountViewSaveValidator_22", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                    }
                    if (parentId != 0L) {
                        boolean pisallowca;
                        DynamicObject parent;
                        DynamicObject dynamicObject = parent = parentMaps.get(parentId) == null ? dataEntitiesMap.get(parentId) : parentMaps.get(parentId);
                        if (parent != null && !(pisallowca = parent.getBoolean("isallowca")) && !isFromRepairOrAssignOp) {
                            return ResManager.loadKDString((String)"\u4e0a\u7ea7\u79d1\u76ee\u4e0d\u52fe\u9009\u5141\u8bb8\u516c\u53f8\u589e\u52a0\u4e0b\u7ea7\u79d1\u76ee\u65f6\uff0c\u4e0b\u7ea7\u79d1\u76ee\u4e5f\u4e0d\u80fd\u52fe\u9009\u3002", (String)"AccountViewSaveValidator_23", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                        }
                    }
                }
                if (controllevel < (controllevelDB = Integer.parseInt(acctInDB.getString("orgcontrollevel")))) {
                    int ctrlcontrollevel;
                    this.cacheAccts(this.acctsMap, useorgId, accounttableId);
                    ctrlAcct = this.getCtrlAcct(this.acctsMap, accounttableId, useorgId, account.getString("number"));
                    if (ctrlAcct != null && controllevel < (ctrlcontrollevel = Integer.parseInt(ctrlAcct.get("orgcontrollevel")))) {
                        return ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u79d1\u76ee\u7684\u63a7\u5236\u7ea7\u6b21\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u4e0a\u7ea7\u7ec4\u7ec7\u8be5\u79d1\u76ee\u7684\u63a7\u5236\u7ea7\u6b21\u3002", (String)"AccountViewSaveValidator_141", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                    }
                    if (parentId != 0L) {
                        int pcontrollevel;
                        DynamicObject parent;
                        DynamicObject dynamicObject = parent = parentMaps.get(parentId) == null ? dataEntitiesMap.get(parentId) : parentMaps.get(parentId);
                        if (parent != null && controllevel < (pcontrollevel = Integer.parseInt(parent.getString("orgcontrollevel")))) {
                            return ResManager.loadKDString((String)"\u5f53\u524d\u79d1\u76ee\u7684\u63a7\u5236\u7ea7\u6b21\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u4e0a\u7ea7\u79d1\u76ee\u7684\u63a7\u5236\u7ea7\u6b21\u3002", (String)"AccountViewSaveValidator_142", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                        }
                    }
                } else if (controllevel > controllevelDB) {
                    List subOrgIds = BDUtil.getAllSubordinateOrgs((Object)useorgId, (boolean)true);
                    boolean exist = false;
                    try (DataSet ds = BDUtil.getAllSubAccts((DynamicObject)account, new HashSet(subOrgIds));){
                        for (Row row : ds) {
                            if (row.getLong("id").longValue() == account.getLong("id") || controllevel <= Integer.parseInt(row.getString("controllevel"))) continue;
                            exist = true;
                            break;
                        }
                    }
                    if (exist) {
                        return ResManager.loadKDString((String)"\u5f53\u524d\u79d1\u76ee\u63a7\u5236\u7ea7\u6b21\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u4e0b\u7ea7\u7ec4\u7ec7\u548c\u4e0b\u7ea7\u79d1\u76ee\u7684\u63a7\u5236\u7ea7\u6b21\u3002", (String)"AccountViewSaveValidator_155", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                    }
                }
            }
        }
        return "";
    }

    private List<String> getNumber(DataSet ds) {
        ArrayList<String> list = new ArrayList<String>(10);
        for (Row row : ds) {
            list.add(row.getString("number"));
        }
        return list;
    }

    private String bussinessValidate(DynamicObject account, Map<Long, DynamicObject> dataEntitiesMap, Map<Object, DynamicObject> parentMaps, Object acctsInDB) {
        long groupid;
        long unitgroupid;
        boolean isbw;
        boolean isqty;
        boolean isEdit = account.getDataEntityState().getFromDatabase();
        boolean isFromRepairOrAssignOp = AccountVersionOpVars.isFromRepairOrAssignView((OperateOption)this.getOption());
        if (null != account.getDate("startdate") && BDUtil.getLaterCrossPeriods((Date)account.getDate("startdate")).isEmpty()) {
            return ResManager.loadKDString((String)"\u5c1a\u672a\u7ef4\u62a4\u7248\u672c\u5316\u65e5\u671f\u6240\u5c5e\u7684\u4f1a\u8ba1\u671f\u95f4\uff0c\u8bf7\u524d\u5f80\u3010\u57fa\u7840\u8d44\u6599\u3011-\u3010\u4f1a\u8ba1\u671f\u95f4\u3011\u7ef4\u62a4\u7248\u672c\u5316\u65e5\u671f\u6240\u5c5e\u7684\u4f1a\u8ba1\u671f\u95f4\u3002", (String)"AccountViewSaveValidator_165", (String)"fi-bd-opplugin", (Object[])new Object[0]);
        }
        String controlresult = this.checkOrgControllevel(account, dataEntitiesMap, parentMaps, acctsInDB, isEdit);
        if (!controlresult.isEmpty()) {
            return controlresult;
        }
        long parentId = account.getLong("parent_id");
        int count = 0;
        boolean isCash = account.getBoolean("iscash");
        boolean isBank = account.getBoolean("isbank");
        boolean isCashQuivalent = account.getBoolean("iscashequivalent");
        boolean isAcNotice = account.getBoolean("acnotice");
        if (isCash) {
            ++count;
        }
        if (isBank) {
            ++count;
        }
        if (isCashQuivalent) {
            ++count;
        }
        if (count > 1) {
            return ResManager.loadKDString((String)"\u73b0\u91d1\u79d1\u76ee\u3001\u94f6\u884c\u79d1\u76ee\u548c\u73b0\u91d1\u7b49\u4ef7\u7269\u53ea\u80fd\u52fe\u9009\u5176\u4e2d\u4e00\u9879\u3002", (String)"AccountViewSaveValidator_33", (String)"fi-bd-opplugin", (Object[])new Object[0]);
        }
        boolean isJournal = account.getBoolean("isjournal");
        if ((isCash || isBank) && !isJournal) {
            return ResManager.loadKDString((String)"\u73b0\u91d1\u3001\u94f6\u884c\u79d1\u76ee\u5fc5\u987b\u52fe\u9009\u767b\u65e5\u8bb0\u8d26\u3002", (String)"AccountViewSaveValidator_179", (String)"fi-bd-opplugin", (Object[])new Object[0]);
        }
        DynamicObject accounttype = account.getDynamicObject("accounttype");
        if (accounttype != null) {
            String t = accounttype.getString("accounttype");
            boolean isAccheck = account.getBoolean("accheck");
            boolean isBudGet = isCashQuivalent || isCash || isBank || isAcNotice || isAccheck;
            boolean isBudGetType = AccountType.isBudGetType((String)t);
            if (isBudGetType && isBudGet) {
                return ResManager.loadKDString((String)"\u5f53\u79d1\u76ee\u7c7b\u578b\u4e3a%s\u65f6\uff0c\u4e0d\u80fd\u52fe\u9009\u6216\u8005\u5f00\u542f\u73b0\u91d1\u79d1\u76ee\u3001\u94f6\u884c\u79d1\u76ee\u3001\u73b0\u91d1\u7b49\u4ef7\u7269\u3001\u5f80\u6765\u901a\u77e5\u3001\u5f80\u6765\u6838\u7b97\u5c5e\u6027\u3002", (String)"AccountViewSaveValidator_171", (String)"fi-bd-opplugin", (Object[])new Object[]{accounttype.getString("name")});
            }
            if (isBudGetType && account.getBoolean("isjournal")) {
                return ResManager.loadKDString((String)"\u5f53\u79d1\u76ee\u7c7b\u578b\u4e3a%s\u65f6\uff0c\u4e0d\u80fd\u52fe\u9009\u767b\u65e5\u8bb0\u8d26\u5c5e\u6027\u3002", (String)"AccountViewSaveValidator_182", (String)"fi-bd-opplugin", (Object[])new Object[]{accounttype.getString("name")});
            }
            if (!"0".equals(t) && (isCash || isBank || isCashQuivalent)) {
                return ResManager.loadKDString((String)"\u5f53\u79d1\u76ee\u7c7b\u578b\u4e0d\u4e3a\u8d44\u4ea7\u65f6\uff0c\u4e0d\u80fd\u52fe\u9009\u73b0\u91d1\u79d1\u76ee\u3001\u94f6\u884c\u79d1\u76ee\u3001\u73b0\u91d1\u7b49\u4ef7\u7269\u3002", (String)"AccountViewSaveValidator_34", (String)"fi-bd-opplugin", (Object[])new Object[0]);
            }
            if (!"5".equals(t) && account.getBoolean("bw")) {
                return ResManager.loadKDString((String)"\u975e\u8868\u5916\u7c7b\u578b\u79d1\u76ee\uff0c\u4e0d\u80fd\u52fe\u9009\u8868\u5916\u79d1\u76ee\u5c5e\u6027\u3002", (String)"AccountViewSaveValidator_174", (String)"fi-bd-opplugin", (Object[])new Object[0]);
            }
        }
        if (!(isqty = account.getBoolean("isqty"))) {
            DynamicObject measureunitgroup = account.getDynamicObject("measureunitgroup");
            DynamicObject measureunit = account.getDynamicObject("measureunit");
            if (measureunitgroup != null || measureunit != null) {
                return ResManager.loadKDString((String)"\u672a\u52fe\u9009\u6570\u91cf\u6838\u7b97\u65f6\uff0c\u65e0\u6cd5\u586b\u5199\u8ba1\u91cf\u5355\u4f4d\u548c\u8ba1\u91cf\u5355\u4f4d\u5206\u7ec4\u3002", (String)"AccountViewSaveValidator_35", (String)"fi-bd-opplugin", (Object[])new Object[0]);
            }
        }
        if ((isbw = account.getBoolean("bw")) && isAcNotice) {
            return ResManager.loadKDString((String)"\u5f53\u79d1\u76ee\u7c7b\u578b\u4e3a\u8868\u5916\u79d1\u76ee\u65f6\uff0c\u4e0d\u80fd\u52fe\u9009\u5f80\u6765\u901a\u77e5\u3002", (String)"AccountViewSaveValidator_36", (String)"fi-bd-opplugin", (Object[])new Object[0]);
        }
        ArrayList<Long> itemIds = new ArrayList<Long>();
        if (isAcNotice) {
            DynamicObjectCollection checkitementry = account.getDynamicObjectCollection("checkitementry");
            for (DynamicObject item : checkitementry) {
                if (item.getDynamicObject("asstactitem") == null) continue;
                itemIds.add(item.getDynamicObject("asstactitem").getLong("id"));
            }
            if (itemIds.size() == 0) {
                return ResManager.loadKDString((String)"\u5f53\u524d\u79d1\u76ee\u4e3a\u53d1\u9001\u5f80\u6765\u901a\u77e5\u5355\u79d1\u76ee\uff0c\u6838\u7b97\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AccountViewSaveValidator_37", (String)"fi-bd-opplugin", (Object[])new Object[0]);
            }
        }
        HashMap<Long, DynamicObject> checkitemMap = new HashMap<Long, DynamicObject>();
        DynamicObjectCollection checkitementry = account.getDynamicObjectCollection("checkitementry");
        boolean isCashOrgBankSource = false;
        for (DynamicObject checkitem : checkitementry) {
            if (checkitem.getDynamicObject("asstactitem") == null) {
                if (checkitem.get("isrequire") == null && checkitem.get("isdetail") == null) continue;
                return ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6\u4e3a\u7a7a\u65f6\uff0c\u5fc5\u5f55\u3001\u660e\u7ec6\u5c5e\u6027\u4e5f\u5e94\u8be5\u4e3a\u7a7a\u3002", (String)"AccountViewSaveValidator_143", (String)"fi-bd-opplugin", (Object[])new Object[0]);
            }
            DynamicObject assisItem = checkitem.getDynamicObject("asstactitem");
            String valuesourceId = assisItem.getString("valuesource_id");
            if ((valuesourceId.equals("cas_accountcash") || valuesourceId.equals("bd_accountbanks")) && !isCashOrgBankSource) {
                isCashOrgBankSource = true;
            }
            boolean isrequire = checkitem.getBoolean("isrequire");
            boolean enaccheck = checkitem.getBoolean("enaccheck");
            if (enaccheck && !isrequire) {
                return ResManager.loadKDString((String)"\u52fe\u9009\u5f80\u6765\u6838\u7b97\u7684\u6838\u7b97\u7ef4\u5ea6\u5fc5\u987b\u5fc5\u5f55\u3002", (String)"AccountViewSaveValidator_40", (String)"fi-bd-opplugin", (Object[])new Object[0]);
            }
            String valuetype = assisItem.getString("valuetype");
            if (enaccheck && "3".equals(valuetype)) {
                return ResManager.loadKDString((String)"\u503c\u7c7b\u578b\u4e3a\u624b\u5de5\u8f93\u5165\u7684\u6838\u7b97\u7ef4\u5ea6\u4e0d\u5141\u8bb8\u52fe\u9009\u5f80\u6765\u6838\u7b97\u3002", (String)"AccountViewSaveValidator_41", (String)"fi-bd-opplugin", (Object[])new Object[0]);
            }
            checkitemMap.put(checkitem.getDynamicObject("asstactitem").getLong("id"), checkitem);
        }
        if (!(isCash || isBank || isCashQuivalent || isCashOrgBankSource || !isJournal)) {
            return ResManager.loadKDString((String)"\u767b\u65e5\u8bb0\u8d26\u7684\u975e\u73b0\u91d1\u7c7b\u79d1\u76ee\u5fc5\u987b\u8bbe\u7f6e\u73b0\u91d1\u8d26\u6237\u6216\u94f6\u884c\u8d26\u6237\u6838\u7b97\u7ef4\u5ea6\u3002", (String)"AccountViewSaveValidator_180", (String)"fi-bd-opplugin", (Object[])new Object[0]);
        }
        DynamicObject measureunitgroup = account.getDynamicObject("measureunitgroup");
        DynamicObject measureunit = account.getDynamicObject("measureunit");
        if (measureunit != null && measureunitgroup != null && (unitgroupid = measureunit.getLong("group.id")) != (groupid = Long.parseLong(String.valueOf(measureunitgroup.getPkValue())))) {
            return ResManager.loadKDString((String)"\u6240\u9009\u7684\u8ba1\u91cf\u5355\u4f4d\u5206\u7ec4\u91cc\u6ca1\u6709\u6240\u9009\u7684\u8ba1\u91cf\u5355\u4f4d\u3002", (String)"AccountViewSaveValidator_42", (String)"fi-bd-opplugin", (Object[])new Object[0]);
        }
        String acctcurrency = account.getString("acctcurrency");
        DynamicObjectCollection curentry = account.getDynamicObjectCollection("currencyentry");
        if (!curentry.isEmpty() && ("allcurrency".equals(acctcurrency) || "nocurrency".equals(acctcurrency))) {
            return ResManager.loadKDString((String)"\u5f53\u4e0d\u6838\u7b97\u5e01\u79cd\u6216\u8005\u6838\u7b97\u6240\u6709\u5e01\u79cd\u65f6\uff0c\u4e0d\u9700\u8981\u589e\u52a0\u5e01\u79cd\u5206\u5f55\u660e\u7ec6\u3002", (String)"AccountViewSaveValidator_44", (String)"fi-bd-opplugin", (Object[])new Object[0]);
        }
        if (parentId != 0L) {
            String pacctcurrency;
            boolean ismanual;
            boolean parentismanual;
            long parentaccounttypeId;
            DynamicObject parent;
            DynamicObject dynamicObject = parent = parentMaps.get(parentId) == null ? dataEntitiesMap.get(parentId) : parentMaps.get(parentId);
            if (parent == null) {
                return "";
            }
            long accounttypeId = account.getLong("accounttype_id");
            if (accounttypeId != (parentaccounttypeId = parent.getLong("accounttype_id"))) {
                return ResManager.loadKDString((String)"\u79d1\u76ee\u7c7b\u578b\u548c\u4e0a\u7ea7\u79d1\u76ee\u4e0d\u4e00\u81f4\u3002", (String)"AccountViewSaveValidator_45", (String)"fi-bd-opplugin", (Object[])new Object[0]);
            }
            boolean parentiscash = parent.getBoolean("iscash");
            boolean parentisbank = parent.getBoolean("isbank");
            boolean parentiscashequivalent = parent.getBoolean("iscashequivalent");
            if (isCash != parentiscash || isBank != parentisbank || isCashQuivalent != parentiscashequivalent) {
                if (isCash != parentiscash || isBank != parentisbank) {
                    return ResManager.loadKDString((String)"\u73b0\u91d1\u79d1\u76ee\u3001\u94f6\u884c\u79d1\u76ee\u52fe\u9009\u72b6\u6001\u5e94\u8be5\u548c\u4e0a\u7ea7\u79d1\u76ee\u4fdd\u6301\u4e00\u81f4\u3002", (String)"AccountViewSaveValidator_46", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                }
                if (parentiscashequivalent && !isCashQuivalent) {
                    return ResManager.loadKDString((String)"\u4e0a\u7ea7\u79d1\u76ee\u52fe\u9009\u73b0\u91d1\u7b49\u4ef7\u5c5e\u6027\u65f6\uff0c\u4e0b\u7ea7\u79d1\u76ee\u5fc5\u987b\u4e0e\u4e0a\u7ea7\u79d1\u76ee\u4fdd\u6301\u4e00\u81f4\u3002", (String)"AccountViewSaveValidator_167", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                }
            }
            if (!(parentismanual = parent.getBoolean("ismanual")) && parentismanual != (ismanual = account.getBoolean("ismanual")) && !isFromRepairOrAssignOp) {
                return ResManager.loadKDString((String)"\u5f53\u4e0a\u7ea7\u79d1\u76ee\u7684\u624b\u5de5\u5f55\u5165\u5c5e\u6027\u4e3a\u5426\u65f6\uff0c\u4e0b\u7ea7\u4e0d\u80fd\u4e3a\u662f\u3002", (String)"AccountViewSaveValidator_47", (String)"fi-bd-opplugin", (Object[])new Object[0]);
            }
            for (int i = 0; i < fieldKeys.length; ++i) {
                if (isFromRepairOrAssignOp && !fieldKeys[i].equals("bw")) continue;
                boolean field = account.getBoolean(fieldKeys[i]);
                boolean parentField = parent.getBoolean(fieldKeys[i]);
                if (!parentField || field == parentField) continue;
                return String.format(ResManager.loadKDString((String)"%s\u5c5e\u6027\u7684\u52fe\u9009\u72b6\u6001\u5e94\u8be5\u548c\u4e0a\u7ea7\u79d1\u76ee\u4fdd\u6301\u4e00\u81f4\u3002", (String)"AccountViewSaveValidator_111", (String)"fi-bd-opplugin", (Object[])new Object[0]), fieldNames[i]);
            }
            DynamicObjectCollection parentcheckitementry = parent.getDynamicObjectCollection("checkitementry");
            if (parentcheckitementry.size() != 0) {
                for (int i = 0; i < parentcheckitementry.size(); ++i) {
                    if (((DynamicObject)parentcheckitementry.get(i)).getDynamicObject("asstactitem") == null) {
                        return ResManager.loadKDString((String)"\u4e0a\u7ea7\u79d1\u76ee\u7684\u6838\u7b97\u9879\u76ee\u5206\u5f55\u4e2d\u5b58\u5728\u6838\u7b97\u7ef4\u5ea6\u4e3a\u7a7a\u7684\u884c\u3002", (String)"AccountViewSaveValidator_50", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                    }
                    DynamicObject assist = ((DynamicObject)parentcheckitementry.get(i)).getDynamicObject("asstactitem");
                    long parentasstactTypeId = assist.getLong("id");
                    if (!checkitemMap.containsKey(parentasstactTypeId)) {
                        return String.format(ResManager.loadKDString((String)"\u4e0b\u7ea7\u79d1\u76ee\u5fc5\u987b\u5305\u542b\u4e0a\u7ea7\u79d1\u76ee\u7684\u6838\u7b97\u7ef4\u5ea6\u3002\u4e0a\u7ea7\u79d1\u76ee\u6709'%s'\u7ef4\u5ea6\uff0c\u5f53\u524d\u79d1\u76ee\u4e5f\u5fc5\u987b\u5305\u542b\u8be5\u7ef4\u5ea6\u3002", (String)"AccountViewSaveValidator_144", (String)"fi-bd-opplugin", (Object[])new Object[0]), assist.getString("name"));
                    }
                    DynamicObject parentItem = (DynamicObject)parentcheckitementry.get(i);
                    DynamicObject curItem = (DynamicObject)checkitemMap.get(parentasstactTypeId);
                    for (int t = 0; t < entryFields.length; ++t) {
                        if (!parentItem.getBoolean(entryFields[t]) || curItem.getBoolean(entryFields[t])) continue;
                        return String.format(ResManager.loadKDString((String)"\u5f53\u4e0a\u7ea7\u79d1\u76ee\u6838\u7b97\u7ef4\u5ea6'%1$s'\u7684'%2$s'\u5c5e\u6027\u52fe\u9009\u65f6\uff0c\u4e0b\u7ea7\u4e0d\u80fd\u53d6\u6d88\u52fe\u9009\u3002", (String)"AccountViewSaveValidator_52", (String)"fi-bd-opplugin", (Object[])new Object[0]), curItem.getDynamicObject("asstactitem").getString("name"), entryFieldNames[t]);
                    }
                }
            }
            if ("descurrency".equals(pacctcurrency = parent.getString("acctcurrency"))) {
                DynamicObject cur;
                if ("allcurrency".equals(acctcurrency)) {
                    return ResManager.loadKDString((String)"\u4e0a\u7ea7\u79d1\u76ee\u6838\u7b97\u6307\u5b9a\u5e01\u79cd,\u5f53\u524d\u79d1\u76ee\u4e0d\u80fd\u6838\u7b97\u6240\u6709\u5e01\u79cd\uff0c\u4e0b\u7ea7\u79d1\u76ee\u6838\u7b97\u7684\u5e01\u79cd\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u4e0a\u7ea7\u79d1\u76ee\u3002", (String)"AccountViewSaveValidator_145", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                }
                DynamicObjectCollection pcurentry = parent.getDynamicObjectCollection("currencyentry");
                if (pcurentry.size() < curentry.size()) {
                    return ResManager.loadKDString((String)"\u5f53\u524d\u79d1\u76ee\u6307\u5b9a\u7684\u6838\u7b97\u5e01\u79cd\u6570\u76ee\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u4e0a\u7ea7\u79d1\u76ee\u7684\u5e01\u79cd\u6838\u7b97\u6570\u76ee\u3002", (String)"AccountViewSaveValidator_146", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                }
                HashSet<Long> pcurIds = new HashSet<Long>(pcurentry.size());
                for (DynamicObject row : pcurentry) {
                    cur = row.getDynamicObject("currency");
                    if (cur == null) continue;
                    pcurIds.add(cur.getLong("id"));
                }
                for (DynamicObject row : curentry) {
                    long curId;
                    cur = row.getDynamicObject("currency");
                    if (cur == null || pcurIds.contains(curId = cur.getLong("id"))) continue;
                    return ResManager.loadKDString((String)"\u5f53\u524d\u79d1\u76ee\u7684\u6838\u7b97\u5e01\u79cd\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u4e0a\u7ea7\u79d1\u76ee\u7684\u6307\u5b9a\u5e01\u79cd\u3002", (String)"AccountViewSaveValidator_147", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                }
            }
            if ("nocurrency".equals(pacctcurrency) && ("allcurrency".equals(acctcurrency) || "descurrency".equals(acctcurrency))) {
                return ResManager.loadKDString((String)"\u4e0a\u7ea7\u79d1\u76ee\u4e0d\u6838\u7b97\u5916\u5e01\u65f6\uff0c\u5f53\u524d\u79d1\u76ee\u4e5f\u53ea\u80fd\u4e0d\u6838\u7b97\u5916\u5e01\u3002", (String)"AccountViewSaveValidator_148", (String)"fi-bd-opplugin", (Object[])new Object[0]);
            }
        }
        if (DebugTrace.enable()) {
            LOGGER.info("account_duplicate_assistitem debug, acc ID {}, number: {}, assist entries: {}", new Object[]{account.getLong("id"), account.getString("number"), checkitementry});
        }
        Set oids = new HashSet(10);
        PkSnapshotSet pkSnapshot = account.getDynamicObjectType().getPkSnapshot((Object)account);
        if (pkSnapshot != null) {
            oids = pkSnapshot.Snapshots.stream().filter(snapshot -> snapshot.TableName.equalsIgnoreCase("t_bd_accountasstactitem")).map(snapshot -> snapshot.Oids).collect(() -> new HashSet(10), (x, y) -> x.addAll(Arrays.asList(y)), (l, f) -> l.addAll(f));
        }
        List nids = checkitementry.stream().map(assistRow -> (Long)assistRow.getPkValue()).collect(Collectors.toList());
        oids.removeAll(nids);
        HashMap dbAssistMap = new HashMap(10);
        HashMap<Long, String> assistNameMap = new HashMap<Long, String>(10);
        for (DynamicObject assistRow2 : checkitementry) {
            DynamicObject assistObj = (DynamicObject)assistRow2.get("asstactitem");
            long currAssistId = (Long)assistObj.getPkValue();
            if (!dbAssistMap.containsKey(currAssistId)) {
                HashSet<Long> entryIdSet = new HashSet<Long>(10);
                entryIdSet.add((Long)assistRow2.getPkValue());
                dbAssistMap.put(currAssistId, entryIdSet);
                continue;
            }
            return String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6\u201c%s\u201d\u91cd\u590d,\u53ef\u80fd\u9875\u9762\u6570\u636e\u8fc7\u671f,\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"AccountViewSaveValidator_164", (String)"fi-bd-opplugin", (Object[])new Object[0]), assistObj.getString("name"));
        }
        if (null != acctsInDB) {
            DynamicObject acctInDB = (DynamicObject)((Map)acctsInDB).get(account.getPkValue());
            DynamicObjectCollection dbCheckItementry = acctInDB.getDynamicObjectCollection("checkitementry");
            if (DebugTrace.enable()) {
                LOGGER.info("account_duplicate_assistitem debug, db assist entries: {}", (Object)dbCheckItementry);
            }
            for (DynamicObject assistDb : dbCheckItementry) {
                DynamicObject assistObj = (DynamicObject)assistDb.get("asstactitem");
                assistNameMap.put((Long)assistObj.getPkValue(), assistObj.getString("name"));
                long assistId = (Long)assistObj.getPkValue();
                if (oids.contains(assistDb.getPkValue())) continue;
                if (dbAssistMap.containsKey(assistId)) {
                    ((Set)dbAssistMap.get(assistId)).add((Long)assistDb.getPkValue());
                    continue;
                }
                HashSet<Long> entryIdSet = new HashSet<Long>(10);
                entryIdSet.add((Long)assistDb.getPkValue());
                dbAssistMap.put(assistId, entryIdSet);
            }
        }
        for (Map.Entry assistEntryMap : dbAssistMap.entrySet()) {
            if (((Set)assistEntryMap.getValue()).size() <= 1) continue;
            return String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6\u201c%s\u201d\u91cd\u590d\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"AccountViewSaveValidator_163", (String)"fi-bd-opplugin", (Object[])new Object[0]), assistNameMap.get(assistEntryMap.getKey()));
        }
        return null;
    }

    private void editValidate(AccountSaveParam param) {
        Map<Long, Map<Long, Map<String, DynamicObject>>> acctIdsMap = this.getPrepareData();
        for (int i = 0; i < this.getDataEntities().length; ++i) {
            String errorMesg;
            ExtendedDataEntity entity = this.getDataEntities()[i];
            DynamicObject account = entity.getDataEntity();
            if (!account.getDataEntityState().getFromDatabase() || this.getFalseDataEntities().contains(entity) || !StringUtils.isNotEmpty((CharSequence)(errorMesg = this.doEditValidate(param, account, acctIdsMap)))) continue;
            this.addMessage(entity, errorMesg, ErrorLevel.Error);
        }
    }

    private String doEditValidate(AccountSaveParam param, DynamicObject account, Map<Long, Map<Long, Map<String, DynamicObject>>> acctIdsMap) {
        boolean isFromRepairOrAssignOp;
        Set<DynamicObject> paccts;
        String checkReferencRes;
        DynamicObject acctInDB = this.getAcctInDB(account, acctIdsMap);
        long useorgId = account.getLong("useorg_id");
        long createorgId = account.getLong("createorg_id");
        boolean isNameChanged = AccountVersionUtil.isNameChanged((DynamicObject)account, (DynamicObject)acctInDB);
        String errorMesg = null;
        boolean isExistsBizOnOrgDomain = false;
        if (acctInDB.getBoolean("iscashequivalent") != account.getBoolean("iscashequivalent")) {
            isExistsBizOnOrgDomain = BizHappenUtils.existsOnOrgDomain((long)account.getLong("masterid"), (long)useorgId, null);
            if (isExistsBizOnOrgDomain) {
                return ResManager.loadKDString((String)"\u5f53\u524d\u79d1\u76ee\u5df2\u6709\u4e1a\u52a1\u53d1\u751f\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u73b0\u91d1\u7b49\u4ef7\u7269\u5c5e\u6027\u3002", (String)"AccountViewSaveValidator_168", (String)"fi-bd-opplugin", (Object[])new Object[0]);
            }
            DynamicObject accountTable = account.getDynamicObject("accounttable");
            String ctrlStrategy = account.getString("ctrlstrategy");
            if ("1".equals(ctrlStrategy) || "2".equals(ctrlStrategy)) {
                boolean isCreatedByCurrOrg = AccountVersionUtil.isCreatedByCurrOrg((DynamicObject)account, (long)accountTable.getLong("id"), (long)useorgId);
                if (!isCreatedByCurrOrg) {
                    return ResManager.loadKDString((String)"\u5f53\u524d\u79d1\u76ee\u975e\u5f53\u524d\u7ec4\u7ec7\u521b\u5efa\uff0c\u4e0d\u652f\u6301\u5bf9\u73b0\u91d1\u7b49\u4ef7\u7269\u5c5e\u6027\u8fdb\u884c\u53d8\u66f4\u3002", (String)"AccountViewSaveValidator_169", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                }
                if (AccountVersionUtil.isAccountCustomizedByOrgs((long)account.getLong("id"), Collections.emptyList())) {
                    return ResManager.loadKDString((String)"\u5f53\u524d\u79d1\u76ee\u88ab\u4e0b\u7ea7\u7ec4\u7ec7\u505a\u8fc7\u7248\u672c\u5316\uff0c\u8bf7\u5220\u9664\u4e0b\u7ea7\u7248\u672c\u5316\u8bb0\u5f55\u3002", (String)"AccountViewSaveValidator_170", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(checkReferencRes = AccountViewSaveValidator.checkAccountTableRef(account, acctInDB)))) {
            return checkReferencRes;
        }
        boolean isVersion = this.getOption().containsVariable("isversion");
        if (isVersion) {
            PeriodStateEnum stateEnum = BDUtil.getCurVersionState(param.getPeriodTypeDatePeriodMap(), param.getPeriodTypeIds(), (Date)account.getDate("startdate"), (Date)acctInDB.getDate("startdate"));
            if (PeriodStateEnum.BOTH == stateEnum) {
                return ResManager.loadKDString((String)"\u7248\u672c\u5316\u65e5\u671f\u5bf9\u5e94\u591a\u4e2a\u4f1a\u8ba1\u671f\u95f4\uff0c\u8bf7\u8c03\u6574\u7248\u672c\u5316\u65e5\u671f\u3002", (String)"AccountViewSaveValidator_181", (String)"fi-bd-opplugin", (Object[])new Object[0]);
            }
            if (PeriodStateEnum.ALL_SAME == stateEnum) {
                if (DebugTrace.enable()) {
                    LOGGER.info("account is same period version curDate:{},dbDate:{}", account.get("startdate"), (Object)acctInDB.getDate("startdate"));
                }
                account.set("startdate", (Object)acctInDB.getDate("startdate"));
            }
            if (BizHappenUtils.existsOnOrgDomain((long)account.getLong("masterid"), (long)useorgId, (Date)account.getDate("startdate"))) {
                return ResManager.loadKDString((String)"\u79d1\u76ee\u5f53\u524d\u671f\u95f4\u6216\u4ee5\u540e\u671f\u95f4\u5df2\u6709\u4e1a\u52a1\u53d1\u751f\uff0c\u4e0d\u80fd\u7248\u672c\u5316\u3002", (String)"AccountViewSaveValidator_158", (String)"fi-bd-opplugin", (Object[])new Object[0]);
            }
        }
        if (useorgId != createorgId && ("5".equals(account.getString("ctrlstrategy")) || "6".equals(account.getString("ctrlstrategy")))) {
            return ResManager.loadKDString((String)"\u5171\u4eab\u7684\u79d1\u76ee\u53ea\u80fd\u5728\u521b\u5efa\u7ec4\u7ec7\u8fdb\u884c\u4fee\u6539\u3002", (String)"AccountViewSaveValidator_57", (String)"fi-bd-opplugin", (Object[])new Object[0]);
        }
        if (isNameChanged) {
            if (!AccountVersionUtil.isLatestAccount((DynamicObject)account, (long)0L)) {
                errorMesg = ResManager.loadKDString((String)"\u5f53\u524d\u79d1\u76ee\u4e0d\u662f\u6700\u65b0\u7248\u672c\u79d1\u76ee\uff0c\u65e0\u6cd5\u4fee\u6539\u540d\u79f0\u3002", (String)"AccountViewSaveValidator_58", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                return errorMesg;
            }
            if (!isVersion) {
                if (BizHappenUtils.existsOnOrgDomain((long)account.getLong("masterid"), (long)useorgId, (Date)acctInDB.getDate("startdate"))) {
                    return ResManager.loadKDString((String)"\u79d1\u76ee\u5df2\u6709\u4e1a\u52a1\u53d1\u751f\uff0c\u65e0\u6cd5\u4fee\u6539\u540d\u79f0\u3002", (String)"AccountViewSaveValidator_59", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                }
                List subIds = AccountVersionUtil.getAllSubAccts((Object)account.getPkValue());
                boolean existBiz = BizHappenUtils.batchExist(subIds.stream().map(x -> (Long)x).collect(Collectors.toSet()), null);
                if (existBiz) {
                    return ResManager.loadKDString((String)"\u4e0b\u7ea7\u79d1\u76ee\u5df2\u6709\u4e1a\u52a1\u53d1\u751f\uff0c\u65e0\u6cd5\u4fee\u6539\u540d\u79f0\u3002", (String)"AccountViewSaveValidator_60", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                }
            }
        }
        long id = account.getLong("id");
        errorMesg = this.checkTableTypeChange(account, acctInDB);
        if (!StringUtils.isEmpty((CharSequence)errorMesg)) {
            return errorMesg;
        }
        AccountOpContext.initOrgRelated(AccountOpContext.getContext(), useorgId);
        Long porgId = AccountOpContext.getContext().getOrgPorgs().get(account.getLong("useorg_id"));
        AccountOpContext.initTableOrgPaccts(AccountOpContext.getContext(), account.getLong("accounttable_id"), porgId, account.getString("number"));
        errorMesg = this.checkPorgProperties(useorgId, account, acctInDB);
        if (!StringUtils.isEmpty((CharSequence)errorMesg)) {
            return errorMesg;
        }
        errorMesg = this.checkChildorgProperties(account, acctInDB);
        if (!StringUtils.isEmpty((CharSequence)errorMesg)) {
            return errorMesg;
        }
        long tableId = account.getLong("accounttable_id");
        if (((Boolean)this.getAssistItemRequireChange((DynamicObject)acctInDB, (DynamicObject)account).item2).booleanValue() && (paccts = AccountOpContext.getContext().getTableOrgPAccts().get(tableId).get(porgId).get(account.getString("number"))) != null) {
            for (DynamicObject pacct : paccts) {
                if (useorgId == pacct.getLong("createorg_id")) continue;
                Tuple<String, Boolean> itemChanges = this.getAssistItemRequireChange(pacct, account);
                boolean isRequireChange = (Boolean)itemChanges.item2;
                if (!isRequireChange) continue;
                return String.format(ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7%1$s\u7684%2$s\u79d1\u76ee\u7684%3$s\u6838\u7b97\u7ef4\u5ea6\u8bbe\u7f6e\u4e3a\u5fc5\u5f55\u65f6\uff0c\u4e0b\u7ea7\u7ec4\u7ec7\u4e0d\u80fd\u6539\u4e3a\u975e\u5fc5\u5f55\u3002", (String)"AccountViewSaveValidator_61", (String)"fi-bd-opplugin", (Object[])new Object[0]), AccountOpContext.getContext().getOrgNum(porgId), pacct.getString("number"), itemChanges.item1);
            }
        }
        if (!(isFromRepairOrAssignOp = AccountVersionOpVars.isFromRepairOrAssignView((OperateOption)this.getOption()))) {
            errorMesg = this.checkParentAccts(account, useorgId);
        }
        if (!StringUtils.isEmpty((CharSequence)errorMesg)) {
            return errorMesg;
        }
        errorMesg = this.checkControlField(useorgId, account, acctInDB, isNameChanged, isExistsBizOnOrgDomain);
        if (!StringUtils.isEmpty((CharSequence)errorMesg)) {
            return errorMesg;
        }
        if (!isFromRepairOrAssignOp) {
            Object ctrlCheckErrorMsg;
            AccountVersionControlChecker.Result resultCheck = AccountVersionControlChecker.Result.success();
            if (AccountVersionOpVars.isBatchAddingAssist((OperateOption)this.getOption())) {
                if (AccountVersionOpVars.isOnlyValidatorWork((OperateOption)this.getOption())) {
                    int mainCheckTypes = AccountVersionControlChecker.CheckType.ACC_UP.getValue() | AccountVersionControlChecker.CheckType.ACC_DOWN.getValue() | AccountVersionControlChecker.CheckType.PARTENT_ORG.getValue() | AccountVersionControlChecker.CheckType.CHILD_ORG.getValue();
                    resultCheck = AccountVersionControlChecker.checkAccountControl((DynamicObject)account, (long)account.getLong("useorg_id"), (boolean)false, (long)account.getLong("id"), (int)mainCheckTypes, (int)AccountVersionControlChecker.AccPropType.OTHERS.getValue(), (OperateOption)this.getOption());
                }
                if (AccountVersionControlChecker.Status.SUCCESS == resultCheck.getStatus()) {
                    resultCheck = AccountVersionControlChecker.checkAccountControl((DynamicObject)account, (long)account.getLong("useorg_id"), (boolean)false, (long)account.getLong("id"), (int)(AccountVersionControlChecker.CheckType.ACC_UP.getValue() | AccountVersionControlChecker.CheckType.PARTENT_ORG.getValue()), (int)AccountVersionControlChecker.AccPropType.ASSIST.getValue(), (OperateOption)this.getOption());
                }
            } else {
                resultCheck = AccountVersionControlChecker.checkAccountControl((DynamicObject)account, (long)useorgId, (boolean)false, (long)id, (int)AccountVersionControlChecker.CheckType.allTypes(), (int)AccountVersionControlChecker.AccPropType.allTypes(), (OperateOption)this.getOption());
            }
            if (((Optional)(ctrlCheckErrorMsg = AccountVersionControlChecker.buildCheckResultTip((AccountVersionControlChecker.Result)resultCheck))).isPresent()) {
                return (String)((Optional)ctrlCheckErrorMsg).get();
            }
        }
        if (!StringUtils.isEmpty((CharSequence)(errorMesg = this.checkLeafAcctOfBizUnitBussinessHappen(account, acctInDB, useorgId)))) {
            return errorMesg;
        }
        Set<DynamicObject> paccts2 = AccountOpContext.getContext().getTableOrgPAccts().get(tableId).get(porgId).get(account.getString("number"));
        for (DynamicObject parentOrgDyo : paccts2) {
            boolean iscashequivalent;
            if (parentOrgDyo == null || useorgId == parentOrgDyo.getLong("createorg_id")) continue;
            boolean parentIsManual = parentOrgDyo.getBoolean("ismanual");
            if (!parentIsManual && account.getBoolean("ismanual") && !isFromRepairOrAssignOp) {
                return ResManager.loadKDString((String)"\u5f53\u4e0a\u7ea7\u7ec4\u7ec7\u79d1\u76ee\u7684\u624b\u5de5\u5f55\u5165\u5c5e\u6027\u4e3a\u5426\u65f6\uff0c\u4e0b\u7ea7\u4e0d\u80fd\u4e3a\u662f\u3002", (String)"AccountViewSaveValidator_108", (String)"fi-bd-opplugin", (Object[])new Object[0]);
            }
            boolean piscashequivalent = parentOrgDyo.getBoolean("iscashequivalent");
            if (piscashequivalent != (iscashequivalent = account.getBoolean("iscashequivalent"))) {
                return ResManager.loadKDString((String)"\u73b0\u91d1\u7b49\u4ef7\u7269\u7684\u52fe\u9009\u72b6\u6001\u5e94\u8be5\u4e0e\u4e0a\u7ea7\u7ec4\u7ec7\u4fdd\u6301\u4e00\u81f4\u3002", (String)"AccountViewSaveValidator_62", (String)"fi-bd-opplugin", (Object[])new Object[0]);
            }
            boolean pisjournal = parentOrgDyo.getBoolean("isjournal");
            boolean isjournal = account.getBoolean("isjournal");
            if (pisjournal && !isjournal && !isFromRepairOrAssignOp) {
                return ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7\u52fe\u9009\u767b\u65e5\u8bb0\u8d26\u65f6\uff0c\u4e0b\u7ea7\u7ec4\u7ec7\u4e5f\u5e94\u8be5\u52fe\u9009\u3002", (String)"AccountViewSaveValidator_63", (String)"fi-bd-opplugin", (Object[])new Object[0]);
            }
            String acctcurrency = account.getString("acctcurrency");
            String pacctcurrency = parentOrgDyo.getString("acctcurrency");
            if ("nocurrency".equals(pacctcurrency) && !"nocurrency".equals(acctcurrency)) {
                return ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7\u4e0d\u6838\u7b97\u5916\u5e01\u65f6,\u4e0b\u7ea7\u7ec4\u7ec7\u4e5f\u5e94\u8be5\u4e0d\u6838\u7b97\u5916\u5e01\u3002", (String)"AccountViewSaveValidator_64", (String)"fi-bd-opplugin", (Object[])new Object[0]);
            }
            if ("descurrency".equals(pacctcurrency) && "descurrency".equals(acctcurrency)) {
                DynamicObject cur;
                DynamicObjectCollection pcurentry = parentOrgDyo.getDynamicObjectCollection("currencyentry");
                DynamicObjectCollection curentry = account.getDynamicObjectCollection("currencyentry");
                if (pcurentry.size() < curentry.size()) {
                    return ResManager.loadKDString((String)"\u5f53\u524d\u79d1\u76ee\u6307\u5b9a\u7684\u6838\u7b97\u5e01\u79cd\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u4e0a\u7ea7\u7ec4\u7ec7\u8be5\u79d1\u76ee\u7684\u6307\u5b9a\u5e01\u79cd\u3002", (String)"AccountViewSaveValidator_149", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                }
                HashSet<Long> pcid = new HashSet<Long>(pcurentry.size());
                for (DynamicObject row : pcurentry) {
                    cur = row.getDynamicObject("currency");
                    if (cur == null) continue;
                    pcid.add(cur.getLong("id"));
                }
                for (DynamicObject row : curentry) {
                    cur = row.getDynamicObject("currency");
                    if (cur == null || pcid.contains(cur.getLong("id"))) continue;
                    return ResManager.loadKDString((String)"\u5f53\u524d\u79d1\u76ee\u6307\u5b9a\u7684\u6838\u7b97\u5e01\u79cd\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u4e0a\u7ea7\u7ec4\u7ec7\u8be5\u79d1\u76ee\u7684\u6307\u5b9a\u5e01\u79cd\u3002", (String)"AccountViewSaveValidator_149", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                }
            }
            if (!"descurrency".equals(pacctcurrency) || !"allcurrency".equals(acctcurrency)) continue;
            return ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7\u79d1\u76ee\u6838\u7b97\u6307\u5b9a\u5e01\u79cd\uff0c\u5f53\u524d\u79d1\u76ee\u4e0d\u80fd\u6838\u7b97\u6240\u6709\u5e01\u79cd\uff0c\u4e0b\u7ea7\u7ec4\u7ec7\u79d1\u76ee\u6838\u7b97\u7684\u5e01\u79cd\u5fc5\u987b\u5c11\u4e8e\u6216\u7b49\u4e8e\u4e0a\u7ea7\u7ec4\u7ec7\u5bf9\u5e94\u79d1\u76ee\u3002", (String)"AccountViewSaveValidator_150", (String)"fi-bd-opplugin", (Object[])new Object[0]);
        }
        if (isVersion) {
            if (useorgId != createorgId && ("5".equals(account.getString("ctrlstrategy")) || "6".equals(account.getString("ctrlstrategy")))) {
                return ResManager.loadKDString((String)"\u5171\u4eab\u7684\u79d1\u76ee\u53ea\u80fd\u521b\u5efa\u7ec4\u7ec7\u8fdb\u884c\u4fee\u6539\uff0c\u4e0d\u5141\u8bb8\u5728\u975e\u521b\u5efa\u7ec4\u7ec7\u8fdb\u884c\u7248\u672c\u5316\u3002", (String)"AccountViewSaveValidator_154", (String)"fi-bd-opplugin", (Object[])new Object[0]);
            }
            Map<Long, Set<Long>> excAcctidOrgIds = AccountOpContext.getContext().getExcAcctidOrgIds();
            Set<Long> excOrgIds = excAcctidOrgIds.get(id);
            if (0 != AccountVersionUtil.compareDate((Date)account.getDate("enddate"), (Date)AccountVersionUtil.getEndDate()) || excOrgIds != null && excOrgIds.contains(useorgId)) {
                if (DebugTrace.enable()) {
                    LOGGER.info(String.format("check_account_version: accountEndDate: %s, excOrgIds: %s, useOrgId: %s, full data: %s", DateUtils.formatString((Date)account.getDate("enddate"), (String)"yyyy-MM-dd HH:mm:ss"), excOrgIds == null ? "null" : String.join((CharSequence)",", excOrgIds.stream().map(x -> String.valueOf(x)).collect(Collectors.toList())), useorgId, account.toString()));
                }
                return ResManager.loadKDString((String)"\u79d1\u76ee\u4e0d\u662f\u6700\u65b0\u7248\u672c\u79d1\u76ee\uff0c\u65e0\u6cd5\u4fee\u6539\uff0c\u8bf7\u5237\u65b0\u79d1\u76ee\u5217\u8868\u4e4b\u540e\uff0c\u518d\u4fee\u6539\u79d1\u76ee\u3002", (String)"AccountViewSaveValidator_153", (String)"fi-bd-opplugin", (Object[])new Object[0]);
            }
            Date dbStartDate = acctInDB.getDate("startdate");
            Date startDate = account.getDate("startdate");
            if (startDate.before(dbStartDate)) {
                return ResManager.loadKDString((String)"\u5f53\u524d\u79d1\u76ee\u5728\u540e\u7eed\u671f\u95f4\u5df2\u7ecf\u8fdb\u884c\u8fc7\u7248\u672c\u5316\uff0c\u65e0\u6cd5\u5728\u5386\u53f2\u671f\u95f4\u7248\u672c\u5316\u3002", (String)"AccountViewSaveValidator_68", (String)"fi-bd-opplugin", (Object[])new Object[0]);
            }
            if (BizHappenUtils.existsOnOrgDomain((long)account.getLong("masterid"), (long)useorgId, (Date)startDate)) {
                if (((Boolean)AccountSaveParam.isAssistItemAdd((DynamicObject)acctInDB, (DynamicObject)account).item1).booleanValue() || this.isAssistItemChange(acctInDB, account, false)) {
                    return String.format(ResManager.loadKDString((String)"%s\u79d1\u76ee\u5728\u5f53\u524d\u65e5\u671f\u6240\u5c5e\u671f\u95f4\u53ca\u4ee5\u540e\u671f\u95f4\u6709\u51ed\u8bc1\u6216\u4f59\u989d\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u7ef4\u5ea6\uff0c\u8bf7\u5148\u5220\u9664\u51ed\u8bc1\u3002", (String)"AccountViewSaveValidator_71", (String)"fi-bd-opplugin", (Object[])new Object[0]), account.getString("number"));
                }
                if (isNameChanged) {
                    return String.format(ResManager.loadKDString((String)"%s\u79d1\u76ee\u5728\u5f53\u524d\u65e5\u671f\u6240\u5c5e\u7684\u671f\u95f4\u53ca\u4ee5\u540e\u671f\u95f4\u6709\u51ed\u8bc1\u6216\u4f59\u989d\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u540d\u79f0\uff0c\u8bf7\u5148\u5220\u9664\u51ed\u8bc1\u3002", (String)"AccountViewSaveValidator_72", (String)"fi-bd-opplugin", (Object[])new Object[0]), account.getString("number"));
                }
            }
        }
        boolean isNewAcceck = account.getBoolean("accheck");
        boolean isOldAcceck = acctInDB.getBoolean("accheck");
        if (isNewAcceck && isOldAcceck) {
            boolean businessHappen;
            boolean bl = businessHappen = AccountVersionUtil.isAccountVersionalized((DynamicObject)acctInDB) && acctInDB.getBoolean("isleaf");
            if (!businessHappen) {
                businessHappen = this.checkAcCheck(account, useorgId);
            }
            if (businessHappen) {
                Set<String> newAcceckFields = this.getAcceckFlexFields(account);
                Set<String> oldAcceckFields = this.getAcceckFlexFields(acctInDB);
                boolean isAccFieldChanged = false;
                if (newAcceckFields.size() != oldAcceckFields.size()) {
                    isAccFieldChanged = true;
                } else {
                    for (String newAcceckField : newAcceckFields) {
                        if (oldAcceckFields.contains(newAcceckField)) continue;
                        isAccFieldChanged = true;
                        break;
                    }
                }
                if (isAccFieldChanged) {
                    return String.format(ResManager.loadKDString((String)"%s\u79d1\u76ee\u53ea\u5141\u8bb8\u53d8\u66f4\u4e3a\u975e\u5f80\u6765\u79d1\u76ee\uff0c\u4e0d\u5141\u8bb8\u90e8\u5206\u589e\u52a0\u6216\u51cf\u5c11\u5f80\u6765\u6838\u7b97\u7ef4\u5ea6\u3002", (String)"AccountViewSaveValidator_90", (String)"fi-bd-opplugin", (Object[])new Object[0]), account.getString("number"));
                }
            }
        }
        if (isNewAcceck && !isOldAcceck && QueryServiceHelper.exists((String)"bd_accountview", (QFilter[])new QFilter[]{new QFilter("masterid", "=", acctInDB.get("masterid")), new QFilter("createorg", "=", (Object)useorgId), new QFilter("accheck", "=", (Object)true), new QFilter("startdate", "<", acctInDB.get("startdate"))}) && BizHappenUtils.existsOnOrgDomain((long)account.getLong("masterid"), (long)useorgId, (Date)acctInDB.getDate("startdate"))) {
            return ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u79d1\u76ee\u505a\u8d26\u4e4b\u540e\uff0c\u5c06\u5f80\u6765\u5c5e\u6027\u6539\u4e3a\u975e\u5f80\u6765\u518d\u6539\u4e3a\u5f80\u6765\u3002", (String)"AccountViewSaveValidator_96", (String)"fi-bd-opplugin", (Object[])new Object[0]);
        }
        return errorMesg;
    }

    private boolean checkAcCheck(DynamicObject account, long useorgId) {
        AccountOpContext ctx = AccountOpContext.getContext();
        DynamicObject dbObj = ctx.getDbDyos().get(account.getPkValue());
        String accountNumber = dbObj.getString("number");
        Set childOrgIds = BDUtil.getAllChildrenOrgIds((long)useorgId, (boolean)true);
        QFilter accFilter = new QFilter("accounttable", "=", account.get("accounttable_id")).and("number", "like", (Object)(accountNumber + "%")).and("isleaf", "=", (Object)Boolean.TRUE);
        Set acctIds = AccountVersionUtil.queryAllAccIdsByUseOrgs((Collection)childOrgIds, (boolean)true, (QFilter)accFilter);
        return BizHappenUtils.batchExist((Set)acctIds, (Set)childOrgIds);
    }

    private String checkControlField(long useorgId, DynamicObject account, DynamicObject acctInDB, boolean isNameChanged, boolean isExistsOnOrgDomain) {
        boolean isVersion;
        boolean isRealVerOfCurrOp;
        boolean isAddAllAssgrps = this.getOption().containsVariable("isAddAllAssgrps");
        boolean isUpdateQTY = acctInDB.getBoolean("isqty") != account.getBoolean("isqty");
        boolean isAssistItem = this.isAssistItemChange(acctInDB, account, true);
        if (isAddAllAssgrps || isNameChanged || isUpdateQTY || isAssistItem) {
            if (!account.getBoolean("isleaf") && isNameChanged) {
                return ResManager.loadKDString((String)"\u5f53\u524d\u7248\u672c\uff0c\u975e\u660e\u7ec6\u79d1\u76ee\u4e0d\u80fd\u4fee\u6539\u540d\u79f0\u3002", (String)"AccountViewSaveValidator_159", (String)"fi-bd-opplugin", (Object[])new Object[0]);
            }
            if (this.isSubOrgAcctVersion(account) && isNameChanged) {
                return ResManager.loadKDString((String)"\u4e0b\u7ea7\u7ec4\u7ec7\u8be5\u79d1\u76ee\u5df2\u505a\u8fc7\u7248\u672c\u5316\uff0c\u8be5\u79d1\u76ee\u4e0d\u80fd\u4fee\u6539\u540d\u79f0\u3002", (String)"AccountViewSaveValidator_113", (String)"fi-bd-opplugin", (Object[])new Object[0]);
            }
            if (BizHappenUtils.existsOnOrgDomain((long)account.getLong("masterid"), (long)useorgId, (Date)account.getDate("startdate"))) {
                if (isAddAllAssgrps) {
                    return ResManager.loadKDString((String)"\u79d1\u76ee\u5f53\u524d\u671f\u95f4\u6216\u4ee5\u540e\u671f\u95f4\u5df2\u6709\u4e1a\u52a1\u53d1\u751f\uff0c\u4e0d\u80fd\u65b0\u589e\u6838\u7b97\u7ef4\u5ea6\u3002", (String)"AccountViewSaveValidator_116", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                }
                if (isNameChanged) {
                    return ResManager.loadKDString((String)"\u79d1\u76ee\u5f53\u524d\u671f\u95f4\u6216\u4ee5\u540e\u671f\u95f4\u5df2\u6709\u4e1a\u52a1\u53d1\u751f\uff0c\u4e0d\u80fd\u4fee\u6539\u540d\u79f0\u3002", (String)"AccountViewSaveValidator_117", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                }
                if (isUpdateQTY) {
                    return ResManager.loadKDString((String)"\u79d1\u76ee\u5f53\u524d\u671f\u95f4\u6216\u4ee5\u540e\u671f\u95f4\u5df2\u6709\u4e1a\u52a1\u53d1\u751f\uff0c\u4e0d\u80fd\u4fee\u6539\u6570\u91cf\u6838\u7b97\u3002", (String)"AccountViewSaveValidator_118", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                }
                if (isAssistItem) {
                    return ResManager.loadKDString((String)"\u79d1\u76ee\u5f53\u524d\u671f\u95f4\u6216\u4ee5\u540e\u671f\u95f4\u5df2\u6709\u4e1a\u52a1\u53d1\u751f\uff0c\u4e0d\u80fd\u4fee\u6539\u5f80\u6765\u6838\u7b97\u6216\u6838\u7b97\u7ef4\u5ea6\u5fc5\u5f55\u6027\u3002", (String)"AccountViewSaveValidator_119", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                }
            }
        }
        if (!isExistsOnOrgDomain) {
            isExistsOnOrgDomain = BizHappenUtils.existsOnOrgDomain((long)account.getLong("masterid"), (long)useorgId, null);
        }
        boolean bl = isRealVerOfCurrOp = (isVersion = this.getOption().containsVariable("isversion")) && isExistsOnOrgDomain;
        if (!isRealVerOfCurrOp && !account.getBoolean("isleaf")) {
            return "";
        }
        boolean accountPropEqual = AccountVersionControlChecker.compareAccountEntryIsEqual((DynamicObject)account, (DynamicObject)acctInDB, (boolean)true);
        if (!accountPropEqual && AccountTableRefUtils.checkAccountTableReference((DynamicObject)account, (boolean)isRealVerOfCurrOp, (long)account.getLong("id"))) {
            if (isRealVerOfCurrOp) {
                return String.format(ResManager.loadKDString((String)"%s\u79d1\u76ee\u5df2\u88ab\u79d1\u76ee\u8868\u7248\u672c\u5316\u4e2d\u7684\u5bf9\u7167\u4fe1\u606f\u5f15\u7528\uff0c\u8bf7\u5148\u5220\u9664\u5bf9\u7167\u4fe1\u606f\u540e\u518d\u8fdb\u884c\u7248\u672c\u5316\u3002", (String)"AccountViewSaveValidator_178", (String)"fi-bd-opplugin", (Object[])new Object[0]), account.getString("number"));
            }
            return String.format(ResManager.loadKDString((String)"%s\u79d1\u76ee\u5df2\u88ab\u79d1\u76ee\u8868\u7248\u672c\u5316\u4e2d\u7684\u5bf9\u7167\u4fe1\u606f\u5f15\u7528\uff0c\u8bf7\u5148\u5220\u9664\u5bf9\u7167\u4fe1\u606f\u540e\u518d\u4fee\u6539\u3002", (String)"AccountViewSaveValidator_176", (String)"fi-bd-opplugin", (Object[])new Object[0]), account.getString("number"));
        }
        return "";
    }

    private Set<String> getAcceckFlexFields(DynamicObject account) {
        HashSet<String> acceckFields = new HashSet<String>(8);
        DynamicObjectCollection assistEntry = account.getDynamicObjectCollection("checkitementry");
        for (DynamicObject assist : assistEntry) {
            DynamicObject asstItem;
            if (!assist.getBoolean("enaccheck") || (asstItem = assist.getDynamicObject("asstactitem")) == null) continue;
            acceckFields.add(asstItem.getString("flexfield"));
        }
        return acceckFields;
    }

    private Map<Long, Map<Long, Map<String, DynamicObject>>> getPrepareData() {
        DynamicObject[] accts;
        HashMap<Long, Map<Long, Map<String, DynamicObject>>> acctIdsMap = new HashMap<Long, Map<Long, Map<String, DynamicObject>>>();
        HashSet<String> numSet = new HashSet<String>();
        for (ExtendedDataEntity entity : this.dataEntities) {
            DynamicObject account = entity.getDataEntity();
            if (!account.getDataEntityState().getFromDatabase()) continue;
            long accounttableId = account.getLong(Account.getDotId((String)"accounttable"));
            String longnumber = account.getString("longnumber");
            String rootNumber = longnumber.split("_")[0];
            numSet.add(rootNumber);
            HashMap acctIdsMapOfTable = (HashMap)acctIdsMap.get(accounttableId);
            if (acctIdsMapOfTable != null) continue;
            acctIdsMapOfTable = new HashMap();
            acctIdsMap.put(accounttableId, acctIdsMapOfTable);
        }
        QFilter qtable = new QFilter("accounttable", "in", acctIdsMap.keySet());
        QFilter qlongnumber = null;
        for (String lnum : numSet) {
            if (qlongnumber == null) {
                qlongnumber = new QFilter("longnumber", "like", (Object)(lnum + "%"));
                continue;
            }
            qlongnumber = qlongnumber.or(new QFilter("longnumber", "like", (Object)(lnum + "%")));
        }
        QFilter qdate = new QFilter("enddate", "=", (Object)AccountVersionUtil.getEndDate());
        List acctIds = QueryServiceHelper.queryPrimaryKeys((String)"bd_accountview", (QFilter[])new QFilter[]{qtable, qlongnumber, qdate}, (String)"longnumber asc", (int)-1);
        for (DynamicObject acct : accts = BusinessDataServiceHelper.load((Object[])acctIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountview"))) {
            HashMap<String, DynamicObject> acctIdsMapOfOrg;
            long accounttableId = acct.getLong("accounttable_id");
            long createorgId = acct.getLong("createorg_id");
            String longnumber = acct.getString("longnumber");
            HashMap<Long, HashMap<String, DynamicObject>> acctIdsMapOfTable = (HashMap<Long, HashMap<String, DynamicObject>>)acctIdsMap.get(accounttableId);
            if (acctIdsMapOfTable == null) {
                acctIdsMapOfTable = new HashMap<Long, HashMap<String, DynamicObject>>();
                acctIdsMap.put(accounttableId, acctIdsMapOfTable);
            }
            if ((acctIdsMapOfOrg = (HashMap<String, DynamicObject>)acctIdsMapOfTable.get(createorgId)) == null) {
                acctIdsMapOfOrg = new HashMap<String, DynamicObject>();
                acctIdsMapOfTable.put(createorgId, acctIdsMapOfOrg);
            }
            acctIdsMapOfOrg.put(longnumber, acct);
        }
        return acctIdsMap;
    }

    private String checkTableTypeChange(DynamicObject account, DynamicObject accountDB) {
        long typeIdDB;
        long tableIdDB;
        long tableId = account.getLong("accounttable_id");
        if (tableId != (tableIdDB = accountDB.getLong("accounttable_id"))) {
            return ResManager.loadKDString((String)"\u4e0d\u80fd\u4fee\u6539\u79d1\u76ee\u8868\u3002", (String)"AccountViewSaveValidator_75", (String)"fi-bd-opplugin", (Object[])new Object[0]);
        }
        long typeId = account.getLong("accounttype_id");
        if (typeId != (typeIdDB = accountDB.getLong("accounttype_id"))) {
            return ResManager.loadKDString((String)"\u4e0d\u80fd\u4fee\u6539\u79d1\u76ee\u7c7b\u578b\u3002", (String)"AccountViewSaveValidator_76", (String)"fi-bd-opplugin", (Object[])new Object[0]);
        }
        return "";
    }

    private DynamicObject getAcctInDB(DynamicObject account, Map<Long, Map<Long, Map<String, DynamicObject>>> acctIdsMap) {
        Map<String, DynamicObject> acctIdsMapOfOrg;
        long createorgId = account.getLong("createorg_id");
        String longnumber = account.getString("longnumber");
        long accounttableId = account.getLong("accounttable_id");
        DynamicObject acctInDB = null;
        Map<Long, Map<String, DynamicObject>> acctIdsMapOfTable = acctIdsMap.get(accounttableId);
        if (acctIdsMapOfTable != null && (acctIdsMapOfOrg = acctIdsMapOfTable.get(createorgId)) != null) {
            acctInDB = acctIdsMapOfOrg.get(longnumber);
        }
        if (acctInDB == null || account.getDate("enddate").compareTo(AccountVersionUtil.getEndDate()) != 0) {
            acctInDB = BusinessDataServiceHelper.loadSingle((Object)account.get("id"), (String)"bd_accountview");
        }
        return acctInDB;
    }

    private String checkPorgProperties(long useorgId, DynamicObject account, DynamicObject acctInDB) {
        boolean isFromRepairOrAssignOp = AccountVersionOpVars.isFromRepairOrAssignView((OperateOption)this.getOption());
        AccountOpContext ctx = AccountOpContext.getContext();
        Long porgId = ctx.getOrgPorgs().get(account.getLong("useorg_id"));
        Map<Long, Map<Long, Map<String, Set<DynamicObject>>>> tableOrgPAccts = AccountOpContext.getContext().getTableOrgPAccts();
        Map<Long, Map<String, Set<DynamicObject>>> orgPaccts = tableOrgPAccts.get(account.getLong("accounttable_id"));
        Map<String, Set<DynamicObject>> allpaccts = orgPaccts.get(porgId);
        Set<DynamicObject> paccts = allpaccts.get(account.getString("number"));
        StringBuilder result1 = new StringBuilder();
        for (DynamicObject pacct : paccts) {
            if (useorgId == pacct.getLong("createorg_id")) continue;
            for (int i = 0; i < fieldKeys.length; ++i) {
                if (isFromRepairOrAssignOp && !fieldKeys[i].equals("bw")) continue;
                boolean field = account.getBoolean(fieldKeys[i]);
                boolean dbField = acctInDB.getBoolean(fieldKeys[i]);
                boolean pField = pacct.getBoolean(fieldKeys[i]);
                if (field == dbField || !pField || field) continue;
                result1.append(String.format(ResManager.loadKDString((String)"\u5f53\u4e0a\u7ea7\u7ec4\u7ec7%1$s\u7684%2$s\u79d1\u76ee\u7684%3$s\u5c5e\u6027\u52fe\u9009\u65f6\uff0c\u4e0b\u7ea7\u79d1\u76ee\u4e0d\u5141\u8bb8\u53d6\u6d88\u52fe\u9009\u3002", (String)"AccountViewSaveValidator_77", (String)"fi-bd-opplugin", (Object[])new Object[0]), ctx.getOrgNum(porgId), pacct.getString("number"), fieldNames[i]));
                result1.append("\n");
            }
            String accrualdirection = account.getString("accrualdirection");
            String subaccrualdirection = pacct.getString("accrualdirection");
            if ("nocontrol".equals(subaccrualdirection) || !"nocontrol".equals(accrualdirection) || isFromRepairOrAssignOp) continue;
            result1.append(String.format(ResManager.loadKDString((String)"\u5f53\u4e0a\u7ea7\u7ec4\u7ec7%1$s\u7684%2$s\u79d1\u76ee\u7684\u5f55\u5165\u65b9\u5411\u4e3a\u63a7\u5236\u65f6\uff0c\u4e0b\u7ea7\u79d1\u76ee\u4e0d\u5141\u8bb8\u6539\u4e3a\u4e0d\u63a7\u5236\u3002", (String)"AccountViewSaveValidator_114", (String)"fi-bd-opplugin", (Object[])new Object[0]), ctx.getOrgNum(porgId), pacct.getString("number"))).append("\n");
        }
        return result1.length() == 0 ? "" : result1.substring(0, result1.length() - 2);
    }

    private String checkChildorgProperties(DynamicObject account, DynamicObject acctInDB) {
        AccountOpContext ctx = AccountOpContext.getContext();
        Map<String, Set<DynamicObject>> allSubAccts = ctx.getTableOrgSubAccts().get(account.getLong("accounttable_id")).get(account.getLong("useorg_id"));
        StringBuilder result = new StringBuilder();
        for (DynamicObject subAcct : allSubAccts.get(account.getString("number"))) {
            for (int i = 0; i < fieldKeys.length; ++i) {
                if (AccountVersionOpVars.isFromRepairOrAssignView((OperateOption)this.getOption()) && !fieldKeys[i].equals("bw")) continue;
                boolean field = account.getBoolean(fieldKeys[i]);
                boolean dbField = acctInDB.getBoolean(fieldKeys[i]);
                if (!field || dbField || subAcct.getBoolean(fieldKeys[i])) continue;
                result.append(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%1$s\u7684%2$s\u79d1\u76ee\u7684%3$s\u5c5e\u6027\u672a\u52fe\u9009\u65f6\uff0c\u8be5\u79d1\u76ee\u4e0d\u53ef\u4ee5\u52fe\u9009\u3002", (String)"AccountViewSaveValidator_115", (String)"fi-bd-opplugin", (Object[])new Object[0]), ctx.getOrgNumAndName(subAcct.getLong("createorg_id")), subAcct.getString("number"), fieldNames[i]));
            }
        }
        return result.length() == 0 ? "" : result.toString();
    }

    private String checkSubAccts(DynamicObject account, long useorgId, Map<Long, List<Object>> subOrgMap, Map<Long, Map<Long, Map<String, DynamicObject>>> acctIdsMap) {
        boolean isAddAllAssgrps = this.getOption().containsVariable("isAddAllAssgrps");
        QFilter qtable = new QFilter("accounttable", "=", account.get("accounttable_id"));
        QFilter qnumber = new QFilter("number", "=", account.get("number"));
        QFilter qlongnumber = new QFilter("longnumber", "like", (Object)(account.getString("longnumber") + "_%")).and(new QFilter("level", "!=", account.get("level")));
        QFilter qall = qnumber.or(qlongnumber);
        QFilter qdate = new QFilter("enddate", "=", (Object)AccountVersionUtil.getEndDate());
        if (useorgId == OrgUnitServiceHelper.getRootOrgId()) {
            DynamicObject[] curSubAccts;
            List ids = QueryServiceHelper.queryPrimaryKeys((String)"bd_accountview", (QFilter[])new QFilter[]{qtable, qall, qdate}, null, (int)-1);
            for (DynamicObject subAcct : curSubAccts = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountview"))) {
                String checkResult = this.checkItems(subAcct, useorgId, account, 0L, ITEMCHECK_SUB, 0L, isAddAllAssgrps);
                if (!StringUtils.isEmpty((CharSequence)checkResult)) {
                    return checkResult;
                }
                checkResult = this.checkCurrency(subAcct, useorgId, account, 0L);
                if (StringUtils.isEmpty((CharSequence)checkResult)) continue;
                return checkResult;
            }
        } else {
            String ctrlstrategy = account.getString("ctrlstrategy");
            List subOrgIds = subOrgMap.get(useorgId);
            if (subOrgIds == null) {
                subOrgIds = AccountVersionUtil.getObjAssignSubOrgIds((Object)account.getPkValue(), (Object)useorgId, (String)ctrlstrategy, (useorgId == account.getLong("createorg_id") ? 1 : 0) != 0, (boolean)true);
                subOrgMap.put(useorgId, subOrgIds);
            }
            for (Object subOrgId : subOrgIds) {
                DynamicObject[] curSubAccts;
                QFilter qids = AccountUtils.getBaseDataFilter((long)Long.parseLong(String.valueOf(subOrgId)));
                List ids = QueryServiceHelper.queryPrimaryKeys((String)"bd_accountview", (QFilter[])new QFilter[]{qids, qtable, qall, qdate}, null, (int)-1);
                for (DynamicObject subAcct : curSubAccts = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountview"))) {
                    String checkResult = this.checkItems(subAcct, useorgId, account, Long.parseLong(String.valueOf(subOrgId)), ITEMCHECK_SUB, Long.parseLong(String.valueOf(subOrgId)), isAddAllAssgrps);
                    if (!StringUtils.isEmpty((CharSequence)checkResult)) {
                        return checkResult;
                    }
                    checkResult = this.checkCurrency(subAcct, useorgId, account, Long.parseLong(String.valueOf(subOrgId)));
                    if (StringUtils.isEmpty((CharSequence)checkResult)) continue;
                    return checkResult;
                }
            }
        }
        return "";
    }

    private String checkCurrency(DynamicObject subAcct, long useorgId, DynamicObject account, long subOrgId) {
        if (useorgId == account.getLong("createorg_id") && subAcct.getLong("id") == account.getLong("id")) {
            return "";
        }
        if (useorgId == subOrgId && subAcct.getString("number").equals(account.get("number"))) {
            return "";
        }
        String acctcurrency = account.getString("acctcurrency");
        String subacctcurrency = subAcct.getString("acctcurrency");
        if (account.getLong("id") != subAcct.getLong("id") && (Integer)Account.getCurtypevals().get(acctcurrency) < (Integer)Account.getCurtypevals().get(subacctcurrency)) {
            return ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7\u548c\u4e0a\u7ea7\u79d1\u76ee\u7684\u5e01\u79cd\u6838\u7b97\u7c7b\u578b\u5e94\u8be5\u5305\u542b\u4e0b\u7ea7\u7ec4\u7ec7\u548c\u4e0b\u7ea7\u79d1\u76ee\u3002", (String)"AccountViewSaveValidator_99", (String)"fi-bd-opplugin", (Object[])new Object[0]);
        }
        if ("descurrency".equals(acctcurrency) && "descurrency".equals(subacctcurrency)) {
            List acctcurIds = BDUtil.getKeyFieldIdsInEntry((DynamicObjectCollection)account.getDynamicObjectCollection("currencyentry"), (String)"currency");
            List subacctcurIds = BDUtil.getKeyFieldIdsInEntry((DynamicObjectCollection)subAcct.getDynamicObjectCollection("currencyentry"), (String)"currency");
            for (Long subCurId : subacctcurIds) {
                if (acctcurIds.contains(subCurId)) continue;
                return ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7\u548c\u4e0a\u7ea7\u79d1\u76ee\u6838\u7b97\u7684\u5e01\u79cd\u79cd\u7c7b\u5e94\u8be5\u5927\u4e8e\u7b49\u4e8e\u4e0b\u7ea7\u7ec4\u7ec7\u548c\u4e0b\u7ea7\u79d1\u76ee\u6307\u5b9a\u7684\u6838\u7b97\u5e01\u79cd\u79cd\u7c7b\u3002", (String)"AccountViewSaveValidator_156", (String)"fi-bd-opplugin", (Object[])new Object[0]);
            }
        }
        return "";
    }

    private String checkItems(DynamicObject subAcct, long useorgId, DynamicObject account, long subOrgId, String checkdirection, long acctorgId, boolean isAddAllAssgrps) {
        String result = "";
        if (AccountVersionOpVars.isFromRepairOrAssignView((OperateOption)this.getOption())) {
            return result;
        }
        if (useorgId == account.getLong("createorg_id") && subAcct.getLong("id") == account.getLong("id")) {
            return result;
        }
        if (useorgId == subOrgId && subAcct.getString("number").equals(account.get("number"))) {
            return result;
        }
        if (((Boolean)AccountSaveParam.isAssistItemAdd((DynamicObject)subAcct, (DynamicObject)account).item1).booleanValue() && !isAddAllAssgrps) {
            DynamicObject assp = (DynamicObject)AccountSaveParam.isAssistItemAdd((DynamicObject)subAcct, (DynamicObject)account).item2;
            String title = assp.getString("name") + "";
            result = checkdirection.equals(ITEMCHECK_SUB) ? String.format(ResManager.loadKDString((String)"\u975e\u660e\u7ec6\u79d1\u76ee\u589e\u52a0\u6838\u7b97\u7ef4\u5ea6'%s'\u65f6\uff0c\u9700\u8981\u4e0b\u7ea7\u79d1\u76ee\u548c\u4e0b\u7ea7\u7ec4\u7ec7\u540c\u4e00\u79d1\u76ee\u90fd\u589e\u52a0\u4e0a\u8be5\u6838\u7b97\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u4e0b\u7ea7\u79d1\u76ee\u6216\u8005\u4e0b\u7ea7\u7ec4\u7ec7\u7684\u662f\u5426\u6709\u8be5\u7ef4\u5ea6\u3002", (String)"AccountViewSaveValidator_151", (String)"fi-bd-opplugin", (Object[])new Object[0]), title) : String.format(ResManager.loadKDString((String)"\u5f53\u524d\u79d1\u76ee\u7684\u6838\u7b97\u7ef4\u5ea6\uff0c\u5e94\u8be5\u5305\u542b\u4e0a\u7ea7\u79d1\u76ee\u548c\u4e0a\u7ea7\u7ec4\u7ec7\u7684\u6838\u7b97\u7ef4\u5ea6\u3002\u4e0a\u7ea7\u7ec4\u7ec7\u540c\u4e00\u79d1\u76ee\u6709'%s'\u6838\u7b97\u7ef4\u5ea6\uff0c\u5f53\u524d\u7ec4\u7ec7\u79d1\u76ee\u4e5f\u5fc5\u987b\u5305\u542b\u8be5\u7ef4\u5ea6\u3002", (String)"AccountViewSaveValidator_120", (String)"fi-bd-opplugin", (Object[])new Object[0]), title);
        }
        Map<Long, Map<String, Object>> itemInfos = this.getEntryItemInfos(account);
        Map<Long, Map<String, Object>> subAcctitemInfos = this.getEntryItemInfos(subAcct);
        block0: for (Map.Entry<Long, Map<String, Object>> entry : subAcctitemInfos.entrySet()) {
            long itemid = entry.getKey();
            Map<String, Object> subItemInfo = entry.getValue();
            Map<String, Object> itemInfo = itemInfos.get(itemid);
            if (itemInfo == null) continue;
            for (String field : entryFields) {
                if (((Boolean)subItemInfo.get(field)).booleanValue() || !((Boolean)itemInfo.get(field)).booleanValue()) continue;
                String title = String.valueOf(subItemInfo.get("itemname")) + "(" + subItemInfo.get("itemnum") + ")";
                if (field.equals("isrequire")) {
                    result = checkdirection.equals(ITEMCHECK_SUB) ? String.format(ResManager.loadKDString((String)"\u4e0b\u7ea7\u7ec4\u7ec7\u548c\u4e0b\u7ea7\u79d1\u76ee\u7684%s\u6838\u7b97\u7ef4\u5ea6\u8bbe\u7f6e\u4e3a\u975e\u5fc5\u5f55\u65f6\uff0c\u4e0a\u7ea7\u7ec4\u7ec7\u548c\u4e0a\u7ea7\u79d1\u76ee\u4e0d\u80fd\u6539\u4e3a\u5fc5\u5f55\u3002", (String)"AccountViewSaveValidator_80", (String)"fi-bd-opplugin", (Object[])new Object[0]), title) : String.format(ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7\u548c\u4e0a\u7ea7\u79d1\u76ee\u7684%s\u6838\u7b97\u7ef4\u5ea6\u8bbe\u7f6e\u4e3a\u5fc5\u5f55\u65f6\uff0c\u4e0b\u7ea7\u7ec4\u7ec7\u548c\u4e0b\u7ea7\u79d1\u76ee\u4e0d\u80fd\u6539\u4e3a\u975e\u5fc5\u5f55\u3002", (String)"AccountViewSaveValidator_101", (String)"fi-bd-opplugin", (Object[])new Object[0]), title);
                    continue block0;
                }
                if (field.equals("isdetail")) {
                    result = checkdirection.equals(ITEMCHECK_SUB) ? String.format(ResManager.loadKDString((String)"\u4e0b\u7ea7\u7ec4\u7ec7\u548c\u4e0b\u7ea7\u79d1\u76ee\u7684%s\u6838\u7b97\u7ef4\u5ea6\u8bbe\u7f6e\u4e3a\u975e\u660e\u7ec6\u65f6\uff0c\u4e0a\u7ea7\u7ec4\u7ec7\u548c\u4e0a\u7ea7\u79d1\u76ee\u4e0d\u80fd\u6539\u4e3a\u660e\u7ec6\u3002", (String)"AccountViewSaveValidator_126", (String)"fi-bd-opplugin", (Object[])new Object[0]), title) : String.format(ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7\u548c\u4e0a\u7ea7\u79d1\u76ee\u7684%s\u6838\u7b97\u7ef4\u5ea6\u8bbe\u7f6e\u4e3a\u660e\u7ec6\u65f6\uff0c\u4e0b\u7ea7\u7ec4\u7ec7\u548c\u4e0b\u7ea7\u79d1\u76ee\u4e0d\u80fd\u6539\u4e3a\u975e\u660e\u7ec6\u3002", (String)"AccountViewSaveValidator_102", (String)"fi-bd-opplugin", (Object[])new Object[0]), title);
                    continue block0;
                }
                if (!field.equals("enaccheck")) continue;
                result = checkdirection.equals(ITEMCHECK_SUB) ? String.format(ResManager.loadKDString((String)"\u4e0b\u7ea7\u7ec4\u7ec7\u548c\u4e0b\u7ea7\u79d1\u76ee\u7684%s\u6838\u7b97\u7ef4\u5ea6\u8bbe\u7f6e\u4e3a\u975e\u5f80\u6765\u65f6\uff0c\u4e0a\u7ea7\u7ec4\u7ec7\u548c\u4e0a\u7ea7\u79d1\u76ee\u4e0d\u80fd\u6539\u4e3a\u5f80\u6765\u3002", (String)"AccountViewSaveValidator_125", (String)"fi-bd-opplugin", (Object[])new Object[0]), title) : String.format(ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7\u548c\u4e0a\u7ea7\u79d1\u76ee\u7684%s\u6838\u7b97\u7ef4\u5ea6\u8bbe\u7f6e\u4e3a\u5f80\u6765\u65f6\uff0c\u4e0b\u7ea7\u7ec4\u7ec7\u548c\u4e0b\u7ea7\u79d1\u76ee\u4e0d\u80fd\u6539\u4e3a\u975e\u5f80\u6765\u3002", (String)"AccountViewSaveValidator_103", (String)"fi-bd-opplugin", (Object[])new Object[0]), title);
                continue block0;
            }
        }
        if (result.length() != 0) {
            result = result + (checkdirection.equals(ITEMCHECK_SUB) ? String.format(ResManager.loadKDString((String)"\u68c0\u9a8c\u5931\u8d25\u7684\u79d1\u76ee\u7f16\u7801\uff1a%1$s\uff0c\u7ec4\u7ec7\u7f16\u7801\u662f\uff1a%2$s\u3002", (String)"AccountViewSaveValidator_105", (String)"fi-bd-opplugin", (Object[])new Object[0]), subAcct.getString("number"), acctorgId == 0L ? subAcct.getDynamicObject("org").getString("number") : AccountOpContext.getContext().getOrgNum(acctorgId)) : String.format(ResManager.loadKDString((String)"\u68c0\u9a8c\u5931\u8d25\u7684\u79d1\u76ee\u7f16\u7801\uff1a%1$s\uff0c\u7ec4\u7ec7\u7f16\u7801\u662f\uff1a%2$s\u3002", (String)"AccountViewSaveValidator_105", (String)"fi-bd-opplugin", (Object[])new Object[0]), account.getString("number"), acctorgId == 0L ? account.getDynamicObject("org").getString("number") : AccountOpContext.getContext().getOrgNum(acctorgId)));
        }
        return result;
    }

    private String checkParentAccts(DynamicObject account, long useorgId) {
        boolean isAddAllAssgrps = this.getOption().containsVariable("isAddAllAssgrps");
        HashSet pitems = new HashSet();
        DynamicObject parentAcctCurOrg = account.getDynamicObject("parent");
        if (parentAcctCurOrg != null) {
            pitems.addAll(BDUtil.getKeyFieldIdsInEntry((DynamicObjectCollection)parentAcctCurOrg.getDynamicObjectCollection("checkitementry"), (String)"asstactitem"));
        }
        Set<DynamicObject> pacctsPorgs = AccountOpContext.getContext().getTableOrgPAccts().get(account.getLong("accounttable_id")).get(AccountOpContext.getContext().getOrgPorgs().get(account.getLong("useorg_id"))).get(account.getString("number"));
        for (DynamicObject pacct : pacctsPorgs) {
            String checkResult = this.checkItems(account, useorgId, pacct, 0L, ITEMCHECK_PAR, AccountOpContext.getContext().getOrgPorgs().get(account.getLong("useorg_id")), isAddAllAssgrps);
            if (StringUtils.isEmpty((CharSequence)checkResult)) continue;
            return checkResult;
        }
        return "";
    }

    private String checkLeafAcctOfBizUnitBussinessHappen(DynamicObject account, DynamicObject acctInDB, long useorgId) {
        boolean isLeaf = account.getBoolean("isleaf");
        boolean isversion = this.getOption().containsVariable("isversion");
        long accountId = (Long)account.getPkValue();
        boolean iscash = account.getBoolean("iscash");
        boolean isbank = account.getBoolean("isbank");
        boolean iscashequivalent = account.getBoolean("iscashequivalent");
        boolean DBiscash = acctInDB.getBoolean("iscash");
        boolean DBisbank = acctInDB.getBoolean("isbank");
        boolean DBiscashequivalent = acctInDB.getBoolean("iscashequivalent");
        String dc = account.getString("dc");
        String dcInDb = acctInDB.getString("dc");
        boolean acnotice = account.getBoolean("acnotice");
        boolean DBacnotice = acctInDB.getBoolean("acnotice");
        boolean isCashRelateChange = this.isCashRelateChange(iscash, DBiscash, isbank, DBisbank);
        boolean isAssisItemChange = this.isAssistItemChange(acctInDB, account, false);
        boolean isAssistItemAdd = (Boolean)AccountSaveParam.isAssistItemAdd((DynamicObject)acctInDB, (DynamicObject)account).item1;
        if (isCashRelateChange || isAssisItemChange || isAssistItemAdd || !dc.equals(dcInDb) || !acnotice && DBacnotice) {
            if (isCashRelateChange) {
                if (!isLeaf) {
                    return ResManager.loadKDString((String)"\u8be5\u79d1\u76ee\u4e3a\u975e\u660e\u7ec6\u79d1\u76ee\uff0c\u6682\u4e0d\u652f\u6301\u66f4\u6539\u6307\u5b9a\u79d1\u76ee\u5c5e\u6027\uff1a\u73b0\u91d1\u79d1\u76ee\uff0c\u94f6\u884c\u79d1\u76ee\uff0c\u73b0\u91d1\u7b49\u4ef7\u7269\u3002", (String)"AccountviewEdit_11", (String)"fi-bd-formplugin", (Object[])new Object[0]);
                }
                Set assignAcctUseOrgIds = AccountVersionUtil.getAssignAcctUseOrgId((Long)accountId);
                if (!CollectionUtils.isEmpty((Collection)assignAcctUseOrgIds)) {
                    assignAcctUseOrgIds.remove(account.getLong("createorg_id"));
                }
                if (!CollectionUtils.isEmpty((Collection)assignAcctUseOrgIds)) {
                    return ResManager.loadKDString((String)"\u8be5\u79d1\u76ee\u5df2\u5b58\u5728\u5206\u914d\u5173\u7cfb\uff0c\u4e0d\u80fd\u66f4\u6539\u6307\u5b9a\u79d1\u76ee\u5c5e\u6027\uff1a\u73b0\u91d1\u79d1\u76ee\uff0c\u94f6\u884c\u79d1\u76ee\uff0c\u8bf7\u5148\u6267\u884c\u53cd\u5206\u914d\u3002", (String)"AccountViewSaveValidator_183", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                }
            }
            if (useorgId != acctInDB.getLong("createorg_id") && isCashRelateChange) {
                return ResManager.loadKDString((String)"\u53d7\u7ba1\u63a7\u7684\u7ec4\u7ec7\u4e0d\u80fd\u4fee\u6539\u73b0\u91d1\u7c7b\u5c5e\u6027\u3002", (String)"AccountViewSaveValidator_82", (String)"fi-bd-opplugin", (Object[])new Object[0]);
            }
            DynamicObject parent = account.getDynamicObject("parent");
            if (parent != null) {
                boolean parentiscash = parent.getBoolean("iscash");
                boolean parentisbank = parent.getBoolean("isbank");
                boolean parentiscashequivalent = parent.getBoolean("iscashequivalent");
                boolean ischange = this.isCashRelateChange(iscash, parentiscash, isbank, parentisbank);
                if (ischange) {
                    return ResManager.loadKDString((String)"\u4e0b\u7ea7\u79d1\u76ee\u4e0d\u80fd\u4fee\u6539\u73b0\u91d1\u7c7b\u5c5e\u6027\u3002", (String)"AccountViewSaveValidator_83", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                }
            }
            if (isLeaf) {
                long accMasterId = account.getLong("masterid");
                if (BizHappenUtils.existsOnOrgDomain((long)accMasterId, (long)useorgId, null)) {
                    if (isCashRelateChange) {
                        return ResManager.loadKDString((String)"\u5f53\u524d\u79d1\u76ee\u6709\u4e1a\u52a1\u53d1\u751f\uff0c\u6682\u4e0d\u652f\u6301\u66f4\u6539\u6307\u5b9a\u79d1\u76ee\u5c5e\u6027\uff1a\u73b0\u91d1\u79d1\u76ee\uff0c\u94f6\u884c\u79d1\u76ee\uff0c\u73b0\u91d1\u7b49\u4ef7\u7269\u3002", (String)"AccountViewSaveValidator_85", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                    }
                    if ((isAssisItemChange || isAssistItemAdd) && !isversion) {
                        return ResManager.loadKDString((String)"\u5f53\u524d\u79d1\u76ee\u6709\u4e1a\u52a1\u53d1\u751f\uff0c\u8bf7\u901a\u8fc7\u7248\u672c\u5316\u6765\u589e\u52a0\u3001\u5220\u9664\u6838\u7b97\u7ef4\u5ea6\u6216\u8005\u4fee\u6539\u5f80\u6765\u5c5e\u6027\u3002", (String)"AccountViewSaveValidator_86", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                    }
                }
            } else if (isCashRelateChange) {
                QFilter accFilter = new QFilter("accounttable", "=", account.get("accounttable_id")).and("number", "like", (Object)(account.getString("number") + "%")).and("isleaf", "=", (Object)Boolean.TRUE);
                long queryAccIdTick = System.currentTimeMillis();
                Collection childrenOrgIds = BDUtil.buildSubTreeByOrgId(Optional.of(useorgId)).collect(BiTreeNode::getId);
                Set acctIds = AccountVersionUtil.queryAllAccIdsByUseOrgs((Collection)childrenOrgIds, (boolean)true, (QFilter)accFilter);
                LOGGER.info("account_view_save query acc id cost:" + (System.currentTimeMillis() - queryAccIdTick));
                if (!acctIds.isEmpty() && BizHappenUtils.batchExistsOnOrgDomain((Collection)acctIds, (long)useorgId)) {
                    return ResManager.loadKDString((String)"\u5f53\u524d\u79d1\u76ee\u7684\u4e0b\u7ea7\u79d1\u76ee\u6709\u4e1a\u52a1\u53d1\u751f\uff0c\u6682\u4e0d\u652f\u6301\u66f4\u6539\u6307\u5b9a\u79d1\u76ee\u5c5e\u6027\uff1a\u73b0\u91d1\u79d1\u76ee\uff0c\u94f6\u884c\u79d1\u76ee\uff0c\u73b0\u91d1\u7b49\u4ef7\u7269\u3002", (String)"AccountViewSaveValidator_87", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                }
            }
        }
        if (iscash != DBiscash || isbank != DBisbank || iscashequivalent != DBiscashequivalent) {
            HashSet<Long> useOrgIds = new HashSet<Long>(8);
            useOrgIds.add(account.getLong("useorg_id"));
            HashSet<Long> accIds = new HashSet<Long>(8);
            accIds.add(account.getLong("id"));
            Map accountMappingRefMap = AccountTableRefUtils.checkAccountMappingRef((Long)account.getLong("accounttable_id"), useOrgIds, accIds);
            if (!CollectionUtils.isEmpty((Map)accountMappingRefMap)) {
                return String.format(ResManager.loadKDString((String)"\u8be5\u79d1\u76ee\uff08%s\uff09\u5df2\u88ab\u8d26\u7c3f\u534f\u540c\u7684\u79d1\u76ee\u5bf9\u7167\u5173\u7cfb\u5f15\u7528\uff0c\u8bf7\u5148\u5220\u9664\u79d1\u76ee\u5bf9\u7167\u5173\u7cfb\u540e\u518d\u4fee\u6539\u3002", (String)"AccountViewSaveValidator_177", (String)"fi-bd-opplugin", (Object[])new Object[0]), account.getString("number"));
            }
        }
        return "";
    }

    private boolean isCashRelateChange(boolean iscash, boolean DBiscash, boolean isbank, boolean DBisbank) {
        return iscash != DBiscash || isbank != DBisbank;
    }

    private Map<Long, Map<String, Object>> getEntryItemInfos(DynamicObject account) {
        DynamicObjectCollection itemEntry = account.getDynamicObjectCollection("checkitementry");
        HashMap<Long, Map<String, Object>> infos = new HashMap<Long, Map<String, Object>>();
        for (DynamicObject entryRow : itemEntry) {
            DynamicObject item = entryRow.getDynamicObject("asstactitem");
            if (item == null) continue;
            HashMap<String, Object> info = new HashMap<String, Object>(3);
            for (String field : entryFields) {
                info.put(field, entryRow.getBoolean(field));
            }
            info.put("itemnum", item.getString("number"));
            info.put("itemname", item.getString("name"));
            infos.put(item.getLong("id"), info);
        }
        return infos;
    }

    private Tuple<String, Boolean> getAssistItemRequireChange(DynamicObject acctInDB, DynamicObject account) {
        DynamicObjectCollection itemEntry = account.getDynamicObjectCollection("checkitementry");
        DynamicObjectCollection DBitemEntry = acctInDB.getDynamicObjectCollection("checkitementry");
        HashMap<Object, DynamicObject> DBitemMap = new HashMap<Object, DynamicObject>();
        for (DynamicObject entryRow : DBitemEntry) {
            DynamicObject item = entryRow.getDynamicObject("asstactitem");
            if (item == null) continue;
            DBitemMap.put(item.getPkValue(), entryRow);
        }
        HashMap<Object, DynamicObject> itemMap = new HashMap<Object, DynamicObject>();
        for (DynamicObject entryRow : itemEntry) {
            DynamicObject item = entryRow.getDynamicObject("asstactitem");
            if (item == null) continue;
            itemMap.put(item.getPkValue(), entryRow);
        }
        for (Map.Entry entry : DBitemMap.entrySet()) {
            Object DBitemId = entry.getKey();
            DynamicObject DBentryRow = (DynamicObject)entry.getValue();
            DynamicObject entryRow = (DynamicObject)itemMap.get(DBitemId);
            if (entryRow == null) continue;
            for (String field : entryFields) {
                if (!field.equals("isrequire")) continue;
                boolean DBValue = DBentryRow.getBoolean(field);
                boolean value = entryRow.getBoolean(field);
                if (!DBValue || value) continue;
                return new Tuple((Object)entryRow.getDynamicObject("asstactitem").getString("number"), (Object)true);
            }
        }
        return new Tuple(null, (Object)false);
    }

    private boolean isAssistItemChange(DynamicObject acctInDB, DynamicObject account, boolean isAllowableDeleteAssist) {
        DynamicObjectCollection itemEntry = account.getDynamicObjectCollection("checkitementry");
        DynamicObjectCollection DBitemEntry = acctInDB.getDynamicObjectCollection("checkitementry");
        HashMap<Object, DynamicObject> DBitemMap = new HashMap<Object, DynamicObject>();
        for (DynamicObject entryRow : DBitemEntry) {
            DynamicObject item = entryRow.getDynamicObject("asstactitem");
            if (item == null) continue;
            DBitemMap.put(item.getPkValue(), entryRow);
        }
        HashMap<Object, DynamicObject> itemMap = new HashMap<Object, DynamicObject>();
        for (DynamicObject entryRow : itemEntry) {
            DynamicObject item = entryRow.getDynamicObject("asstactitem");
            if (item == null) continue;
            itemMap.put(item.getPkValue(), entryRow);
        }
        for (Map.Entry entry : DBitemMap.entrySet()) {
            DynamicObject entryRow;
            Object DBitemId = entry.getKey();
            DynamicObject DBentryRow = (DynamicObject)entry.getValue();
            if (!this.disableModifyAssitRow(isAllowableDeleteAssist, DBentryRow, entryRow = (DynamicObject)itemMap.get(DBitemId))) continue;
            return true;
        }
        return false;
    }

    private boolean disableModifyAssitRow(boolean isAllowableDeleteAssist, DynamicObject DBentryRow, DynamicObject entryRow) {
        boolean value;
        if (entryRow == null && !isAllowableDeleteAssist) {
            return true;
        }
        if (entryRow == null) {
            return DBentryRow.getBoolean("enaccheck");
        }
        boolean DBValue = DBentryRow.getBoolean("enaccheck");
        if (DBValue != (value = entryRow.getBoolean("enaccheck"))) {
            return true;
        }
        boolean DBRequire = DBentryRow.getBoolean("isrequire");
        boolean currRequire = entryRow.getBoolean("isrequire");
        return !DBRequire && currRequire;
    }

    private static String checkAccountTableRef(DynamicObject account, DynamicObject acctInDB) {
        if (AccountVersionControlChecker.checkCurrencyChange((DynamicObject)acctInDB, (DynamicObject)account)) {
            HashSet<Long> useOrgIds = new HashSet<Long>(8);
            useOrgIds.add(account.getLong("useorg_id"));
            HashSet<Long> accIds = new HashSet<Long>(8);
            accIds.add(account.getLong("id"));
            long accountTableId = account.getLong("accounttable_id");
            Map checkRes = AccountTableRefUtils.batchCheckAccountTableRef((Long)accountTableId, useOrgIds, accIds, null);
            if (!CollectionUtils.isEmpty((Map)checkRes) && AccountTableRefUtils.checkCurrency((Map)checkRes, (DynamicObject)account)) {
                return String.format(ResManager.loadKDString((String)"\u8be5\u79d1\u76ee\uff08%s\uff09\u5df2\u88ab\u79d1\u76ee\u8868\u7248\u672c\u5316\u5f15\u7528\uff0c\u5f53\u524d\u4fee\u6539\u4f1a\u5bfc\u81f4\u79d1\u76ee\u8868\u7248\u672c\u5316\u4e2d\u76ee\u6807\u79d1\u76ee\u5e01\u79cd\u6838\u7b97\u8303\u56f4\u672a\u5305\u542b\u6e90\u79d1\u76ee\u5e01\u79cd\u6838\u7b97\u8303\u56f4\uff0c\u8bf7\u5220\u9664\u79d1\u76ee\u8868\u7248\u672c\u5316\u4e2d\u7684\u5bf9\u7167\u4fe1\u606f\u5206\u5f55\u540e\u518d\u4fee\u6539\u79d1\u76ee\u3002", (String)"AccountViewSaveValidator_175", (String)"fi-bd-opplugin", (Object[])new Object[0]), account.getString("number"));
            }
            Map accountMappingRefMap = AccountTableRefUtils.checkAccountMappingRef((Long)accountTableId, useOrgIds, accIds);
            if (!CollectionUtils.isEmpty((Map)accountMappingRefMap) && AccountTableRefUtils.checkCurrency((Map)accountMappingRefMap, (DynamicObject)account)) {
                return String.format(ResManager.loadKDString((String)"\u8be5\u79d1\u76ee\uff08%s\uff09\u5df2\u88ab\u8d26\u7c3f\u534f\u540c\u7684\u79d1\u76ee\u5bf9\u7167\u5173\u7cfb\u5f15\u7528\uff0c\u8bf7\u5148\u5220\u9664\u79d1\u76ee\u5bf9\u7167\u5173\u7cfb\u540e\u518d\u4fee\u6539\u3002", (String)"AccountViewSaveValidator_177", (String)"fi-bd-opplugin", (Object[])new Object[0]), account.getString("number"));
            }
        }
        return " ";
    }
}

