/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.opplugin;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.bd.consts.AccountOperationType;
import kd.fi.bd.consts.OperationLogEntry;
import kd.fi.bd.util.AccountOperationLogUtil;
import kd.fi.bd.util.AccountVersionUtil;
import kd.fi.bd.util.BatchProcessUtil;
import kd.fi.bd.util.BizHappenUtils;
import kd.fi.bd.util.PerformanceMonitor;

public class AccountviewDeleteValidator
extends AbstractValidator {
    public void validate() {
        ArrayList<OperationLogEntry> entryList = new ArrayList<OperationLogEntry>(8);
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            ExtendedDataEntity[] account = extendedDataEntity.getDataEntity();
            OperationLogEntry entry = new OperationLogEntry(Long.valueOf(account.getLong("createorg_id")), Long.valueOf(account.getLong("id")), AccountOperationType.DELETE, Boolean.TRUE.booleanValue());
            entry.setNumber(account.getString("number"));
            entry.setAccountName(account.getString("name"));
            entryList.add(entry);
        }
        AccountOperationLogUtil.addLogEntryRow(entryList);
        HashMap<Long, Set<Long>> hasSubAccts = new HashMap<Long, Set<Long>>();
        HashMap<Long, Set<Long>> hasSubAcctOrgMap = new HashMap<Long, Set<Long>>();
        this.preprateData(hasSubAccts, hasSubAcctOrgMap);
        boolean isVersionList = this.getOption().containsVariable("versionlist");
        HashSet<Long> failedAccIds = new HashSet<Long>(8);
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            DynamicObject acct = extendedDataEntity.getDataEntity();
            Long accId = acct.getLong("id");
            long masterid = acct.getLong("masterid");
            long orgid = acct.getLong("createorg_id");
            Set subAccts = (Set)hasSubAccts.get(orgid);
            if (subAccts != null && subAccts.contains(masterid)) {
                failedAccIds.add(accId);
                Set hasSubAccOrgIds = (Set)hasSubAcctOrgMap.get(orgid);
                DynamicObjectCollection qryResult = QueryServiceHelper.query((String)"bos_org", (String)"number,name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)hasSubAccOrgIds)});
                Set orgInfos = qryResult.stream().map(d -> d.getString("name") + "(" + d.getString("number") + ")").collect(Collectors.toSet());
                String errTips = String.join((CharSequence)",", orgInfos);
                this.addMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u5220\u9664\u4e0b\u7ea7\u6838\u7b97\u7ec4\u7ec7\u8be5\u79d1\u76ee\u7684\u4e0b\u7ea7\u79d1\u76ee\u3002\u5b58\u5728\u4e0b\u7ea7\u79d1\u76ee\u7684\u7ec4\u7ec7\u4e3a\uff1a%s", (String)"AccountviewDeleteValidator_10", (String)"fi-bd-opplugin", (Object[])new Object[0]), errTips), ErrorLevel.Error);
                continue;
            }
            if (!isVersionList && acct.getLong("id") != acct.getLong("masterid")) {
                failedAccIds.add(accId);
                this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8be5\u79d1\u76ee\u5df2\u88ab\u7248\u672c\u5316\uff0c\u8bf7\u524d\u5f80\u7248\u672c\u5316\u8bb0\u5f55\u8868\u5220\u9664\u3002", (String)"AccountviewDeleteValidator_3", (String)"fi-bd-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            if (0 != AccountVersionUtil.compareDate((Date)acct.getDate("enddate"), (Date)AccountVersionUtil.getEndDate())) {
                failedAccIds.add(accId);
                this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8be5\u79d1\u76ee\u4e0d\u662f\u6700\u65b0\u7248\u672c\u79d1\u76ee\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"AccountviewDeleteValidator_4", (String)"fi-bd-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            if (BizHappenUtils.exist((long)accId, (Set)Collections.EMPTY_SET)) {
                failedAccIds.add(accId);
                this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8be5\u79d1\u76ee\u5b58\u5728\u76f8\u5173\u4e1a\u52a1\uff08\u51ed\u8bc1\u3001\u4f59\u989d\u3001\u521d\u59cb\u5316\u7b49\uff09\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"AccountviewDeleteValidator_13", (String)"fi-bd-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            if (!this.isExistPreset(accId)) continue;
            failedAccIds.add(accId);
            this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u5f15\u7528\u4e0d\u80fd\u88ab\u5220\u9664\uff0c\u201c\u79d1\u76ee\u73b0\u91d1\u6d41\u91cf\u6620\u5c04\u5173\u7cfb\u201d\u7684\u5b57\u6bb5\u201c\u79d1\u76ee\u201d\u5f15\u7528\u4e86\u6b64\u8d44\u6599\u6570\u636e\u3002", (String)"AccountviewDeleteValidator_14", (String)"fi-bd-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
        }
        List validateResults = this.getValidateContext().getValidateResults().getValidateErrors();
        if (!CollectionUtils.isEmpty(failedAccIds) && !CollectionUtils.isEmpty((Collection)validateResults)) {
            validateResults.stream().forEach(x -> x.getAllErrorInfo().removeAll(x.getAllErrorInfo().stream().filter(y -> failedAccIds.contains(y.getPkValue())).collect(Collectors.toList())));
        }
    }

    private void preprateData(Map<Long, Set<Long>> hasSubAccts, Map<Long, Set<Long>> hasSubAcctOrgMap) {
        HashMap<Long, List> orgMap = new HashMap<Long, List>();
        HashSet<Long> tableSet = new HashSet<Long>(this.dataEntities.length);
        HashSet<Long> idSet = new HashSet<Long>(this.dataEntities.length);
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            DynamicObject acct = extendedDataEntity.getDataEntity();
            long accttableid = acct.getLong("accounttable_id");
            long masterid = acct.getLong("masterid");
            long orgid = acct.getLong("createorg_id");
            List orgids = (List)orgMap.get(orgid);
            ArrayList<Long> paramOrg = new ArrayList<Long>();
            paramOrg.add(orgid);
            if (orgids == null) {
                orgids = OrgUnitServiceHelper.getAllSubordinateOrgs((String)"10", paramOrg, (boolean)false);
                orgMap.put(orgid, orgids);
            }
            tableSet.add(accttableid);
            idSet.add(masterid);
        }
        for (Map.Entry entry : orgMap.entrySet()) {
            DynamicObjectCollection accts = BatchProcessUtil.batchQueryDynColl((Collection)((Collection)entry.getValue()), batchOrgs -> QueryServiceHelper.query((String)"bd_accountview", (String)"id,masterid,parent.masterid,createorg,accounttable", (QFilter[])new QFilter[]{new QFilter("createorg", "in", batchOrgs), new QFilter("accounttable", "in", (Object)tableSet), new QFilter("parent.masterid", "in", (Object)idSet)}));
            long curOrgId = (Long)entry.getKey();
            for (DynamicObject acct : accts) {
                long pmasterid = acct.getLong("parent.masterid");
                Set acctIds = hasSubAccts.computeIfAbsent(curOrgId, k -> new HashSet());
                Set hasSubAccOrgIds = hasSubAcctOrgMap.computeIfAbsent(curOrgId, k -> new HashSet());
                acctIds.add(pmasterid);
                hasSubAccOrgIds.add(acct.getLong("createorg"));
            }
        }
    }

    private boolean isExistPreset(long accountId) {
        if (accountId == 0L) {
            return false;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select TOP 1 fid from t_gl_presetcfentry where ", new Object[0]);
        sqlBuilder.append("faccountid = ? ", new Object[]{accountId});
        return (Boolean)PerformanceMonitor.watch(() -> (Boolean)DB.query((DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws Exception {
                return rs.next();
            }
        }), (int)10, (Object)sqlBuilder);
    }
}

