/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.bd.cashflow.CashflowRelationFactory;
import kd.fi.bd.cfversion.CashflowItemOptionVarManager;
import kd.fi.bd.cfversion.CashflowPropertyCheck;
import kd.fi.bd.cfversion.CheckResult;
import kd.fi.bd.consts.BDCommonResource;
import kd.fi.bd.enums.PeriodStateEnum;
import kd.fi.bd.opplugin.CashflowAssistEntryInfo;
import kd.fi.bd.opplugin.CashflowInfo;
import kd.fi.bd.opplugin.CashflowItemContext;
import kd.fi.bd.util.AccountVersionUtil;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.CashflowItemCheckUtil;
import kd.fi.bd.util.CashflowItemVersionUtil;
import kd.fi.bd.util.FibdApp;
import kd.fi.bd.vo.AssistEntryVO;

public class CashFlowItemSaveVaildator
extends AbstractValidator {
    private static Log logger = LogFactory.getLog(CashFlowItemSaveVaildator.class);
    private long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
    private Map<Long, DynamicObject> successDataEntitiesMap = new HashMap<Long, DynamicObject>(16);
    private Map<Long, ExtendedDataEntity> id2DataEntitys = new HashMap<Long, ExtendedDataEntity>(16);
    private Map<Long, CashflowInfo> cfMap = new HashMap<Long, CashflowInfo>();
    private Map<Long, DynamicObject> dbDataEntity = new HashMap<Long, DynamicObject>();

    public void validate() {
        Map<Long, List<ExtendedDataEntity>> map = Arrays.stream(this.dataEntities).collect(Collectors.groupingBy(x -> x.getDataEntity().getLong("createorg_id")));
        List<Long> dbList = Arrays.stream(this.dataEntities).filter(x -> x.getDataEntity().getDataEntityState().getFromDatabase()).map(x -> x.getDataEntity().getLong("id")).collect(Collectors.toList());
        this.prepareCfMap(dbList);
        for (Map.Entry<Long, List<ExtendedDataEntity>> entry : map.entrySet()) {
            this.validate(entry.getKey(), entry.getValue());
        }
        if (CashflowItemOptionVarManager.isOnlyValidate((OperateOption)this.getOption())) {
            this.dataEntities = new ExtendedDataEntity[0];
        }
    }

    private void prepareCfMap(List<Long> ids) {
        Map objectMap = BusinessDataServiceHelper.loadFromCache((String)"gl_cashflowitem", (String)"id,isexchangerate,isscheduleitem,name,number,isdealactivity,isprefit,type,direction,assistentry.asstypeid,assistentry.isrequire,assistentry.isdetail,startdate", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        objectMap.entrySet().stream().forEach(entry -> {
            DynamicObject value = (DynamicObject)entry.getValue();
            long id = value.getLong("id");
            this.dbDataEntity.put(value.getLong("id"), value);
            CashflowInfo info = new CashflowInfo();
            info.setId(id);
            info.setIsprefit(value.getBoolean("isprefit"));
            info.setIsexchangerate(value.getBoolean("isexchangerate"));
            info.setName(value.getString("name"));
            info.setNumber(value.getString("number"));
            info.setType(value.getString("type"));
            info.setDirection(value.getString("direction"));
            info.setScheduleitem(value.getBoolean("isscheduleitem"));
            ArrayList<CashflowAssistEntryInfo> cashflowAssistEntryInfos = new ArrayList<CashflowAssistEntryInfo>(8);
            DynamicObjectCollection assistentry = value.getDynamicObjectCollection("assistentry");
            for (DynamicObject assist : assistentry) {
                cashflowAssistEntryInfos.add(new CashflowAssistEntryInfo(assist.getLong("asstypeid_id"), assist.getBoolean("isrequire"), assist.getBoolean("isdetail")));
            }
            info.setEntry(cashflowAssistEntryInfos);
            this.cfMap.put(id, info);
        });
        CashflowItemContext context = new CashflowItemContext();
        context.setDbDataEntity(this.dbDataEntity);
        context.setCtx(context);
        context.setPeriodTypeIds(BDUtil.getPeriodType());
    }

    private void validate(long orgId, List<ExtendedDataEntity> extendedDataEntities) {
        long suprefitCf = -1L;
        long parentExchangeRateCf = -1L;
        long oneLevelSuppCf = -1L;
        ArrayList<Long> exchangeRateCfs = new ArrayList<Long>(8);
        for (ExtendedDataEntity dataEntity : extendedDataEntities) {
            DynamicObject cashflowItem = dataEntity.getDataEntity();
            long id = cashflowItem.getLong("id");
            this.id2DataEntitys.put(id, dataEntity);
            this.resetLongStr(cashflowItem);
            this.resetDate(cashflowItem);
            this.resetAssist(cashflowItem);
            String errors = "";
            errors = this.selfInfoValidate(cashflowItem);
            if (StringUtils.isEmpty((CharSequence)errors)) {
                errors = this.propertyConsitentValidate(cashflowItem, this.successDataEntitiesMap);
            }
            if (StringUtils.isEmpty((CharSequence)errors)) {
                if (StringUtils.isEmpty((CharSequence)errors) && cashflowItem.getBoolean("isprefit")) {
                    if (suprefitCf == -1L) {
                        suprefitCf = id;
                    } else {
                        errors = ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u51c0\u5229\u6da6\u3002", (String)"CashFlowItemSaveVaildator_1", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                    }
                }
                if (StringUtils.isEmpty((CharSequence)errors) && cashflowItem.getBoolean("isexchangerate")) {
                    exchangeRateCfs.add(id);
                    if (parentExchangeRateCf == -1L || parentExchangeRateCf == cashflowItem.getLong("parent_id")) {
                        parentExchangeRateCf = cashflowItem.getLong("parent_id");
                    } else {
                        errors = ResManager.loadKDString((String)"\u6c47\u7387\u53d8\u52a8\u4ea7\u751f\u7684\u73b0\u91d1\u6d41\u91cf\u53ea\u80fd\u88ab\u4e00\u4e2a\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u548c\u4ed6\u7684\u4e0b\u7ea7\u52fe\u9009\uff0c\u5176\u4ed6\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u4e0d\u80fd\u52fe\u9009\u3002", (String)"CashFlowItemSaveVaildator_7", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                    }
                }
                if (StringUtils.isEmpty((CharSequence)errors) && cashflowItem.getInt("level") == 1 && "3".equals(cashflowItem.getString("type"))) {
                    if (oneLevelSuppCf == -1L) {
                        oneLevelSuppCf = id;
                    } else {
                        errors = ResManager.loadKDString((String)"\u8865\u5145\u8d44\u6599\u9879\u76ee\u4e0d\u53ef\u91cd\u590d\u521b\u5efa\u3002", (String)"CashFlowItemSaveVaildator_2", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                    }
                }
            }
            if (StringUtils.isNotBlank((CharSequence)errors)) {
                this.addMessage(dataEntity, errors, ErrorLevel.Error);
                continue;
            }
            this.successDataEntitiesMap.put(cashflowItem.getLong("id"), cashflowItem);
            errors = this.businessValiedate(cashflowItem);
            if (!StringUtils.isNotBlank((CharSequence)errors)) continue;
            this.addMessage(dataEntity, errors, ErrorLevel.Error);
        }
        this.singleCheck(suprefitCf, parentExchangeRateCf, oneLevelSuppCf, orgId, exchangeRateCfs);
        this.checkParentExsit();
    }

    private void resetDate(DynamicObject cashflowItem) {
        if (!cashflowItem.getDataEntityState().getFromDatabase() && !CashflowItemOptionVarManager.isVersion((OperateOption)this.getOption())) {
            DynamicObject parent = cashflowItem.getDynamicObject("parent");
            if (parent != null) {
                cashflowItem.set("startdate", (Object)parent.getDate("startdate"));
            } else {
                cashflowItem.set("startdate", (Object)CashflowItemVersionUtil.getBeginDate());
                cashflowItem.set("enddate", (Object)CashflowItemVersionUtil.getEndDate());
            }
        }
    }

    private void resetAssist(DynamicObject cashflow) {
        DynamicObjectCollection checkitems = cashflow.getDynamicObjectCollection("assistentry");
        boolean isAssist = false;
        Iterator it = checkitems.iterator();
        while (it.hasNext()) {
            DynamicObject dyo = (DynamicObject)it.next();
            if (dyo.get("asstypeid") == null) {
                it.remove();
                continue;
            }
            isAssist = true;
        }
        cashflow.set("isassist", (Object)isAssist);
    }

    private String businessValiedate(DynamicObject cashflowItem) {
        DynamicObject parent = cashflowItem.getDynamicObject("parent");
        boolean isVersion = CashflowItemOptionVarManager.isVersion((OperateOption)this.getOption());
        if (parent != null) {
            if (parent.getBoolean("isleaf")) {
                boolean existBizHappen = CashflowItemCheckUtil.existsBizOnOrg((long)parent.getLong("masterid"), (long)cashflowItem.getLong("useorg_id"), null);
                boolean enableVersion = CashflowItemVersionUtil.isEnableVersion();
                if (existBizHappen && (!enableVersion || "3".equalsIgnoreCase(parent.getString("type")))) {
                    logger.info("addleaf_fail:enableflase or type_supp");
                    return ResManager.loadKDString((String)"\u4e0a\u7ea7\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u5b58\u5728\u4e1a\u52a1\u53d1\u751f\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\u4e0b\u7ea7\u3002", (String)"CashFlowItemSaveVaildator_46", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                }
                if (existBizHappen && !isVersion) {
                    if ("1".equalsIgnoreCase(parent.getString("type"))) {
                        return ResManager.loadKDString((String)"\u4e0a\u7ea7\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u5b58\u5728\u4e1a\u52a1\u53d1\u751f\uff0c\u8bf7\u901a\u8fc7\u65b0\u589e\u6309\u94ae\u589e\u52a0\u5176\u4e0b\u7ea7\uff0c\u5e76\u8bbe\u7f6e\u7248\u672c\u5316\u65e5\u671f\u3002", (String)"CashFlowItemSaveVaildator_45", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                    }
                    logger.info("addleaf_fail:nonversion");
                    return ResManager.loadKDString((String)"\u4e0a\u7ea7\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u5b58\u5728\u4e1a\u52a1\u53d1\u751f\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\u4e0b\u7ea7\u3002", (String)"CashFlowItemSaveVaildator_46", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                }
                Date startDate = parent.getDate("startdate");
                Date curDate = cashflowItem.getDate("startdate");
                logger.info("CashflowItemSaveValidator_validate_parentstartdate:" + startDate + " ,curDatestartdate:" + curDate);
                if (-1 == AccountVersionUtil.compareDate((Date)curDate, (Date)startDate)) {
                    return ResManager.loadKDString((String)"\u4e0a\u7ea7\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u5728\u540e\u7eed\u671f\u95f4\u5df2\u7ecf\u8fdb\u884c\u8fc7\u7248\u672c\u5316\uff0c\u65e0\u6cd5\u5728\u5386\u53f2\u671f\u95f4\u65b0\u589e\u3002", (String)"CashFlowItemSaveVaildator_47", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                }
                if (CashflowItemCheckUtil.existsBizOnOrg((long)parent.getLong("masterid"), (long)cashflowItem.getLong("createorg_id"), (Date)curDate)) {
                    return String.format(ResManager.loadKDString((String)"%s\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u5728\u5f53\u524d\u65e5\u671f\u6240\u5c5e\u7684\u671f\u95f4\u53ca\u4ee5\u540e\u671f\u95f4\u5728\u5f53\u524d\u7ec4\u7ec7\u6216\u4e0b\u7ea7\u7ec4\u7ec7\u6709\u51ed\u8bc1\u6216\u521d\u59cb\u5316\u4f59\u989d\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\u4e0b\u7ea7\uff0c\u8bf7\u5148\u5220\u9664\u51ed\u8bc1\u6216\u521d\u59cb\u5316\u4f59\u989d\u6570\u636e\u3002", (String)"CashFlowItemSaveVaildator_48", (String)"fi-bd-opplugin", (Object[])new Object[0]), parent.getString("number"));
                }
            } else if (cashflowItem.getDataEntityState().getFromDatabase()) {
                return this.checkBusiness(cashflowItem, isVersion);
            }
        } else if (cashflowItem.getDataEntityState().getFromDatabase()) {
            return this.checkBusiness(cashflowItem, isVersion);
        }
        return "";
    }

    private String checkBusiness(DynamicObject cashflowItem, boolean isVersion) {
        boolean existBizHappen = CashflowItemCheckUtil.existsBizOnOrg((long)cashflowItem.getLong("masterid"), (long)cashflowItem.getLong("useorg_id"), null);
        long itemId = cashflowItem.getLong("id");
        boolean isAssistChange = this.isAssistChange(cashflowItem, this.cfMap.get(itemId));
        CashflowItemOptionVarManager.setAssistChange((OperateOption)this.getOption(), (boolean)isAssistChange);
        boolean enableVersion = CashflowItemVersionUtil.isEnableVersion();
        if (isAssistChange && !isVersion && existBizHappen && enableVersion) {
            return ResManager.loadKDString((String)"%s\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u5b58\u5728\u4e1a\u52a1\u53d1\u751f\uff0c\u8bf7\u901a\u8fc7\u73b0\u91d1\u6d41\u91cf\u7248\u672c\u5316\u64cd\u4f5c\u8fdb\u884c\u6838\u7b97\u7ef4\u5ea6\u53d8\u66f4\u3002", (String)"CashFlowItemSaveVaildator_49", (String)"fi-bd-opplugin", (Object[])new Object[]{cashflowItem.getString("number")});
        }
        if (!enableVersion && isAssistChange && existBizHappen) {
            return ResManager.loadKDString((String)"%s\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u5b58\u5728\u4e1a\u52a1\u53d1\u751f\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u6838\u7b97\u7ef4\u5ea6\u3002", (String)"CashFlowItemSaveVaildator_50", (String)"fi-bd-opplugin", (Object[])new Object[]{cashflowItem.getString("number")});
        }
        Date startDate = this.dbDataEntity.get(cashflowItem.getLong("id")).getDate("startdate");
        Date curDate = cashflowItem.getDate("startdate");
        logger.info("CashflowItemSaveValidator_validate_parentstartdate:" + startDate + " ,curDatestartdate:" + curDate);
        if (isVersion) {
            CashflowItemContext context = CashflowItemContext.get();
            PeriodStateEnum stateEnum = BDUtil.getCurVersionState(context.getPeriodMap(), context.getPeriodTypeIds(), (Date)startDate, (Date)curDate);
            if (PeriodStateEnum.BOTH == stateEnum) {
                return BDCommonResource.getMessageConstantsE005Text();
            }
            if (PeriodStateEnum.ALL_NO == stateEnum && AccountVersionUtil.compareDate((Date)curDate, (Date)startDate) == -1) {
                return ResManager.loadKDString((String)"\u8be5\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u5728\u540e\u7eed\u671f\u95f4\u5df2\u7ecf\u8fdb\u884c\u8fc7\u7248\u672c\u5316\uff0c\u65e0\u6cd5\u5728\u5386\u53f2\u671f\u95f4\u65b0\u589e\u3002", (String)"CashFlowItemSaveVaildator_51", (String)"fi-bd-opplugin", (Object[])new Object[0]);
            }
            if (PeriodStateEnum.ALL_SAME == stateEnum) {
                cashflowItem.set("startdate", (Object)startDate);
            }
        }
        if (isAssistChange && CashflowItemCheckUtil.existsBizOnOrg((long)cashflowItem.getLong("masterid"), (long)cashflowItem.getLong("useorg_id"), (Date)curDate)) {
            return String.format(ResManager.loadKDString((String)"%s\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u5728\u5f53\u524d\u65e5\u671f\u6240\u5c5e\u671f\u95f4\u53ca\u4ee5\u540e\u671f\u95f4\u6709\u51ed\u8bc1\u6216\u4f59\u989d\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u6838\u7b97\u7ef4\u5ea6\uff0c\u8bf7\u5148\u5220\u9664\u4e1a\u52a1\u6570\u636e\u3002", (String)"CashFlowItemSaveVaildator_42", (String)"fi-bd-opplugin", (Object[])new Object[0]), cashflowItem.getString("number"));
        }
        if (existBizHappen) {
            DynamicObjectCollection items;
            long level = cashflowItem.getLong("level");
            boolean isexchangerate = cashflowItem.getBoolean("isexchangerate");
            CashflowInfo itemDB = this.cfMap.get(itemId);
            if (level <= 3L && !isexchangerate && itemDB.isIsexchangerate() && !(items = QueryServiceHelper.query((String)"gl_cashflowitem", (String)"createorg", (QFilter[])new QFilter("id", "=", cashflowItem.get("masterid")).toArray())).isEmpty() && ((DynamicObject)items.get(0)).getLong("createorg") != this.rootOrgId) {
                this.successDataEntitiesMap.remove(itemId);
                return ResManager.loadKDString((String)"\u975e\u96c6\u56e2\u516c\u53f8\u521b\u5efa\u76843\u7ea7\u4ee5\u4e0b\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\uff0c\u4e0d\u5141\u8bb8\u5c06\u6c47\u7387\u53d8\u52a8\u7531\u662f\u6539\u4e3a\u5426\u3002", (String)"CashFlowItemSaveVaildator_8", (String)"fi-bd-opplugin", (Object[])new Object[0]);
            }
            if (this.isChangeName(cashflowItem, itemDB)) {
                this.successDataEntitiesMap.remove(itemId);
                return ResManager.loadKDString((String)"\u8be5\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u6709\u4e1a\u52a1\u53d1\u751f\uff0c\u4e0d\u80fd\u4fee\u6539\u540d\u79f0\u3002", (String)"CashFlowItemSaveVaildator_9", (String)"fi-bd-opplugin", (Object[])new Object[0]);
            }
            if (this.isChangeNumber(cashflowItem, itemDB)) {
                this.successDataEntitiesMap.remove(itemId);
                return ResManager.loadKDString((String)"\u8be5\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u6709\u4e1a\u52a1\u53d1\u751f\uff0c\u4e0d\u80fd\u4fee\u6539\u7f16\u7801\u3002", (String)"CashFlowItemSaveVaildator_37", (String)"fi-bd-opplugin", (Object[])new Object[0]);
            }
            if (this.isChangeType(cashflowItem, itemDB)) {
                this.successDataEntitiesMap.remove(itemId);
                return ResManager.loadKDString((String)"\u8be5\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u6709\u4e1a\u52a1\u53d1\u751f\uff0c\u4e0d\u80fd\u4fee\u9879\u76ee\u7c7b\u522b\u3002", (String)"CashFlowItemSaveVaildator_5", (String)"fi-bd-opplugin", (Object[])new Object[0]);
            }
            if (this.isChangeDirection(cashflowItem, itemDB)) {
                this.successDataEntitiesMap.remove(itemId);
                return ResManager.loadKDString((String)"\u8be5\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u6709\u4e1a\u52a1\u53d1\u751f\uff0c\u4e0d\u80fd\u4fee\u73b0\u91d1\u6d41\u5411\u3002", (String)"CashFlowItemSaveVaildator_6", (String)"fi-bd-opplugin", (Object[])new Object[0]);
            }
            if (this.isChangePrefit(cashflowItem, itemDB)) {
                this.successDataEntitiesMap.remove(itemId);
                return ResManager.loadKDString((String)"\u88ab\u5f15\u7528\u7684\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u4e0d\u80fd\u4fee\u6539\u51c0\u5229\u6da6\u5c5e\u6027\u3002", (String)"CashFlowItemSaveVaildator_10", (String)"fi-bd-opplugin", (Object[])new Object[0]);
            }
            if (this.isChangeExchange(cashflowItem, itemDB)) {
                this.successDataEntitiesMap.remove(itemId);
                return ResManager.loadKDString((String)"\u88ab\u5f15\u7528\u7684\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u4e0d\u80fd\u4fee\u6539\u6c47\u7387\u53d8\u52a8\u5c5e\u6027\u3002", (String)"CashFlowItemSaveVaildator_43", (String)"fi-bd-opplugin", (Object[])new Object[0]);
            }
            if (this.isChangeSuppItem(cashflowItem, itemDB)) {
                this.successDataEntitiesMap.remove(itemId);
                return ResManager.loadKDString((String)"\u88ab\u5f15\u7528\u7684\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u4e0d\u80fd\u4fee\u6539\u9644\u8868\u9879\u76ee\u5c5e\u6027\u3002", (String)"CashFlowItemSaveVaildator_44", (String)"fi-bd-opplugin", (Object[])new Object[0]);
            }
        }
        return "";
    }

    private boolean isChangeSuppItem(DynamicObject cashflowItem, CashflowInfo itemDB) {
        String oldName;
        String newName = cashflowItem.getString("isscheduleitem");
        return !newName.equals(oldName = String.valueOf(itemDB.isScheduleitem()));
    }

    private boolean isChangeExchange(DynamicObject cashflowItem, CashflowInfo itemDB) {
        String oldName;
        String newName = cashflowItem.getString("isexchangerate");
        return !newName.equals(oldName = String.valueOf(itemDB.isIsexchangerate()));
    }

    private boolean isChangeName(DynamicObject item, CashflowInfo itemDB) {
        String oldName;
        String newName = item.getString("name");
        return !newName.equals(oldName = itemDB.getName());
    }

    private boolean isChangeNumber(DynamicObject item, CashflowInfo itemDB) {
        String oldNumber;
        String newNumber = item.getString("number");
        return !newNumber.equals(oldNumber = itemDB.getNumber());
    }

    private boolean isChangePrefit(DynamicObject item, CashflowInfo itemDB) {
        boolean isprefit = item.getBoolean("isprefit");
        boolean isprefitDB = itemDB.isIsprefit();
        return !isprefit == isprefitDB;
    }

    private boolean isChangeType(DynamicObject item, CashflowInfo itemDB) {
        String oldType;
        String newType = item.getString("type");
        return !newType.equals(oldType = itemDB.getType());
    }

    private boolean isChangeDirection(DynamicObject item, CashflowInfo itemDB) {
        String oldDirection;
        String newDirection = item.getString("direction");
        return !newDirection.equals(oldDirection = itemDB.getDirection());
    }

    private boolean isAssistChange(DynamicObject cashflowItem, CashflowInfo cashflowInfo) {
        DynamicObjectCollection col = cashflowItem.getDynamicObjectCollection("assistentry");
        List<CashflowAssistEntryInfo> cashflowInfoEntry = cashflowInfo.getEntry();
        if (col.isEmpty() && cashflowInfoEntry.isEmpty()) {
            return false;
        }
        if (col.size() != cashflowInfoEntry.size()) {
            return true;
        }
        HashMap<Long, AssistEntryVO> map = new HashMap<Long, AssistEntryVO>(col.size());
        for (DynamicObject dyn : col) {
            long l = dyn.getDynamicObject("asstypeid").getLong("id");
            map.put(l, new AssistEntryVO(l, dyn.getBoolean("isrequire"), dyn.getBoolean("isdetail"), false));
        }
        HashMap<Long, AssistEntryVO> dbMap = new HashMap<Long, AssistEntryVO>(cashflowInfoEntry.size());
        for (CashflowAssistEntryInfo cashflowAssistEntryInfo : cashflowInfoEntry) {
            dbMap.put(cashflowAssistEntryInfo.getAssistId(), new AssistEntryVO(cashflowAssistEntryInfo.getAssistId(), cashflowAssistEntryInfo.isRequire(), cashflowAssistEntryInfo.isDetail(), false));
        }
        for (Map.Entry entry : map.entrySet()) {
            Long key = (Long)entry.getKey();
            AssistEntryVO value = (AssistEntryVO)entry.getValue();
            AssistEntryVO entryDbVO = (AssistEntryVO)dbMap.remove(key);
            if (entryDbVO == null) {
                return true;
            }
            boolean noToYes = !entryDbVO.isMustInput() && value.isMustInput() || !entryDbVO.isLeaf() && value.isLeaf();
            if (!noToYes) continue;
            return true;
        }
        return false;
    }

    private void checkParentExsit() {
        for (ExtendedDataEntity entity : this.dataEntities) {
            DynamicObject dyo = entity.getDataEntity();
            long id = dyo.getLong("id");
            long parentId = dyo.getLong("parent_id");
            if (parentId == 0L) continue;
            DynamicObject parent = dyo.getDynamicObject("parent");
            if (parent == null) {
                parent = this.successDataEntitiesMap.get(parentId);
            }
            if (parent != null) continue;
            this.addMessage(entity, ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599(\u4e0a\u7ea7)\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"CashFlowItemSaveVaildator_11", (String)"fi-bd-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
            this.successDataEntitiesMap.remove(id);
        }
    }

    private void singleCheck(long suprefitCf, long parentExchangeRateCf, long oneLevelSuppCf, long orgId, List<Long> exchangeRateCfs) {
        if (suprefitCf != -1L || parentExchangeRateCf != -1L || oneLevelSuppCf != -1L) {
            ArrayList<Long> exchangeRateCfDB = new ArrayList<Long>(8);
            long suprefitCfDB = -1L;
            long oneLevelSuppCfDB = -1L;
            QFilter baseFilter = BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)orgId);
            QFilter exchangeRateFilter = new QFilter("isexchangerate", "=", (Object)true);
            exchangeRateFilter.or(new QFilter("isprefit", "=", (Object)true));
            exchangeRateFilter.or(new QFilter("type", "=", (Object)"3"));
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"", (String)"gl_cashflowitem", (String)"id,isexchangerate,isprefit,type,level", (QFilter[])new QFilter[]{baseFilter, exchangeRateFilter}, (String)"");){
                for (Row row : ds) {
                    long id = row.getLong("id");
                    if (row.getBoolean("isexchangerate").booleanValue()) {
                        exchangeRateCfDB.add(id);
                    }
                    if (row.getBoolean("isprefit").booleanValue()) {
                        suprefitCfDB = id;
                    }
                    if (!"3".equals(row.getString("type")) || row.getInteger("level") != 1) continue;
                    oneLevelSuppCfDB = id;
                }
            }
            if (suprefitCf != -1L && suprefitCfDB != -1L && suprefitCf != suprefitCfDB) {
                this.successDataEntitiesMap.remove(suprefitCf);
                this.addErrorMessage(this.id2DataEntitys.get(suprefitCf), ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u51c0\u5229\u6da6\u3002", (String)"CashFlowItemSaveVaildator_1", (String)"fi-bd-opplugin", (Object[])new Object[0]));
            }
            if (oneLevelSuppCf != -1L && oneLevelSuppCfDB != -1L && oneLevelSuppCf != oneLevelSuppCfDB) {
                this.successDataEntitiesMap.remove(oneLevelSuppCf);
                this.addErrorMessage(this.id2DataEntitys.get(oneLevelSuppCf), ResManager.loadKDString((String)"\u8865\u5145\u8d44\u6599\u9879\u76ee\u4e0d\u53ef\u91cd\u590d\u521b\u5efa\u3002", (String)"CashFlowItemSaveVaildator_2", (String)"fi-bd-opplugin", (Object[])new Object[0]));
            }
            for (long cf : exchangeRateCfs) {
                if (parentExchangeRateCf == -1L || exchangeRateCfDB.size() <= 0 || exchangeRateCfDB.contains(cf) || exchangeRateCfDB.contains(parentExchangeRateCf)) continue;
                this.successDataEntitiesMap.remove(cf);
                this.addErrorMessage(this.id2DataEntitys.get(cf), ResManager.loadKDString((String)"\u6c47\u7387\u53d8\u52a8\u4ea7\u751f\u7684\u73b0\u91d1\u6d41\u91cf\u53ea\u80fd\u88ab\u4e00\u4e2a\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u548c\u4ed6\u7684\u4e0b\u7ea7\u52fe\u9009\uff0c\u5176\u4ed6\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u4e0d\u80fd\u52fe\u9009\u3002", (String)"CashFlowItemSaveVaildator_7", (String)"fi-bd-opplugin", (Object[])new Object[0]));
            }
        }
    }

    private String propertyConsitentValidate(DynamicObject item, Map<Long, DynamicObject> dataEntitiesMap) {
        CashflowPropertyCheck check;
        CheckResult result;
        String direction;
        String errors = "";
        String type = item.getString("type");
        boolean isdealactivity = item.getBoolean("isdealactivity");
        long parentId = item.getLong("parent_id");
        if (parentId != 0L) {
            String direction2;
            DynamicObject parent = item.getDynamicObject("parent");
            if (parent == null && (parent = dataEntitiesMap.get(parentId)) == null) {
                return "";
            }
            String parentType = parent.getString("type");
            boolean parentisdealactivity = parent.getBoolean("isdealactivity");
            if (!type.equals(parentType)) {
                errors = ResManager.loadKDString((String)"\u9879\u76ee\u7c7b\u522b\u6309\u94ae\u52fe\u9009\u72b6\u6001\u5e94\u8be5\u4e0e\u4e0a\u7ea7\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u4fdd\u6301\u4e00\u81f4\u3002", (String)"CashFlowItemSaveVaildator_30", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                return errors;
            }
            if (isdealactivity != parentisdealactivity) {
                errors = ResManager.loadKDString((String)"\u7ecf\u8425\u6d3b\u52a8\u6309\u94ae\u52fe\u9009\u72b6\u6001\u5e94\u8be5\u4e0e\u4e0a\u7ea7\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u4fdd\u6301\u4e00\u81f4\u3002", (String)"CashFlowItemSaveVaildator_29", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                return errors;
            }
            String parentDirection = parent.getString("direction");
            if (!"b".equals(parentDirection) && !(direction2 = item.getString("direction")).equals(parentDirection)) {
                String directionName = this.getDirectionName(parentDirection);
                errors = String.format(ResManager.loadKDString((String)"\u5f53\u4e0a\u7ea7\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u7684\u73b0\u91d1\u6d41\u5411\u662f%1$s\u65f6\uff0c\u4e0b\u7ea7\u7684\u73b0\u91d1\u6d41\u5411\u5e94\u8be5\u4fdd\u6301\u4e00\u81f4\u3002", (String)"CashFlowItemSaveVaildator_27", (String)"fi-bd-opplugin", (Object[])new Object[0]), directionName);
                return errors;
            }
            boolean isexchangerate = item.getBoolean("isexchangerate");
            boolean parentIsexchangerate = parent.getBoolean("isexchangerate");
            if (parentIsexchangerate && !isexchangerate) {
                return ResManager.loadKDString((String)"\u4e0a\u7ea7\u52fe\u9009\u6c47\u7387\u53d8\u52a8\u65f6\uff0c\u4e0b\u7ea7\u4e0d\u80fd\u53d6\u6d88\u52fe\u9009\u3002", (String)"CashFlowItemSaveVaildator_34", (String)"fi-bd-opplugin", (Object[])new Object[0]);
            }
            boolean notice = item.getBoolean("notice");
            boolean pnotice = parent.getBoolean("notice");
            if (pnotice && !notice) {
                return ResManager.loadKDString((String)"\u4e0a\u7ea7\u52fe\u9009\u901a\u77e5\u5355\u5c5e\u6027\u65f6\uff0c\u4e0b\u7ea7\u4e0d\u80fd\u53d6\u6d88\u52fe\u9009\u3002", (String)"CashFlowItemSaveVaildator_24", (String)"fi-gl-opplugin", (Object[])new Object[0]);
            }
            if (item.getBoolean("isexchangerate") != parent.getBoolean("isexchangerate")) {
                errors = ResManager.loadKDString((String)"\u4e0a\u4e0b\u7ea7\u6c47\u7387\u53d8\u52a8\u9700\u4fdd\u6301\u4e00\u81f4\u3002", (String)"CashFlowItemSaveVaildator_33", (String)"fi-bd-opplugin", (Object[])new Object[0]);
            }
        }
        if (item.getDataEntityState().getFromDatabase() && !"b".equalsIgnoreCase(direction = item.getString("direction")) && !direction.equals(this.cfMap.get(item.getLong("id")).getDirection())) {
            QFilter forg = BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)item.getLong("createorg_id"));
            QFilter fnumber = new QFilter("longnumber", "like", (Object)item.getString("longnumber"));
            DynamicObjectCollection col = QueryServiceHelper.query((String)"gl_cashflowitem", (String)"id,direction,assistentry.asstypeid,assistentry.isdetail,assistentry.isrequire", (QFilter[])new QFilter[]{forg, fnumber});
            for (DynamicObject dyn : col) {
                if (dyn.getString("direction").equals(direction) || dyn.getLong("id") == item.getLong("id")) continue;
                String directionName = this.getDirectionName(dyn.getString("direction"));
                return String.format(ResManager.loadKDString((String)"\u4e0b\u7ea7\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u5b58\u5728\u6d41\u5411\u662f%1$s\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u5f53\u524d\u73b0\u91d1\u6d41\u91cf\u6d41\u5411", (String)"CashFlowItemSaveVaildator_24", (String)"fi-gl-opplugin", (Object[])new Object[0]), directionName);
            }
        }
        if ((result = (check = new CashflowPropertyCheck()).saveCheck(item, CashflowItemOptionVarManager.isOnlyValidate((OperateOption)this.getOption()), item.getLong("useorg_id"))).getStatus() != CashflowPropertyCheck.Status.SUCCESS) {
            return result.getErrorMsg();
        }
        return errors;
    }

    private String getDirectionName(String direction) {
        if ("i".equals(direction)) {
            return ResManager.loadKDString((String)"\u73b0\u91d1\u6d41\u5165", (String)"CashFlowItemSaveVaildator_38", (String)"fi-bd-opplugin", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u73b0\u91d1\u6d41\u51fa", (String)"CashFlowItemSaveVaildator_39", (String)"fi-bd-opplugin", (Object[])new Object[0]);
    }

    private String selfInfoValidate(DynamicObject item) {
        Date endDate;
        String errors = "";
        errors = this.checkAssistDuplicate(item);
        if (StringUtils.isEmpty((CharSequence)errors) && (endDate = item.getDate("enddate")).before(CashflowItemVersionUtil.getEndDate())) {
            errors = ResManager.loadKDString((String)"\u5f53\u524d\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u4e0d\u662f\u6700\u65b0\u7248\u672c\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u518d\u7ee7\u7eed\u64cd\u4f5c\u3002", (String)"CashFlowItemSaveVaildator_32", (String)"fi-bd-opplugin", (Object[])new Object[0]);
        }
        if (StringUtils.isEmpty((CharSequence)errors) && item.getString("number").contains("_")) {
            errors = ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u5141\u8bb8\u5305\u542b\u4e0b\u5212\u7ebf\u201c_\u201d\u3002", (String)"CashFlowItemSaveVaildator_52", (String)FibdApp.instance.oppluginModule(), (Object[])new Object[0]);
        }
        if (StringUtils.isEmpty((CharSequence)errors)) {
            errors = this.checkNotice(item);
        }
        if (StringUtils.isEmpty((CharSequence)errors)) {
            errors = this.checkNumberRepeat(item);
        }
        if (StringUtils.isEmpty((CharSequence)errors)) {
            errors = this.levelControl(item);
        }
        if (StringUtils.isEmpty((CharSequence)errors)) {
            errors = this.suppCheck(item);
        }
        if (StringUtils.isEmpty((CharSequence)errors)) {
            boolean versionByself;
            boolean isVersion = CashflowItemOptionVarManager.isVersion((OperateOption)this.getOption());
            String ctrlStrategy = item.getString("ctrlstrategy");
            boolean free_assign = "2".equalsIgnoreCase(ctrlStrategy);
            if (isVersion && free_assign) {
                return ResManager.loadKDString((String)"\u81ea\u7531\u5206\u914d\u7b56\u7565\u7684\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u6682\u4e0d\u652f\u6301\u7248\u672c\u5316\u529f\u80fd\u3002", (String)"CashFlowItemSaveVaildator_14", (String)"fi-bd-opplugin", (Object[])new Object[0]);
            }
            boolean isShareOrPrivate = "5".equals(ctrlStrategy) || "6".equals(ctrlStrategy) || "7".equals(ctrlStrategy);
            boolean bl = versionByself = item.getLong("createorg_id") == item.getLong("useorg_id");
            if (isShareOrPrivate && !versionByself) {
                return ResManager.loadKDString((String)"\u5171\u4eab\u7b56\u7565\u548c\u79c1\u6709\u7b56\u7565\u4e0b\uff0c\u53ea\u80fd\u7531\u521b\u5efa\u7ec4\u7ec7\u8fdb\u884c\u7248\u672c\u5316\u3002", (String)"CashFlowItemSaveVaildator_15", (String)"fi-bd-opplugin", (Object[])new Object[0]);
            }
            if ("3".equals(item.getString("type")) && item.getBoolean("isexchangerate")) {
                return ResManager.loadKDString((String)"\u6c47\u7387\u53d8\u52a8\u5c5e\u6027\u53ea\u5141\u8bb8\u4e3b\u8868\u9879\u76ee\u52fe\u9009\u3002", (String)"CashFlowItemSaveVaildator_16", (String)"fi-bd-opplugin", (Object[])new Object[0]);
            }
            if (item.getDataEntityState().getFromDatabase()) {
                if (!item.getString("isdealactivity").equals(this.dbDataEntity.get(item.getLong("id")).getString("isdealactivity"))) {
                    return ResManager.loadKDString((String)"\u7ecf\u8425\u6d3b\u52a8\u5c5e\u6027\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"CashFlowItemSaveVaildator_17", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                }
                if (!item.getString("name").equals(this.dbDataEntity.get(item.getLong("id")).getString("name"))) {
                    if (this.disableModifyNameProperty(item)) {
                        return ResManager.loadKDString((String)"\u5f53\u524d\u9879\u76ee\u4e3a\u975e\u660e\u7ec6\u6216\u4e0b\u7ea7\u505a\u8fc7\u4e2a\u6027\u5316\uff0c\u540d\u79f0\u5c5e\u6027\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"CashFlowItemSaveVaildator_18", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                    }
                    CashflowItemOptionVarManager.setIsVersion((OperateOption)this.getOption(), (boolean)true);
                }
                if (!item.getString("number").equals(this.dbDataEntity.get(item.getLong("id")).getString("number"))) {
                    return ResManager.loadKDString((String)"\u7f16\u7801\u5c5e\u6027\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"CashFlowItemSaveVaildator_19", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                }
            }
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"gl_cashflowitem");
            TextProp property = (TextProp)entityType.getProperty("longnumber");
            int maxLenth = property.getMaxLenth();
            if (item.getString("longnumber").length() > maxLenth) {
                return ResManager.loadKDString((String)"\u957f\u7f16\u7801\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7%1$s\u3002", (String)"CashFlowItemSaveVaildator_20", (String)"fi-bd-opplugin", (Object[])new Object[]{maxLenth});
            }
        }
        return errors;
    }

    private boolean disableModifyNameProperty(DynamicObject item) {
        if (!item.getBoolean("isleaf")) {
            return true;
        }
        List orgIds = OrgServiceHelper.getAllSubordinateOrgs((String)"10", Collections.singletonList(item.getLong("useorg_id")), (boolean)false);
        Set indivisionOrgIds = CashflowRelationFactory.get().queryIndivisionOrgIds(item.getLong("id"), orgIds);
        if (indivisionOrgIds != null && !indivisionOrgIds.isEmpty()) {
            logger.info("indivisionOrgIds:{}", (Object)indivisionOrgIds);
            return true;
        }
        return false;
    }

    private String suppCheck(DynamicObject item) {
        String error = "";
        String type = item.getString("type");
        boolean isdealactivity = item.getBoolean("isdealactivity");
        boolean isprefit = item.getBoolean("isprefit");
        String level = item.getString("level");
        if ("3".equals(type)) {
            if (isdealactivity) {
                error = ResManager.loadKDString((String)"\u8865\u5145\u8d44\u6599\u9879\u76ee\u4e0d\u80fd\u52fe\u9009\u7ecf\u8425\u6d3b\u52a8\u3002", (String)"CashFlowItemSaveVaildator_21", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                return error;
            }
        } else {
            boolean isscheduleitem = item.getBoolean("isscheduleitem");
            if (isscheduleitem) {
                return ResManager.loadKDString((String)"\u53ea\u6709\u9879\u76ee\u7c7b\u522b\u4e3a\u8865\u5145\u8d44\u6599\u9879\u76ee\u65f6,\u624d\u53ef\u4ee5\u52fe\u9009\u9644\u8868\u9879\u76ee\u3002", (String)"CashFlowItemSaveVaildator_22", (String)"fi-bd-opplugin", (Object[])new Object[0]);
            }
        }
        if (("1".equals(type) || !"3".equals(level)) && isprefit) {
            error = ResManager.loadKDString((String)"\u53ea\u6709\u4e09\u7ea7\u8865\u5145\u8d44\u6599\u9879\u76ee\u624d\u53ef\u52fe\u9009\u51c0\u5229\u6da6\u3002", (String)"CashFlowItemSaveVaildator_23", (String)"fi-bd-opplugin", (Object[])new Object[0]);
            return error;
        }
        return error;
    }

    private String checkAssistDuplicate(DynamicObject cashflow) {
        String type;
        String errors = "";
        DynamicObjectCollection col = cashflow.getDynamicObjectCollection("assistentry");
        ArrayList<String> assists = new ArrayList<String>(col.size());
        HashMap<Long, DynamicObject> checkitemMap = new HashMap<Long, DynamicObject>(col.size());
        for (DynamicObject entry : col) {
            DynamicObject asstype = entry.getDynamicObject("asstypeid");
            if (asstype == null) {
                if (entry.get("isrequire") == null && entry.get("isdetail") == null) continue;
                return ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6\u5206\u5f55\u4e2d\uff0c\u5f53\u6838\u7b97\u7ef4\u5ea6\u660e\u7ec6\u4e3a\u7a7a\u65f6\uff0c\u5fc5\u5f55\u548c\u975e\u660e\u7ec6\u4e5f\u5e94\u4e3a\u7a7a\u3002", (String)"CashFlowItemSaveVaildator_12", (String)"fi-bd-opplugin", (Object[])new Object[0]);
            }
            checkitemMap.put(entry.getDynamicObject("asstypeid").getLong("id"), entry);
            String assist = asstype.getString("flexfield");
            if (assists.contains(assist)) {
                errors = ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"CashFlowItemSaveVaildator_0", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                break;
            }
            assists.add(assist);
        }
        if ("3".equals(type = cashflow.getString("type")) && !checkitemMap.isEmpty()) {
            return ResManager.loadKDString((String)"\u53ea\u6709\u9879\u76ee\u7c7b\u522b\u4e3a\u4e3b\u8868\u9879\u76ee\u65f6\uff0c\u624d\u5141\u8bb8\u6dfb\u52a0\u6838\u7b97\u7ef4\u5ea6\u3002", (String)"CashFlowItemSaveVaildator_24", (String)"fi-bd-opplugin", (Object[])new Object[0]);
        }
        if (checkitemMap.size() > 8) {
            return String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6\u4e0d\u80fd\u8d85\u8fc7%s\u4e2a\u3002", (String)"CashFlowItemSaveVaildator_25", (String)"fi-bd-opplugin", (Object[])new Object[0]), 8);
        }
        boolean notice = cashflow.getBoolean("notice");
        if (notice && checkitemMap.isEmpty()) {
            return ResManager.loadKDString((String)"\u5f53\u524d\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u6ca1\u6709\u8bbe\u7f6e\u6838\u7b97\u7ef4\u5ea6\uff0c\u4e0d\u80fd\u52fe\u9009\u901a\u77e5\u5355\u3002", (String)"CashFlowItemSaveVaildator_26", (String)"fi-bd-opplugin", (Object[])new Object[0]);
        }
        return errors;
    }

    private String levelControl(DynamicObject cashflowItem) {
        long useorgId = cashflowItem.getLong("useorg_id");
        long level = cashflowItem.getLong("level");
        if (level == 1L && useorgId != this.rootOrgId && !cashflowItem.getDataEntityState().getFromDatabase()) {
            return ResManager.loadKDString((String)"\u4e00\u7ea7\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u53ea\u80fd\u5728\u96c6\u56e2\u7ec4\u7ec7\u521b\u5efa\u3002", (String)"CashFlowItemSaveVaildator_31", (String)"fi-bd-opplugin", (Object[])new Object[0]);
        }
        return "";
    }

    private String checkNumberRepeat(DynamicObject item) {
        QFilter forg = BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)item.getLong("useorg_id"));
        QFilter fnum = new QFilter("number", "=", (Object)item.getString("number"));
        HashSet<Long> masterId = new HashSet<Long>();
        DataSet set = QueryServiceHelper.queryDataSet((String)"CashflwoSaveValidator#checkNumberRepeat", (String)"gl_cashflowitem", (String)"masterid", (QFilter[])new QFilter[]{forg, fnum}, null);
        for (Row row : set) {
            masterId.add(row.getLong("masterid"));
        }
        String error = "";
        if (item.getLong("id") == 0L || !item.getDataEntityState().getFromDatabase()) {
            if (!masterId.isEmpty()) {
                error = ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"CashFlowItemSaveVaildator_36", (String)"fi-bd-opplugin", (Object[])new Object[0]);
            }
        } else if (!(this.dbDataEntity.get(item.getLong("id")).getString("number").equals(item.getString("number")) || masterId.isEmpty() || masterId.contains(item.getLong("masterid")))) {
            error = ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"CashFlowItemSaveVaildator_36", (String)"fi-bd-opplugin", (Object[])new Object[0]);
        }
        return error;
    }

    private String checkNotice(DynamicObject object) {
        DynamicObjectCollection checkitementry = object.getDynamicObjectCollection("assistentry");
        HashMap<Long, DynamicObject> checkitemMap = new HashMap<Long, DynamicObject>(checkitementry.size());
        for (DynamicObject checkitem : checkitementry) {
            if (checkitem.getDynamicObject("asstypeid") == null) continue;
            checkitemMap.put(checkitem.getDynamicObject("asstypeid").getLong("id"), checkitem);
        }
        boolean notice = object.getBoolean("notice");
        if (notice && checkitemMap.isEmpty()) {
            return ResManager.loadKDString((String)"\u5f53\u524d\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u6ca1\u6709\u8bbe\u7f6e\u6838\u7b97\u7ef4\u5ea6\uff0c\u4e0d\u80fd\u52fe\u9009\u901a\u77e5\u5355\u3002", (String)"CashFlowItemSaveVaildator_35", (String)"fi-bd-opplugin", (Object[])new Object[0]);
        }
        return "";
    }

    private void resetLongStr(DynamicObject cashflow) {
        ILocaleString name = (ILocaleString)cashflow.get("name");
        ILocaleString fullname = (ILocaleString)cashflow.get("fullname");
        if (name != null) {
            LocaleString currentFullName = new LocaleString();
            DynamicObject parent = cashflow.getDynamicObject("parent");
            if (parent != null) {
                ILocaleString pcurrentFullName = parent.getLocaleString("fullname");
                for (Map.Entry nameEntry : pcurrentFullName.entrySet()) {
                    String key = (String)nameEntry.getKey();
                    String value = (String)nameEntry.getValue();
                    if (StringUtils.isEmpty((CharSequence)value)) continue;
                    fullname.put((Object)key, (Object)StringUtils.join((Object[])new Object[]{pcurrentFullName.get((Object)key), name.get((Object)key)}, (String)"@"));
                }
                String parentLongnumber = parent.getString("longnumber");
                String currentLongnumber = parentLongnumber + "@" + cashflow.getString("number");
                cashflow.set("longnumber", (Object)currentLongnumber);
            } else {
                for (Map.Entry nameEntry : fullname.entrySet()) {
                    String key = (String)nameEntry.getKey();
                    String value = (String)nameEntry.getValue();
                    if (StringUtils.isEmpty((CharSequence)value)) continue;
                    currentFullName.put((Object)key, name.get((Object)key));
                }
                cashflow.set("longnumber", cashflow.get("number"));
            }
            cashflow.set("fullname", (Object)fullname);
        }
    }
}

