/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.opplugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.bd.cashflow.CashflowRelationFactory;
import kd.fi.bd.opplugin.CashflowItemDeleteValidator;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.bd.util.CashflowItemCheckUtil;
import kd.fi.bd.util.CashflowItemVersionUtil;

public class CashflowItemDeleteOp
extends AbstractOperationServicePlugIn {
    private static final DBRoute DB_ROUTE = DBRoute.of((String)"gl");

    public void onAddValidators(AddValidatorsEventArgs e) {
        String appendIds = BillParamUtil.getStringValue((String)"P9H6JC5EVP1", (String)"fi.bd.account.delete.ignorerefentityids", (String)"gl_voucher");
        Set<String> ignorerefSet = this.getIgnoreref();
        Collections.addAll(ignorerefSet, appendIds.split(","));
        appendIds = String.join((CharSequence)",", ignorerefSet);
        this.getOption().setVariableValue("ignorerefentityids", appendIds);
        super.onAddValidators(e);
        e.getValidators().add(new CashflowItemDeleteValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List keys = e.getFieldKeys();
        keys.add("org");
        keys.add("createorg");
        keys.add("startdate");
        keys.add("enddate");
        keys.add("level");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        for (DynamicObject dyn : e.getDataEntities()) {
            long userOrgId;
            QFilter fcreateOrg;
            String number = dyn.getString("number");
            QFilter fnumber = new QFilter("number", "=", (Object)number);
            DynamicObjectCollection objs = QueryServiceHelper.query((String)"", (String)"gl_cashflowitem", (String)"id,startdate", (QFilter[])new QFilter[]{fnumber, fcreateOrg = new QFilter("createorg", "=", (Object)(userOrgId = dyn.getLong("createorg_id")))}, (String)"startdate");
            if (!objs.isEmpty()) {
                String sql1 = "update t_gl_cashflowitem set fenddate = ? where fid = ?";
                DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)sql1, (Object[])new Object[]{CashflowItemVersionUtil.getEndDate(), ((DynamicObject)objs.get(objs.size() - 1)).getLong("id")});
            } else {
                DynamicObject parent = dyn.getDynamicObject("parent");
                if (parent != null && dyn.getDate("startdate").compareTo(CashflowItemVersionUtil.getBeginDate()) != 0) {
                    DynamicObjectCollection objects;
                    QFilter forg;
                    QFilter flevel;
                    String longNum = dyn.getString("longnumber");
                    number = longNum.substring(0, longNum.lastIndexOf("@"));
                    userOrgId = dyn.getLong("createorg_id");
                    QFilter fnum_like = new QFilter("longnumber", "like", (Object)(number + "@%"));
                    boolean isExistLeaf = QueryServiceHelper.exists((String)"gl_cashflowitem", (QFilter[])new QFilter[]{fnum_like, flevel = new QFilter("level", "=", (Object)dyn.getInt("level")), forg = BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)userOrgId)});
                    if (!isExistLeaf && (objects = QueryServiceHelper.query((String)"", (String)"gl_cashflowitem", (String)"id,startdate", (QFilter[])new QFilter[]{fnumber = new QFilter("number", "=", (Object)parent.getString("number")), fcreateOrg = new QFilter("createorg", "=", (Object)userOrgId)}, (String)"startdate")).size() >= 2) {
                        DeleteServiceHelper.delete((IDataEntityType)dyn.getDataEntityType(), (Object[])new Object[]{((DynamicObject)objects.get(objects.size() - 1)).getLong("id")});
                        String sql1 = "update t_gl_cashflowitem set fenddate = ? where fid = ?";
                        DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)sql1, (Object[])new Object[]{CashflowItemVersionUtil.getEndDate(), ((DynamicObject)objects.get(objects.size() - 2)).getLong("id")});
                    }
                }
            }
            this.delRelateExcRecord(dyn);
        }
    }

    private void delRelateExcRecord(DynamicObject dyo) {
        long useOrgId = Long.parseLong(this.getOption().getVariableValue("createOrg"));
        long masterId = dyo.getLong("masterid");
        long itemId = dyo.getLong("id");
        String number = dyo.getString("number");
        if (CashflowItemVersionUtil.personalize((Long)useOrgId, (Long)masterId, (Long)itemId, (String)number)) {
            HashSet<Long> delDataIds = new HashSet<Long>();
            Set<Long> sameMasterDataIds = QueryServiceHelper.query((String)"gl_cashflowitem", (String)"id", (QFilter[])new QFilter[]{new QFilter("masterid", "=", (Object)masterId), new QFilter("number", "=", (Object)number)}).stream().map(d -> d.getLong("id")).collect(Collectors.toSet());
            if (!sameMasterDataIds.isEmpty()) {
                this.constructDelData(sameMasterDataIds, delDataIds, useOrgId, useOrgId);
                if (!delDataIds.isEmpty()) {
                    Set assignOrgIds = CashflowRelationFactory.get().queryAssignOrgIds(itemId);
                    if (!assignOrgIds.isEmpty()) {
                        SqlBuilder sql = new SqlBuilder();
                        sql.appendIn("delete from t_gl_cashflowitemexc where fdataid", delDataIds.toArray());
                        sql.appendIn("AND fuseorgid", assignOrgIds.toArray());
                        DB.execute((DBRoute)DB_ROUTE, (SqlBuilder)sql);
                        List insertParams = assignOrgIds.stream().map(orgId -> delDataIds.stream().map(dataid -> new Object[]{dataid, orgId}).collect(Collectors.toList())).collect(ArrayList::new, (r, x) -> r.addAll(x), ArrayList::addAll);
                        if (!insertParams.isEmpty()) {
                            DB.executeBatch((DBRoute)DB_ROUTE, (String)"delete from t_gl_cashflowitem_u where fdataid = ? and fuseorgid = ?", (List)insertParams);
                            DB.executeBatch((DBRoute)DB_ROUTE, (String)"insert into t_gl_cashflowitem_u(fdataid,fuseorgid) values(?,?)", (List)insertParams);
                        }
                    }
                } else {
                    SqlBuilder dataUseRangeSql = new SqlBuilder();
                    dataUseRangeSql.appendIn("delete from t_gl_cashflowitemusereg where fdataid", sameMasterDataIds.toArray());
                    dataUseRangeSql.append("and fuseorgid = ?", new Object[]{useOrgId});
                    DB.execute((DBRoute)DB_ROUTE, (SqlBuilder)dataUseRangeSql);
                    dataUseRangeSql = new SqlBuilder();
                    dataUseRangeSql.appendIn("delete from t_gl_cashflowitemexc where fdataid", sameMasterDataIds.toArray());
                    dataUseRangeSql.append("and fuseorgid = ?", new Object[]{useOrgId});
                    DB.execute((DBRoute)DB_ROUTE, (SqlBuilder)dataUseRangeSql);
                    dataUseRangeSql = new SqlBuilder();
                    dataUseRangeSql.appendIn("delete from t_gl_cashflowitem_u where fdataid", sameMasterDataIds.toArray());
                    dataUseRangeSql.append("and fuseorgid = ?", new Object[]{useOrgId});
                    DB.execute((DBRoute)DB_ROUTE, (SqlBuilder)dataUseRangeSql);
                }
            }
        }
    }

    private void constructDelData(Set<Long> sameMasterDataIds, Set<Long> delDataIds, long iterUseOrgId, long useOrgId) {
        long parentOrg = CashflowItemCheckUtil.getParentOrgId((Object)iterUseOrgId);
        if (parentOrg == 0L) {
            return;
        }
        Set itemIds = CashflowRelationFactory.get().queryExcnDataIds(parentOrg, sameMasterDataIds);
        if (itemIds.size() == 0) {
            this.constructDelData(sameMasterDataIds, delDataIds, parentOrg, useOrgId);
        } else {
            Set dataIds = CashflowRelationFactory.get().queryAssignDataIds(useOrgId, itemIds);
            if (dataIds.size() == 0) {
                this.constructDelData(sameMasterDataIds, delDataIds, parentOrg, useOrgId);
            } else {
                delDataIds.addAll(itemIds);
            }
        }
    }

    private Set<String> getIgnoreref() {
        Object row2;
        HashSet<String> ignorerefSet = new HashSet<String>(20);
        ignorerefSet.add("gl_voucher");
        ignorerefSet.add("gl_voucher_ajust");
        ignorerefSet.add("gl_voucher_cashflowedit");
        ignorerefSet.add("gl_voucher_ref");
        ignorerefSet.add("gl_cashflow");
        ignorerefSet.add("gl_cashflow_log");
        ignorerefSet.add("gl_initcashflow");
        ignorerefSet.add("gl_initacccurrent");
        ignorerefSet.add("gl_acnotice");
        ignorerefSet.add("gl_acccurrent");
        ignorerefSet.add("ai_bizvoucher");
        ignorerefSet.add("ict_relcfrecord");
        ignorerefSet.add("ai_voucher");
        ignorerefSet.add("fr_manualtallybill");
        ignorerefSet.add("gl_cfnotice");
        ignorerefSet.add("gl_templatevoucher");
        ignorerefSet.add("gl_voucher_mid");
        String ignorerefentitycheck = BillParamUtil.getStringValue((String)"P9H6JC5EVP1", (String)"fi.bd.account.delete.ignorerefentitycheck", (String)"check");
        if (!ignorerefentitycheck.equals("check")) {
            return ignorerefSet;
        }
        SqlBuilder allOutFiEntityIdSql = new SqlBuilder();
        allOutFiEntityIdSql.append("select distinct re.fobjecttypeid", new Object[0]);
        allOutFiEntityIdSql.append("from t_meta_objecttyperef as re", new Object[0]);
        allOutFiEntityIdSql.append("inner join T_META_BIZUNITRELFORM as bf on bf.fformid =re.fentityid", new Object[0]);
        allOutFiEntityIdSql.append("inner join t_meta_bizapp as bizapp on bizapp.fid=bf.fbizappid", new Object[0]);
        allOutFiEntityIdSql.append("inner join t_meta_bizcloud as bizcloud on bizapp.fbizcloudid=bizcloud.fid", new Object[0]);
        allOutFiEntityIdSql.append("WHERE re.frefobjecttypeid='gl_cashflowitem'", new Object[0]);
        allOutFiEntityIdSql.append("and bizcloud.fnumber != 'FI'", new Object[0]);
        allOutFiEntityIdSql.append("and re.ftablename != ''", new Object[0]);
        allOutFiEntityIdSql.append("and re.ftablename != ' '", new Object[0]);
        try (DataSet dataSet = DB.queryDataSet((String)"CashflowItemDeleteOp", (DBRoute)DBRoute.of((String)"sys.meta"), (SqlBuilder)allOutFiEntityIdSql);){
            for (Object row2 : dataSet) {
                ignorerefSet.add(row2.getString("fobjecttypeid"));
            }
        }
        HashSet<String> ignorerefTablename = new HashSet<String>(20);
        SqlBuilder findTableName = new SqlBuilder();
        findTableName.appendIn("select distinct ftablename from t_meta_entityinfo where fid", new ArrayList<String>(ignorerefSet));
        DataSet dataSet = DB.queryDataSet((String)"CashflowItemDeleteOp", (DBRoute)DBRoute.of((String)"sys.meta"), (SqlBuilder)findTableName);
        row2 = null;
        try {
            for (Row row3 : dataSet) {
                ignorerefTablename.add(row3.getString("ftablename"));
            }
        }
        catch (Throwable throwable) {
            row2 = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (row2 != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)row2).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        if (ignorerefTablename.size() > 0) {
            SqlBuilder sb = new SqlBuilder();
            sb.append("select distinct fobjecttypeid", new Object[0]);
            sb.append("from t_meta_objecttyperef", new Object[0]);
            sb.append("WHERE frefobjecttypeid ='gl_cashflowitem' ", new Object[0]);
            sb.appendIn("and ftablename", new ArrayList(ignorerefTablename));
            DataSet dataSet2 = DB.queryDataSet((String)"CashflowItemDeleteOp", (DBRoute)DBRoute.of((String)"sys.meta"), (SqlBuilder)sb);
            Object object = null;
            try {
                for (Row row4 : dataSet2) {
                    ignorerefSet.add(row4.getString("fobjecttypeid"));
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (dataSet2 != null) {
                    if (object != null) {
                        try {
                            dataSet2.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        dataSet2.close();
                    }
                }
            }
        }
        return ignorerefSet;
    }
}

