/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.opplugin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.form.plugin.bdctrl.BaseDataEnableValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.bd.opplugin.CashflowItemEnableValidator;

public class CashflowItemEnablePlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("parent");
        e.getFieldKeys().add("enable");
        e.getFieldKeys().add("masterid");
        e.getFieldKeys().add("createorg");
        e.getFieldKeys().add("longnumber");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        BaseDataEnableValidator validator = new BaseDataEnableValidator();
        String entityKey = this.billEntityType.getName();
        validator.setEntityKey(entityKey);
        e.addValidator((AbstractValidator)validator);
        e.addValidator((AbstractValidator)new CashflowItemEnableValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        ArrayList<Object> subItems = new ArrayList<Object>();
        for (DynamicObject item : e.getDataEntities()) {
            Long id = item.getLong("id");
            Long userOrgId = item.getLong("createorg_id");
            subItems.addAll(this.getAllSubAccts(item, userOrgId));
        }
        Set itemIds = subItems.stream().collect(Collectors.toCollection(HashSet::new));
        this.batchEnable(itemIds);
    }

    private List<Object> getAllSubAccts(DynamicObject curAcct, long curOrgId) {
        ArrayList<Long> paramOrg = new ArrayList<Long>();
        paramOrg.add(curOrgId);
        List orgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((String)"10", paramOrg, (boolean)true);
        QFilter qnumber = new QFilter("longnumber", "like", (Object)(curAcct.get("longnumber") + "%"));
        QFilter qorg = new QFilter("createorg", "in", (Object)orgIds);
        return QueryServiceHelper.queryPrimaryKeys((String)"gl_cashflowitem", (QFilter[])new QFilter[]{qorg, qnumber}, null, (int)-1);
    }

    private void batchEnable(Set<Object> itemIds) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"gl_cashflowitem");
        DynamicObject[] itemObjs = BusinessDataServiceHelper.load((Object[])itemIds.toArray(new Long[0]), (DynamicObjectType)type);
        ArrayList<DynamicObject> recordList = new ArrayList<DynamicObject>(itemObjs.length);
        for (DynamicObject entity : itemObjs) {
            entity.set("enable", (Object)"1");
            recordList.add(entity);
        }
        BusinessDataWriter.update((IDataEntityType)type, (Object[])recordList.toArray(new DynamicObject[0]));
        this.operationResult.setSuccess(true);
    }
}

