/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.opplugin.accountingsys;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.util.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgApiResult;
import kd.bos.org.model.OrgParam;
import kd.bos.org.model.ViewSchemaParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.bd.accsyscache.AccSysModelCacheService;
import kd.fi.bd.opplugin.accountingsys.AccountingSysAddViewSaveValidator;

public class AccountingSysAddViewSaveOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(AbstractOperationServicePlugIn.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new AccountingSysAddViewSaveValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        Map variables = this.getOption().getVariables();
        String deletenode = this.getOption().getVariableValue("deletenode", null);
        String viewschemanumber = this.getOption().getVariableValue("viewschemanumber", null);
        String accountingsysId = this.getOption().getVariableValue("accountingsys_id", null);
        String rootnode = this.getOption().getVariableValue("rootnode", null);
        String savenode = this.getOption().getVariableValue("savenode", null);
        for (DynamicObject dataEntity : e.getDataEntities()) {
            try (TXHandle h1 = TX.requiresNew((String)"AccountingSysAddViewSaveOp");){
                try {
                    boolean fromDatabase;
                    Long pkId = 0L;
                    boolean bl = fromDatabase = Long.parseLong(accountingsysId) != 0L;
                    if (fromDatabase) {
                        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dataEntity});
                        pkId = (Long)dataEntity.getPkValue();
                    } else {
                        DynamicObject[] saveDb = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataEntity});
                        pkId = saveDb[0].getLong("id");
                    }
                    try (TXHandle h2 = TX.requiresNew((String)"AccountingSysAddViewSaveOp");){
                        try {
                            this.addViewSchema(pkId, accountingsysId, viewschemanumber, dataEntity.getString("name"));
                            this.addDutyRoot(rootnode, viewschemanumber);
                            this.saveDuty(pkId, viewschemanumber, savenode, deletenode);
                        }
                        catch (Exception e1) {
                            h2.markRollback();
                            logger.error(e1.getMessage(), (Throwable)e1);
                            throw new KDBizException(e1.getMessage());
                        }
                    }
                }
                catch (Exception exc) {
                    logger.info(exc.toString());
                    h1.markRollback();
                    throw exc;
                }
            }
            finally {
                this.clearCahce();
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        this.clearCahce();
    }

    private void clearCahce() {
        AccSysModelCacheService accSysModelCacheService = new AccSysModelCacheService();
        accSysModelCacheService.clear();
    }

    private void saveDuty(Long pkId, String viewschemanumber, String savenode, String deletenode) {
        StringBuilder sb = new StringBuilder();
        List<Object> orgParams = new ArrayList(10);
        if (StringUtils.isNotEmpty((String)savenode)) {
            Map saveNodeMap = (Map)SerializationUtils.fromJsonString((String)savenode, Map.class);
            orgParams = this.constructStruc(saveNodeMap, viewschemanumber);
        }
        DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bos_org_structure", (String)"org,parent,enable,isfreeze", (QFilter[])new QFilter("view", "=", (Object)pkId).toArray());
        ArrayList<OrgParam> updateParam = new ArrayList<OrgParam>(10);
        ArrayList<OrgParam> addParam = new ArrayList<OrgParam>(10);
        HashMap<Long, DynamicObject> existMap = new HashMap<Long, DynamicObject>(16);
        for (Object org : orgs) {
            existMap.put(org.getLong("org"), (DynamicObject)org);
        }
        HashSet<Long> orgIds = new HashSet<Long>(10);
        if (orgParams.size() > 0) {
            for (OrgParam orgParam : orgParams) {
                orgIds.add(orgParam.getId());
                if (existMap.containsKey(orgParam.getId())) {
                    DynamicObject existObj = (DynamicObject)existMap.get(orgParam.getId());
                    if (orgParam.getParentId() == existObj.getLong("parent")) continue;
                    updateParam.add(orgParam);
                    continue;
                }
                addParam.add(orgParam);
            }
            OrgUnitServiceHelper.addDuty(addParam);
            OrgUnitServiceHelper.addOrUpdate(updateParam);
            this.getReslutInfo(sb, updateParam);
            this.getReslutInfo(sb, addParam);
        }
        if (deletenode != null) {
            List deletes = (List)SerializationUtils.fromJsonString((String)deletenode, List.class);
            ArrayList<OrgParam> arrayList = new ArrayList<OrgParam>(deletes.size());
            for (String delete : deletes) {
                DynamicObject existObj;
                if (orgIds.contains(Long.parseLong(delete)) || existMap.containsKey(Long.parseLong(delete)) && (!(existObj = (DynamicObject)existMap.get(Long.parseLong(delete))).getBoolean("enable") || existObj.getBoolean("isfreeze"))) continue;
                OrgParam o = new OrgParam();
                o.setDuty(viewschemanumber);
                o.setId(Long.parseLong(delete));
                arrayList.add(o);
            }
            OrgUnitServiceHelper.deleteDuty(arrayList);
            this.getReslutInfo(sb, arrayList);
        }
        if (sb.length() > 0) {
            throw new KDBizException(sb.toString());
        }
    }

    private void getReslutInfo(StringBuilder sb, List<OrgParam> orgPar) {
        for (OrgParam orgParam : orgPar) {
            if (orgParam.isSuccess()) continue;
            sb.append(orgParam.getMsg());
        }
    }

    private void addViewSchema(Long pkId, String accountingsysId, String viewschemanumber, String viewschemaname) throws Exception {
        Long newId;
        boolean isEdit;
        ViewSchemaParam view = new ViewSchemaParam();
        view.setNumber(viewschemanumber);
        view.setName(viewschemaname);
        view.setViewType("10");
        Long id = Long.parseLong(accountingsysId);
        boolean bl = isEdit = !id.equals(0L);
        if (isEdit) {
            newId = id;
            view.setId(newId.longValue());
        } else {
            newId = pkId;
        }
        view.setCustomId(newId.longValue());
        logger.info(view.getViewType());
        OrgApiResult result = OrgUnitServiceHelper.saveOrgViewSchema((ViewSchemaParam)view);
        if (!result.isSuccess()) {
            throw new Exception(result.getErrorMsg());
        }
    }

    private void addDutyRoot(String rootnode, String viewschemanumber) {
        if (StringUtils.isEmpty((String)rootnode)) {
            throw new KDBizException("rootnode is null");
        }
        List rootnodes = (List)SerializationUtils.fromJsonString((String)rootnode, List.class);
        OrgParam param = new OrgParam();
        param.setId(Long.parseLong((String)rootnodes.get(0)));
        param.setDuty(viewschemanumber);
        String parentId = (String)rootnodes.get(1);
        param.setParentId(parentId.equals("") ? 0L : Long.parseLong(parentId));
        OrgUnitServiceHelper.addDutyRoot((OrgParam)param);
        if (!param.isSuccess()) {
            throw new KDBizException(param.getMsg());
        }
    }

    private List<OrgParam> constructStruc(Map<String, String> saveNodeMap, String viewschemanumber) {
        ArrayList<OrgParam> orgParams = new ArrayList<OrgParam>(10);
        for (Map.Entry<String, String> entry : saveNodeMap.entrySet()) {
            String idStr = entry.getKey();
            String parentIdStr = entry.getValue();
            if (StringUtils.isEmpty((String)idStr) || StringUtils.isEmpty((String)parentIdStr)) continue;
            long id = Long.parseLong(entry.getKey());
            long parentId = Long.parseLong(entry.getValue());
            if (id == 0L || parentId == 0L) continue;
            OrgParam param = new OrgParam();
            param.setId(id);
            param.setDuty(viewschemanumber);
            param.setParentId(parentId);
            orgParams.add(param);
        }
        return orgParams;
    }
}

