/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.opplugin.accountingsys;

import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.util.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class AccountingSysAddViewSaveValidator
extends AbstractValidator {
    private static final String BD_ACCOUNTINGSYSVIEWSCH = "bd_accountingsysviewsch";
    private static final String BOS_ORG_VIEWSCHEMA = "bos_org_viewschema";
    private static final String ACCOUNTINGSYS = "accountingsys";
    private static final String ISMAINVIEW = "ismainview";

    public void validate() {
        String viewschemanumber = this.getOption().getVariableValue("viewschemanumber", null);
        if (StringUtils.isEmpty((String)viewschemanumber)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u89c6\u56fe\u65b9\u6848\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AccountingSysAddViewSaveValidator_3", (String)"fi-bd-opplugin", (Object[])new Object[0]));
        }
        String rootnode = this.getOption().getVariableValue("rootnode", null);
        if (StringUtils.isEmpty((String)rootnode)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u89c6\u56fe\u6839\u8282\u70b9\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AccountingSysAddViewSaveValidator_4", (String)"fi-bd-opplugin", (Object[])new Object[0]));
        }
        String savenode = this.getOption().getVariableValue("savenode", null);
        if (StringUtils.isEmpty((String)savenode)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6838\u7b97\u4f53\u7cfb\u89c6\u56fe\u53ea\u5b58\u5728\u6839\u7ec4\u7ec7\uff0c\u8bf7\u5728\u6839\u7ec4\u7ec7\u4e0b\u6dfb\u52a0\u4e0b\u7ea7\u7ec4\u7ec7\u3002", (String)"AccountingSysAddViewSaveValidator_5", (String)"fi-bd-opplugin", (Object[])new Object[0]));
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(3);
        ArrayList<QFilter> viewSchemaFilters = new ArrayList<QFilter>(2);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            boolean isExistAccOrg;
            String number = dataEntity.getBillNo();
            Long primaryKey = (Long)dataEntity.getValue("id");
            boolean ismainview = (Boolean)dataEntity.getValue(ISMAINVIEW);
            Long accSysId = (Long)dataEntity.getValue("accountingsys_id");
            qFilters.clear();
            viewSchemaFilters.clear();
            qFilters.add(new QFilter("number", "=", (Object)number));
            viewSchemaFilters.add(new QFilter("number", "=", (Object)(accSysId + ":" + number)));
            if (!primaryKey.equals(0L)) {
                qFilters.add(new QFilter("id", "!=", (Object)primaryKey));
                viewSchemaFilters.add(new QFilter("id", "!=", (Object)primaryKey));
            }
            qFilters.add(new QFilter(ACCOUNTINGSYS, "=", (Object)accSysId));
            boolean isExistCurrent = QueryServiceHelper.exists((String)BD_ACCOUNTINGSYSVIEWSCH, (QFilter[])qFilters.toArray(new QFilter[0]));
            if (isExistCurrent) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u5141\u8bb8\u91cd\u590d\u3002", (String)"AccountingSysAddViewSaveValidator_0", (String)"fi-bd-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            boolean isExistOrgView = QueryServiceHelper.exists((String)BOS_ORG_VIEWSCHEMA, (QFilter[])viewSchemaFilters.toArray(new QFilter[0]));
            if (isExistOrgView) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u7f16\u7801\u548c\u4e1a\u52a1\u5355\u5143\u89c6\u56fe\u91cd\u590d\u3002", (String)"AccountingSysAddViewSaveValidator_1", (String)"fi-bd-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            if (!ismainview) continue;
            qFilters.clear();
            qFilters.add(new QFilter(ACCOUNTINGSYS, "=", (Object)accSysId));
            qFilters.add(new QFilter(ISMAINVIEW, "=", (Object)"1"));
            if (!primaryKey.equals(0L)) {
                qFilters.add(new QFilter("id", "!=", (Object)primaryKey));
            }
            if (!(isExistAccOrg = QueryServiceHelper.exists((String)BD_ACCOUNTINGSYSVIEWSCH, (QFilter[])qFilters.toArray(new QFilter[0])))) continue;
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u6838\u7b97\u4f53\u7cfb\u4e0b\u5df2\u5b58\u5728\u4e00\u4e2a\u4e3b\u89c6\u56fe\u3002", (String)"AccountingSysAddViewSaveValidator_2", (String)"fi-bd-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
        }
    }
}

