/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.opplugin.accountingsys;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.JSONUtils;
import kd.fi.bd.opplugin.accountingsys.AccountReplace;
import kd.fi.bd.opplugin.accountingsys.UpdateVoucherParam;
import kd.fi.bd.opplugin.accountingsys.UpdateVoucherValidator;
import kd.fi.bd.util.AccountDataMutexUtil;

public class UpdateVoucherOp
extends AbstractOperationServicePlugIn {
    private Set<Long> mutexAccountIds = new HashSet<Long>(16);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("createorg");
        fieldKeys.add("masterid");
        fieldKeys.add("checkitementry");
        fieldKeys.add("accounttable");
        fieldKeys.add("startdate");
        fieldKeys.add("enddate");
        fieldKeys.add("isleaf");
        fieldKeys.add("checkitementry");
        fieldKeys.add("checkitementry.asstactitem");
        fieldKeys.add("checkitementry.asstactitem.flexfield");
        fieldKeys.add("checkitementry.defaulid");
        fieldKeys.add("checkitementry.asstactitem.valuetype");
        fieldKeys.add("checkitementry.enaccheck");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new UpdateVoucherValidator(this.mutexAccountIds));
    }

    public void onReturnOperation(ReturnOperationArgs e) {
        super.onReturnOperation(e);
        String useOrg = this.getOption().getVariableValue("useorg", "0");
        String accountTable = this.getOption().getVariableValue("accounttable", "0");
        String lockKey = "fi/bd/updatevoucher/" + useOrg + accountTable;
        try (DLock lock = DLock.create((String)lockKey).fastMode();){
            lock.unlock();
        }
        AccountDataMutexUtil.batchRelease((String)"bd_accountview", this.mutexAccountIds);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String string;
        UpdateVoucherParam param = new UpdateVoucherParam();
        String useOrg = this.getOption().getVariableValue("useorg", "0");
        long useOrgId = Long.parseLong(useOrg);
        String accountTable = this.getOption().getVariableValue("accounttable", "0");
        long accountTableId = Long.parseLong(accountTable);
        param.setOrg(useOrgId);
        param.setAccountTable(accountTableId);
        DynamicObject[] dataEntities = e.getDataEntities();
        HashMap<Long, Long> master2Id = new HashMap<Long, Long>(dataEntities.length);
        HashSet<Long> accountIdSet = new HashSet<Long>(dataEntities.length);
        HashSet<Long> accountMasteridSet = new HashSet<Long>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            accountIdSet.add(dataEntity.getLong("id"));
            accountMasteridSet.add(dataEntity.getLong("masterid"));
            master2Id.put(dataEntity.getLong("masterid"), dataEntity.getLong("id"));
        }
        param.setAccountIdSet(accountIdSet);
        param.setMaster2Id(master2Id);
        param.setAccountMasteridSet(accountMasteridSet);
        List<AccountReplace> accountReplaces = param.getAccounts();
        if (accountReplaces == null) {
            accountReplaces = new ArrayList<AccountReplace>(dataEntities.length);
            param.setAccounts(accountReplaces);
        }
        for (DynamicObject account : dataEntities) {
            Map<String, Object> defaultAssgrp = this.getDefaultAssgrp(account);
            accountReplaces.add(new AccountReplace(account.getLong("id"), account.getLong("masterid"), account.getLong("accounttable_id"), defaultAssgrp, account.getDate("startdate"), this.isReci(account)));
        }
        try {
            string = JSONUtils.toString((Object)param);
        }
        catch (IOException e1) {
            throw new KDBizException(e1.getCause(), new ErrorCode("", String.format(ResManager.loadKDString((String)"\u53c2\u6570\u8f6c\u5316\u5931\u8d25\uff1a%s", (String)"UpdateVoucherOp_0", (String)"fi-bd-opplugin", (Object[])new Object[0]), param.toString())), new Object[0]);
        }
        DispatchServiceHelper.invokeBizService((String)"fi", (String)"gl", (String)"UpdateVoucherService", (String)"updateVoucher", (Object[])new Object[]{string});
    }

    private Map<String, Object> getDefaultAssgrp(DynamicObject account) {
        DynamicObjectCollection assistEntries = account.getDynamicObjectCollection("checkitementry");
        if (assistEntries == null || assistEntries.size() == 0) {
            return new HashMap<String, Object>(1);
        }
        HashMap<String, Object> assistMap = new HashMap<String, Object>(assistEntries.size());
        for (DynamicObject entry : assistEntries) {
            Object defaultval = entry.get("defaulid");
            if (defaultval != null && !defaultval.equals("") && !entry.getString("asstactitem.flexfield").equals("3")) {
                defaultval = Long.parseLong(entry.get("defaulid").toString());
            }
            assistMap.put(entry.getString("asstactitem.flexfield"), defaultval);
        }
        return assistMap;
    }

    private boolean isReci(DynamicObject account) {
        DynamicObjectCollection assistEntries = account.getDynamicObjectCollection("checkitementry");
        if (assistEntries == null || assistEntries.size() == 0) {
            return false;
        }
        for (DynamicObject entry : assistEntries) {
            if (!entry.getBoolean("enaccheck")) continue;
            return true;
        }
        return false;
    }
}

