/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.opplugin.billparam.validator;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.ext.fi.util.DateUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bd.opplugin.billparam.FaBillParamSaveOp;
import kd.fi.fa.enums.BillParamOperateTypeEnum;
import kd.fi.fa.enums.BillParamValueTypeEnum;
import kd.fi.fa.mservice.BillParamBizCheckParam;

public class FaBillParamBizServiceValidator
extends AbstractValidator {
    private static Log log = LogFactory.getLog(FaBillParamBizServiceValidator.class);

    public void validate() {
        String operateType = this.getOperateType();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject dataObj = dataEntity.getDataEntity();
            String checkMsg = this.bizCheck(dataObj, operateType);
            if (!StringUtils.isNotEmpty((String)checkMsg)) continue;
            this.addErrorMessage(dataEntity, checkMsg);
        }
    }

    private String bizCheck(DynamicObject paramObj, String operateType) {
        DynamicObject paramTypeObj = paramObj.getDynamicObject("paramtype");
        BillParamOperateTypeEnum operateTypeEnum = BillParamOperateTypeEnum.getEnumByOperateType((String)operateType);
        String serviceName = paramTypeObj.getString("servicename");
        String paramTypeNumber = paramTypeObj.getString("number");
        BillParamValueTypeEnum valueTypeEnum = BillParamValueTypeEnum.getEnumByType((String)paramTypeObj.getString("valuetype"));
        if (StringUtils.isNotEmpty((String)serviceName)) {
            BillParamBizCheckParam serviceParam;
            DynamicObject paramDBObj = QueryServiceHelper.queryOne((String)"fa_billparam", (String)"value", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)paramObj.getLong("id"))});
            String showValueField = FaBillParamSaveOp.getShowValueField(paramTypeObj);
            String valueBeforeStr = paramDBObj == null ? null : paramDBObj.getString("value");
            switch (valueTypeEnum) {
                case DECIMAL: {
                    BigDecimal valueBefDecimal = StringUtils.isEmpty((String)valueBeforeStr) ? null : new BigDecimal(valueBeforeStr);
                    serviceParam = new BillParamBizCheckParam(operateTypeEnum, paramTypeNumber, valueTypeEnum, (Object)valueBefDecimal, (Object)paramObj.getBigDecimal(showValueField));
                    break;
                }
                case BOOLEAN: {
                    serviceParam = new BillParamBizCheckParam(operateTypeEnum, paramTypeNumber, valueTypeEnum, (Object)Boolean.parseBoolean(valueBeforeStr), (Object)paramObj.getBoolean(showValueField));
                    break;
                }
                case COMBOX: {
                    List valueBefList = valueBeforeStr == null || valueBeforeStr.equals("") ? null : Arrays.stream(valueBeforeStr.split(",")).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
                    String valueAftStr = paramObj.getString(showValueField);
                    List valueAftList = StringUtils.isEmpty((String)valueAftStr) ? null : Arrays.stream(valueAftStr.split(",")).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
                    serviceParam = new BillParamBizCheckParam(operateTypeEnum, paramTypeNumber, valueTypeEnum, valueBefList, valueAftList);
                    break;
                }
                case DATE: {
                    Date valueBefDate = StringUtils.isEmpty((String)valueBeforeStr) ? null : DateUtils.stringToDate((String)valueBeforeStr, (String)"yyyy-MM-dd");
                    serviceParam = new BillParamBizCheckParam(operateTypeEnum, paramTypeNumber, valueTypeEnum, (Object)valueBefDate, (Object)paramObj.getDate(showValueField));
                    break;
                }
                case LONG: {
                    Long valueBefLong = StringUtils.isEmpty((String)valueBeforeStr) ? null : Long.valueOf(Long.parseLong(valueBeforeStr));
                    serviceParam = new BillParamBizCheckParam(operateTypeEnum, paramTypeNumber, valueTypeEnum, (Object)valueBefLong, (Object)paramObj.getLong(showValueField));
                    break;
                }
                default: {
                    serviceParam = new BillParamBizCheckParam(operateTypeEnum, paramTypeNumber, valueTypeEnum, (Object)valueBeforeStr, (Object)paramObj.getString(showValueField));
                }
            }
            DynamicObject entityObj = paramObj.getDynamicObject("entity");
            serviceParam.setEntityName(entityObj == null ? null : entityObj.getString("number"));
            serviceParam.setOrg(paramObj.getDynamicObject("org"));
            try {
                String checkResult = (String)DispatchServiceHelper.invokeBizService((String)paramObj.getDynamicObject("bizcloud").getString("number").toLowerCase(), (String)paramObj.getDynamicObject("bizapp").getString("number").toLowerCase(), (String)serviceName, (String)"check", (Object[])new Object[]{serviceParam});
                if (StringUtils.isNotEmpty((String)checkResult)) {
                    return String.format(ResManager.loadKDString((String)"\u8c03\u7528\u4e1a\u52a1\u7cfb\u7edf\u5fae\u670d\u52a1\u6821\u9a8c\u5931\u8d25\uff1a%s\u3002", (String)"FaBillParamBizServiceValidator_0", (String)"fi-bd-opplugin", (Object[])new Object[0]), checkResult);
                }
            }
            catch (Exception e) {
                log.error("bizCheck\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a", (Throwable)e);
                return String.format(ResManager.loadKDString((String)"\u8c03\u7528\u4e1a\u52a1\u7cfb\u7edf\u5fae\u670d\u52a1\u51fa\u9519\u3002[msg=%1$s:%2$s; traceid=%3$s]", (String)"FaBillParamBizServiceValidator_1", (String)"fi-bd-opplugin", (Object[])new Object[0]), e.getClass().getName(), e.getMessage(), RequestContext.get().getTraceId());
            }
        }
        return null;
    }
}

