/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.opplugin.financialclose;

import com.google.common.collect.Table;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.gl.autoclose.CloseContext;
import kd.bos.ext.fi.gl.autoclose.CloseResult;
import kd.bos.ext.fi.gl.closeperiod.BookRegisterInfo;
import kd.bos.ext.fi.gl.closeperiod.BookRegisterService;
import kd.bos.ext.fi.gl.dao.BookDAOFactory;
import kd.bos.ext.fi.gl.vo.BookVO;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.JSONUtils;
import kd.fi.bd.cache.CacheHelper;
import kd.fi.bd.cache.CacheModule;
import kd.fi.bd.cache.DistributeCache;
import kd.fi.bd.enums.SkipMode;
import kd.fi.bd.financialclose.FinancialCloseInfo;
import kd.fi.bd.opplugin.financialclose.FinancialLogInfo;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.util.MultiLangPunc;
import kd.fi.bd.util.PeriodUtil;

public class FinancialCloseConsumer
implements MessageConsumer {
    private static final Log log = LogFactory.getLog(FinancialCloseConsumer.class);
    private static final String GL_CLOSEFORM = "gl_autocloseperiod";
    private static final String GL_ACCOUNTBOOK = "gl_accountbook";
    private final String CLOSE_STATE = "gl_closestate";
    private DistributeCache cache = CacheHelper.getDistributeCache((CacheModule)CacheModule.periodClose);
    private static final String CUR_PERIOD = "curperiod";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Object arg0, String arg1, boolean arg2, MessageAcker ack) {
        if (DebugTrace.enable()) {
            log.info("FinancialCloseConsumer,arg0:" + arg0.toString());
        }
        FinancialCloseInfo closeInfo = (FinancialCloseInfo)SerializationUtils.fromJsonString((String)arg0.toString(), FinancialCloseInfo.class);
        FinancialLogInfo financialLogInfo = new FinancialLogInfo();
        this.resetRequestContext(closeInfo);
        try {
            BookRegisterInfo registerInfo = BookRegisterService.queryByBizApp((String)closeInfo.getBizAppNumber());
            if (registerInfo != null) {
                String closeOperation = registerInfo.getCloseOperationKey();
                String checkOutNumber = registerInfo.getCloseEntityOfCloseOp();
                String bookTypeFiled = registerInfo.getBookTypeFieldOnCloseEntity();
                String skipMode = registerInfo.getSkipMode();
                if (StringUtils.isNotEmpty((CharSequence)closeOperation)) {
                    financialLogInfo = this.checkOutOp(checkOutNumber, closeOperation, bookTypeFiled, closeInfo, skipMode);
                } else {
                    String closeService = registerInfo.getClosePeriodMservice();
                    if (StringUtils.isEmpty((CharSequence)closeService)) {
                        String message = ResManager.loadKDString((String)"\u5f53\u524d\u7cfb\u7edf\u672a\u914d\u7f6e\u7ed3\u8d26\u3002", (String)"FinancialCloseConsumer_2", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                        this.setFailLogInfo(financialLogInfo, message, closeInfo, "");
                    } else {
                        financialLogInfo = this.checkOutService(closeInfo, closeService);
                    }
                }
            } else {
                String message = ResManager.loadKDString((String)"\u5f53\u524d\u7cfb\u7edf\u672a\u914d\u7f6e\u7ed3\u8d26\u3002", (String)"FinancialCloseConsumer_2", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                this.setFailLogInfo(financialLogInfo, message, closeInfo, "");
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            String message = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            this.setFailLogInfo(financialLogInfo, message, closeInfo, "");
        }
        finally {
            this.updateCurrentLogInfo(financialLogInfo);
            ack.ack(arg1);
        }
    }

    private void updateCurrentLogInfo(FinancialLogInfo financialLogInfo) {
        String state;
        String res;
        String message = financialLogInfo.getMessage();
        message = message.length() > 512 ? message.substring(0, 512) : message;
        FinancialCloseInfo closeInfo = financialLogInfo.getCloseInfo();
        if (financialLogInfo.isSuccess()) {
            res = String.format(ResManager.loadKDString((String)"%s\u7ed3\u8d26\u6210\u529f", (String)"FinancialCloseConsumer_0", (String)"fi-bd-opplugin", (Object[])new Object[0]), closeInfo.getCurperiodName());
            state = "1";
        } else {
            res = String.format(ResManager.loadKDString((String)"%s\u7ed3\u8d26\u5931\u8d25", (String)"FinancialCloseConsumer_1", (String)"fi-bd-opplugin", (Object[])new Object[0]), closeInfo.getCurperiodName());
            state = "2";
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("update t_fcm_financialcloselog set fclosestate= ? ", new Object[]{state});
        if (financialLogInfo.isSuccess()) {
            sqlBuilder.append(" ,fcurperiod=? ", new Object[]{financialLogInfo.getAwaitPeriodId()});
            if (StringUtils.isNotBlank((CharSequence)message)) {
                sqlBuilder.append(" ,fdetailslink=? ", new Object[]{this.genDetailLinkStr(financialLogInfo.getFormShowParam())});
                sqlBuilder.append(" ,fdetailslink_tag=? ", new Object[]{financialLogInfo.getFormShowParam()});
            }
        } else {
            sqlBuilder.append(" ,fdetailslink=? ", new Object[]{this.genDetailLinkStr(financialLogInfo.getFormShowParam())});
            sqlBuilder.append(" ,fdetailslink_tag=? ", new Object[]{financialLogInfo.getFormShowParam()});
        }
        sqlBuilder.append(" ,fdealres = ? ", new Object[]{res});
        sqlBuilder.append(" ,ffaildetails = ? ", new Object[]{message});
        sqlBuilder.append(" where forgid = ? ", new Object[]{closeInfo.getOrg()});
        sqlBuilder.append(" and fbooktypeid  = ? ", new Object[]{closeInfo.getBookType()});
        sqlBuilder.append(" and fcurperiod  = ? ", new Object[]{closeInfo.getCurPeriodId()});
        sqlBuilder.append(" and fbizappid  = ? ", new Object[]{closeInfo.getBizAppId()});
        sqlBuilder.append("  and fstate='1' and fclosestate='0' ", new Object[0]);
        DB.execute((DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder);
    }

    private FinancialLogInfo checkOutOp(String checkOutNumber, String checkOutOp, String bookTypeFiled, FinancialCloseInfo closeInfo, String skipMode) {
        DynamicObject dy;
        FinancialLogInfo financialLogInfo = new FinancialLogInfo();
        String formId = GL_ACCOUNTBOOK.equals(checkOutNumber) ? GL_CLOSEFORM : checkOutNumber;
        closeInfo.setFormId(checkOutNumber);
        closeInfo.setTypeFieldName(bookTypeFiled);
        QFilter orgFilter = new QFilter("org", "=", (Object)closeInfo.getOrg());
        String appNumber = closeInfo.getBizAppNumber();
        long orgId = closeInfo.getOrg();
        if ("cas".equals(appNumber)) {
            QFilter periodFilter = new QFilter("period", "=", closeInfo.getCurPeriodId());
            dy = BusinessDataServiceHelper.loadSingle((String)formId, (String)"id,org,period,checkoutstatus,creator,checkoutmsg", (QFilter[])new QFilter[]{orgFilter, periodFilter});
            if (dy == null) {
                log.info("checkOutOp query data not exist");
                String message = ResManager.loadKDString((String)"\u5f53\u524d\u7ed3\u8d26\u65f6\u7684\u671f\u95f4\u4e0e\u4e1a\u52a1\u7cfb\u7edf\u4e0d\u4e00\u81f4\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"FinancialCloseConsumer_4", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                this.setFailLogInfo(financialLogInfo, message, closeInfo, "");
                return financialLogInfo;
            }
        } else {
            QFilter[] qFilters;
            long closeCurPeriodId;
            long bookTypeId = Long.parseLong(closeInfo.getBookType().toString());
            ArrayList<Long> orgIdList = new ArrayList<Long>(2);
            orgIdList.add(orgId);
            Table bookTable = BookDAOFactory.getBookDAO((String)appNumber).query(appNumber, orgIdList, Long.valueOf(bookTypeId));
            BookVO bookVO = (BookVO)bookTable.get((Object)orgId, (Object)bookTypeId);
            if (bookVO == null) {
                String message = ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5bf9\u5e94\u6570\u636e\u3002", (String)"FinancialCloseConsumer_7", (String)"fi-gl-opplugin", (Object[])new Object[0]);
                this.setFailLogInfo(financialLogInfo, message, closeInfo, "");
                return financialLogInfo;
            }
            long dbCurPeriodId = bookVO.getCurPeriodId();
            if (dbCurPeriodId != (closeCurPeriodId = Long.parseLong(closeInfo.getCurPeriodId().toString()))) {
                log.info("checkOutOp query data not exist");
                String message = ResManager.loadKDString((String)"\u5f53\u524d\u7ed3\u8d26\u65f6\u7684\u671f\u95f4\u4e0e\u4e1a\u52a1\u7cfb\u7edf\u4e0d\u4e00\u81f4\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"FinancialCloseConsumer_4", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                this.setFailLogInfo(financialLogInfo, message, closeInfo, "");
                return financialLogInfo;
            }
            if (StringUtils.isNotEmpty((CharSequence)bookTypeFiled)) {
                QFilter bookTypeFilter = new QFilter(bookTypeFiled, "=", (Object)bookTypeId);
                qFilters = new QFilter[]{orgFilter, bookTypeFilter};
            } else {
                qFilters = new QFilter[]{orgFilter};
            }
            dy = BusinessDataServiceHelper.loadSingle((String)formId, (String)"id", (QFilter[])qFilters);
        }
        OperateOption opt = OperateOption.create();
        Long awaitPeriodId = this.getNextPeriodId(Long.parseLong(closeInfo.getCurPeriodId().toString()), appNumber);
        closeInfo.setAwaitPeriodId(awaitPeriodId);
        opt.setVariableValue("reachperiod", awaitPeriodId.toString());
        String requestId = closeInfo.getRequestId();
        String closeCacheKey = this.genCacheKey(Long.toString(orgId), requestId, appNumber, closeInfo.getBookType().toString());
        opt.setVariableValue("closeCacheKey", closeCacheKey);
        opt.setVariableValue("bizapp", appNumber);
        opt.setVariableValue("booktype", bookTypeFiled);
        opt.setVariableValue("manual", "true");
        opt.setVariableValue("operationId", requestId);
        long startTime = System.currentTimeMillis();
        log.info("close opt:" + SerializationUtils.toJsonString((Object)opt));
        OperationResult result = "cas".equals(appNumber) ? OperationServiceHelper.executeOperate((String)checkOutOp, (String)formId, (DynamicObject[])new DynamicObject[]{dy}, (OperateOption)opt) : OperationServiceHelper.executeOperate((String)checkOutOp, (String)formId, (Object[])new Object[]{dy.getLong("id")}, (OperateOption)opt);
        String reachPeriod = opt.getVariableValue("openedperiod", "0");
        Long reachPeriodId = Long.valueOf(reachPeriod);
        HashMap<Long, String> map = new HashMap<Long, String>();
        HashMap<Long, Long> periodMap = new HashMap<Long, Long>();
        long endTime = System.currentTimeMillis();
        if (DebugTrace.enable()) {
            log.info("close elapsed time\uff1a" + (endTime - startTime) + ",return\uff1a" + SerializationUtils.toJsonString((Object)result));
        }
        String failedMessage = this.getFailedMessage(result);
        if (result.isSuccess() && StringUtils.isBlank((CharSequence)failedMessage)) {
            financialLogInfo.setSuccess(true);
            financialLogInfo.setMessage("");
            financialLogInfo.setCloseInfo(closeInfo);
            financialLogInfo.setAwaitPeriodId(awaitPeriodId);
            if (SkipMode.GL_MODE.getValue().equals(skipMode)) {
                this.getCloseInfoId(closeInfo, result.getSuccessPkIds().get(0), orgId, true);
                if (this.isLessSlePeriod(orgId, closeInfo)) {
                    this.setCacheInfo((Long)orgId, "1", closeInfo, map);
                }
                if (reachPeriodId > 0L) {
                    closeInfo.setCurPeriodId((Object)reachPeriodId);
                    this.setCacheInfo((Long)orgId, reachPeriodId, closeInfo, periodMap);
                }
                this.getAndSaveDynamicObject(orgId, closeInfo, "1", endTime - startTime);
            }
        } else {
            this.setFailLogInfo(financialLogInfo, failedMessage, closeInfo, "");
            Long resultId = 0L;
            if (result.isSuccess()) {
                financialLogInfo.setSuccess(true);
                financialLogInfo.setCloseInfo(closeInfo);
                financialLogInfo.setAwaitPeriodId(awaitPeriodId);
                resultId = result.getSuccessPkIds().get(0);
            }
            if (SkipMode.GL_MODE.getValue().equals(skipMode)) {
                this.getCloseInfoId(closeInfo, resultId, orgId, result.isSuccess());
                if (result.isSuccess()) {
                    if (this.isLessSlePeriod(orgId, closeInfo)) {
                        this.setCacheInfo((Long)orgId, "1", closeInfo, map);
                    }
                } else {
                    this.setCacheInfo((Long)orgId, "2", closeInfo, map);
                }
                if (reachPeriodId > 0L) {
                    closeInfo.setCurPeriodId((Object)reachPeriodId);
                    this.setCacheInfo((Long)orgId, reachPeriodId, closeInfo, periodMap);
                }
                Long id = this.getAndSaveDynamicObject(orgId, closeInfo, result.isSuccess() ? "1" : "2", endTime - startTime);
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("gl_periodclosedetails");
                formShowParameter.setCustomParam("accountId", (Object)id);
                formShowParameter.setCustomParam("closeKey", (Object)closeCacheKey);
                formShowParameter.setCustomParam("checkItems", (Object)this.cache.get(closeCacheKey));
                formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                financialLogInfo.setFormShowParam(formShowParameter.toString());
            } else if (SkipMode.CHECK_MODE.getValue().equals(skipMode)) {
                ListShowParameter showParameter = new ListShowParameter();
                showParameter.setBillFormId("fcm_checklog");
                showParameter.setFormId("bos_list");
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>(4);
                qFilters.add(new QFilter("operationid", "=", (Object)requestId));
                qFilters.add(new QFilter("bizappid", "=", (Object)closeInfo.getBizAppId()));
                qFilters.add(new QFilter("executionperiod", "=", closeInfo.getCurPeriodId()));
                if (Long.parseLong(closeInfo.getBookType().toString()) > 0L) {
                    qFilters.add(new QFilter("subbiztypeid", "=", closeInfo.getBookType()));
                }
                showParameter.getListFilterParameter().getQFilters().addAll(qFilters);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                financialLogInfo.setFormShowParam(showParameter.toString());
            }
        }
        return financialLogInfo;
    }

    private FinancialLogInfo checkOutService(FinancialCloseInfo closeInfo, String closeService) {
        FinancialLogInfo financialLogInfo = new FinancialLogInfo();
        CloseContext closeContext = new CloseContext(CloseContext.CloseType.ACCOUNT_CLOSE, closeInfo.getOrg(), Long.valueOf(closeInfo.getBookType().toString()), Long.valueOf(closeInfo.getCurPeriodId().toString()), null, null);
        log.info("checkOutService,closeContext:" + SerializationUtils.toJsonString((Object)closeContext));
        String[] args = closeService.split(",");
        CloseResult result = (CloseResult)DispatchServiceHelper.invokeBizService((String)args[0], (String)args[1], (String)args[2], (String)args[3], (Object[])new Object[]{closeContext});
        log.info("checkOutService,result,success:" + (result == null ? "" : Boolean.valueOf(result.isSuccess())));
        if (result == null) {
            String message = ResManager.loadKDString((String)"\u7ed3\u8d26\u5931\u8d25\uff1a\u63a5\u53e3\u65e0\u8fd4\u56de\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FinancialCloseConsumer_3", (String)"fi-bd-opplugin", (Object[])new Object[0]);
            this.setFailLogInfo(financialLogInfo, message, closeInfo, "");
            return financialLogInfo;
        }
        if (result.isSuccess()) {
            Long awaitPeriodId = this.getNextPeriodId(Long.parseLong(closeInfo.getCurPeriodId().toString()), closeInfo.getBizAppNumber());
            financialLogInfo.setSuccess(true);
            financialLogInfo.setMessage("");
            financialLogInfo.setCloseInfo(closeInfo);
            financialLogInfo.setAwaitPeriodId(awaitPeriodId);
        } else {
            String message = result.getErrorMessages() == null ? "" : result.getErrorMessages().toString().replace("[", "").replace("]", "");
            FormShowParameter parameter = result.getDetailFormShowParam();
            String parameterStr = parameter == null ? "" : parameter.toString();
            log.info("checkOutService,message:{}parameterStr:{}", (Object)message, (Object)parameterStr);
            this.setFailLogInfo(financialLogInfo, message, closeInfo, parameterStr);
        }
        return financialLogInfo;
    }

    private long getNextPeriodId(long periodId, String appNumber) {
        DynamicObject nextPeriod;
        boolean isAdjustPeriod = false;
        if ("gl".equals(appNumber)) {
            isAdjustPeriod = true;
        }
        if ((nextPeriod = PeriodUtil.getNextPeriod((Object)periodId, (boolean)isAdjustPeriod)) == null) {
            log.warn("None next period found.");
            return 0L;
        }
        return nextPeriod.getLong("id");
    }

    private void setFailLogInfo(FinancialLogInfo financialLogInfo, String message, FinancialCloseInfo closeInfo, String parameterStr) {
        financialLogInfo.setSuccess(false);
        financialLogInfo.setMessage(message);
        financialLogInfo.setCloseInfo(closeInfo);
        financialLogInfo.setAwaitPeriodId(0L);
        financialLogInfo.setFormShowParam(parameterStr);
    }

    private String dealErrorInfos(List<OperateErrorInfo> errorInfos) {
        StringBuilder errorMessage = new StringBuilder();
        if (CollectionUtils.isEmpty(errorInfos)) {
            return "";
        }
        int size = errorInfos.size();
        String comma = MultiLangPunc.comma();
        String semicolon = MultiLangPunc.semicolon();
        for (int i = 0; i < size; ++i) {
            String message = errorInfos.get(i).getMessage();
            if (!StringUtils.isNotEmpty((CharSequence)message)) continue;
            message = message.replace("\t", semicolon);
            errorMessage.append(message);
            if (i == size - 1) continue;
            errorMessage.append(comma);
        }
        return this.removeLastSymbol(errorMessage.toString());
    }

    private String removeLastSymbol(String str) {
        if (str.endsWith("\uff0c") || str.endsWith("\uff1b")) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    private void resetRequestContext(FinancialCloseInfo closeInfo) {
        try {
            String rc = closeInfo.getRequestContextStr();
            if (StringUtils.isNotBlank((CharSequence)rc)) {
                RequestContext currentRC = RequestContext.get();
                RequestContext originRC = (RequestContext)SerializationUtils.deSerializeFromBase64((String)rc);
                currentRC.setClient(originRC.getClient());
                currentRC.setLoginIP(originRC.getLoginIP());
            }
        }
        catch (Exception e) {
            log.error("resetRC error", (Throwable)e);
        }
    }

    private void getCloseInfoId(FinancialCloseInfo closeInfo, Object resultid, Long orgid, boolean isSuccess) {
        Object id = resultid;
        Long period = this.isHaveBook(orgid, closeInfo, CUR_PERIOD);
        if (isSuccess) {
            period = this.getPreviousPeriodId(period, closeInfo.getBizAppNumber());
        }
        closeInfo.setCurPeriodId((Object)period);
        closeInfo.setCloseItemPK(id);
    }

    private void setCacheInfo(Long orgid, String state, FinancialCloseInfo closeInfo, Map<Long, String> map) {
        map.put(orgid, state);
        try {
            String comst = JSONUtils.toString(map);
            this.cache.put("companyState" + closeInfo.getPageId(), comst);
        }
        catch (IOException e) {
            throw new KDBizException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }

    private void setCacheInfo(Long orgid, Long periodId, FinancialCloseInfo closeInfo, Map<Long, Long> map) {
        map.put(orgid, periodId);
        try {
            String comst = JSONUtils.toString(map);
            this.cache.put("companyPeriod" + closeInfo.getPageId(), comst);
        }
        catch (IOException e) {
            throw new KDBizException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }

    private void closeIsSuccess(long orgid, FinancialCloseInfo closeInfo, long time, String state, Map<Long, String> map) {
        this.getAndSaveDynamicObject(orgid, closeInfo, state, time);
        this.setCacheInfo((Long)orgid, state, closeInfo, map);
    }

    private DynamicObject getParams(long companyId, FinancialCloseInfo closeInfo, long bookId) {
        QFilter org = new QFilter("company", "=", (Object)companyId);
        QFilter period = new QFilter("period", "=", closeInfo.getCurPeriodId());
        QFilter system = new QFilter("subsysformnum", "=", (Object)closeInfo.getFormId());
        QFilter accountbook = new QFilter("accountbooks", "=", (Object)String.valueOf(bookId));
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"gl_closestate", (String)"id", (QFilter[])new QFilter[]{org, period, accountbook, system});
        if (!collection.isEmpty()) {
            if (collection.size() > 1) {
                Object[] o = new Object[collection.size()];
                for (int i = 1; i < collection.size(); ++i) {
                    o[i] = ((DynamicObject)collection.get(i)).getPkValue();
                }
                DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"gl_closestate"), (Object[])o);
            }
            return BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)collection.get(0)).getLong("id"), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"gl_closestate"));
        }
        return BusinessDataServiceHelper.newDynamicObject((String)"gl_closestate");
    }

    private Long isHaveBook(long org, FinancialCloseInfo closeInfo, String select) {
        DynamicObjectCollection collection;
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        list.add(new QFilter("org", "=", (Object)org));
        if (closeInfo.getBookType() != null && !"0".equals(closeInfo.getBookType().toString())) {
            list.add(new QFilter(closeInfo.getTypeFieldName(), "=", (Object)Long.valueOf(closeInfo.getBookType().toString())));
        }
        if ((collection = QueryServiceHelper.query((String)closeInfo.getFormId(), (String)select, (QFilter[])list.toArray(new QFilter[0]))).isEmpty()) {
            return 0L;
        }
        return ((DynamicObject)collection.get(0)).getLong(select);
    }

    private Long getAndSaveDynamicObject(long companyId, FinancialCloseInfo closeInfo, String closeState, long time) {
        Long bookId = this.isHaveBook(companyId, closeInfo, "id");
        DynamicObject state = this.getParams(companyId, closeInfo, bookId);
        state.set("company", (Object)companyId);
        state.set("period", closeInfo.getCurPeriodId());
        state.set("subsysformnum", (Object)closeInfo.getFormId());
        state.set("accountbooks", (Object)bookId);
        state.set("thisclosetime", (Object)time);
        state.set("linestate", (Object)"0");
        state.set("closedate", (Object)new Date());
        state.set("closestate", (Object)closeState);
        if ("gl".equals(closeInfo.getBizAppNumber())) {
            String closeUserId = RequestContext.getOrCreate().getUserId();
            state.set("closeuser", (Object)closeUserId);
        }
        Throwable throwable = null;
        try (TXHandle h = TX.requiresNew((String)"gl_subsystem_save");){
            DynamicObject[] save = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{state});
            Long l = save[0].getLong("id");
            return l;
        }
        catch (Throwable e) {
            try {
                h.markRollback();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private void createFailInfo(FinancialCloseInfo closeInfo, Map<Long, String> map, String ... str) {
        Long org = Long.parseLong(str[0]);
        Long periodId = this.isHaveBook(org, closeInfo, CUR_PERIOD);
        if (periodId != 0L) {
            closeInfo.setCurPeriodId((Object)periodId);
        } else {
            closeInfo.setCurPeriodId((Object)closeInfo.getAwaitPeriodId());
        }
        DynamicObject closecheck = BusinessDataServiceHelper.newDynamicObject((String)"bd_closecheckitem");
        closecheck.set("company", (Object)org);
        closecheck.set("period", closeInfo.getCurPeriodId());
        closecheck.set("subsysformnum", (Object)closeInfo.getFormId());
        closecheck.set("accountbooks", (Object)this.isHaveBook(org, closeInfo, "id"));
        DynamicObjectCollection entitys = closecheck.getDynamicObjectCollection("entryentity");
        DynamicObject entity = new DynamicObject(entitys.getDynamicObjectType());
        entity.set("checkitem", (Object)str[1]);
        entity.set("checkstate", (Object)str[2]);
        entity.set("menuid", (Object)str[3]);
        entity.set("formquery", null);
        entity.set("formnumber", null);
        entity.set("message", (Object)str[4]);
        entitys.add((Object)entity);
        String cacheKey = this.genCacheKey(org.toString(), closeInfo.getRequestId(), closeInfo.getBizAppNumber(), closeInfo.getBookType().toString());
        this.cache.put(cacheKey, DataEntitySerializer.serializerToString((Object)closecheck));
        closeInfo.setCloseItemPK((Object)0L);
        this.closeIsSuccess(org, closeInfo, 0L, "2", map);
    }

    public boolean isLessSlePeriod(long orgid, FinancialCloseInfo closeInfo) {
        String currentPer = this.isHaveBook(orgid, closeInfo, CUR_PERIOD) + "";
        currentPer = currentPer.substring(currentPer.length() - 8, currentPer.length() - 1);
        String selectPer = closeInfo.getAwaitPeriodId() + "";
        selectPer = selectPer.substring(selectPer.length() - 8, selectPer.length() - 1);
        return Integer.parseInt(currentPer) >= Integer.parseInt(selectPer);
    }

    private String getFailedMessage(OperationResult result) {
        String failedMessage = this.dealStandardErrorInfos(result.getValidateResult().getValidateErrors());
        if (StringUtils.isNotEmpty((CharSequence)failedMessage)) {
            return failedMessage;
        }
        if (StringUtils.isNotEmpty((CharSequence)result.getMessage())) {
            return result.getMessage();
        }
        return this.dealErrorInfos(result.getAllErrorInfo());
    }

    private String genCacheKey(String orgId, String requestId, String appNumber, String bookTypeId) {
        return "CLOSE_PERIOD." + requestId + "_" + orgId + "_" + appNumber + "_" + bookTypeId;
    }

    private String genDetailLinkStr(String formShowParam) {
        if (StringUtils.isNotEmpty((CharSequence)formShowParam)) {
            if (formShowParam.length() > 200) {
                return formShowParam.substring(0, 200);
            }
            return formShowParam;
        }
        return "";
    }

    private long getPreviousPeriodId(long periodId, String appNumber) {
        DynamicObject previousPeriod;
        boolean isAdjustPeriod = false;
        if ("gl".equals(appNumber)) {
            isAdjustPeriod = true;
        }
        if ((previousPeriod = PeriodUtil.getPreviousPeriod((Object)periodId, (boolean)isAdjustPeriod)) == null) {
            log.warn("None Previous period found.");
            return 0L;
        }
        return previousPeriod.getLong("id");
    }

    private String dealStandardErrorInfos(List<ValidateResult> validateResults) {
        StringBuilder errorMessage = new StringBuilder();
        if (CollectionUtils.isEmpty(validateResults)) {
            return "";
        }
        int size = validateResults.size();
        String comma = MultiLangPunc.comma();
        for (int i = 0; i < size; ++i) {
            List allErrorInfo = validateResults.get(i).getAllErrorInfo();
            errorMessage.append(this.dealErrorInfos(allErrorInfo)).append(comma);
        }
        return this.removeLastSymbol(errorMessage.toString());
    }
}

