/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.opplugin.schedual;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class FiSchedualConfigTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(FiSchedualConfigTask.class);
    private static final String SELECT_FIELDS = "canclose,selbill.number, schschedule.id, schschedule.status, selbillfilter_tag";

    public void execute(RequestContext context, Map<String, Object> paramMap) throws KDException {
        long startTime = System.currentTimeMillis();
        logger.info("\u5f00\u59cb\u8c03\u5ea6\u8ba1\u5212\u542f\u52a8\u914d\u7f6e\u8c03\u5ea6\u4efb\u52a1, param={}", (Object)SerializationUtils.toJsonString(paramMap));
        QFilter qFilter = QFilter.isNotNull((String)"selbill").and("enable", "=", (Object)"1");
        DynamicObjectCollection schedualConfigs = QueryServiceHelper.query((String)"bd_sch_config", (String)SELECT_FIELDS, (QFilter[])qFilter.toArray());
        ArrayList<String> disableScheduleIds = new ArrayList<String>(8);
        ArrayList<String> enableScheduleIds = new ArrayList<String>(8);
        for (DynamicObject config : schedualConfigs) {
            String status;
            boolean isEnable;
            String scheduleId = config.getString("schschedule.id");
            if (StringUtils.isEmpty((String)scheduleId) || (isEnable = "1".equals(status = config.getString("schschedule.status"))) && !config.getBoolean("canclose")) continue;
            boolean exists = false;
            try {
                exists = this.isExists(config);
            }
            catch (Exception e) {
                logger.error(String.format("check isExists error, scheduleId: %s", scheduleId), (Throwable)e);
                continue;
            }
            if (exists && !isEnable) {
                enableScheduleIds.add(scheduleId);
                continue;
            }
            if (exists || !isEnable) continue;
            disableScheduleIds.add(scheduleId);
        }
        ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        for (String scheduleId : disableScheduleIds) {
            try {
                scheduleManager.disableSchedule(scheduleId);
            }
            catch (Exception e) {
                logger.error("disableSchedule error, scheduleId: {}, error: {}", (Object)scheduleId, (Object)e.getMessage());
            }
        }
        for (String scheduleId : enableScheduleIds) {
            try {
                scheduleManager.enableSchedule(scheduleId);
            }
            catch (Exception e) {
                logger.error("enableSchedule error, scheduleId: {}, error: {}", (Object)scheduleId, (Object)e.getMessage());
            }
        }
        logger.info("\u7ed3\u675f\u8c03\u5ea6\u8ba1\u5212\u542f\u52a8\u914d\u7f6e\u8c03\u5ea6\u4efb\u52a1, \u8017\u65f6: {}ms", (Object)(System.currentTimeMillis() - startTime));
    }

    private boolean isExists(DynamicObject config) {
        String entityNumber = config.getString("selbill.number");
        QFilter filter = this.getFilterGridFilter(config.getString("selbillfilter_tag"), entityNumber);
        return QueryServiceHelper.exists((String)entityNumber, (QFilter[])(filter != null ? filter.toArray() : null));
    }

    private QFilter getFilterGridFilter(String filterTag, String entityName) {
        if (StringUtils.isBlank((String)filterTag)) {
            return null;
        }
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterTag, FilterCondition.class);
        FilterBuilder fb = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)entityName), filterCondition, true);
        fb.buildFilter(true);
        return fb.getQFilter();
    }
}

