/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.upgradeservice;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.ExceptionUtils;

public class AccountRelevantInitService
implements IUpgradeService {
    private static final Log LOG = LogFactory.getLog(AccountRelevantInitService.class);
    private static final DBRoute FI = DBRoute.of((String)"fi");
    private static final DBRoute SYS = DBRoute.of((String)"sys");
    private static final String DIR = "accountinit";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            if (this.onlyHaveCustomerAssist() && !this.existAccountTable() && !this.existVoucherType()) {
                this.doInitAssistItemAndAccountRelevant();
            } else {
                result.setLog("is not new user,skip init");
            }
            result.setSuccess(true);
        }
        catch (Exception e) {
            result.setErrorInfo(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            result.setSuccess(false);
            LOG.error((Throwable)e);
        }
        return result;
    }

    private boolean onlyHaveCustomerAssist() {
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"AccountRelevantInitService.onlyHaveConsumerAssist", (String)"bd_asstacttype", (String)"id", (QFilter[])new QFilter[0], (String)"id");){
            if (ds.hasNext()) {
                Row row = ds.next();
                boolean bl = row.getLong("id").equals(251805847271815168L) && !ds.hasNext();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    private void doInitAssistItemAndAccountRelevant() {
        try (TXHandle handle = TX.requiresNew();){
            try {
                Stream.of("t_bas_flex_property", "t_bas_flex_property_l", "t_bd_ctrlstrategydetail").map(this::getSqlList).flatMap(Collection::stream).forEach(sql -> DB.execute((DBRoute)SYS, (String)sql.replace("100000", String.valueOf(OrgUnitServiceHelper.getRootOrgId()))));
            }
            catch (Exception e) {
                handle.markRollback();
                throw e;
            }
        }
        handle = TX.requiresNew();
        var2_2 = null;
        try {
            try {
                Stream.of("t_bd_accounttable", "t_bd_accounttable_l", "t_bd_accounttype", "t_bd_accounttype_l", "t_bd_account", "t_bd_account_l", "t_bd_accountasstactitem", "t_fcm_checkitem", "t_bd_accountasstactitem", "t_gl_vouchertype", "t_gl_vouchertype_l").map(this::getSqlList).flatMap(Collection::stream).forEach(sql -> DB.execute((DBRoute)FI, (String)sql.replace("100000", String.valueOf(OrgUnitServiceHelper.getRootOrgId()))));
            }
            catch (Exception e) {
                handle.markRollback();
                throw e;
            }
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (handle != null) {
                if (var2_2 != null) {
                    try {
                        handle.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    handle.close();
                }
            }
        }
    }

    private boolean existAccountTable() {
        return QueryServiceHelper.exists((String)"bd_accounttable", (QFilter[])new QFilter[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> getSqlList(String tableName) {
        ArrayList<String> result = new ArrayList<String>(100);
        try (InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(String.format("%s/%s_init.sql", DIR, tableName));){
            String line;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((line = bufferedReader.readLine()) != null) {
                result.add(line);
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private boolean existVoucherType() {
        return QueryServiceHelper.exists((String)"gl_vouchertype", (QFilter[])new QFilter[0]);
    }
}

