/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.upgradeservice;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.ExceptionUtils;

public class AccountingsysInitService
implements IUpgradeService {
    private static final Log LOG = LogFactory.getLog(AccountingsysInitService.class);
    private static final DBRoute FI = DBRoute.of((String)"fi");
    private static final DBRoute SYS = DBRoute.of((String)"sys");
    private static final String DIR = "accountinit";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            if (!this.existAccountingsys()) {
                this.doInitAccoutingsys();
            } else {
                result.setLog("bd_accountingsys is not empty,skip init");
            }
            result.setSuccess(true);
        }
        catch (Exception e) {
            result.setErrorInfo(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            result.setSuccess(false);
            LOG.error((Throwable)e);
        }
        return result;
    }

    private void doInitAccoutingsys() {
        try (TXHandle handle = TX.requiresNew();){
            try {
                Stream.of("t_bd_accountingsys").map(this::getSqlList).flatMap(Collection::stream).forEach(sql -> DB.execute((DBRoute)FI, (String)sql));
            }
            catch (Exception e) {
                handle.markRollback();
                throw e;
            }
        }
        handle = TX.requiresNew();
        var2_2 = null;
        try {
            try {
                Stream.of("t_org_viewschema").map(this::getSqlList).flatMap(Collection::stream).forEach(sql -> DB.execute((DBRoute)SYS, (String)sql.replace("100000", String.valueOf(OrgUnitServiceHelper.getRootOrgId()))));
            }
            catch (Exception e) {
                handle.markRollback();
                throw e;
            }
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (handle != null) {
                if (var2_2 != null) {
                    try {
                        handle.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    handle.close();
                }
            }
        }
    }

    private boolean existAccountingsys() {
        return QueryServiceHelper.exists((String)"bd_accountingsys", (QFilter[])new QFilter[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> getSqlList(String tableName) {
        ArrayList<String> result = new ArrayList<String>(100);
        try (InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(String.format("%s/%s_init.sql", DIR, tableName));){
            String line;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((line = bufferedReader.readLine()) != null) {
                result.add(line);
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

