/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.upgradeservice;

import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.ExceptionUtils;
import kd.fi.bd.service.balance.AppHelper;

public class FcmBillParamUpgradeService
implements IUpgradeService {
    private static final String QUERY_SQL = "SELECT fid, fparam, fvalue from t_fa_billparam where forgid = 0 and fentityid = ' ' and fbizappid in ('104BM8137+43')";
    private static final String UPDATE_SQL = "UPDATE t_fa_billparam set fvalue = ? where fid = ?";
    private static final DBRoute FI = DBRoute.of((String)"fi");

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            this.doUpgrade();
            result.setSuccess(true);
        }
        catch (Exception e) {
            result.setErrorInfo(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            result.setSuccess(false);
        }
        return result;
    }

    private void doUpgrade() {
        try (DataSet dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)FI, (String)QUERY_SQL);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String value = AppHelper.getSystemProperty((String)row.getString("fparam"), null);
                if (!Objects.nonNull(value)) continue;
                this.update(value, row);
            }
        }
    }

    private void update(String value, Row row) {
        DB.execute((DBRoute)FI, (String)UPDATE_SQL, (Object[])new Object[]{value, row.getLong("fid")});
    }
}

