/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.accountref;

import java.io.Serializable;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class AccountBookInfo
implements Serializable {
    private static final long serialVersionUID = -451463358628060096L;
    private long id;
    private long org;
    private long bookstype;
    private String bookstypeNum;
    private long basecurrency;
    private long periodtype;
    private long startperiod;
    private long curperiod;
    private long exratetable;
    private long accounttable;
    private long cashinitperiod;
    private long accountingsys;
    private boolean isendinit;
    private String enable;
    private boolean isbizunit;
    private long yearprofitacct;
    private boolean isbudget;
    private boolean isendinitcashflow;
    private boolean isLocalSet;
    private Date localSetDate;
    private static final String selectFields = "org,bookstype,bookstype.number,basecurrency,periodtype,startperiod,curperiod,exratetable,accounttable,cashinitperiod,isendinit,enable,isbizunit,accountingsys,yearprofitacct,isendinitcashflow,localset,localsetdate,isbudget";

    public AccountBookInfo() {
    }

    public AccountBookInfo(String orgNum, String booktypeNum) {
        QFilter qorg = new QFilter("org.number", "=", (Object)orgNum);
        QFilter qbooktype = new QFilter("bookstype.number", "=", (Object)booktypeNum);
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((String)"gl_accountbook", (String)selectFields, (QFilter[])new QFilter[]{qorg, qbooktype});
        if (obj == null) {
            return;
        }
        this.initVal(obj);
    }

    public AccountBookInfo(long orgId, long bookTypeId) {
        QFilter qorg = new QFilter("org", "=", (Object)orgId);
        QFilter qbooktype = new QFilter("bookstype", "=", (Object)bookTypeId);
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((String)"gl_accountbook", (String)selectFields, (QFilter[])new QFilter[]{qorg, qbooktype});
        if (obj == null) {
            return;
        }
        this.initVal(obj);
    }

    public AccountBookInfo(DynamicObject dynBook) {
        this.initVal(dynBook);
    }

    private void initVal(DynamicObject obj) {
        this.id = obj.getLong("id");
        this.org = obj.getLong("org.id");
        this.bookstype = obj.getLong("bookstype.id");
        this.bookstypeNum = obj.getString("bookstype.number");
        this.accounttable = obj.getLong("accounttable.id");
        this.basecurrency = obj.getLong("basecurrency.id");
        this.periodtype = obj.getLong("periodtype.id");
        this.startperiod = obj.getLong("startperiod.id");
        this.curperiod = obj.getLong("curperiod.id");
        this.exratetable = obj.getLong("exratetable.id");
        this.cashinitperiod = obj.getLong("cashinitperiod.id");
        this.accountingsys = obj.getLong("accountingsys.id");
        this.isendinit = obj.getBoolean("isendinit");
        this.isbizunit = obj.getBoolean("isbizunit");
        this.enable = obj.getString("enable");
        this.yearprofitacct = obj.getLong("yearprofitacct.id");
        this.isendinitcashflow = obj.getBoolean("isendinitcashflow");
        this.isLocalSet = obj.getBoolean("localset");
        this.localSetDate = obj.getDate("localsetdate");
        this.isbudget = obj.getBoolean("isbudget");
    }

    public AccountBookInfo(long bookId) {
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((Object)bookId, (String)"gl_accountbook", (String)selectFields);
        if (obj == null) {
            return;
        }
        this.initVal(obj);
    }

    public long getId() {
        return this.id;
    }

    public long getOrgId() {
        return this.org;
    }

    public long getBookTypeId() {
        return this.bookstype;
    }

    public String getBookTypeNum() {
        return this.bookstypeNum;
    }

    public long getBaseCurrencyId() {
        return this.basecurrency;
    }

    public long getPeriodTypeId() {
        return this.periodtype;
    }

    public long getStartPeriodId() {
        return this.startperiod;
    }

    public void setCurPeriodId(long period) {
        this.curperiod = period;
    }

    public long getCurPeriodId() {
        return this.curperiod;
    }

    public long getCurPeriodId(long openedPeriodId) {
        if (openedPeriodId > 0L) {
            return openedPeriodId;
        }
        return this.curperiod;
    }

    public long getExrateTableId() {
        return this.exratetable;
    }

    public long getAccountTableId() {
        return this.accounttable;
    }

    public long getCashinitPeriodId() {
        return this.cashinitperiod;
    }

    public long getAccountingsysId() {
        return this.accountingsys;
    }

    public boolean isIsendinit() {
        return this.isendinit;
    }

    public String getEnable() {
        return this.enable;
    }

    public boolean isIsbizunit() {
        return this.isbizunit;
    }

    public long getYearProfitAcct() {
        return this.yearprofitacct;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setOrg(long org) {
        this.org = org;
    }

    public void setBookstype(long bookstype) {
        this.bookstype = bookstype;
    }

    public void setBookstypeNum(String bookstypeNum) {
        this.bookstypeNum = bookstypeNum;
    }

    public void setBasecurrency(long basecurrency) {
        this.basecurrency = basecurrency;
    }

    public void setPeriodtype(long periodtype) {
        this.periodtype = periodtype;
    }

    public void setStartperiod(long startperiod) {
        this.startperiod = startperiod;
    }

    public void setExratetable(long exratetable) {
        this.exratetable = exratetable;
    }

    public void setAccounttable(long accounttable) {
        this.accounttable = accounttable;
    }

    public void setCashinitperiod(long cashinitperiod) {
        this.cashinitperiod = cashinitperiod;
    }

    public void setAccountingsys(long accountingsys) {
        this.accountingsys = accountingsys;
    }

    public void setIsendinit(boolean isendinit) {
        this.isendinit = isendinit;
    }

    public void setEnable(String enable) {
        this.enable = enable;
    }

    public void setIsbizunit(boolean isbizunit) {
        this.isbizunit = isbizunit;
    }

    public void setYearprofitacct(long yearprofitacct) {
        this.yearprofitacct = yearprofitacct;
    }

    public boolean isIsendinitcashflow() {
        return this.isendinitcashflow;
    }

    public void setIsendinitcashflow(boolean isendinitcashflow) {
        this.isendinitcashflow = isendinitcashflow;
    }

    public boolean isLocalSet() {
        return this.isLocalSet;
    }

    public void setLocalSet(boolean localSet) {
        this.isLocalSet = localSet;
    }

    public Date getLocalSetDate() {
        return this.localSetDate;
    }

    public void setLocalSetDate(Date localSetDate) {
        this.localSetDate = localSetDate;
    }

    public boolean isBudget() {
        return this.isbudget;
    }

    public void setIsBudget(boolean isbudget) {
        this.isbudget = isbudget;
    }

    public static String getSelectFields() {
        return selectFields;
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public boolean equals(Object obj) {
        if (obj instanceof AccountBookInfo) {
            return this.id == ((AccountBookInfo)obj).getId();
        }
        return false;
    }

    public String toString() {
        return "AccountBookInfo [id=" + this.id + ", org=" + this.org + ", bookstype=" + this.bookstype + ", bookstypeNum=" + this.bookstypeNum + ", basecurrency=" + this.basecurrency + ", periodtype=" + this.periodtype + ", startperiod=" + this.startperiod + ", curperiod=" + this.curperiod + ", exratetable=" + this.exratetable + ", accounttable=" + this.accounttable + ", cashinitperiod=" + this.cashinitperiod + ", accountingsys=" + this.accountingsys + ", isendinit=" + this.isendinit + ", enable=" + this.enable + ", isbizunit=" + this.isbizunit + ", yearprofitacct=" + this.yearprofitacct + ", isendinitcashflow=" + this.isendinitcashflow + ", isLocalSet=" + this.isLocalSet + ", localSetDate=" + this.localSetDate + "]";
    }
}

