/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.accountref;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.flex.FlexEntireData;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.ext.fi.accountref.AccountBookInfo;
import kd.bos.ext.fi.accountref.AccountRef;
import kd.bos.ext.fi.accountref.AccountTableRef;
import kd.bos.ext.fi.accountref.AccountVersionReplaceParam;
import kd.bos.ext.fi.accountref.AssGrpDefaultVal;
import kd.bos.ext.fi.accountref.BookVersion;
import kd.bos.ext.fi.accountref.BookVersionInfo;
import kd.bos.ext.fi.accountref.SingleAccountRef;
import kd.bos.ext.fi.accountref.ThreadCacheKey;
import kd.bos.ext.fi.ai.dap.cache.CacheHelper;
import kd.bos.ext.fi.ai.dap.cache.CacheKeyPrefix;
import kd.bos.ext.fi.ai.dap.cache.CacheModule;
import kd.bos.ext.fi.ai.dap.cache.DistributeCache;
import kd.bos.ext.fi.ai.dap.cache.LocalCacheHelper;
import kd.bos.ext.fi.ai.dap.cache.LocalCacheKey;
import kd.bos.flex.FlexService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.JSONUtils;

public class AccountRefUtils {
    public static final String ACCOUNTVERSION = "accountversion";
    public static final String ERROR_ACCT_NOT_FOUND = "acct";
    private static Log logger = LogFactory.getLog(AccountRefUtils.class);
    private static final String FLEX_ENTITY_NUMBER = "gl_assist";
    private static final String FLEX_ENTITY_VALUE_KEY = "value";
    private static final String FLEX_ENTITY_VALUE_ALIAS = "value";
    private static final String FLEX_ENTITY_GL_VALUE_KEY = "assvals";

    private AccountRefUtils() {
        throw new IllegalStateException("illegal initial");
    }

    public static long getNewAccountId(long orgId, long oldAccountTableId, long newAccountTableId, long oldAccountId) {
        AccountTableRef accountTableRef = AccountRefUtils.getAccountTableRef(orgId, oldAccountTableId, newAccountTableId);
        return accountTableRef.getNewAccountId(oldAccountId) == null ? 0L : accountTableRef.getNewAccountId(oldAccountId);
    }

    public static long getNewAccountMasterId(long orgId, long oldAccountTableId, long newAccountTableId, long oldAccountId) {
        AccountTableRef accountTableRef = AccountRefUtils.getMasterAccountTableRef(orgId, oldAccountTableId, newAccountTableId);
        return accountTableRef.getNewAccountId(oldAccountId) == null ? 0L : accountTableRef.getNewAccountId(oldAccountId);
    }

    public static Set<Long> getOldAccountIds(long orgId, long oldAccountTableId, long newAccountTableId, long newAccountId) {
        AccountTableRef accountTableRef = AccountRefUtils.getAccountTableRef(orgId, oldAccountTableId, newAccountTableId);
        return accountTableRef.getOldAccountIds(newAccountId) == null ? Collections.emptySet() : accountTableRef.getOldAccountIds(newAccountId);
    }

    public static Set<Long> getOldAccountMasterIds(long orgId, long oldAccountTableId, long newAccountTableId, long newAccountId) {
        AccountTableRef accountTableRef = AccountRefUtils.getMasterAccountTableRef(orgId, oldAccountTableId, newAccountTableId);
        return accountTableRef.getOldAccountIds(newAccountId) == null ? Collections.emptySet() : accountTableRef.getOldAccountIds(newAccountId);
    }

    public static SingleAccountRef getSingleAccountRefByOldAccountMasterId(long orgId, long oldAccountTableId, long newAccountTableId, long oldAccountMasterId) {
        AccountTableRef accountTableRef = AccountRefUtils.getMasterAccountTableRef(orgId, oldAccountTableId, newAccountTableId);
        SingleAccountRef singleAccountRef = new SingleAccountRef();
        long newAccountMasterId = accountTableRef.getNewAccountId(oldAccountMasterId) == null ? 0L : accountTableRef.getNewAccountId(oldAccountMasterId);
        singleAccountRef.setOldAccountId(Collections.singleton(oldAccountMasterId));
        singleAccountRef.setNewAccountId(newAccountMasterId);
        AssGrpDefaultVal newDefaultAssgrp = accountTableRef.getNewDefaultAssgrp(oldAccountMasterId);
        if (!Objects.isNull(newDefaultAssgrp)) {
            singleAccountRef.addAssGrpDefaultVals(oldAccountMasterId, newDefaultAssgrp);
        }
        return singleAccountRef;
    }

    public static SingleAccountRef getSingleAccountRefByNewAccountMasterId(long orgId, long oldAccountTableId, long newAccountTableId, long newAccountMasterId) {
        AccountTableRef accountTableRef = AccountRefUtils.getMasterAccountTableRef(orgId, oldAccountTableId, newAccountTableId);
        SingleAccountRef singleAccountRef = new SingleAccountRef();
        Set<Long> oldAccountMasterIds = accountTableRef.getOldAccountIds(newAccountMasterId) == null ? Collections.emptySet() : accountTableRef.getOldAccountIds(newAccountMasterId);
        singleAccountRef.setOldAccountId(oldAccountMasterIds);
        singleAccountRef.setNewAccountId(newAccountMasterId);
        for (Long oldAccountId : oldAccountMasterIds) {
            AssGrpDefaultVal newDefaultAssgrp = accountTableRef.getNewDefaultAssgrp(oldAccountId);
            if (Objects.isNull(newDefaultAssgrp)) continue;
            singleAccountRef.addAssGrpDefaultVals(oldAccountId, newDefaultAssgrp);
        }
        return singleAccountRef;
    }

    public static AccountTableRef getAccountTableRef(long orgId, long oldAccountTableId, long newAccountTableId) {
        return (AccountTableRef)ThreadCache.get((Object)AccountRefUtils.getThreadCacheKey(orgId, oldAccountTableId, newAccountTableId), () -> {
            QFilter oldTableFilter = new QFilter("oldacttable", "=", (Object)oldAccountTableId);
            QFilter newTableFilter = new QFilter("newacttable", "=", (Object)newAccountTableId);
            QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accounttableref", (Long)orgId);
            DynamicObject accountTableRefDO = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_accounttableref", (QFilter[])new QFilter[]{oldTableFilter, newTableFilter, baseDataFilter});
            AccountRef accountRef = new AccountRef();
            AccountTableRef accountTableRef = new AccountTableRef(oldAccountTableId, newAccountTableId, accountRef);
            if (Objects.isNull(accountTableRefDO)) {
                return accountTableRef;
            }
            DynamicObjectCollection refEntries = accountTableRefDO.getDynamicObjectCollection("mappingentry");
            HashSet masterIds = new HashSet(refEntries.size());
            refEntries.forEach(x -> {
                DynamicObject oldAccount = x.getDynamicObject("oldaccount");
                DynamicObject newAccount = x.getDynamicObject("newaccount");
                if (oldAccount != null && newAccount != null) {
                    masterIds.add(oldAccount.getLong("masterid"));
                    masterIds.add(newAccount.getLong("masterid"));
                }
            });
            ArrayList<QFilter> filters = new ArrayList<QFilter>(4);
            Date date = accountTableRefDO.getDate("enabledate");
            filters.add(new QFilter("startdate", "<=", (Object)date));
            filters.add(new QFilter("enddate", ">", (Object)date));
            filters.add(new QFilter("masterid", "in", masterIds));
            filters.add(BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)orgId));
            Map accounts = BusinessDataServiceHelper.loadFromCache((String)"bd_accountview", (String)"id,masterid", (QFilter[])filters.toArray(new QFilter[filters.size()]));
            Map<Long, Long> masterIdAndId = accounts.values().stream().collect(Collectors.toMap(x -> x.getLong("masterid"), x -> x.getLong("id"), (oldVal, newVal) -> newVal));
            for (DynamicObject refEntry : refEntries) {
                DynamicObject oldAccount = refEntry.getDynamicObject("oldaccount");
                DynamicObject newAccount = refEntry.getDynamicObject("newaccount");
                if (oldAccount == null || newAccount == null) continue;
                long oldAccountMasterId = oldAccount.getLong("masterid");
                long newAccountMasterId = newAccount.getLong("masterid");
                Long oldAccountId = masterIdAndId.get(oldAccountMasterId);
                Long newAccountId = masterIdAndId.get(newAccountMasterId);
                if (oldAccountId == null || newAccountId == null) continue;
                DynamicObjectCollection assgrpEntries = refEntry.getDynamicObjectCollection("assgrpentry");
                HashMap<String, Object> assgrpMap = new HashMap<String, Object>(assgrpEntries.size());
                for (DynamicObject assgrpEntry : assgrpEntries) {
                    String value;
                    DynamicObject assistItem = assgrpEntry.getDynamicObject("assisttype");
                    if (Objects.isNull(assistItem) || !StringUtils.isNotBlank((CharSequence)(value = assgrpEntry.getString("value")))) continue;
                    String valueType = assistItem.getString("valuetype");
                    if ("1".equals(valueType) || "2".equals(valueType)) {
                        assgrpMap.put(assistItem.getString("flexfield"), Long.valueOf(value));
                        continue;
                    }
                    assgrpMap.put(assistItem.getString("flexfield"), value);
                }
                accountRef.addAccountRef(newAccountId, oldAccountId, assgrpMap);
            }
            return accountTableRef;
        });
    }

    public static AccountTableRef getMasterAccountTableRef(long orgId, long oldAccountTableId, long newAccountTableId) {
        return (AccountTableRef)ThreadCache.get((Object)AccountRefUtils.getMasterThreadCacheKey(orgId, oldAccountTableId, newAccountTableId), () -> {
            QFilter oldTableFilter = new QFilter("oldacttable", "=", (Object)oldAccountTableId);
            QFilter newTableFilter = new QFilter("newacttable", "=", (Object)newAccountTableId);
            QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accounttableref", (Long)orgId);
            DynamicObject accountTableRefDO = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_accounttableref", (QFilter[])new QFilter[]{oldTableFilter, newTableFilter, baseDataFilter});
            AccountRef accountRef = new AccountRef();
            AccountTableRef accountTableRef = new AccountTableRef(oldAccountTableId, newAccountTableId, accountRef);
            if (!Objects.isNull(accountTableRefDO)) {
                DynamicObjectCollection refEntries = accountTableRefDO.getDynamicObjectCollection("mappingentry");
                for (DynamicObject refEntry : refEntries) {
                    DynamicObject oldAccount = refEntry.getDynamicObject("oldaccount");
                    DynamicObject newAccount = refEntry.getDynamicObject("newaccount");
                    if (oldAccount == null || newAccount == null) continue;
                    long oldAccountId = oldAccount.getLong("masterid");
                    long newAccountId = newAccount.getLong("masterid");
                    DynamicObjectCollection assgrpEntries = refEntry.getDynamicObjectCollection("assgrpentry");
                    HashMap<String, Object> assgrpMap = new HashMap<String, Object>(assgrpEntries.size());
                    for (DynamicObject assgrpEntry : assgrpEntries) {
                        String value;
                        DynamicObject assistItem = assgrpEntry.getDynamicObject("assisttype");
                        if (Objects.isNull(assistItem) || !StringUtils.isNotBlank((CharSequence)(value = assgrpEntry.getString("value")))) continue;
                        String valueType = assistItem.getString("valuetype");
                        if ("1".equals(valueType) || "2".equals(valueType)) {
                            assgrpMap.put(assistItem.getString("flexfield"), Long.valueOf(value));
                            continue;
                        }
                        assgrpMap.put(assistItem.getString("flexfield"), value);
                    }
                    accountRef.addAccountRef(newAccountId, oldAccountId, assgrpMap);
                }
            }
            return accountTableRef;
        });
    }

    private static String getThreadCacheKey(long orgId, long oldAccountTableId, long newAccountTableId) {
        return StringUtils.join((Object[])new Object[]{"bos-ext-fi-getAccountTableRef", orgId, oldAccountTableId, newAccountTableId}, (String)"-");
    }

    private static String getMasterThreadCacheKey(long orgId, long oldAccountTableId, long newAccountTableId) {
        return StringUtils.join((Object[])new Object[]{"bos-ext-fi-getMasterAccountTableRef", orgId, oldAccountTableId, newAccountTableId}, (String)"-");
    }

    public static long getCurPeriodAccountTableId(long orgId, long bookTypeId, long periodId) {
        List<BookVersionInfo> bookVersions = AccountRefUtils.getAccountBookVersionsFromCache(orgId, bookTypeId);
        if (CollectionUtils.isEmpty(bookVersions)) {
            return 0L;
        }
        int size = bookVersions.size();
        for (int i = 0; i < size; ++i) {
            BookVersionInfo bookVersionInfo = bookVersions.get(i);
            if (periodId >= bookVersionInfo.getDisablePeriodId()) continue;
            return bookVersionInfo.getAccountTableId();
        }
        return 0L;
    }

    public static long getCurDateAccountTableId(long orgId, long bookTypeId, Date date) {
        List<BookVersionInfo> bookVersions = AccountRefUtils.getAccountBookVersionsFromCache(orgId, bookTypeId);
        if (CollectionUtils.isEmpty(bookVersions)) {
            return 0L;
        }
        int size = bookVersions.size();
        for (int i = 0; i < size; ++i) {
            BookVersionInfo bookVersionInfo = bookVersions.get(i);
            if (date.compareTo(bookVersionInfo.getDisableDate()) >= 0) continue;
            return bookVersionInfo.getAccountTableId();
        }
        return 0L;
    }

    private static List<BookVersionInfo> getAccountBookVersionsFromCache(long orgId, long bookTypeId) {
        LocalCacheKey cacheKey = LocalCacheKey.getCacheKey((CacheKeyPrefix)CacheKeyPrefix.ACCOUNT_BOOK_VERSION, (Object[])new Object[]{orgId, bookTypeId});
        ArrayList<BookVersionInfo> result = (ArrayList<BookVersionInfo>)LocalCacheHelper.get((LocalCacheKey)cacheKey, List.class);
        if (Objects.isNull(result)) {
            QFilter qforg = new QFilter("org", "=", (Object)orgId);
            QFilter qfBooktype = new QFilter("booktype", "=", (Object)bookTypeId);
            Map versionDOs = BusinessDataServiceHelper.loadFromCache((String)"gl_book_version", (QFilter[])new QFilter[]{qforg, qfBooktype});
            ArrayList versions = new ArrayList(versionDOs.values());
            result = new ArrayList<BookVersionInfo>(versions.size() + 1);
            if (versions.size() > 0) {
                versions.sort((x, y) -> x.getDate("enabledate").compareTo(y.getDate("enabledate")));
                DynamicObject firstVersion = (DynamicObject)versions.get(0);
                long firstAccountTableId = firstVersion.getLong(BookVersion.id_("oldaccttab"));
                Date firstDisableDate = firstVersion.getDate("enabledate");
                long firstDisablePeriodId = firstVersion.getLong(BookVersion.id_("enableperiod"));
                result.add(new BookVersionInfo(firstDisableDate, firstAccountTableId, firstDisablePeriodId));
                for (DynamicObject versionDO : versions) {
                    result.add(new BookVersionInfo(versionDO.getDate("disabledate"), versionDO.getLong(BookVersion.id_("accounttable")), versionDO.getLong(BookVersion.id_("disableperiod"))));
                }
            } else {
                AccountBookInfo bookInfo = AccountRefUtils.getBookFromAccSys(orgId, bookTypeId);
                if (!Objects.isNull(bookInfo)) {
                    result.add(new BookVersionInfo(AccountRefUtils.getEndDate(), bookInfo.getAccountTableId(), 99999999999L));
                }
            }
            LocalCacheHelper.put((LocalCacheKey)cacheKey, result);
        }
        return result;
    }

    public static Date getEndDate() {
        try {
            SimpleDateFormat dt = new SimpleDateFormat("yyyy-MM-dd");
            return dt.parse("2999-12-31");
        }
        catch (ParseException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u89e3\u6790\u5f02\u5e38", (String)"AccountRefUtils_105", (String)"fi-bd-opplugin", (Object[])new Object[0]));
        }
    }

    public static AccountBookInfo getBookFromAccSys(long org, long bookType) {
        return (AccountBookInfo)ThreadCache.get((Object)ThreadCacheKey.getAccountBookKey(org, bookType), () -> {
            Long bookId = AccountRefUtils.getBookIdFromCache(org, bookType);
            return bookId == null ? null : new AccountBookInfo(bookId);
        });
    }

    private static Long getBookIdFromCache(long org, long bookType) {
        return (Long)ThreadCache.get((Object)ThreadCacheKey.getBookIdKey(org, bookType), () -> {
            long result;
            String key = org + "-" + bookType;
            DistributeCache cache = CacheHelper.getDistributeCache((CacheModule)CacheModule.book);
            String bookIdStr = cache.get(key);
            if (StringUtils.isEmpty((CharSequence)bookIdStr)) {
                QFilter orgF = new QFilter("org", "=", (Object)org);
                QFilter bookTypeF = new QFilter("bookstype", "=", (Object)bookType);
                DynamicObject book = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"id", (QFilter[])new QFilter[]{orgF, bookTypeF});
                if (book == null) {
                    return null;
                }
                result = book.getLong("id");
                cache.put(key, String.valueOf(result));
            } else {
                result = Long.parseLong(bookIdStr);
            }
            return result;
        });
    }

    @Deprecated
    public static DynamicObject getCurAccountForDap(AccountVersionReplaceParam accountVersionParam) {
        return AccountRefUtils.getCurVersionAccount(accountVersionParam);
    }

    public static DynamicObject getCurVersionAccount(AccountVersionReplaceParam accountVersionParam) {
        DynamicObject account = accountVersionParam.getAccount();
        if (!Objects.isNull(accountVersionParam.getAccount())) {
            account = BusinessDataServiceHelper.loadSingleFromCache((Object)account.getLong("id"), (String)"bd_accountview");
        }
        long orgId = accountVersionParam.getOrgId();
        long bookTypeId = accountVersionParam.getBookTypeId();
        long curTableId = accountVersionParam.getCurAccountTableId();
        if (0L == curTableId) {
            curTableId = AccountRefUtils.getCurPeriodAccountTableId(orgId, bookTypeId, accountVersionParam.getPeriod().getLong("id"));
            accountVersionParam.setCurAccountTableId(curTableId);
        }
        long accountTableId = account.getLong("accounttable_id");
        accountVersionParam.setVoucherAccountTableId(accountTableId);
        boolean tableVersion = false;
        if (curTableId != accountTableId) {
            tableVersion = true;
        }
        DynamicObject period = accountVersionParam.getPeriod();
        Date startDate = account.getDate("startdate");
        Date endDate = account.getDate("enddate");
        DynamicObject accountInfo = null;
        if (tableVersion || startDate.getTime() > period.getDate("enddate").getTime() || endDate.getTime() <= period.getDate("enddate").getTime() || orgId != account.getLong("createorg_id")) {
            HashMap<String, DynamicObject> accountReplaceMap = (HashMap<String, DynamicObject>)LocalCacheHelper.get((LocalCacheKey)LocalCacheKey.getCacheKey((CacheKeyPrefix)CacheKeyPrefix.GL_ACCOUNT_REPLACE, (Object[])new Object[0]), Map.class);
            if (accountReplaceMap == null) {
                accountReplaceMap = new HashMap<String, DynamicObject>(16);
            }
            long acctMasterid = account.getLong("masterid");
            String key = AccountRefUtils.getVersonKey(new Object[]{orgId, acctMasterid, period.getLong("id")});
            accountInfo = (DynamicObject)accountReplaceMap.get(key);
            if (accountInfo == null && null != (accountInfo = tableVersion ? AccountRefUtils.getCurAccountContainTable(accountVersionParam) : AccountRefUtils.getCurAccount(accountVersionParam))) {
                accountReplaceMap.put(key, accountInfo);
            }
            if (accountInfo == null) {
                Optional<String> accNumber = AccountRefUtils.getAccountNumber(accountVersionParam);
                Object accountNumber = accNumber.isPresent() ? accNumber.get() : Long.valueOf(acctMasterid);
                throw new KDBizException(new ErrorCode(ERROR_ACCT_NOT_FOUND, String.format(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e0b\u627e\u4e0d\u5230\u7f16\u7801\u4e3a\uff1a%s\u7684\u79d1\u76ee\u6570\u636e\u3002", (String)"AccountRefUtils_106", (String)"fi-bd-common", (Object[])new Object[0]), accountNumber)), new Object[0]);
            }
            long assgrpId = AccountRefUtils.getAssgrpReplaceForDap(accountVersionParam, accountInfo, orgId, acctMasterid);
            accountVersionParam.setAssgrpId(assgrpId);
            LocalCacheHelper.put((LocalCacheKey)LocalCacheKey.getCacheKey((CacheKeyPrefix)CacheKeyPrefix.GL_ACCOUNT_REPLACE, (Object[])new Object[0]), accountReplaceMap);
        } else {
            accountInfo = account;
        }
        return accountInfo;
    }

    public static DynamicObject getCurAccountContainTable(AccountVersionReplaceParam accountVersionParam) {
        SingleAccountRef accountRef = AccountRefUtils.getSingleAccountRefByOldAccountMasterId(accountVersionParam.getOrgId(), accountVersionParam.getVoucherAccountTableId(), accountVersionParam.getCurAccountTableId(), accountVersionParam.getAccountMasterid());
        long curAccountMasterId = accountRef.getNewAccountId();
        if (curAccountMasterId == 0L) {
            accountRef = AccountRefUtils.getSingleAccountRefByNewAccountMasterId(accountVersionParam.getOrgId(), accountVersionParam.getCurAccountTableId(), accountVersionParam.getVoucherAccountTableId(), accountVersionParam.getAccountMasterid());
            Set<Long> curAccountMasterIds = accountRef.getOldAccountId();
            if (curAccountMasterIds == null || curAccountMasterIds.size() != 1) {
                return null;
            }
            curAccountMasterId = curAccountMasterIds.iterator().next();
        }
        Map<Long, AssGrpDefaultVal> assGrpDefaultValsMap = accountRef.getAssGrpDefaultVals();
        AssGrpDefaultVal assgrpDefVal = assGrpDefaultValsMap.get(accountVersionParam.getAccountMasterid());
        accountVersionParam.setAssgrpDefVal(assgrpDefVal);
        accountVersionParam.setVoucherAccountTableId(accountVersionParam.getCurAccountTableId());
        accountVersionParam.setAccountMasterid(curAccountMasterId);
        return AccountRefUtils.getCurAccount(accountVersionParam);
    }

    public static DynamicObject getCurAccount(AccountVersionReplaceParam accountVersionParam) {
        Optional<String> accountNumber;
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        qFilterList.add(BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)accountVersionParam.getOrgId()));
        if (accountVersionParam.getPeriod() != null) {
            qFilterList.add(new QFilter("startdate", "<=", (Object)accountVersionParam.getPeriod().getDate("enddate")));
            qFilterList.add(new QFilter("enddate", ">", (Object)accountVersionParam.getPeriod().getDate("enddate")));
        } else {
            qFilterList.add(new QFilter("enddate", "=", (Object)AccountRefUtils.getEndDate()));
        }
        Long accountTableId = accountVersionParam.getCurAccountTableId();
        if (!accountVersionParam.getIsFromVoucherEdit() && (accountNumber = AccountRefUtils.getAccountNumber(accountVersionParam)).isPresent()) {
            ArrayList<QFilter> numberFilters = new ArrayList<QFilter>(8);
            numberFilters.addAll(qFilterList);
            numberFilters.addAll(AccountRefUtils.getNumberFilter(accountTableId, accountNumber.get()));
            numberFilters.addAll(accountVersionParam.getCustomAccountFilterList());
            List ids = QueryServiceHelper.queryPrimaryKeys((String)"bd_accountview", (QFilter[])numberFilters.toArray(new QFilter[0]), null, (int)-1);
            if (!CollectionUtils.isEmpty((Collection)ids)) {
                return BusinessDataServiceHelper.loadSingleFromCache(ids.get(0), (String)"bd_accountview");
            }
        }
        if (accountVersionParam.getAccountMasterid() != 0L) {
            qFilterList.add(new QFilter("masterid", "=", (Object)accountVersionParam.getAccountMasterid()));
        } else {
            qFilterList.addAll(AccountRefUtils.getNumberFilter(accountTableId, accountVersionParam.getAccountNumber()));
        }
        qFilterList.addAll(accountVersionParam.getCustomAccountFilterList());
        List ids = QueryServiceHelper.queryPrimaryKeys((String)"bd_accountview", (QFilter[])qFilterList.toArray(new QFilter[0]), null, (int)-1);
        if (ids.isEmpty()) {
            return null;
        }
        return BusinessDataServiceHelper.loadSingleFromCache(ids.get(0), (String)"bd_accountview");
    }

    private static List<QFilter> getNumberFilter(long accountTableId, String accountNumber) {
        ArrayList<QFilter> numberFilters = new ArrayList<QFilter>(8);
        numberFilters.add(new QFilter("number", "=", (Object)accountNumber));
        numberFilters.add(new QFilter("accounttable", "=", (Object)accountTableId));
        return numberFilters;
    }

    public static Optional<String> getAccountNumber(AccountVersionReplaceParam accountVersionParam) {
        String accountNumber = accountVersionParam.getAccountNumber();
        if (StringUtils.isNotBlank((CharSequence)accountNumber)) {
            return Optional.of(accountNumber);
        }
        DynamicObject account = accountVersionParam.getAccount();
        Optional<String> number = AccountRefUtils.getAccountNumber(accountVersionParam, account);
        if (number.isPresent()) {
            return number;
        }
        account = QueryServiceHelper.queryOne((String)"bd_accountview", (String)"number", (QFilter[])new QFilter("id", "=", (Object)accountVersionParam.getAccountMasterid()).toArray());
        return AccountRefUtils.getAccountNumber(accountVersionParam, account);
    }

    private static Optional<String> getAccountNumber(AccountVersionReplaceParam accountVersionParam, DynamicObject account) {
        if (Objects.nonNull(account)) {
            String accountNumber = account.getString("number");
            accountVersionParam.setAccountNumber(accountNumber);
            return Optional.of(accountNumber);
        }
        return Optional.empty();
    }

    public static long getAssgrpReplaceForDap(AccountVersionReplaceParam param, DynamicObject accountInfo, long orgId, long acctMasterid) {
        long assgrpId = param.getAssgrpId();
        if (assgrpId == 0L) {
            return 0L;
        }
        LocalCacheKey cacheKey = LocalCacheKey.getCacheKey((CacheKeyPrefix)CacheKeyPrefix.GL_ASSGRP_REPLACE_DAP, (Object[])new Object[0]);
        HashMap<String, Long> assgrpReplaceMap = (HashMap<String, Long>)LocalCacheHelper.get((LocalCacheKey)cacheKey, Map.class);
        if (assgrpReplaceMap == null) {
            assgrpReplaceMap = new HashMap<String, Long>(999);
            LocalCacheHelper.put((LocalCacheKey)cacheKey, assgrpReplaceMap);
        }
        String assgrpKey = AccountRefUtils.getVersonKey(new Object[]{orgId, acctMasterid, assgrpId, param.getPeriod().getLong("id")});
        return assgrpReplaceMap.computeIfAbsent(assgrpKey, k -> {
            Map assgrpMap;
            DynamicObject assgrp = BusinessDataServiceHelper.loadSingleFromCache((Object)assgrpId, (String)FLEX_ENTITY_NUMBER, (String)FLEX_ENTITY_GL_VALUE_KEY);
            String assgrpJson = assgrp.getString(FLEX_ENTITY_GL_VALUE_KEY);
            try {
                assgrpMap = (Map)JSONUtils.cast((String)assgrpJson, Map.class);
            }
            catch (IOException e) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7248\u672c\u5316-\u6838\u7b97\u7ef4\u5ea6\u89e3\u6790\u5931\u8d25\uff1a%s", (String)"AccountRefUtils_104", (String)"fi-bd-opplugin", (Object[])new Object[0]), assgrpJson));
            }
            AssGrpDefaultVal assgrpDefVal = param.getAssgrpDefVal();
            DynamicObjectCollection assistEntry = accountInfo.getDynamicObjectCollection("checkitementry");
            HashMap<String, Object> assgrpNew = new HashMap<String, Object>(assistEntry.size());
            for (DynamicObject assist : assistEntry) {
                DynamicObject assistDyn = assist.getDynamicObject("asstactitem");
                String assistId = assistDyn.getString("flexfield");
                Object assistValue = assgrpMap.get(assistId);
                if (assistValue != null) {
                    assgrpNew.put(assistId, assistValue);
                    continue;
                }
                if (assgrpDefVal == null) continue;
                assgrpNew.put(assistId, assgrpDefVal.getDefaultAssgrpId(assistId));
            }
            return AccountRefUtils.rebuildAssgrpId(assgrpNew);
        });
    }

    public static void getAssgrpReplace(DynamicObject assgrp, DynamicObject accountInfo, long orgId, long acctMasterid, Map<String, DynamicObject> assgrpReplaceMap, AssGrpDefaultVal tableVersonDefaultAssgrp, long periodId) {
        DynamicObject assgrpReplace;
        long assGrpId = assgrp.getLong("id");
        String assgrpJson = null;
        if (assGrpId != 0L) {
            assgrpJson = assgrp.getString("value");
        }
        String assgrpKey = AccountRefUtils.getVersonKey(new Object[]{orgId, acctMasterid, assGrpId, periodId});
        if (assgrpReplaceMap == null) {
            assgrpReplaceMap = new HashMap<String, DynamicObject>(999);
        }
        if ((assgrpReplace = assgrpReplaceMap.get(assgrpKey)) != null) {
            assgrp.set("id", (Object)assgrpReplace.getLong("id"));
            assgrp.set("value", (Object)assgrpReplace.getString("value"));
            return;
        }
        assgrpReplace = new DynamicObject(assgrp.getDynamicObjectType());
        HashMap assgrpMap = null;
        try {
            assgrpMap = assgrpJson != null ? (HashMap)JSONUtils.cast((String)assgrpJson, Map.class) : new HashMap(1);
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
        DynamicObjectCollection assistEntry = accountInfo.getDynamicObjectCollection("checkitementry");
        HashMap<String, Object> assgrpNew = new HashMap<String, Object>(assistEntry.size());
        for (DynamicObject assist : assistEntry) {
            DynamicObject assistDyn = assist.getDynamicObject("asstactitem");
            String assistId = assistDyn.getString("flexfield");
            Object assistValue = null;
            if (null != assgrpMap) {
                assistValue = assgrpMap.get(assistId);
            }
            if (assistValue != null) {
                assgrpNew.put(assistId, assistValue);
                continue;
            }
            if (tableVersonDefaultAssgrp == null) continue;
            assgrpNew.put(assistId, tableVersonDefaultAssgrp.getDefaultAssgrpId(assistId));
        }
        if (assgrpNew != null) {
            assGrpId = AccountRefUtils.rebuildAssgrpId(assgrpNew);
        }
        try {
            assgrpJson = JSONUtils.toString(assgrpNew);
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
        assgrpReplace.set("id", (Object)assGrpId);
        assgrpReplace.set("value", (Object)assgrpJson);
        assgrp.set("id", (Object)assGrpId);
        assgrp.set("value", (Object)assgrpJson);
        assgrpReplaceMap.put(assgrpKey, assgrpReplace);
    }

    public static Long getAssgrpReplaceId(long oldAssgrpId, String oldAssgrpJson, DynamicObject accountInfo, long orgId, long acctMasterid, Map<String, Long> assgrpReplaceMap, AssGrpDefaultVal tableVersonDefaultAssgrp, long periodId) {
        HashMap assgrpMap;
        Long replaceAssgrpId;
        String assgrpKey = AccountRefUtils.getVersonKey(new Object[]{orgId, acctMasterid, oldAssgrpId, periodId});
        if (assgrpReplaceMap == null) {
            assgrpReplaceMap = new HashMap<String, Long>(999);
        }
        if ((replaceAssgrpId = assgrpReplaceMap.get(assgrpKey)) != null) {
            return replaceAssgrpId;
        }
        long newAssgrpId = 0L;
        try {
            assgrpMap = StringUtils.isNotBlank((CharSequence)oldAssgrpJson) ? (HashMap)JSONUtils.cast((String)oldAssgrpJson, Map.class) : new HashMap(1);
        }
        catch (IOException e) {
            throw new KDBizException("json parse error : " + oldAssgrpJson);
        }
        if (assgrpMap.isEmpty()) {
            return newAssgrpId;
        }
        DynamicObjectCollection assistEntry = accountInfo.getDynamicObjectCollection("checkitementry");
        HashMap<String, Object> newAssgrpJsonMap = new HashMap<String, Object>(assistEntry.size());
        for (DynamicObject assist : assistEntry) {
            DynamicObject assistDyn = assist.getDynamicObject("asstactitem");
            String assistId = assistDyn.getString("flexfield");
            Object assistValue = assgrpMap.get(assistId);
            if (assistValue != null) {
                newAssgrpJsonMap.put(assistId, assistValue);
                continue;
            }
            if (tableVersonDefaultAssgrp == null) continue;
            newAssgrpJsonMap.put(assistId, tableVersonDefaultAssgrp.getDefaultAssgrpId(assistId));
        }
        if (!newAssgrpJsonMap.isEmpty()) {
            newAssgrpId = AccountRefUtils.rebuildAssgrpId(newAssgrpJsonMap);
        }
        assgrpReplaceMap.put(assgrpKey, newAssgrpId);
        return newAssgrpId;
    }

    public static String getVersonKey(Object[] keyValues) {
        return StringUtils.join((Object[])keyValues, (String)"&");
    }

    public static Long rebuildAssgrpId(Map<String, Object> flexFieldValueMap) {
        if (flexFieldValueMap.isEmpty()) {
            return 0L;
        }
        ArrayList<FlexEntireData.FlexData> flexDatas = new ArrayList<FlexEntireData.FlexData>();
        FlexEntireData flexEntireData = new FlexEntireData();
        for (Map.Entry<String, Object> entry : flexFieldValueMap.entrySet()) {
            String flexField = entry.getKey();
            Object value = entry.getValue();
            FlexEntireData.FlexData flexData = new FlexEntireData.FlexData(flexEntireData);
            if (value instanceof Long || value instanceof Integer) {
                flexData.setDbType(FlexEntireData.FlexFieldDataType.LONG);
            } else if (value instanceof String) {
                flexData.setDbType(FlexEntireData.FlexFieldDataType.STRING);
            }
            flexData.setPropId(flexField);
            flexData.setValue(value);
            if (value == null) continue;
            flexDatas.add(flexData);
        }
        flexEntireData.setFlexDatas(flexDatas);
        MainEntityType mainEntity = new MainEntityType();
        mainEntity.setAlias("T_GL_ASSIST");
        mainEntity.setDBRouteKey("gl");
        return FlexService.saveFlexData((MainEntityType)mainEntity, (FlexEntireData)flexEntireData);
    }

    public static Map<Long, Boolean> isAccountTableRefEnabled(Date date, List<Long> accountIds) {
        HashMap<Long, Boolean> result = new HashMap<Long, Boolean>(accountIds.size());
        for (Long accountId : accountIds) {
            result.put(accountId, Boolean.FALSE);
        }
        if (!accountIds.isEmpty()) {
            QFilter accountFilter = new QFilter("mappingentry.newaccount", "in", accountIds);
            QFilter enableDateFilter = new QFilter("enabledate", ">=", (Object)date);
            QFilter accountTableRefRecordFilter = QFilter.joinSQL((String)"bd_accounttableref", (String)"inner join t_bd_accttabref_record record on record.faccountrefid = bd_accounttableref.fid", (Object[])new Object[0]);
            try (DataSet enabledAccounts = QueryServiceHelper.queryDataSet((String)(AccountRefUtils.class.getName() + ".isAccountTabalRefEnabled"), (String)"bd_accounttableref", (String)"mappingentry.newaccount account", (QFilter[])new QFilter[]{accountFilter, enableDateFilter, accountTableRefRecordFilter}, null).groupBy(new String[]{"account"}).finish();){
                for (Row row : enabledAccounts) {
                    result.put(row.getLong("account"), Boolean.TRUE);
                }
            }
        }
        return result;
    }

    public static Map<Long, Boolean> isAccountTableRefEnabled(long orgId, List<Long> accountIds) {
        HashMap<Long, Boolean> result = new HashMap<Long, Boolean>(accountIds.size());
        for (Long accountId : accountIds) {
            result.put(accountId, Boolean.FALSE);
        }
        if (!accountIds.isEmpty()) {
            QFilter newAccountFilter = new QFilter("mappingentry.newaccount", "in", accountIds);
            QFilter oldAccountFilter = new QFilter("mappingentry.oldaccount", "in", accountIds);
            QFilter accountTableRefRecordFilter = QFilter.joinSQL((String)"bd_accounttableref", (String)("inner join t_bd_accttabref_record record on record.faccountrefid = bd_accounttableref.fid and record.forgid = " + orgId), (Object[])new Object[0]);
            try (DataSet enabledAccounts = QueryServiceHelper.queryDataSet((String)(AccountRefUtils.class.getName() + ".isAccountTabalRefEnabled"), (String)"bd_accounttableref", (String)"mappingentry.newaccount newaccount,mappingentry.oldaccount oldaccount", (QFilter[])new QFilter[]{newAccountFilter.or(oldAccountFilter), accountTableRefRecordFilter}, null).groupBy(new String[]{"newaccount", "oldaccount"}).finish();){
                for (Row row : enabledAccounts) {
                    result.put(row.getLong("newaccount"), Boolean.TRUE);
                    result.put(row.getLong("oldaccount"), Boolean.TRUE);
                }
            }
        }
        return result;
    }

    public static DynamicObject createNewFlex() {
        MainEntityType assistType = EntityMetadataCache.getDataEntityType((String)FLEX_ENTITY_NUMBER);
        try {
            MainEntityType cloneType = (MainEntityType)assistType.clone();
            DataEntityPropertyCollection properties = cloneType.getProperties();
            DynamicProperty valueType = cloneType.getProperty(FLEX_ENTITY_GL_VALUE_KEY);
            for (IDataEntityProperty type : properties) {
                if (!"value".equals(type.getAlias()) && !FLEX_ENTITY_GL_VALUE_KEY.equals(type.getName()) && !"value".equals(type.getName())) continue;
                valueType = (DynamicProperty)type;
                break;
            }
            if (valueType != null) {
                if (!"value".equals(valueType.getName())) {
                    properties.remove((Object)valueType);
                    valueType.setName("value");
                    cloneType.registerSimpleProperty((DynamicSimpleProperty)valueType);
                }
            } else {
                throw new KDBizException("gl_assist can't find value prop");
            }
            return (DynamicObject)cloneType.createInstance();
        }
        catch (CloneNotSupportedException e) {
            throw new KDException((Throwable)e, new ErrorCode("CREATE_NEW_FLEX", "create new flex error."), new Object[0]);
        }
    }

    public static boolean checkDate(DynamicObject account, Date peridoEndDate) {
        return account.getDate("startdate").getTime() > peridoEndDate.getTime() || account.getDate("enddate").getTime() <= peridoEndDate.getTime();
    }
}

