/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.accountref;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.ext.fi.accountref.CheckAccountReferenceResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.bd.business.service.cashitem.AccountCashFlowService;
import kd.fi.bd.business.vo.PresetCashFlowItemRelation;
import kd.fi.bd.util.AccountVersionControlChecker;
import kd.fi.bd.util.DebugTrace;

public class AccountTableRefUtils {
    private static final Log LOG = LogFactory.getLog(AccountCashFlowService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Long, CheckAccountReferenceResult> batchCheckAccountTableRef(Long accountTableId, Set<Long> orgIds, Set<Long> accIds, Date enableDate) {
        HashMap<Long, CheckAccountReferenceResult> relMap = new HashMap<Long, CheckAccountReferenceResult>(8);
        long tick = System.currentTimeMillis();
        try {
            List orgList = Lists.partition(new ArrayList<Long>(orgIds), (int)1000);
            for (List batchOrg : orgList) {
                Map<Long, CheckAccountReferenceResult> checkRes = AccountTableRefUtils.checkAccountTableRef(accountTableId, batchOrg, accIds, enableDate);
                if (CollectionUtils.isEmpty(checkRes)) continue;
                relMap.putAll(checkRes);
            }
        }
        catch (Throwable throwable) {
            if (DebugTrace.enable()) {
                LOG.info("batchCheckAccountTableRef_cost: {}, accTableId: {}, orgIds: {}", new Object[]{System.currentTimeMillis() - tick, accountTableId, orgIds});
            }
            throw throwable;
        }
        if (DebugTrace.enable()) {
            LOG.info("batchCheckAccountTableRef_cost: {}, accTableId: {}, orgIds: {}", new Object[]{System.currentTimeMillis() - tick, accountTableId, orgIds});
        }
        return relMap;
    }

    public static Map<Long, CheckAccountReferenceResult> checkAccountTableRef(Long accountTableId, List<Long> orgIds, Set<Long> accIds, Date enableDate) {
        Set<Object> useAccountTableRefs = AccountTableRefUtils.getOrgUseAccountTableRef(accountTableId, orgIds, enableDate);
        if (CollectionUtils.isEmpty(useAccountTableRefs)) {
            return new HashMap<Long, CheckAccountReferenceResult>(8);
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select foldaccountid,fnewaccountid,fid from t_bd_accounttablerefentry ", new Object[0]);
        sqlBuilder.appendIn(" where fid ", useAccountTableRefs.toArray());
        sqlBuilder.appendIn(" and ( foldaccountid ", accIds.toArray());
        sqlBuilder.appendIn(" or fnewaccountid ", accIds.toArray()).append(");", new Object[0]);
        HashMap<Long, CheckAccountReferenceResult> tableRefOldAndNewAccMap = new HashMap<Long, CheckAccountReferenceResult>(8);
        try (DataSet dataSet = DB.queryDataSet((String)"kd.fi.bd.util.AccountTableRefUtils.checkAccountTableRef", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder);){
            while (dataSet.hasNext()) {
                CheckAccountReferenceResult referenceInfo;
                Row row = dataSet.next();
                Long oldaccountId = row.getLong("foldaccountid");
                Long newaccountId = row.getLong("fnewaccountid");
                Long accountTableRefId = row.getLong("fid");
                if (tableRefOldAndNewAccMap.containsKey(accountTableRefId)) {
                    referenceInfo = (CheckAccountReferenceResult)tableRefOldAndNewAccMap.get(accountTableRefId);
                    if (Objects.isNull(referenceInfo)) {
                        referenceInfo = new CheckAccountReferenceResult();
                    }
                    AccountTableRefUtils.checkExistRef(accIds, oldaccountId, newaccountId, referenceInfo);
                    continue;
                }
                referenceInfo = new CheckAccountReferenceResult();
                AccountTableRefUtils.checkExistRef(accIds, oldaccountId, newaccountId, referenceInfo);
                tableRefOldAndNewAccMap.put(accountTableRefId, referenceInfo);
            }
        }
        return tableRefOldAndNewAccMap;
    }

    private static void checkExistRef(Set<Long> accIds, Long oldaccountId, Long newaccountId, CheckAccountReferenceResult referenceInfo) {
        if (accIds.contains(oldaccountId)) {
            referenceInfo.getReferencedAccountSet().add(oldaccountId);
        }
        if (accIds.contains(newaccountId)) {
            referenceInfo.getReferencedAccountSet().add(newaccountId);
        }
        referenceInfo.getOldToNewAccounMappingMap().put(oldaccountId, newaccountId);
    }

    public static Set<Object> getOrgUseAccountTableRef(Long accountTableId, List<Long> orgIds, Date enableDate) {
        List accountTableRefs;
        ArrayList<QFilter> useQFilters = new ArrayList<QFilter>(10);
        orgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((String)"10", orgIds, (boolean)true);
        QFilter tableFilter = new QFilter("oldacttable", "=", (Object)accountTableId);
        tableFilter.or(new QFilter("newacttable", "=", (Object)accountTableId));
        QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accounttableref", new ArrayList(orgIds), (boolean)false);
        if (Objects.nonNull(orgFilter)) {
            useQFilters.add(orgFilter);
        }
        useQFilters.add(tableFilter);
        if (Objects.nonNull(enableDate)) {
            useQFilters.add(new QFilter("enabledate", ">=", (Object)enableDate));
        }
        return CollectionUtils.isEmpty((Collection)(accountTableRefs = QueryServiceHelper.queryPrimaryKeys((String)"AccountTableRefUtils.getOrgUseAccountTableRef#", (String)"bd_accounttableref", (QFilter[])useQFilters.toArray(new QFilter[0]), null, (int)-1))) ? new HashSet<Object>(8) : new HashSet(accountTableRefs);
    }

    public static boolean isGl_presetcashflowitem(String entityNumber, boolean isAccTableVersion) {
        return isAccTableVersion && entityNumber.equals("gl_presetcashflowitem");
    }

    public static Optional<DynamicObject> dealPresetCashFlowEntry(Set<PresetCashFlowItemRelation> presetCashFlowItemRelations, DynamicObject entry, String accountLongNumber, long newAccountId) {
        String dc = entry.getString("dc");
        Long assgrpId = entry.getLong("assgrp_id");
        PresetCashFlowItemRelation presetCashFlowItemRelation = new PresetCashFlowItemRelation(accountLongNumber, dc, assgrpId);
        if (CollectionUtils.isEmpty(presetCashFlowItemRelations) || presetCashFlowItemRelations.add(presetCashFlowItemRelation)) {
            DynamicObject newEntry = AccountCashFlowService.createRelationShip(entry, presetCashFlowItemRelation, newAccountId);
            return Optional.of(newEntry);
        }
        return Optional.empty();
    }

    public static boolean checkAccountTableReference(DynamicObject account, boolean isVersion, long accountIdForCheck) {
        HashSet<Long> accIds = new HashSet<Long>(8);
        accIds.add(accountIdForCheck);
        long accountTableId = account.getLong("accounttable_id");
        HashSet<Long> useOrgIds = new HashSet<Long>(8);
        useOrgIds.add(account.getLong("useorg_id"));
        Map<Object, Object> checkRes = new HashMap(8);
        checkRes = isVersion ? AccountTableRefUtils.batchCheckAccountTableRef(accountTableId, useOrgIds, accIds, account.getDate("startdate")) : AccountTableRefUtils.batchCheckAccountTableRef(accountTableId, useOrgIds, accIds, null);
        for (Map.Entry<Object, Object> referenceRes : checkRes.entrySet()) {
            CheckAccountReferenceResult res = (CheckAccountReferenceResult)referenceRes.getValue();
            if (CollectionUtils.isEmpty(res.getReferencedAccountSet())) continue;
            return true;
        }
        return false;
    }

    public static Map<Long, CheckAccountReferenceResult> checkAccountMappingRef(Long accountTableId, Set<Long> orgIds, Set<Long> accIds) {
        DataSet dataSet = AccountTableRefUtils.getOrgAccountMappingRef(accIds, orgIds);
        if (dataSet == null) {
            return new HashMap<Long, CheckAccountReferenceResult>(8);
        }
        HashMap<Long, CheckAccountReferenceResult> accountMappingMap = new HashMap<Long, CheckAccountReferenceResult>(8);
        while (dataSet.hasNext()) {
            CheckAccountReferenceResult referenceInfo;
            Row row = dataSet.next();
            Long oldaccountId = row.getLong("mappinginfoentry.srcact");
            Long newaccountId = row.getLong("mappinginfoentry.goalact");
            Long accountMappingId = row.getLong("id");
            if (accountMappingMap.containsKey(accountMappingId)) {
                referenceInfo = (CheckAccountReferenceResult)accountMappingMap.get(accountMappingId);
                if (Objects.isNull(referenceInfo)) {
                    referenceInfo = new CheckAccountReferenceResult();
                }
                AccountTableRefUtils.checkExistRef(accIds, oldaccountId, newaccountId, referenceInfo);
                continue;
            }
            referenceInfo = new CheckAccountReferenceResult();
            AccountTableRefUtils.checkExistRef(accIds, oldaccountId, newaccountId, referenceInfo);
            accountMappingMap.put(accountMappingId, referenceInfo);
        }
        return accountMappingMap;
    }

    public static DataSet getOrgAccountMappingRef(Set<Long> accountIds, Set<Long> orgIds) {
        ArrayList<QFilter> useQFilters = new ArrayList<QFilter>(10);
        List allSubordinateOrgs = OrgUnitServiceHelper.getAllSubordinateOrgs((String)"10", new ArrayList<Long>(orgIds), (boolean)true);
        useQFilters.add(new QFilter("mappingtype", "=", (Object)"0"));
        QFilter tableFilter = new QFilter("mappinginfoentry.srcact", "in", accountIds);
        tableFilter.or(new QFilter("mappinginfoentry.goalact", "in", accountIds));
        QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountmapping", new ArrayList(allSubordinateOrgs), (boolean)false);
        if (Objects.nonNull(orgFilter)) {
            useQFilters.add(orgFilter);
        }
        useQFilters.add(tableFilter);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"checkAccountMappingRef", (String)"bd_accountmapping", (String)"id,mappinginfoentry.srcact, mappinginfoentry.goalact", (QFilter[])useQFilters.toArray(new QFilter[0]), null);
        return dataSet;
    }

    public static boolean checkCurrency(Map<Long, CheckAccountReferenceResult> checkRes, DynamicObject account) {
        long accountId = account.getLong("id");
        for (Map.Entry<Long, CheckAccountReferenceResult> referenceResMap : checkRes.entrySet()) {
            CheckAccountReferenceResult result = referenceResMap.getValue();
            if (Objects.isNull(result)) continue;
            Map<Long, Long> accountMappingInfo = result.getOldToNewAccounMappingMap();
            HashSet<Long> oldAndNewAccountIdSet = new HashSet<Long>(8);
            for (Map.Entry<Long, Long> entry : accountMappingInfo.entrySet()) {
                oldAndNewAccountIdSet.add(entry.getKey());
                Long newAccountId = entry.getValue();
                if (newAccountId == null || newAccountId == 0L) continue;
                oldAndNewAccountIdSet.add(entry.getValue());
            }
            if (CollectionUtils.isEmpty(oldAndNewAccountIdSet)) continue;
            Map dynamicObjects = BusinessDataServiceHelper.loadFromCache((Object[])oldAndNewAccountIdSet.toArray(), (String)"bd_accountview");
            for (Map.Entry<Long, Long> accountMapping : accountMappingInfo.entrySet()) {
                long oldAccountId = accountMapping.getKey();
                Long newAccountId = accountMapping.getValue();
                if (newAccountId == null || newAccountId == 0L) continue;
                if (accountId == oldAccountId) {
                    return AccountVersionControlChecker.accountCurrencyControlCheck(account, (DynamicObject)dynamicObjects.get(newAccountId));
                }
                return AccountVersionControlChecker.accountCurrencyControlCheck((DynamicObject)dynamicObjects.get(oldAccountId), account);
            }
        }
        return false;
    }
}

