/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.accountref.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.ext.fi.accountref.AccountTableRef;
import kd.bos.ext.fi.accountref.IAccountTableRefService;
import kd.bos.ext.fi.accountref.impl.AcctUpdateUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class AccountMappingVersionImpl
implements IAccountTableRefService {
    private static Log logger = LogFactory.getLog(AccountMappingVersionImpl.class);

    @Override
    public void enable(long orgId, Date enableDate, AccountTableRef accountIdRef) {
        try (TXHandle handle = TX.requiresNew((String)"kd.bos.ext.fi.accountref.impl.ReciprocalSchemeImpl.enable");){
            try {
                DynamicObject[] accountMappings;
                long oldAccountTableId = accountIdRef.getOldAccountTableId();
                QFilter orgF = new QFilter("createorg", "=", (Object)orgId);
                QFilter sourceTableF = new QFilter("srcacttable", "=", (Object)oldAccountTableId);
                for (DynamicObject accountMapping : accountMappings = BusinessDataServiceHelper.load((String)"bd_accountmapping", (String)"", (QFilter[])new QFilter[]{orgF, sourceTableF})) {
                    long l = accountMapping.getLong("srcacttable_id");
                }
            }
            catch (Exception e) {
                logger.info(AcctUpdateUtil.printError(e));
                handle.markRollback();
                throw e;
            }
        }
    }

    private Map<Long, Boolean> getAcheckAccountIds(Set<Long> accountIds) {
        HashMap<Long, Boolean> map = new HashMap<Long, Boolean>(accountIds.size());
        Map dyns = BusinessDataServiceHelper.loadFromCache((String)"bd_accountview", (QFilter[])new QFilter("id", "in", accountIds).toArray());
        for (DynamicObject row : dyns.values()) {
            map.put(row.getLong("id"), row.getBoolean("accheck"));
        }
        return map;
    }

    @Override
    public void disable(long orgId, Date disableDate, AccountTableRef accountIdRef) {
        Long newAccountTableId;
        Long oldAccountTableId = accountIdRef.getOldAccountTableId();
        if (oldAccountTableId.equals(newAccountTableId = Long.valueOf(accountIdRef.getNewAccountTableId()))) {
            this.returnAccountId(orgId, disableDate, accountIdRef);
        } else {
            DeleteServiceHelper.delete((String)"gl_reciprocal_scheme", (QFilter[])new QFilter[]{new QFilter("createorg.id", "=", (Object)orgId), new QFilter("accounttable.id", "=", (Object)newAccountTableId)});
        }
    }

    private void returnAccountId(long orgId, Date disableDate, AccountTableRef accountIdRef) {
        DynamicObject[] dyns;
        String selectFields = "id,metadata,fieldtype,dataid,dataentryid,org,fieldname,entryname,reaccountid,afaccountid,versiondate,recordsource";
        ArrayList<QFilter> filters = new ArrayList<QFilter>(5);
        filters.add(new QFilter("metadata", "=", (Object)"gl_reciprocal_scheme"));
        filters.add(new QFilter("fieldtype", "=", (Object)"acct"));
        filters.add(new QFilter("versiondate", "=", (Object)disableDate));
        Set<Long> oldIds = accountIdRef.getAccountRef().getOldAndNewAccountRef().keySet();
        filters.add(new QFilter("reaccountid", "in", oldIds));
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bd_account_updaterecord", (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]));
        ArrayList<Long> ids = new ArrayList<Long>(collection.size());
        ArrayList<Long> dataIds = new ArrayList<Long>(collection.size());
        HashMap<Long, Long> newAndOldIds = new HashMap<Long, Long>(collection.size());
        for (DynamicObject dyn : collection) {
            ids.add(dyn.getLong("id"));
            dataIds.add(dyn.getLong("dataid"));
            newAndOldIds.put(dyn.getLong("afaccountid"), dyn.getLong("reaccountid"));
        }
        for (DynamicObject dyn : dyns = BusinessDataServiceHelper.load((Object[])dataIds.toArray(new Long[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bd_account_updaterecord"))) {
            DynamicObjectCollection accounts = dyn.getDynamicObjectCollection("account");
            for (DynamicObject account : accounts) {
                Long accountId = account.getLong("fbasedataid_id");
                if (!newAndOldIds.containsKey(accountId)) continue;
                account.set("fbasedataid_id", newAndOldIds.get(accountId));
            }
        }
        SaveServiceHelper.save((DynamicObject[])dyns);
        DeleteServiceHelper.delete((String)"bd_account_updaterecord", (QFilter[])new QFilter("id", "in", ids).toArray());
    }
}

