/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.accountref.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.basedata.cache.BaseDataCtrlCache;
import kd.bos.basedata.cache.BaseDataCtrlCacheMrg;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.ext.fi.accountref.AccountRef;
import kd.bos.ext.fi.accountref.AccountTableRef;
import kd.bos.ext.fi.accountref.AccountTableRefUtils;
import kd.bos.ext.fi.accountref.impl.AcctVerInfo;
import kd.bos.ext.fi.accountref.impl.BackUpAssgrpUtil;
import kd.bos.ext.fi.entity.property.AccountProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bd.business.service.cashitem.AccountCashFlowService;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.util.DebugTraceHelper;

class AcctUpdateUtil {
    private static Log logger = LogFactory.getLog(AcctUpdateUtil.class);
    private static final String _ID = "_id";
    private static final String POINTID = ".id";
    private static final String POINT = ".";
    private static final String ID = "id";
    private static final String FBASEDATAID = ".fbasedataid";
    private static final String FBASEDATAID_ID = "fbasedataid_id";
    private static final String BD_ACCOUNT_UPDATERECORD = "bd_account_updaterecord";
    private static final String METADATA = "metadata";
    private static final String FIELDTYPE = "fieldtype";
    private static final String ORG = "org";
    private static final String DATAID = "dataid";
    private static final String DATAENTRYID = "dataentryid";
    private static final String ENTRYNAME = "entryname";
    private static final String FIELDNAME = "fieldname";
    private static final String REACCOUNTID = "reaccountid";
    private static final String AFACCOUNTID = "afaccountid";
    private static final String CREATER = "creater";
    private static final String CREATEDATE = "createdate";
    private static final String RECORDSOURCE = "recordsource";
    private static final String VERSIONDATE = "versiondate";
    private static final String ACCT = "acct";
    private static final String ACCTTABLE = "accttable";
    private static final String BD_ACCT_REGINFO = "bd_acct_reginfo";
    private static final String ENTITYNAME = "entityName";
    private static final String USEORGFIELD = "useOrgField";
    private static final String ACCTFIELDNAMES = "acctFieldNames";
    private static final String ACCTTABFIELDNAMES = "acctTabFieldNames";
    private static final String ACCTENTRYFIELDNAMES = "acctEntryFieldNames";
    private static final String HEAD = "head";

    AcctUpdateUtil() {
    }

    protected static void enable(long orgId, Date enableDate, AccountTableRef accountIdRef) {
        List<AcctVerInfo> acctVerInfos = AcctUpdateUtil.getAcctVerInfos();
        try (TXHandle handle = TX.requiresNew((String)"kd.bos.ext.fi.accountref.util.AcctVersionUtil.enable");){
            try {
                for (AcctVerInfo acctVerInfo : acctVerInfos) {
                    AcctUpdateUtil.replaceAccountId(orgId, enableDate, accountIdRef, acctVerInfo);
                    logger.info(acctVerInfo.getEntityName() + "\u542f\u7528\u6210\u529f");
                }
            }
            catch (Exception e) {
                logger.info(AcctUpdateUtil.printError(e));
                handle.markRollback();
                throw e;
            }
        }
    }

    protected static void disable(long orgId, Date enableDate, AccountTableRef accountIdRef) {
        try (TXHandle handle = TX.requiresNew((String)"kd.bos.ext.fi.accountref.util.AcctVersionUtil.enable");){
            try {
                String selectFields = "id,metadata,fieldtype,org,dataid,dataentryid,fieldname,entryname,versiondate,reaccountid,afaccountid";
                if (accountIdRef.getNewAccountTableId() != accountIdRef.getOldAccountTableId()) {
                    AcctUpdateUtil.restoreId(selectFields, orgId, enableDate, accountIdRef, ACCTTABLE);
                }
                AcctUpdateUtil.restoreId(selectFields, orgId, enableDate, accountIdRef, ACCT);
                logger.info("\u53cd\u542f\u7528\u6210\u529f");
            }
            catch (Exception e) {
                logger.info(AcctUpdateUtil.printError(e));
                handle.markRollback();
                throw e;
            }
        }
    }

    private static void restoreId(String selectFields, long orgId, Date enableDate, AccountTableRef accountIdRef, String type) {
        String algoKey = "kd.bos.ext.fi.accountref.util.AcctVersionUtil.restoreId";
        List<QFilter> qFilters = AcctUpdateUtil.getQfilters(orgId, enableDate, accountIdRef, type);
        String orderBys = "metadata,org,dataid,dataentryid";
        HashMap<String, HashMap> queryInfos = new HashMap<String, HashMap>(100);
        HashMap<String, Map<Long, Object>> map = new HashMap<String, Map<Long, Object>>(100);
        HashMap<String, Map<String, Set<Long>>> entityNameAndDataIds = new HashMap<String, Map<String, Set<Long>>>(100);
        boolean isSameAcctTab = accountIdRef.getNewAccountTableId() == accountIdRef.getOldAccountTableId();
        Map<Long, Long> oldAndNewIds = accountIdRef.getAccountRef().getOldAndNewAccountRef();
        HashMap<Long, Long> newAndOldIds = new HashMap<Long, Long>(oldAndNewIds.size());
        for (Map.Entry<Long, Long> entry : oldAndNewIds.entrySet()) {
            newAndOldIds.put(entry.getValue(), entry.getKey());
        }
        Throwable throwable = null;
        try (DataSet set = QueryServiceHelper.queryDataSet((String)algoKey, (String)BD_ACCOUNT_UPDATERECORD, (String)selectFields, (QFilter[])qFilters.toArray(new QFilter[0]), (String)orderBys);){
            for (Row row : set) {
                ArrayList<HashMap<String, Object>> list;
                Map mmm;
                Map mm;
                Map m;
                queryInfos.computeIfAbsent(row.getString(METADATA), p -> new HashMap()).put(row.getLong(ID), row.getLong(DATAID));
                String metadata = row.getString(METADATA);
                Long dataid = row.getLong(DATAID);
                Long dataentryid = row.getLong(DATAENTRYID);
                Long reaccountid = row.getLong(REACCOUNTID);
                Long afaccountid = row.getLong(AFACCOUNTID);
                String fieldname = row.getString(FIELDNAME);
                String entryname = row.getString(ENTRYNAME);
                String fieldtype = row.getString(FIELDTYPE);
                if (ACCT.equals(fieldtype)) {
                    HashSet<Long> idset;
                    Long id = dataentryid == 0L ? dataid : dataentryid;
                    Map fieldNameAndDataids = new HashMap(100);
                    if (entityNameAndDataIds.containsKey(metadata)) {
                        fieldNameAndDataids = (Map)entityNameAndDataIds.get(metadata);
                        if (fieldNameAndDataids.containsKey(fieldname)) {
                            ((Set)fieldNameAndDataids.get(fieldname)).add(id);
                        } else {
                            idset = new HashSet(100);
                            idset.add(id);
                            fieldNameAndDataids.put(fieldname, idset);
                        }
                    } else {
                        idset = new HashSet<Long>(100);
                        idset.add(id);
                        fieldNameAndDataids.put(fieldname, idset);
                        entityNameAndDataIds.put(metadata, fieldNameAndDataids);
                    }
                }
                HashMap<String, Object> bakInfo = new HashMap<String, Object>(2);
                if (isSameAcctTab) {
                    reaccountid = (Long)newAndOldIds.get(afaccountid);
                }
                bakInfo.put(FIELDNAME, fieldname);
                bakInfo.put(REACCOUNTID, reaccountid);
                bakInfo.put(ID, row.getLong(ID));
                bakInfo.put(DATAENTRYID, dataentryid);
                if (map.containsKey(metadata)) {
                    Map dataMap = (Map)map.get(metadata);
                    m = new HashMap<Object, ArrayList<HashMap<String, Object>>>(100);
                    if (dataMap.containsKey(dataid)) {
                        m = (Map)dataMap.get(dataid);
                    }
                    if (StringUtils.isEmpty((String)entryname)) {
                        List<HashMap<String, Object>> list2 = new ArrayList<HashMap<String, Object>>(100);
                        if (m.containsKey(HEAD)) {
                            list2 = (List)m.get(HEAD);
                        }
                        list2.add(bakInfo);
                        m.put(HEAD, list2);
                        dataMap.put(dataid, m);
                        map.put(metadata, dataMap);
                        continue;
                    }
                    mm = new HashMap(100);
                    if (m.containsKey(ENTRYNAME)) {
                        mm = (Map)m.get(ENTRYNAME);
                    }
                    mmm = new HashMap(100);
                    if (mm.containsKey(entryname)) {
                        mmm = (Map)mm.get(entryname);
                    }
                    List<HashMap<String, Object>> list3 = new ArrayList<HashMap<String, Object>>(100);
                    if (mmm.containsKey(dataentryid)) {
                        list3 = (List)mmm.get(dataentryid);
                    }
                    list3.add(bakInfo);
                    mmm.put(dataentryid, list3);
                    mm.put(entryname, mmm);
                    m.put(ENTRYNAME, mm);
                    dataMap.put(dataid, m);
                    map.put(metadata, dataMap);
                    continue;
                }
                if (StringUtils.isEmpty((String)entryname)) {
                    list = new ArrayList<HashMap<String, Object>>(100);
                    list.add(bakInfo);
                    m = new HashMap(100);
                    m.put(HEAD, list);
                    mm = new HashMap(100);
                    mm.put((String)((Object)dataid), m);
                    map.put(metadata, mm);
                    continue;
                }
                list = new ArrayList(100);
                list.add(bakInfo);
                m = new HashMap(100);
                m.put((String)((Object)dataentryid), list);
                mm = new HashMap(100);
                mm.put(entryname, m);
                mmm = new HashMap(100);
                mmm.put((Long)((Object)ENTRYNAME), mm);
                HashMap mmmm = new HashMap(100);
                mmmm.put(dataid, mmm);
                map.put(metadata, mmmm);
            }
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        for (Map.Entry<Long, Long> entry : queryInfos.entrySet()) {
            AcctUpdateUtil.restoreSingleMetadataId(entry, map, entityNameAndDataIds);
            logger.info((String)((Object)entry.getKey()) + "\u53cd\u542f\u7528\u6210\u529f");
        }
    }

    private static void restoreSingleMetadataId(Map.Entry<String, HashMap<Long, Long>> queryInfo, Map<String, Map<Long, Object>> map, Map<String, Map<String, Set<Long>>> entityNameAndDataIds) {
        String entityName = queryInfo.getKey();
        Collection<Long> ids = queryInfo.getValue().values();
        Map datamap = BusinessDataServiceHelper.loadFromCache((String)entityName, (QFilter[])new QFilter(ID, "in", ids).toArray());
        if (!CollectionUtils.isEmpty(entityNameAndDataIds.get(entityName))) {
            BackUpAssgrpUtil.excuteAssgrpRecoverService(entityName, new ArrayList<DynamicObject>(datamap.values()), entityNameAndDataIds.get(entityName));
        }
        ArrayList<DynamicObject> dyns = new ArrayList<DynamicObject>(datamap.size());
        for (DynamicObject dyn : datamap.values()) {
            if (map.containsKey(entityName)) {
                Long id = dyn.getLong(ID);
                Map<Long, Object> dataMap = map.get(entityName);
                if (dataMap.containsKey(id)) {
                    Map singleDataMap = (Map)dataMap.get(id);
                    if (singleDataMap.containsKey(HEAD)) {
                        List list = (List)singleDataMap.get(HEAD);
                        for (Map map2 : list) {
                            if ((Long)map2.get(DATAENTRYID) == 0L) {
                                dyn.set(map2.get(FIELDNAME) + _ID, map2.get(REACCOUNTID));
                                continue;
                            }
                            DynamicObjectCollection entrys = dyn.getDynamicObjectCollection(map2.get(FIELDNAME) + "");
                            for (DynamicObject entry : entrys) {
                                if (!Long.valueOf(entry.getPkValue() + "").equals((Long)map2.get(DATAENTRYID))) continue;
                                entry.set(FBASEDATAID_ID, map2.get(REACCOUNTID));
                            }
                        }
                    }
                    if (singleDataMap.containsKey(ENTRYNAME)) {
                        Map mm = (Map)singleDataMap.get(ENTRYNAME);
                        for (Map.Entry entry : mm.entrySet()) {
                            String entityname = (String)entry.getKey();
                            DynamicObjectCollection entitys = dyn.getDynamicObjectCollection(entityname);
                            Map mmm = (Map)entry.getValue();
                            for (DynamicObject entity : entitys) {
                                Long entityId = (Long)entity.getPkValue();
                                if (!mmm.containsKey(entityId)) continue;
                                List list = (List)mmm.get(entityId);
                                for (Map m : list) {
                                    entity.set(m.get(FIELDNAME) + _ID, m.get(REACCOUNTID));
                                }
                            }
                        }
                    }
                }
            }
            dyns.add(dyn);
        }
        SaveServiceHelper.update((DynamicObject[])dyns.toArray(new DynamicObject[0]));
        DeleteServiceHelper.delete((String)BD_ACCOUNT_UPDATERECORD, (QFilter[])new QFilter(ID, "in", queryInfo.getValue().keySet()).toArray());
    }

    private static List<QFilter> getQfilters(long orgId, Date enableDate, AccountTableRef accountIdRef, String type) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter(VERSIONDATE, "=", (Object)enableDate));
        qFilters.add(new QFilter(RECORDSOURCE, "=", (Object)Character.valueOf('0')));
        qFilters.add(new QFilter(FIELDTYPE, "=", (Object)type));
        qFilters.add(new QFilter(ORG, "=", (Object)orgId).or(new QFilter(ORG, "=", (Object)0L)));
        if (ACCT.equals(type)) {
            qFilters.add(new QFilter(AFACCOUNTID, "in", accountIdRef.getAccountRef().getOldAndNewAccountRef().values()));
        } else {
            qFilters.add(new QFilter(REACCOUNTID, "=", (Object)accountIdRef.getOldAccountTableId()));
            qFilters.add(new QFilter(AFACCOUNTID, "=", (Object)accountIdRef.getNewAccountTableId()));
        }
        return qFilters;
    }

    private static List<AcctVerInfo> getAcctVerInfos() {
        Set<String> excMeta = AcctUpdateUtil.getAcctExcInfo();
        Map<String, AcctVerInfo> map = AcctUpdateUtil.getAcctVerInfosFromTable();
        Map<String, Map<String, Object>> metaMap = AcctUpdateUtil.getAcctVerInfoByMeta();
        for (Map.Entry<String, Map<String, Object>> entry : metaMap.entrySet()) {
            AcctVerInfo acctVerInfo;
            String key = entry.getKey();
            if (excMeta.contains(key)) continue;
            Map<String, Object> value = entry.getValue();
            if (map.containsKey(key)) {
                Map valueMaps;
                acctVerInfo = map.get(key);
                if (StringUtils.isEmpty((String)acctVerInfo.getEntityName()) && value.containsKey(ENTITYNAME)) {
                    acctVerInfo.setEntityName((String)value.get(ENTITYNAME));
                }
                if (StringUtils.isEmpty((String)acctVerInfo.getUseOrgField()) && value.containsKey(USEORGFIELD)) {
                    acctVerInfo.setUseOrgField((String)value.get(USEORGFIELD));
                }
                if (value.containsKey(ACCTFIELDNAMES)) {
                    valueMaps = (Map)value.get(ACCTFIELDNAMES);
                    for (Map.Entry valueMap : valueMaps.entrySet()) {
                        if (acctVerInfo.getAcctFieldNames().containsKey(valueMap.getKey())) continue;
                        acctVerInfo.getAcctFieldNames().put((String)valueMap.getKey(), (Boolean)valueMap.getValue());
                    }
                }
                if (value.containsKey(ACCTTABFIELDNAMES)) {
                    valueMaps = (Map)value.get(ACCTTABFIELDNAMES);
                    for (Map.Entry valueMap : valueMaps.entrySet()) {
                        if (acctVerInfo.getAcctTabFieldNames().containsKey(valueMap.getKey())) continue;
                        acctVerInfo.getAcctTabFieldNames().put((String)valueMap.getKey(), (Boolean)valueMap.getValue());
                    }
                }
                if (!value.containsKey(ACCTENTRYFIELDNAMES)) continue;
                Map entryMap = (Map)value.get(ACCTENTRYFIELDNAMES);
                Map<String, Map<String, Boolean>> acctVerInfoMap = acctVerInfo.getAcctEntryFieldNames();
                for (Map.Entry valueMap : entryMap.entrySet()) {
                    if (acctVerInfoMap.containsKey(valueMap.getKey())) {
                        Map<String, Boolean> v = acctVerInfoMap.get(valueMap.getKey());
                        for (Map.Entry vv : ((Map)valueMap.getValue()).entrySet()) {
                            if (v.containsKey(vv.getKey())) continue;
                            v.put((String)vv.getKey(), (Boolean)vv.getValue());
                            acctVerInfoMap.put((String)valueMap.getKey(), v);
                        }
                        continue;
                    }
                    acctVerInfoMap.put((String)valueMap.getKey(), (Map<String, Boolean>)valueMap.getValue());
                }
                acctVerInfo.setAcctEntryFieldNames(acctVerInfoMap);
                continue;
            }
            acctVerInfo = new AcctVerInfo();
            if (value.containsKey(ENTITYNAME)) {
                acctVerInfo.setEntityName((String)value.get(ENTITYNAME));
            }
            if (value.containsKey(USEORGFIELD)) {
                acctVerInfo.setUseOrgField((String)value.get(USEORGFIELD));
            }
            if (value.containsKey(ACCTFIELDNAMES)) {
                acctVerInfo.setAcctFieldNames((Map)value.get(ACCTFIELDNAMES));
            }
            if (value.containsKey(ACCTTABFIELDNAMES)) {
                acctVerInfo.setAcctTabFieldNames((Map)value.get(ACCTTABFIELDNAMES));
            }
            if (value.containsKey(ACCTENTRYFIELDNAMES)) {
                acctVerInfo.setAcctEntryFieldNames((Map)value.get(ACCTENTRYFIELDNAMES));
            }
            map.put(key, acctVerInfo);
        }
        ArrayList<AcctVerInfo> list = new ArrayList<AcctVerInfo>(10);
        ArrayList<String> numbers = new ArrayList<String>(10);
        for (AcctVerInfo acctVerInfo : map.values()) {
            numbers.add(acctVerInfo.getEntityName());
        }
        Map<String, String> relationShips = AcctUpdateUtil.getMetaDataRelationShip(numbers);
        for (AcctVerInfo acctVerInfo : map.values()) {
            acctVerInfo.setEntityName(relationShips.get(acctVerInfo.getEntityName()));
            list.add(acctVerInfo);
        }
        return list;
    }

    private static Set<String> getAcctExcInfo() {
        HashSet<String> acctExcInfo = new HashSet<String>(10);
        acctExcInfo.add("gl_closeinit");
        String ignoreMeta = BillParamUtil.getStringValue("P9H6JC5EVP1", "fi.bd.account.accountref.ignorerefentitys", "gl_closeinit");
        Collections.addAll(acctExcInfo, ignoreMeta.split(","));
        return acctExcInfo;
    }

    private static Map<String, AcctVerInfo> getAcctVerInfosFromTable() {
        String selectFields = "metadata,fieldtype,fieldname,entryname,useorg,ismutibasedata";
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)BD_ACCT_REGINFO, (String)selectFields, null, (String)"metadata,fieldtype");
        if (dyns == null || dyns.isEmpty()) {
            return new HashMap<String, AcctVerInfo>();
        }
        HashMap<String, AcctVerInfo> acctVerInfos = new HashMap<String, AcctVerInfo>(dyns.size());
        String index = null;
        AcctVerInfo acctVerInfo = null;
        for (DynamicObject dyn : dyns) {
            HashMap<String, Boolean> set;
            Map<String, Map<String, Boolean>> map;
            String metadata = dyn.getString(METADATA);
            String fieldtype = dyn.getString(FIELDTYPE);
            String fieldname = dyn.getString(FIELDNAME);
            String entryname = dyn.getString(ENTRYNAME);
            String useorg = dyn.getString("useorg");
            boolean ismutibasedata = dyn.getBoolean("ismutibasedata");
            if (metadata.equals(index)) {
                if (acctVerInfo == null) continue;
                if (ACCT.equals(fieldtype)) {
                    if (StringUtils.isEmpty((String)entryname)) {
                        acctVerInfo.getAcctFieldNames().put(fieldname, ismutibasedata);
                    } else {
                        map = acctVerInfo.getAcctEntryFieldNames();
                        if (map.containsKey(entryname)) {
                            map.get(entryname).put(fieldname, ismutibasedata);
                        } else {
                            set = new HashMap<String, Boolean>(1);
                            set.put(fieldname, ismutibasedata);
                            map.put(entryname, set);
                        }
                    }
                } else if (StringUtils.isEmpty((String)entryname)) {
                    acctVerInfo.getAcctTabFieldNames().put(fieldname, ismutibasedata);
                }
            } else {
                if (acctVerInfo != null) {
                    acctVerInfos.put(acctVerInfo.getEntityName(), acctVerInfo);
                }
                acctVerInfo = new AcctVerInfo();
                index = metadata;
                acctVerInfo.setEntityName(metadata);
                acctVerInfo.setUseOrgField(useorg);
                if (ACCT.equals(fieldtype)) {
                    if (StringUtils.isEmpty((String)entryname)) {
                        acctVerInfo.getAcctFieldNames().put(fieldname, ismutibasedata);
                    } else {
                        map = acctVerInfo.getAcctEntryFieldNames();
                        if (map.containsKey(entryname)) {
                            map.get(entryname).put(fieldname, ismutibasedata);
                        } else {
                            set = new HashMap(1);
                            set.put(fieldname, ismutibasedata);
                            map.put(entryname, set);
                        }
                    }
                } else if (StringUtils.isEmpty((String)entryname)) {
                    acctVerInfo.getAcctTabFieldNames().put(fieldname, ismutibasedata);
                }
            }
            if (acctVerInfo == null) continue;
            acctVerInfos.put(acctVerInfo.getEntityName(), acctVerInfo);
        }
        return acctVerInfos;
    }

    private static Map<String, Map<String, Object>> getAcctVerInfoByMeta() {
        Set<String> set = AcctUpdateUtil.getAllmetanumberRefAccount();
        if (set == null || set.isEmpty()) {
            return null;
        }
        HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>(set.size());
        for (String entityNumber : set) {
            MainEntityType et;
            int index = 0;
            HashMap<String, Object> dataMap = new HashMap<String, Object>(5);
            dataMap.put(ENTITYNAME, entityNumber);
            try {
                et = MetadataServiceHelper.getDataEntityType((String)entityNumber);
            }
            catch (Exception e) {
                logger.error(ResManager.loadKDString((String)"kd.bos.ext.fi.accountref.impl.AcctUpdateUtil#getAcctVerInfoByMeta#######\u5143\u6570\u636e\u627e\u4e0d\u5230\u8fd9\u4e2a: ", (String)"AcctUpdateUtil_3", (String)"bos-ext-fi", (Object[])new Object[0]) + entityNumber);
                logger.error(ResManager.loadKDString((String)"kd.bos.ext.fi.accountref.impl.AcctUpdateUtil#getAcctVerInfoByMeta#######\u5143\u6570\u636e\u627e\u4e0d\u5230\u8fd9\u4e2a: ", (String)"AcctUpdateUtil_3", (String)"bos-ext-fi", (Object[])new Object[0]) + AcctUpdateUtil.printError(e));
                continue;
            }
            DataEntityPropertyCollection collection = et.getProperties();
            for (IDataEntityProperty property : collection) {
                if (AcctUpdateUtil.isAcctAndVersion(property)) {
                    HashMap<String, Boolean> acctTabFieldNames;
                    String acctTabField;
                    ++index;
                    String fieldName = property.getName();
                    String alias = property.getAlias();
                    String useOrgField = ((BasedataProp)property).getOrgProp();
                    if (StringUtils.isNotEmpty((String)useOrgField)) {
                        dataMap.put(USEORGFIELD, useOrgField);
                    }
                    if (StringUtils.isNotEmpty((String)fieldName) && StringUtils.isNotEmpty((String)alias)) {
                        HashMap<String, Boolean> acctFieldNames;
                        if (dataMap.containsKey(ACCTFIELDNAMES)) {
                            acctFieldNames = (HashMap<String, Boolean>)dataMap.get(ACCTFIELDNAMES);
                            acctFieldNames.put(fieldName, Boolean.FALSE);
                        } else {
                            acctFieldNames = new HashMap<String, Boolean>(1);
                            acctFieldNames.put(fieldName, Boolean.FALSE);
                            dataMap.put(ACCTFIELDNAMES, acctFieldNames);
                        }
                    }
                    if (!StringUtils.isNotEmpty((String)(acctTabField = ((AccountProp)property).getAcctTableField()))) continue;
                    if (dataMap.containsKey(ACCTTABFIELDNAMES)) {
                        acctTabFieldNames = (HashMap<String, Boolean>)dataMap.get(ACCTTABFIELDNAMES);
                        acctTabFieldNames.put(acctTabField, Boolean.FALSE);
                        continue;
                    }
                    acctTabFieldNames = new HashMap<String, Boolean>(1);
                    acctTabFieldNames.put(acctTabField, Boolean.FALSE);
                    dataMap.put(ACCTTABFIELDNAMES, acctTabFieldNames);
                    continue;
                }
                if (!(property instanceof EntryProp)) continue;
                EntryProp entryProp = (EntryProp)property;
                DataEntityPropertyCollection entrycollection = entryProp._collectionItemPropertyType.getProperties();
                for (IDataEntityProperty entryproperty : entrycollection) {
                    if (!AcctUpdateUtil.isAcctAndVersion(entryproperty)) continue;
                    ++index;
                    String entryEntityName = entryProp.getName();
                    String fieldName = entryproperty.getName();
                    String alias = entryproperty.getAlias();
                    String useOrgField = ((BasedataProp)entryproperty).getOrgProp();
                    if (!dataMap.containsKey(USEORGFIELD) && StringUtils.isNotEmpty((String)useOrgField)) {
                        dataMap.put(USEORGFIELD, useOrgField);
                    }
                    if (!StringUtils.isNotEmpty((String)fieldName) || !StringUtils.isNotEmpty((String)alias)) continue;
                    Map entryMap = new HashMap(10);
                    Map<String, Boolean> valueMap = new HashMap<String, Boolean>(10);
                    if (dataMap.containsKey(ACCTENTRYFIELDNAMES)) {
                        entryMap = (Map)dataMap.get(ACCTENTRYFIELDNAMES);
                    }
                    if (entryMap.containsKey(entryEntityName)) {
                        valueMap = (Map)entryMap.get(entryEntityName);
                    }
                    valueMap.put(fieldName, Boolean.FALSE);
                    entryMap.put(entryEntityName, valueMap);
                    dataMap.put(ACCTENTRYFIELDNAMES, entryMap);
                }
            }
            if (index <= 0) continue;
            map.put(entityNumber, dataMap);
        }
        return map;
    }

    private static Set<String> getAllmetanumberRefAccount() {
        HashSet<String> set = new HashSet<String>(16);
        String sql = "select distinct(FOBJECTTYPEID) number from t_meta_objecttyperef where FREFOBJECTTYPEID = 'bd_accountview' and ftablename != ' '";
        try (DataSet dataset = DB.queryDataSet((String)"kd.bos.ext.fi.accountref.util.AcctVersionUtil.getAllmetanumberRefAccount", (DBRoute)DBRoute.of((String)"sys.meta"), (String)sql);){
            while (dataset.hasNext()) {
                set.add(dataset.next().getString("number"));
            }
        }
        return set;
    }

    private static boolean isAcctAndVersion(IDataEntityProperty property) {
        return property instanceof AccountProp && ((AccountProp)property).isMultiVersion();
    }

    private static Boolean replaceAccountId(Long orgId, Date enableDate, AccountTableRef accountIdRef, AcctVerInfo acctVerInfo) {
        Map<String, Map<String, Boolean>> acctEntryFieldNames;
        Map<String, Boolean> acctFieldNames;
        String entityNumber = acctVerInfo.getEntityName();
        Map<String, Boolean> acctTabFieldNames = acctVerInfo.getAcctTabFieldNames();
        if (!acctTabFieldNames.isEmpty() && accountIdRef.getNewAccountTableId() != accountIdRef.getOldAccountTableId()) {
            AcctUpdateUtil.replaceAccountTableId(entityNumber, orgId, acctTabFieldNames, accountIdRef, acctVerInfo.getUseOrgField(), ACCTTABLE, enableDate);
        }
        if (!(acctFieldNames = acctVerInfo.getAcctFieldNames()).isEmpty()) {
            AcctUpdateUtil.replaceAccountId(entityNumber, orgId, acctFieldNames, accountIdRef, acctVerInfo.getUseOrgField(), ACCT, enableDate);
        }
        if (!(acctEntryFieldNames = acctVerInfo.getAcctEntryFieldNames()).isEmpty()) {
            AcctUpdateUtil.replaceAccountEntryId(entityNumber, orgId, acctEntryFieldNames, accountIdRef, acctVerInfo.getUseOrgField(), enableDate);
        }
        return Boolean.TRUE;
    }

    private static void replaceAccountId(String entityNumber, Long orgId, Map<String, Boolean> acctFieldNames, AccountTableRef accountIdRef, String useOrgField, String acct, Date enableDate) {
        HashMap<String, Set<Long>> fieldAndDataids = new HashMap<String, Set<Long>>(100);
        Set<Long> oldAcctIds = accountIdRef.getAccountRef().getOldAndNewAccountRef().keySet();
        Map<Long, Long> oldAndNewAccountRef = accountIdRef.getAccountRef().getOldAndNewAccountRef();
        ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
        if (StringUtils.isNotEmpty((String)useOrgField)) {
            filters.add(new QFilter(useOrgField + POINTID, "=", (Object)orgId));
        } else {
            orgId = 0L;
        }
        QFilter qFilter = null;
        for (Map.Entry<String, Boolean> acctFieldName : acctFieldNames.entrySet()) {
            if (!acctFieldName.getValue().booleanValue()) {
                if (qFilter == null) {
                    qFilter = new QFilter(acctFieldName.getKey() + POINTID, "in", oldAcctIds);
                    continue;
                }
                qFilter.or(new QFilter(acctFieldName.getKey() + POINTID, "in", oldAcctIds));
                continue;
            }
            if (qFilter == null) {
                qFilter = new QFilter(acctFieldName.getKey() + FBASEDATAID, "in", oldAcctIds);
                continue;
            }
            qFilter.or(new QFilter(acctFieldName.getKey() + FBASEDATAID, "in", oldAcctIds));
        }
        filters.add(qFilter);
        Map map = BusinessDataServiceHelper.loadFromCache((String)entityNumber, (QFilter[])filters.toArray(new QFilter[0]));
        if (map == null || map.size() < 1) {
            return;
        }
        ArrayList<DynamicObject> dyns = new ArrayList<DynamicObject>(map.size());
        ArrayList<DynamicObject> updateRecords = new ArrayList<DynamicObject>(map.size());
        for (DynamicObject dyn : map.values()) {
            for (Map.Entry<String, Boolean> acctFieldName : acctFieldNames.entrySet()) {
                if (acctFieldName.getValue().booleanValue()) {
                    DynamicObjectCollection entrys = dyn.getDynamicObjectCollection(acctFieldName.getKey());
                    for (DynamicObject entry : entrys) {
                        if (!oldAcctIds.contains(entry.getLong(FBASEDATAID_ID))) continue;
                        Long oldId = entry.getLong(FBASEDATAID_ID);
                        entry.set(FBASEDATAID_ID, (Object)oldAndNewAccountRef.get(oldId));
                        DynamicObject updateRecord = AcctUpdateUtil.buildUpdateRecord(entityNumber, dyn.getLong(ID), Long.valueOf(entry.getPkValue() + ""), orgId, acctFieldName.getKey(), oldId, oldAndNewAccountRef.get(oldId), null, acct, enableDate, "0");
                        updateRecords.add(updateRecord);
                    }
                    continue;
                }
                if (!oldAcctIds.contains(dyn.getLong(acctFieldName.getKey() + POINTID))) continue;
                String fieldName = acctFieldName.getKey();
                dyn.set(acctFieldName.getKey() + _ID, (Object)oldAndNewAccountRef.get(dyn.getLong(acctFieldName.getKey() + POINTID)));
                DynamicObject updateRecord = AcctUpdateUtil.buildUpdateRecord(entityNumber, dyn.getLong(ID), 0L, orgId, acctFieldName.getKey(), dyn.getLong(acctFieldName.getKey() + POINTID), oldAndNewAccountRef.get(dyn.getLong(acctFieldName.getKey() + POINTID)), null, acct, enableDate, "0");
                updateRecords.add(updateRecord);
                if (fieldAndDataids.containsKey(fieldName)) {
                    ((Set)fieldAndDataids.get(fieldName)).add(dyn.getLong(ID));
                    continue;
                }
                HashSet<Long> idSet = new HashSet<Long>(100);
                idSet.add(dyn.getLong(ID));
                fieldAndDataids.put(fieldName, idSet);
            }
            dyns.add(dyn);
        }
        BackUpAssgrpUtil.excuteAssgrpReplaceService(entityNumber, dyns, fieldAndDataids);
        SaveServiceHelper.update((DynamicObject[])dyns.toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])updateRecords.toArray(new DynamicObject[0]));
    }

    private static void replaceAccountEntryId(String entityNumber, Long orgId, Map<String, Map<String, Boolean>> acctEntryFieldNames, AccountTableRef accountTableRef, String useOrgField, Date enableDate) {
        long oldAccountTable;
        long newAccountTable = accountTableRef.getNewAccountTableId();
        boolean isAccTableVersion = newAccountTable != (oldAccountTable = accountTableRef.getOldAccountTableId());
        AccountRef accountRef = accountTableRef.getAccountRef();
        Map<Object, Object> relMap = new HashMap(8);
        Map<Long, Long> oldAndNewAccountRef = accountRef.getOldAndNewAccountRef();
        Map<Long, String> accountLongNumberRef = accountRef.getAccountLongNumberRef();
        if (AccountTableRefUtils.isGl_presetcashflowitem(entityNumber, isAccTableVersion)) {
            HashSet<Long> orgIds = new HashSet<Long>(8);
            orgIds.add(orgId);
            relMap = AccountCashFlowService.batchGetAccountCashItemRel(orgIds, accountTableRef.getNewAccountTableId());
        }
        HashMap<String, Set<Long>> fieldAndDataids = new HashMap<String, Set<Long>>(100);
        Set<Long> oldAcctIds = oldAndNewAccountRef.keySet();
        ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
        if (StringUtils.isNotEmpty((String)useOrgField)) {
            filters.add(new QFilter(useOrgField + POINTID, "=", (Object)orgId));
        } else {
            orgId = 0L;
        }
        QFilter qFilter = null;
        for (Map.Entry<String, Map<String, Boolean>> acctEntryFieldName : acctEntryFieldNames.entrySet()) {
            String entityname = acctEntryFieldName.getKey();
            Map<String, Boolean> map = acctEntryFieldName.getValue();
            for (Map.Entry<String, Boolean> v : map.entrySet()) {
                if (v.getValue().booleanValue()) {
                    if (qFilter == null) {
                        qFilter = new QFilter(entityname + POINT + v.getKey() + FBASEDATAID, "in", oldAcctIds);
                        continue;
                    }
                    qFilter.or(new QFilter(entityname + POINT + v.getKey() + FBASEDATAID, "in", oldAcctIds));
                    continue;
                }
                if (qFilter == null) {
                    qFilter = new QFilter(entityname + POINT + v.getKey() + POINTID, "in", oldAcctIds);
                    continue;
                }
                qFilter.or(new QFilter(entityname + POINT + v.getKey() + POINTID, "in", oldAcctIds));
            }
        }
        filters.add(qFilter);
        Map map = BusinessDataServiceHelper.loadFromCache((String)entityNumber, (QFilter[])filters.toArray(new QFilter[0]));
        if (map == null || map.size() < 1) {
            return;
        }
        ArrayList<DynamicObject> updateRecords = new ArrayList<DynamicObject>(map.size());
        ArrayList<DynamicObject> dyns = new ArrayList<DynamicObject>(map.size());
        for (DynamicObject dyn : map.values()) {
            if (AcctUpdateUtil.isBudgeTypeMapping(entityNumber, dyn)) continue;
            for (Map.Entry<String, Map<String, Boolean>> acctEntryFieldName : acctEntryFieldNames.entrySet()) {
                String entityname = acctEntryFieldName.getKey();
                Map<String, Boolean> v = acctEntryFieldName.getValue();
                DynamicObjectCollection entrys = dyn.getDynamicObjectCollection(entityname);
                DynamicObjectCollection newEntrys = new DynamicObjectCollection(((DynamicObject)entrys.get(0)).getDynamicObjectType(), null);
                for (DynamicObject entry : entrys) {
                    for (Map.Entry<String, Boolean> vv : v.entrySet()) {
                        if (vv.getValue().booleanValue()) continue;
                        Long oldAcctId = entry.getLong(vv.getKey() + POINTID);
                        String fieldName = vv.getKey();
                        Long newAccountId = oldAndNewAccountRef.get(oldAcctId);
                        if (newAccountId == null || newAccountId == 0L) {
                            if (!DebugTrace.enable()) continue;
                            logger.info("curr entityNumber : {}  $$$$ oldAndNewAccountRef: {}  ## oldAcctId \uff1a {}  ## newAccountId \uff1a {}", new Object[]{entityNumber, DebugTraceHelper.toString(oldAndNewAccountRef), oldAcctId, newAccountId});
                            continue;
                        }
                        String accLongNumber = accountLongNumberRef.get(newAccountId);
                        if (!oldAcctIds.contains(oldAcctId)) continue;
                        if (AccountTableRefUtils.isGl_presetcashflowitem(entityNumber, isAccTableVersion)) {
                            Optional<DynamicObject> res = AccountTableRefUtils.dealPresetCashFlowEntry((Set)relMap.get(orgId), entry, accLongNumber, newAccountId);
                            if (!res.isPresent()) continue;
                            newEntrys.add((Object)res.get());
                            continue;
                        }
                        entry.set(vv.getKey() + _ID, (Object)newAccountId);
                        DynamicObject updateRecord = AcctUpdateUtil.buildUpdateRecord(entityNumber, dyn.getLong(ID), Long.valueOf(entry.getPkValue() + ""), orgId, vv.getKey(), oldAcctId, oldAndNewAccountRef.get(oldAcctId), entityname, ACCT, enableDate, "0");
                        updateRecords.add(updateRecord);
                        if (fieldAndDataids.containsKey(fieldName)) {
                            ((Set)fieldAndDataids.get(fieldName)).add(Long.valueOf(entry.getPkValue() + ""));
                            continue;
                        }
                        HashSet<Long> idSet = new HashSet<Long>(100);
                        idSet.add(Long.valueOf(entry.getPkValue() + ""));
                        fieldAndDataids.put(fieldName, idSet);
                    }
                }
                if (newEntrys.isEmpty() || newAccountTable == dyn.getLong("accounttable.id")) continue;
                DynamicObject newDyn = AccountCashFlowService.newPresetCashItem(dyn, newAccountTable);
                newDyn.set(entityname, (Object)newEntrys);
                dyns.add(newDyn);
            }
            if (AccountTableRefUtils.isGl_presetcashflowitem(entityNumber, isAccTableVersion)) continue;
            dyns.add(dyn);
        }
        SaveServiceHelper.save((DynamicObject[])dyns.toArray(new DynamicObject[0]));
        BackUpAssgrpUtil.excuteAssgrpReplaceService(entityNumber, dyns, fieldAndDataids);
        SaveServiceHelper.update((DynamicObject[])dyns.toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])updateRecords.toArray(new DynamicObject[0]));
    }

    private static boolean isBudgeTypeMapping(String entityNumber, DynamicObject dyn) {
        return entityNumber.equals("bd_accountmapping") && dyn.getString("mappingtype").equals("2");
    }

    private static void replaceAccountTableId(String entityNumber, Long orgId, Map<String, Boolean> acctTabFieldNames, AccountTableRef accountTableRef, String useOrgField, String type, Date enableDate) {
        long oldAccountTableId = accountTableRef.getOldAccountTableId();
        long newAccountTableId = accountTableRef.getNewAccountTableId();
        ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
        if (AccountTableRefUtils.isGl_presetcashflowitem(entityNumber, oldAccountTableId != newAccountTableId)) {
            return;
        }
        if (StringUtils.isNotEmpty((String)useOrgField)) {
            filters.add(new QFilter(useOrgField + POINTID, "=", (Object)orgId));
        } else {
            orgId = 0L;
        }
        QFilter qFilter = null;
        for (Map.Entry<String, Boolean> acctTabFieldName : acctTabFieldNames.entrySet()) {
            if (!acctTabFieldName.getValue().booleanValue()) {
                if (qFilter == null) {
                    qFilter = new QFilter(acctTabFieldName.getKey() + POINTID, "=", (Object)oldAccountTableId);
                    continue;
                }
                qFilter.or(new QFilter(acctTabFieldName.getKey() + POINTID, "=", (Object)oldAccountTableId));
                continue;
            }
            if (qFilter == null) {
                qFilter = new QFilter(acctTabFieldName.getKey() + FBASEDATAID, "=", (Object)oldAccountTableId);
                continue;
            }
            qFilter.or(new QFilter(acctTabFieldName.getKey() + FBASEDATAID, "=", (Object)oldAccountTableId));
        }
        filters.add(qFilter);
        Map map = BusinessDataServiceHelper.loadFromCache((String)entityNumber, (QFilter[])filters.toArray(new QFilter[0]));
        if (map == null || map.size() < 1) {
            return;
        }
        ArrayList<DynamicObject> dyns = new ArrayList<DynamicObject>(map.size());
        ArrayList<DynamicObject> updateRecords = new ArrayList<DynamicObject>(map.size());
        for (DynamicObject dyn : map.values()) {
            if (AcctUpdateUtil.isBudgeTypeMapping(entityNumber, dyn)) continue;
            for (Map.Entry<String, Boolean> acctTabFieldName : acctTabFieldNames.entrySet()) {
                if (acctTabFieldName.getValue().booleanValue()) {
                    DynamicObjectCollection entrys = dyn.getDynamicObjectCollection(acctTabFieldName.getKey());
                    for (DynamicObject entry : entrys) {
                        if (oldAccountTableId != entry.getLong(FBASEDATAID_ID)) continue;
                        entry.set(FBASEDATAID_ID, (Object)newAccountTableId);
                        DynamicObject updateRecord = AcctUpdateUtil.buildUpdateRecord(entityNumber, dyn.getLong(ID), Long.valueOf(entry.getPkValue() + ""), orgId, acctTabFieldName.getKey(), oldAccountTableId, newAccountTableId, null, type, enableDate, "0");
                        updateRecords.add(updateRecord);
                    }
                    continue;
                }
                if (oldAccountTableId != dyn.getLong(acctTabFieldName.getKey() + POINTID)) continue;
                dyn.set(acctTabFieldName.getKey() + _ID, (Object)newAccountTableId);
                DynamicObject updateRecord = AcctUpdateUtil.buildUpdateRecord(entityNumber, dyn.getLong(ID), 0L, orgId, acctTabFieldName.getKey(), oldAccountTableId, newAccountTableId, null, type, enableDate, "0");
                updateRecords.add(updateRecord);
            }
            dyns.add(dyn);
        }
        SaveServiceHelper.update((DynamicObject[])dyns.toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])updateRecords.toArray(new DynamicObject[0]));
    }

    protected static DynamicObject buildUpdateRecord(String entityNumber, Long dataid, Long entrydataid, long orgId, String filedName, Long oldAcctId, Long newAcctId, String entryName, String fieldtype, Date enableDate, String source) {
        DynamicObject updateRecord = BusinessDataServiceHelper.newDynamicObject((String)BD_ACCOUNT_UPDATERECORD);
        updateRecord.set(METADATA, (Object)entityNumber);
        updateRecord.set(FIELDTYPE, (Object)fieldtype);
        updateRecord.set(DATAID, (Object)dataid);
        updateRecord.set(DATAENTRYID, (Object)entrydataid);
        updateRecord.set(ORG, (Object)orgId);
        updateRecord.set(ENTRYNAME, (Object)entryName);
        updateRecord.set(FIELDNAME, (Object)filedName);
        updateRecord.set(REACCOUNTID, (Object)oldAcctId);
        updateRecord.set(AFACCOUNTID, (Object)newAcctId);
        updateRecord.set(CREATER, (Object)Long.valueOf(RequestContext.get().getUserId()));
        updateRecord.set(CREATEDATE, (Object)new Date());
        updateRecord.set(VERSIONDATE, (Object)enableDate);
        updateRecord.set(RECORDSOURCE, (Object)source);
        return updateRecord;
    }

    private static Map<String, String> getMetaDataRelationShip(List<String> numbers) {
        HashMap<String, String> map = new HashMap<String, String>(numbers.size());
        StringBuilder sb = new StringBuilder();
        sb.append("select fid,fnumber,fmasterid from t_meta_entitydesign where fnumber in ");
        for (int i = 0; i < numbers.size(); ++i) {
            if (i == 0) {
                sb.append('(').append("'").append(numbers.get(i)).append("',");
                continue;
            }
            if (i == numbers.size() - 1) {
                sb.append("'").append(numbers.get(i)).append("')");
                continue;
            }
            sb.append("'").append(numbers.get(i)).append("',");
        }
        String sql = sb.toString();
        HashMap<String, String> idAndNumber = new HashMap<String, String>(numbers.size());
        HashMap<String, String> idAndMasterId = new HashMap<String, String>(numbers.size());
        try (DataSet dataset = DB.queryDataSet((String)"kd.bos.ext.fi.accountref.util.AcctVersionUtil.getMetaDataRelationShip", (DBRoute)DBRoute.of((String)"sys.meta"), (String)sql);){
            for (Row row : dataset) {
                idAndNumber.put(row.getString("fid"), row.getString("fnumber"));
                idAndMasterId.put(row.getString("fid"), row.getString("fmasterid"));
            }
        }
        for (Map.Entry entry : idAndNumber.entrySet()) {
            String value = "";
            value = StringUtils.isEmpty((String)((String)idAndMasterId.get(entry.getKey()))) ? (String)entry.getValue() : (String)idAndNumber.get(idAndMasterId.get(entry.getKey()));
            map.put((String)entry.getValue(), value);
        }
        return map;
    }

    protected static String printError(Throwable t) {
        if (null == t) {
            return null;
        }
        StringBuilder upper = new StringBuilder();
        if (null != t.getCause() && null != t.getCause().getStackTrace()) {
            upper.append(AcctUpdateUtil.printError(t.getCause())).append("\n");
        }
        StringWriter sW = new StringWriter();
        try (PrintWriter writer = new PrintWriter(sW);){
            t.printStackTrace(writer);
            writer.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return upper.append(sW.toString()).toString();
    }

    protected static void clearBaseDataCache(String entityName) {
        String type = BaseDataCtrlCacheMrg.getType4BaseDataFilter();
        BaseDataCtrlCacheMrg.clearCacheWithPrefix((String)type, (String)entityName);
        BaseDataCtrlCache.clearWithPrefixBaseDataUseRange((String)entityName);
    }
}

