/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.accountref.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.ext.fi.accountref.AccountTableRef;
import kd.bos.ext.fi.accountref.CheckResult;
import kd.bos.ext.fi.accountref.IAccountTableRefService;
import kd.bos.ext.fi.accountref.impl.AcctUpdateUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class AiReconciliationSchemeImpl
implements IAccountTableRefService {
    private static Log logger = LogFactory.getLog(AiReconciliationSchemeImpl.class);

    @Override
    public void enable(long orgId, Date enableDate, AccountTableRef accountIdRef) {
        try (TXHandle handle = TX.requiresNew((String)"kd.bos.ext.fi.accountref.impl.AiReconciliationSchemeImpl.enable");){
            try {
                if (accountIdRef.getOldAccountTableId() != accountIdRef.getNewAccountTableId()) {
                    this.replaceAccountTableId(orgId, enableDate, accountIdRef);
                }
                this.replaceAccountId(orgId, enableDate, accountIdRef);
            }
            catch (Exception e) {
                logger.info(AcctUpdateUtil.printError(e));
                handle.markRollback();
                throw e;
            }
        }
    }

    private void replaceAccountId(long orgId, Date enableDate, AccountTableRef accountIdRef) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
        filters.add(new QFilter("createorg.id", "=", (Object)orgId));
        Set<Long> acctIds = accountIdRef.getAccountRef().getOldAndNewAccountRef().keySet();
        Map<Long, Long> oldAndNewAccountRef = accountIdRef.getAccountRef().getOldAndNewAccountRef();
        filters.add(new QFilter("modularentryentity.account.id", "in", acctIds).or(new QFilter("assistentry.tab1_account.id", "in", acctIds)).or("basedataentry.assistacct.fbasedataid_id", "in", acctIds));
        Map dataMap = BusinessDataServiceHelper.loadFromCache((String)"ai_reconciliation_scheme", (QFilter[])filters.toArray(new QFilter[0]));
        if (dataMap != null && !dataMap.isEmpty()) {
            ArrayList<DynamicObject> dyns = new ArrayList<DynamicObject>(dataMap.size());
            ArrayList<DynamicObject> updateRecords = new ArrayList<DynamicObject>(dataMap.size());
            for (DynamicObject dyn : dataMap.values()) {
                DynamicObject updateRecord;
                Long oldAcctId;
                DynamicObjectCollection entrys = dyn.getDynamicObjectCollection("modularentryentity");
                for (DynamicObject entry : entrys) {
                    oldAcctId = entry.getLong("account_id");
                    if (!acctIds.contains(oldAcctId)) continue;
                    entry.set("account_id", (Object)oldAndNewAccountRef.get(oldAcctId));
                    updateRecord = AcctUpdateUtil.buildUpdateRecord("ai_reconciliation_scheme", dyn.getLong("id"), Long.valueOf(entry.getPkValue() + ""), orgId, "account", oldAcctId, oldAndNewAccountRef.get(oldAcctId), "modularentryentity", "acct", enableDate, "0");
                    updateRecords.add(updateRecord);
                }
                entrys = dyn.getDynamicObjectCollection("assistentry");
                for (DynamicObject entry : entrys) {
                    oldAcctId = entry.getLong("tab1_account_id");
                    if (!acctIds.contains(oldAcctId)) continue;
                    entry.set("tab1_account_id", (Object)oldAndNewAccountRef.get(oldAcctId));
                    updateRecord = AcctUpdateUtil.buildUpdateRecord("ai_reconciliation_scheme", dyn.getLong("id"), Long.valueOf(entry.getPkValue() + ""), orgId, "tab1_account", oldAcctId, oldAndNewAccountRef.get(oldAcctId), "assistentry", "acct", enableDate, "1");
                    updateRecords.add(updateRecord);
                }
                entrys = dyn.getDynamicObjectCollection("basedataentry");
                for (DynamicObject entry : entrys) {
                    DynamicObjectCollection baseentrys = entry.getDynamicObjectCollection("assistacct");
                    for (DynamicObject baseentry : baseentrys) {
                        Long oldAcctId2 = baseentry.getLong("fbasedataid_id");
                        if (!acctIds.contains(oldAcctId2)) continue;
                        baseentry.set("fbasedataid_id", (Object)oldAndNewAccountRef.get(oldAcctId2));
                        DynamicObject updateRecord2 = AcctUpdateUtil.buildUpdateRecord("ai_reconciliation_scheme", dyn.getLong("id"), Long.valueOf(baseentry.getPkValue() + ""), orgId, "assistacct", oldAcctId2, oldAndNewAccountRef.get(oldAcctId2), "basedataentry", "acct", enableDate, "1");
                        updateRecords.add(updateRecord2);
                    }
                }
                dyns.add(dyn);
            }
            SaveServiceHelper.save((DynamicObject[])dyns.toArray(new DynamicObject[0]));
            SaveServiceHelper.save((DynamicObject[])updateRecords.toArray(new DynamicObject[0]));
        }
    }

    private void replaceAccountTableId(long orgId, Date enableDate, AccountTableRef accountIdRef) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
        filters.add(new QFilter("createorg.id", "=", (Object)orgId));
        filters.add(new QFilter("accounttable.id", "=", (Object)accountIdRef.getOldAccountTableId()));
        DynamicObject[] dyns = BusinessDataServiceHelper.load((String)"ai_reconciliation_scheme", (String)"id,accounttable", (QFilter[])filters.toArray(new QFilter[0]));
        if (dyns != null && dyns.length > 0) {
            ArrayList<DynamicObject> updateRecords = new ArrayList<DynamicObject>(dyns.length);
            for (DynamicObject dyn : dyns) {
                dyn.set("accounttable_id", (Object)accountIdRef.getNewAccountTableId());
                DynamicObject updateRecord = AcctUpdateUtil.buildUpdateRecord("ai_reconciliation_scheme", dyn.getLong("id"), 0L, orgId, "accounttable", accountIdRef.getOldAccountTableId(), accountIdRef.getNewAccountTableId(), null, "accttable", enableDate, "1");
                updateRecords.add(updateRecord);
            }
            SaveServiceHelper.save((DynamicObject[])dyns);
            SaveServiceHelper.save((DynamicObject[])updateRecords.toArray(new DynamicObject[0]));
        }
    }

    @Override
    public CheckResult enableCheck(long orgId, Date enableDate, AccountTableRef accountIdRef) {
        return new CheckResult();
    }

    @Override
    public void disable(long orgId, Date disableDate, AccountTableRef accountIdRef) {
        try (TXHandle handle = TX.requiresNew((String)"kd.bos.ext.fi.accountref.impl.AiReconciliationSchemeImpl.disable");){
            try {
                DynamicObject[] dyns;
                String selectFields = "id,metadata,fieldtype,dataid,dataentryid,org,fieldname,entryname,reaccountid,afaccountid,versiondate,recordsource";
                ArrayList<QFilter> filters = new ArrayList<QFilter>(6);
                filters.add(new QFilter("metadata", "=", (Object)"ai_reconciliation_scheme"));
                filters.add(new QFilter("fieldtype", "=", (Object)"accttable"));
                filters.add(new QFilter("versiondate", "=", (Object)disableDate));
                filters.add(new QFilter("org", "=", (Object)orgId));
                filters.add(new QFilter("reaccountid", "=", (Object)accountIdRef.getOldAccountTableId()));
                filters.add(new QFilter("afaccountid", "=", (Object)accountIdRef.getNewAccountTableId()));
                DynamicObjectCollection collection = QueryServiceHelper.query((String)"bd_account_updaterecord", (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]));
                ArrayList<Long> ids = new ArrayList<Long>(collection.size());
                ArrayList<Long> dataIds = new ArrayList<Long>(collection.size());
                for (DynamicObject[] dyn : collection) {
                    ids.add(dyn.getLong("id"));
                    dataIds.add(dyn.getLong("dataid"));
                }
                for (DynamicObject dyn : dyns = BusinessDataServiceHelper.load((Object[])dataIds.toArray(new Long[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"ai_reconciliation_scheme"))) {
                    dyn.set("accounttable_id", (Object)accountIdRef.getOldAccountTableId());
                }
                SaveServiceHelper.save((DynamicObject[])dyns);
                DeleteServiceHelper.delete((String)"bd_account_updaterecord", (QFilter[])new QFilter("id", "in", ids).toArray());
                filters.clear();
                ids.clear();
                filters.add(new QFilter("metadata", "=", (Object)"ai_reconciliation_scheme"));
                filters.add(new QFilter("fieldtype", "=", (Object)"acct"));
                filters.add(new QFilter("versiondate", "=", (Object)disableDate));
                filters.add(new QFilter("org", "=", (Object)orgId));
                filters.add(new QFilter("afaccountid", "in", accountIdRef.getAccountRef().getOldAndNewAccountRef().values()));
                collection = QueryServiceHelper.query((String)"bd_account_updaterecord", (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]));
                ArrayList<DynamicObject> datas = new ArrayList<DynamicObject>(collection.size());
                for (DynamicObject dyn : collection) {
                    DynamicObjectCollection entrys;
                    ids.add(dyn.getLong("id"));
                    String entryname = dyn.getString("entryname");
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)dyn.getLong("dataid"), (String)"ai_reconciliation_scheme");
                    if ("modularentryentity".equals(entryname)) {
                        entrys = dynamicObject.getDynamicObjectCollection("modularentryentity");
                        for (DynamicObject entry : entrys) {
                            if (!Long.valueOf(entry.getPkValue() + "").equals(dyn.getLong("dataentryid"))) continue;
                            entry.set("account_id", (Object)dyn.getLong("reaccountid"));
                        }
                    } else if ("assistentry".equals(entryname)) {
                        entrys = dynamicObject.getDynamicObjectCollection("assistentry");
                        for (DynamicObject entry : entrys) {
                            if (!Long.valueOf(entry.getPkValue() + "").equals(dyn.getLong("dataentryid"))) continue;
                            entry.set("tab1_account_id", (Object)dyn.getLong("reaccountid"));
                        }
                    } else if ("basedataentry".equals(entryname)) {
                        entrys = dynamicObject.getDynamicObjectCollection("basedataentry");
                        for (DynamicObject entry : entrys) {
                            DynamicObjectCollection baseEntrys = entry.getDynamicObjectCollection("assistacct");
                            for (DynamicObject baseEntry : baseEntrys) {
                                if (!Long.valueOf(baseEntry.getPkValue() + "").equals(dyn.getLong("dataentryid"))) continue;
                                baseEntry.set("fbasedataid_id", (Object)dyn.getLong("reaccountid"));
                            }
                        }
                    }
                    datas.add(dynamicObject);
                }
                SaveServiceHelper.save((DynamicObject[])datas.toArray(new DynamicObject[0]));
                DeleteServiceHelper.delete((String)"bd_account_updaterecord", (QFilter[])new QFilter("id", "in", ids).toArray());
            }
            catch (Exception e) {
                logger.info(AcctUpdateUtil.printError(e));
                handle.markRollback();
                throw e;
            }
        }
    }

    @Override
    public CheckResult disableCheck(long orgId, Date disableDate, AccountTableRef accountIdRef) {
        return new CheckResult();
    }
}

