/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.accountref.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.ext.fi.accountref.AccountTableRef;
import kd.bos.ext.fi.accountref.CheckResult;
import kd.bos.ext.fi.accountref.IAccountTableRefService;
import kd.bos.ext.fi.accountref.impl.AcctUpdateUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class AifsTargetsetImpl
implements IAccountTableRefService {
    private static Log logger = LogFactory.getLog(AifsTargetsetImpl.class);

    @Override
    public void enable(long orgId, Date enableDate, AccountTableRef accountIdRef) {
        try (TXHandle handle = TX.requiresNew((String)"kd.bos.ext.fi.accountref.impl.AifsTargetsetImpl.enable");){
            try {
                ArrayList<DynamicObject> updateRecords;
                if (accountIdRef.getNewAccountTableId() != accountIdRef.getOldAccountTableId()) {
                    DynamicObject[] dyns = BusinessDataServiceHelper.load((String)"aifs_targetset", (String)"id,accounttable.id accounttableid", (QFilter[])new QFilter("accounttable", "=", (Object)accountIdRef.getOldAccountTableId()).toArray());
                    updateRecords = new ArrayList<DynamicObject>(dyns.length);
                    for (DynamicObject dyn : dyns) {
                        dyn.set("accounttable_id", (Object)accountIdRef.getNewAccountTableId());
                        DynamicObject updateRecord = AcctUpdateUtil.buildUpdateRecord("aifs_targetset", dyn.getLong("id"), 0L, 0L, "accounttable", accountIdRef.getOldAccountTableId(), accountIdRef.getNewAccountTableId(), null, "accttable", enableDate, "1");
                        updateRecords.add(updateRecord);
                    }
                    SaveServiceHelper.save((DynamicObject[])dyns);
                    SaveServiceHelper.save((DynamicObject[])updateRecords.toArray(new DynamicObject[0]));
                }
                Map<Long, Long> map = accountIdRef.getAccountRef().getOldAndNewAccountRef();
                DynamicObject[] dyns = BusinessDataServiceHelper.load((String)"aifs_targetset", (String)"id,accountfield.id accountfieldid", (QFilter[])new QFilter("accountfield.id", "in", map.keySet()).toArray());
                updateRecords = new ArrayList(dyns.length);
                for (DynamicObject dyn : dyns) {
                    dyn.set("accountfield_id", (Object)map.get(dyn.getLong("accountfield.id")));
                    DynamicObject updateRecord = AcctUpdateUtil.buildUpdateRecord("aifs_targetset", dyn.getLong("id"), 0L, 0L, "accountfield", dyn.getLong("accountfield.id"), map.get(dyn.getLong("accountfield.id")), null, "acct", enableDate, "1");
                    updateRecords.add(updateRecord);
                }
                SaveServiceHelper.save((DynamicObject[])dyns);
                SaveServiceHelper.save((DynamicObject[])updateRecords.toArray(new DynamicObject[0]));
            }
            catch (Exception e) {
                logger.info(AcctUpdateUtil.printError(e));
                handle.markRollback();
                throw e;
            }
        }
    }

    @Override
    public CheckResult enableCheck(long orgId, Date enableDate, AccountTableRef accountIdRef) {
        return new CheckResult();
    }

    @Override
    public void disable(long orgId, Date disableDate, AccountTableRef accountIdRef) {
        try (TXHandle handle = TX.requiresNew((String)"kd.bos.ext.fi.accountref.impl.AifsTargetsetImpl.disable");){
            try {
                if (accountIdRef.getNewAccountTableId() != accountIdRef.getOldAccountTableId()) {
                    DynamicObject[] dyns;
                    String selectFields = "id,metadata,fieldtype,dataid,dataentryid,org,fieldname,entryname,reaccountid,afaccountid,versiondate,recordsource";
                    ArrayList<QFilter> filters = new ArrayList<QFilter>(5);
                    filters.add(new QFilter("metadata", "=", (Object)"aifs_targetset"));
                    filters.add(new QFilter("fieldtype", "=", (Object)"accttable"));
                    filters.add(new QFilter("versiondate", "=", (Object)disableDate));
                    filters.add(new QFilter("reaccountid", "=", (Object)accountIdRef.getOldAccountTableId()));
                    filters.add(new QFilter("afaccountid", "=", (Object)accountIdRef.getNewAccountTableId()));
                    DynamicObjectCollection collection = QueryServiceHelper.query((String)"bd_account_updaterecord", (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]));
                    ArrayList<Long> ids = new ArrayList<Long>(collection.size());
                    ArrayList<Long> dataIds = new ArrayList<Long>(collection.size());
                    for (DynamicObject[] dyn : collection) {
                        ids.add(dyn.getLong("id"));
                        dataIds.add(dyn.getLong("dataid"));
                    }
                    for (DynamicObject dyn : dyns = BusinessDataServiceHelper.load((Object[])dataIds.toArray(new Long[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"aifs_targetset"))) {
                        dyn.set("accounttable_id", (Object)accountIdRef.getOldAccountTableId());
                    }
                    SaveServiceHelper.save((DynamicObject[])dyns);
                    DeleteServiceHelper.delete((String)"bd_account_updaterecord", (QFilter[])new QFilter("id", "in", ids).toArray());
                    filters.clear();
                    ids.clear();
                    filters.add(new QFilter("metadata", "=", (Object)"aifs_targetset"));
                    filters.add(new QFilter("fieldtype", "=", (Object)"acct"));
                    filters.add(new QFilter("versiondate", "=", (Object)disableDate));
                    filters.add(new QFilter("afaccountid", "in", accountIdRef.getAccountRef().getOldAndNewAccountRef().values()));
                    collection = QueryServiceHelper.query((String)"bd_account_updaterecord", (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]));
                    HashMap<Long, Long> newAndOldIds = new HashMap<Long, Long>(collection.size());
                    for (DynamicObject dyn : collection) {
                        ids.add(dyn.getLong("id"));
                        dataIds.add(dyn.getLong("dataid"));
                        newAndOldIds.put(dyn.getLong("afaccountid"), dyn.getLong("reaccountid"));
                    }
                    for (DynamicObject dyn : dyns = BusinessDataServiceHelper.load((Object[])dataIds.toArray(new Long[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"aifs_targetset"))) {
                        dyn.set("accountfield_id", newAndOldIds.get(dyn.getLong("accountfield.id")));
                    }
                    SaveServiceHelper.save((DynamicObject[])dyns);
                    DeleteServiceHelper.delete((String)"bd_account_updaterecord", (QFilter[])new QFilter("id", "in", ids).toArray());
                }
            }
            catch (Exception e) {
                logger.info(AcctUpdateUtil.printError(e));
                handle.markRollback();
                throw e;
            }
        }
    }

    @Override
    public CheckResult disableCheck(long orgId, Date disableDate, AccountTableRef accountIdRef) {
        return new CheckResult();
    }
}

