/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.accountref.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.ext.fi.accountref.AccountTableRef;
import kd.bos.ext.fi.accountref.IAccountTableRefService;
import kd.bos.ext.fi.accountref.impl.AcctUpdateUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class AnasysReportUtilImpl
implements IAccountTableRefService {
    private static Log logger = LogFactory.getLog(AnasysReportUtilImpl.class);

    @Override
    public void enable(long orgId, Date enableDate, AccountTableRef accountIdRef) {
        try (TXHandle handle = TX.requiresNew((String)"kd.bos.ext.fi.accountref.impl.AnasysReportUtilImpl.enable");){
            try {
                Long oldAccountTableId = accountIdRef.getOldAccountTableId();
                Long newAccountTableId = accountIdRef.getNewAccountTableId();
                if (oldAccountTableId.equals(newAccountTableId)) {
                    this.replaceDynamicObject(orgId, enableDate, accountIdRef);
                } else {
                    this.copyDynamictObject(orgId, accountIdRef);
                }
            }
            catch (Exception e) {
                logger.info(AcctUpdateUtil.printError(e));
                handle.markRollback();
                throw e;
            }
        }
    }

    private void replaceDynamicObject(long orgId, Date enableDate, AccountTableRef accountIdRef) {
        Long oldAccountTableId = accountIdRef.getOldAccountTableId();
        Map<Long, Long> map = accountIdRef.getAccountRef().getOldAndNewAccountRef();
        ArrayList<QFilter> filters = new ArrayList<QFilter>(3);
        filters.add(new QFilter("org", "=", (Object)orgId));
        filters.add(new QFilter("accounttable.id", "=", (Object)oldAccountTableId));
        filters.add(new QFilter("entryentity.project.id", "in", map.keySet()));
        ArrayList<DynamicObject> updateRecords = new ArrayList<DynamicObject>(100);
        Map balanceMap = BusinessDataServiceHelper.loadFromCache((String)"gl_balancesheetexpression", (QFilter[])filters.toArray(new QFilter[0]));
        for (DynamicObject dyn : balanceMap.values()) {
            DynamicObjectCollection entryentity = dyn.getDynamicObjectCollection("entryentity");
            for (DynamicObject entity : entryentity) {
                Long accountId = entity.getLong("project.id");
                if (!map.containsKey(accountId)) continue;
                entity.set("project_id", (Object)map.get(accountId));
                DynamicObject updateRecord = AcctUpdateUtil.buildUpdateRecord("gl_balancesheetexpression", dyn.getLong("id"), Long.valueOf(entity.getPkValue() + ""), orgId, "project", accountId, map.get(accountId), "entryentity", "acct", enableDate, "1");
                updateRecords.add(updateRecord);
            }
        }
        Map incomeexpressionMap = BusinessDataServiceHelper.loadFromCache((String)"gl_incomeexpression", (QFilter[])filters.toArray(new QFilter[0]));
        for (DynamicObject dyn : incomeexpressionMap.values()) {
            DynamicObjectCollection entryentity = dyn.getDynamicObjectCollection("entryentity");
            for (DynamicObject entity : entryentity) {
                Long accountId = entity.getLong("project.id");
                if (!map.containsKey(accountId)) continue;
                entity.set("project_id", (Object)map.get(accountId));
                DynamicObject updateRecord = AcctUpdateUtil.buildUpdateRecord("gl_incomeexpression", dyn.getLong("id"), Long.valueOf(entity.getPkValue() + ""), orgId, "project", accountId, map.get(accountId), "entryentity", "acct", enableDate, "1");
                updateRecords.add(updateRecord);
            }
        }
        SaveServiceHelper.update((DynamicObject[])balanceMap.values().toArray(new DynamicObject[0]));
        SaveServiceHelper.update((DynamicObject[])incomeexpressionMap.values().toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])updateRecords.toArray(new DynamicObject[0]));
    }

    private void copyDynamictObject(long orgId, AccountTableRef accountIdRef) {
        this.copyIncomeDynamicObject("gl_balancesheetedit", orgId, accountIdRef, "");
        this.copyIncomeDynamicObject("gl_incomeedit", orgId, accountIdRef, "income");
        this.copyIncomeDynamicObject("gl_incomeedit", orgId, accountIdRef, "taxshow");
        this.copyIncomeDynamicObject("gl_cashflowedit", orgId, accountIdRef, "cashflow");
        this.copyTaxassigntable(orgId, accountIdRef);
    }

    private void copyTaxassigntable(long orgId, AccountTableRef accountIdRef) {
        DeleteServiceHelper.delete((String)"gl_taxassigntable", (QFilter[])new QFilter[]{new QFilter("useorg.id", "=", (Object)orgId), new QFilter("accounttable.id", "=", (Object)accountIdRef.getNewAccountTableId())});
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter("useorg.id", "=", (Object)orgId));
        qFilters.add(new QFilter("accounttable.id", "=", (Object)accountIdRef.getOldAccountTableId()));
        DynamicObject[] dyns = BusinessDataServiceHelper.load((String)"gl_taxassigntable", (String)"accounttable.id", (QFilter[])qFilters.toArray(new QFilter[0]), null);
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(dyns.length);
        CloneUtils util = new CloneUtils(true, true);
        for (DynamicObject dyn : dyns) {
            DynamicObject sheet = (DynamicObject)util.clone((IDataEntityBase)dyn);
            sheet.set("id", null);
            sheet.set("accounttable_id", (Object)accountIdRef.getNewAccountTableId());
            list.add(sheet);
        }
        SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
    }

    private void copyIncomeDynamicObject(String entityName, long orgId, AccountTableRef accountIdRef, String type) {
        long oldAccountTableId = accountIdRef.getOldAccountTableId();
        long newAccountTableId = accountIdRef.getNewAccountTableId();
        ArrayList<QFilter> filters = new ArrayList<QFilter>(3);
        filters.add(new QFilter("org.id", "=", (Object)orgId));
        filters.add(new QFilter("accounttable.id", "=", (Object)oldAccountTableId));
        if (!"gl_balancesheetedit".equals(entityName)) {
            filters.add(new QFilter("type", "=", (Object)type));
            DeleteServiceHelper.delete((String)entityName, (QFilter[])new QFilter[]{new QFilter("org.id", "=", (Object)orgId), new QFilter("accounttable.id", "=", (Object)newAccountTableId), new QFilter("type", "=", (Object)type)});
        } else {
            DeleteServiceHelper.delete((String)entityName, (QFilter[])new QFilter[]{new QFilter("org.id", "=", (Object)orgId), new QFilter("accounttable.id", "=", (Object)newAccountTableId)});
        }
        Map balancesheets = BusinessDataServiceHelper.loadFromCache((String)entityName, (QFilter[])filters.toArray(new QFilter[0]));
        ArrayList<DynamicObject> sheets = new ArrayList<DynamicObject>(balancesheets.size());
        CloneUtils util = new CloneUtils(true, true);
        Collection values = balancesheets.values();
        for (DynamicObject balancesheet : values) {
            DynamicObject dyn = (DynamicObject)util.clone((IDataEntityBase)balancesheet);
            dyn.set("id", null);
            dyn.set("accounttable_id", (Object)newAccountTableId);
            sheets.add(dyn);
        }
        SaveServiceHelper.save((DynamicObject[])sheets.toArray(new DynamicObject[0]));
        Map<Long, Long> map = accountIdRef.getAccountRef().getOldAndNewAccountRef();
        if (!"gl_balancesheetedit".equals(entityName)) {
            entityName = "gl_incomeexpression";
            DeleteServiceHelper.delete((String)entityName, (QFilter[])new QFilter[]{new QFilter("org.id", "=", (Object)orgId), new QFilter("accounttable.id", "=", (Object)newAccountTableId), new QFilter("type", "=", (Object)type)});
        } else {
            entityName = "gl_balancesheetexpression";
            DeleteServiceHelper.delete((String)entityName, (QFilter[])new QFilter[]{new QFilter("org.id", "=", (Object)orgId), new QFilter("accounttable.id", "=", (Object)newAccountTableId)});
        }
        Map expressions = BusinessDataServiceHelper.loadFromCache((String)entityName, (QFilter[])filters.toArray(new QFilter[0]));
        ArrayList<DynamicObject> dyns = new ArrayList<DynamicObject>(expressions.size());
        Collection expressionvalues = expressions.values();
        for (DynamicObject expression : expressionvalues) {
            DynamicObject dyn = (DynamicObject)util.clone((IDataEntityBase)expression);
            dyn.set("id", null);
            dyn.set("accounttable_id", (Object)newAccountTableId);
            DynamicObjectCollection entryentity = dyn.getDynamicObjectCollection("entryentity");
            for (DynamicObject entity : entryentity) {
                Long accountId = entity.getLong("project.id");
                if (!map.containsKey(accountId)) continue;
                entity.set("project_id", (Object)map.get(accountId));
            }
            dyns.add(dyn);
        }
        SaveServiceHelper.save((DynamicObject[])dyns.toArray(new DynamicObject[0]));
    }

    @Override
    public void disable(long orgId, Date disableDate, AccountTableRef accountIdRef) {
        try (TXHandle handle = TX.requiresNew((String)"kd.bos.ext.fi.accountref.impl.AnasysReportUtilImpl.disable");){
            try {
                Long oldAccountTableId = accountIdRef.getOldAccountTableId();
                Long newAccountTableId = accountIdRef.getNewAccountTableId();
                if (oldAccountTableId.equals(newAccountTableId)) {
                    this.returnAccountId(orgId, disableDate, accountIdRef, "gl_incomeexpression");
                    this.returnAccountId(orgId, disableDate, accountIdRef, "gl_balancesheetexpression");
                } else {
                    QFilter[] qFilters = new QFilter[]{new QFilter("org.id", "=", (Object)orgId), new QFilter("accounttable.id", "=", (Object)newAccountTableId)};
                    DeleteServiceHelper.delete((String)"gl_balancesheetedit", (QFilter[])qFilters);
                    DeleteServiceHelper.delete((String)"gl_incomeedit", (QFilter[])qFilters);
                    DeleteServiceHelper.delete((String)"gl_cashflowedit", (QFilter[])qFilters);
                    DeleteServiceHelper.delete((String)"gl_incomeexpression", (QFilter[])qFilters);
                    DeleteServiceHelper.delete((String)"gl_balancesheetexpression", (QFilter[])qFilters);
                    DeleteServiceHelper.delete((String)"gl_taxassigntable", (QFilter[])new QFilter[]{new QFilter("useorg.id", "=", (Object)orgId), new QFilter("accounttable.id", "=", (Object)accountIdRef.getNewAccountTableId())});
                }
            }
            catch (Exception e) {
                logger.info(AcctUpdateUtil.printError(e));
                handle.markRollback();
                throw e;
            }
        }
    }

    private void returnAccountId(long orgId, Date disableDate, AccountTableRef accountIdRef, String entityName) {
        DynamicObject[] dyns;
        String selectFields = "id,metadata,fieldtype,dataid,dataentryid,org,fieldname,entryname,reaccountid,afaccountid,versiondate,recordsource";
        ArrayList<QFilter> filters = new ArrayList<QFilter>(5);
        filters.add(new QFilter("metadata", "=", (Object)entityName));
        filters.add(new QFilter("fieldtype", "=", (Object)"acct"));
        filters.add(new QFilter("versiondate", "=", (Object)disableDate));
        filters.add(new QFilter("afaccountid", "in", accountIdRef.getAccountRef().getOldAndNewAccountRef().values()));
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bd_account_updaterecord", (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]));
        ArrayList<Long> ids = new ArrayList<Long>(collection.size());
        ArrayList<Long> dataIds = new ArrayList<Long>(collection.size());
        HashMap<Long, Long> newAndOldIds = new HashMap<Long, Long>(collection.size());
        Map<Long, Long> oldAndNewIds = accountIdRef.getAccountRef().getOldAndNewAccountRef();
        for (DynamicObject dyn : collection) {
            ids.add(dyn.getLong("id"));
            dataIds.add(dyn.getLong("dataid"));
        }
        for (Map.Entry<Long, Long> entry : oldAndNewIds.entrySet()) {
            newAndOldIds.put(entry.getValue(), entry.getKey());
        }
        for (DynamicObject dyn : dyns = BusinessDataServiceHelper.load((Object[])dataIds.toArray(new Long[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityName))) {
            DynamicObjectCollection entryentity = dyn.getDynamicObjectCollection("entryentity");
            for (DynamicObject entity : entryentity) {
                Long accountId = entity.getLong("project_id");
                if (!newAndOldIds.containsKey(accountId)) continue;
                entity.set("project_id", newAndOldIds.get(accountId));
            }
        }
        SaveServiceHelper.update((DynamicObject[])dyns);
        DeleteServiceHelper.delete((String)"bd_account_updaterecord", (QFilter[])new QFilter("id", "in", ids).toArray());
    }
}

