/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.accountref.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.ext.fi.accountref.impl.AbstractAssgrpReplaceService;
import kd.bos.ext.fi.accountref.impl.AssgrpLoader;
import kd.bos.ext.fi.accountref.impl.AssistItem;
import kd.bos.ext.fi.accountref.impl.BackUpAssgrpUtil;
import kd.bos.ext.fi.accountref.impl.DynamicObjectJsonParser;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

class AssgrpSubEntryReplace
extends AbstractAssgrpReplaceService {
    private static Log logger = LogFactory.getLog(AssgrpSubEntryReplace.class);

    AssgrpSubEntryReplace() {
    }

    @Override
    List<DynamicObject> replaceAccountAssgrp(List<DynamicObject> entityList, String entryName, String accountField, String assgrpField, String subEntryAssgrp, String rowIdField, Set<Long> rowIds) {
        String assgrpFilter = StringUtils.isEmpty((CharSequence)assgrpField) ? entryName : assgrpField;
        ArrayList<DynamicObject> entryRowList = new ArrayList<DynamicObject>();
        for (DynamicObject entity : entityList) {
            IDataEntityProperty prop = (IDataEntityProperty)entity.getDataEntityType().getProperties().get((Object)entryName);
            if (entryName == null || prop == null) continue;
            DynamicObjectCollection entryEntity = entity.getDynamicObjectCollection(prop);
            DynamicProperty accountProp = entryEntity.getDynamicObjectType().getProperty(accountField);
            DynamicProperty assistProp = entryEntity.getDynamicObjectType().getProperty(assgrpField);
            if (accountProp == null || assistProp == null) continue;
            for (DynamicObject entryRow : entryEntity) {
                if (!rowIds.contains(entryRow.getLong("id"))) continue;
                long acctId = entryRow.getLong(accountField + "_id");
                DynamicObjectCollection assistColl = entryRow.getDynamicObjectCollection(assgrpField);
                if (acctId == 0L || assistColl == null || assistColl.isEmpty()) continue;
                Set<String> flexFields = AssgrpLoader.loadAcctFlexField(this.acctFlexFieldMap, acctId);
                ArrayList<DynamicObject> backUpRowList = new ArrayList<DynamicObject>(10);
                boolean needBackUp = false;
                Iterator subEntryIter = assistColl.iterator();
                while (subEntryIter.hasNext()) {
                    DynamicObject assistRow = (DynamicObject)subEntryIter.next();
                    long fieldNameId = assistRow.getLong(subEntryAssgrp + "_id");
                    AssistItem assistItem = AssgrpLoader.loadAssistItem(this.assgrpMap, fieldNameId);
                    if (flexFields.contains(assistItem.getFlexField())) continue;
                    backUpRowList.add(assistRow);
                    subEntryIter.remove();
                    needBackUp = true;
                }
                if (!needBackUp) continue;
                entryRowList.add(entryRow);
                entity.getDataEntityState().setDirty(true);
                for (DynamicObject backUpRow : backUpRowList) {
                    String oriJsonVal = DynamicObjectJsonParser.toJson(backUpRow);
                    this.addBackUpEntryRow(entity, entryRow, oriJsonVal, assgrpFilter);
                }
            }
        }
        if (!entryRowList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])entityList.toArray(new DynamicObject[0]));
        }
        return entityList;
    }

    private void addBackUpEntryRow(DynamicObject entity, DynamicObject entryRow, String oriJsonVal, String assgrpFilter) {
        DynamicObject updateRecord = BusinessDataServiceHelper.newDynamicObject((String)"bd_asstacttype_update");
        updateRecord.set("dataId", entity.get("id"));
        updateRecord.set("metadata_id", (Object)entity.getDataEntityType().getName());
        updateRecord.set("changeType", (Object)"2");
        updateRecord.set("dataEntryId", entryRow.getPkValue());
        updateRecord.set("befAsstValue", (Object)oriJsonVal);
        updateRecord.set("fieldname", (Object)assgrpFilter);
        updateRecord.set("creater", (Object)Long.parseLong(RequestContext.get().getUserId()));
        updateRecord.set("createtime", (Object)new Date());
        this.backUpRecordList.add(updateRecord);
    }

    @Override
    void recoverAccountAssgrp(List<DynamicObject> entityList, String metadata, String entryName, String accountField, String assgrpField, String subEntryAssgrp, String rowIdField, Set<Long> rowIds) {
        String assgrpFilter = StringUtils.isEmpty((CharSequence)assgrpField) ? entryName : assgrpField;
        DynamicObject[] updateRecordArray = BackUpAssgrpUtil.loadBackUpAssgrpRecordByEntityName(entityList, assgrpFilter, rowIds);
        if (updateRecordArray == null || updateRecordArray.length == 0) {
            logger.info("no recover back-up data --" + metadata);
            return;
        }
        HashSet<Long> dataIdSet = new HashSet<Long>();
        HashMap<Long, List<DynamicObject>> updateRecordMap = new HashMap<Long, List<DynamicObject>>();
        BackUpAssgrpUtil.collectUpdateRecord(updateRecordArray, dataIdSet, updateRecordMap);
        ArrayList<Object> deleteRecords = new ArrayList<Object>();
        Map dataMap = BusinessDataServiceHelper.loadFromCache((Object[])dataIdSet.toArray(), (String)metadata);
        for (Map.Entry data : dataMap.entrySet()) {
            Object id = data.getKey();
            DynamicObject entity = (DynamicObject)data.getValue();
            List updateRecordList = (List)updateRecordMap.get(id);
            if (updateRecordList == null) continue;
            for (DynamicObject updateRecord : updateRecordList) {
                String asstValue = updateRecord.getString("befasstvalue");
                Long entryId = updateRecord.getLong("dataentryid");
                if (asstValue == null) continue;
                IDataEntityProperty prop = (IDataEntityProperty)entity.getDataEntityType().getProperties().get((Object)entryName);
                if (entryName == null || !(prop instanceof EntryProp)) continue;
                EntryProp entryProp = (EntryProp)prop;
                DynamicObjectCollection entryEntity = entity.getDynamicObjectCollection(entryName);
                IDataEntityType entryType = entryProp.getItemType();
                IDataEntityProperty entryItemProp = (IDataEntityProperty)entryType.getProperties().get((Object)assgrpField);
                for (DynamicObject entryRow : entryEntity) {
                    if (!(entryItemProp instanceof SubEntryProp) || !entryId.equals(entryRow.getPkValue())) continue;
                    DynamicObjectCollection coll = entryRow.getDynamicObjectCollection(entryItemProp);
                    DynamicObjectJsonParser.fromJson(coll, asstValue);
                    entity.getDataEntityState().setDirty(true);
                    deleteRecords.add(updateRecord.get("id"));
                }
            }
        }
        try (TXHandle handle = TX.requiresNew();){
            try {
                SaveServiceHelper.save((DynamicObject[])dataMap.values().toArray(new DynamicObject[0]));
                DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bd_asstacttype_update"), (Object[])deleteRecords.toArray());
            }
            catch (Exception e) {
                handle.markRollback();
                logger.error((Throwable)e);
            }
        }
    }
}

