/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.accountref.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.EntryProp;
import kd.bos.ext.fi.accountref.impl.AbstractAssgrpReplaceService;
import kd.bos.ext.fi.accountref.impl.AssgrpLoader;
import kd.bos.ext.fi.accountref.impl.AssistItem;
import kd.bos.ext.fi.accountref.impl.BackUpAssgrpUtil;
import kd.bos.ext.fi.accountref.impl.DynamicObjectJsonParser;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

class AssistEntrySingleReplace
extends AbstractAssgrpReplaceService {
    private static Log logger = LogFactory.getLog(AssistEntrySingleReplace.class);

    AssistEntrySingleReplace() {
    }

    @Override
    List<DynamicObject> replaceAccountAssgrp(List<DynamicObject> entityList, String entryField, String accountField, String assgrpField, String subEntryAssgrp, String rowIdField, Set<Long> rowIds) {
        return this.replaceAccountAssgrp(entityList, entryField, accountField, assgrpField, rowIds);
    }

    List<DynamicObject> replaceAccountAssgrp(List<DynamicObject> entityList, String entryName, String accountField, String assgrpField, Set<Long> rowIds) {
        String assgrpFilter = StringUtils.isEmpty((CharSequence)assgrpField) ? entryName : assgrpField;
        for (DynamicObject entity : entityList) {
            IDataEntityProperty prop = (IDataEntityProperty)entity.getDataEntityType().getProperties().get((Object)entryName);
            if (entryName == null || prop == null) continue;
            DynamicObjectCollection entryEntity = entity.getDynamicObjectCollection(prop);
            DynamicProperty accountProp = entryEntity.getDynamicObjectType().getProperty(accountField);
            DynamicProperty assistProp = entryEntity.getDynamicObjectType().getProperty(assgrpField);
            DynamicObjectCollection backUpEntryEntity = new DynamicObjectCollection(entryEntity.getDynamicObjectType(), (Object)entity);
            if (accountProp != null && assistProp != null) {
                Iterator entryEntityIter = entryEntity.iterator();
                while (entryEntityIter.hasNext()) {
                    AssistItem assistItem;
                    Set<String> flexFields;
                    DynamicObject entryRow = (DynamicObject)entryEntityIter.next();
                    if (!rowIds.contains(entryRow.getLong("id"))) continue;
                    long acctId = entryRow.getLong(accountField + "_id");
                    long assistId = entryRow.getLong(assgrpField + "_id");
                    if (acctId == 0L || assistId == 0L || (flexFields = AssgrpLoader.loadAcctFlexField(this.acctFlexFieldMap, acctId)).contains((assistItem = AssgrpLoader.loadAssistItem(this.assgrpMap, assistId)).getFlexField())) continue;
                    backUpEntryEntity.add((Object)entryRow);
                    entryEntityIter.remove();
                }
            }
            if (backUpEntryEntity.isEmpty()) continue;
            for (DynamicObject backUpEntry : backUpEntryEntity) {
                String backUpStr = DynamicObjectJsonParser.toJson(backUpEntry);
                DynamicObject updateRecord = BusinessDataServiceHelper.newDynamicObject((String)"bd_asstacttype_update");
                updateRecord.set("dataId", entity.get("id"));
                updateRecord.set("metadata_id", (Object)entity.getDataEntityType().getName());
                updateRecord.set("changeType", (Object)"1");
                updateRecord.set("dataEntryId", entity.getPkValue());
                updateRecord.set("befAsstValue", (Object)backUpStr);
                updateRecord.set("fieldname", (Object)assgrpFilter);
                updateRecord.set("creater", (Object)Long.parseLong(RequestContext.get().getUserId()));
                updateRecord.set("createtime", (Object)new Date());
                this.backUpRecordList.add(updateRecord);
            }
        }
        SaveServiceHelper.save((DynamicObject[])entityList.toArray(new DynamicObject[0]));
        return entityList;
    }

    @Override
    void recoverAccountAssgrp(List<DynamicObject> entityList, String metadata, String entryName, String accountField, String assgrpField, String subEntryAssgrp, String rowIdField, Set<Long> rowIds) {
        String assgrpFilter = StringUtils.isEmpty((CharSequence)assgrpField) ? entryName : assgrpField;
        DynamicObject[] updateRecordArray = BackUpAssgrpUtil.loadBackUpAssgrpRecordByEntityName(entityList, assgrpFilter, rowIds);
        if (updateRecordArray == null || updateRecordArray.length == 0) {
            logger.info("no recover back-up data --" + metadata);
            return;
        }
        HashSet<Long> dataIdSet = new HashSet<Long>();
        HashMap<Long, List<DynamicObject>> updateRecordMap = new HashMap<Long, List<DynamicObject>>();
        BackUpAssgrpUtil.collectUpdateRecord(updateRecordArray, dataIdSet, updateRecordMap);
        ArrayList<Object> deleteRecords = new ArrayList<Object>();
        Map dataMap = BusinessDataServiceHelper.loadFromCache((Object[])dataIdSet.toArray(), (String)metadata);
        for (Map.Entry data : dataMap.entrySet()) {
            Object id = data.getKey();
            DynamicObject entity = (DynamicObject)data.getValue();
            List updateRecordList = (List)updateRecordMap.get(id);
            if (updateRecordList == null) continue;
            for (DynamicObject updateRecord : updateRecordList) {
                String asstValue = updateRecord.getString("befasstvalue");
                if (asstValue == null) continue;
                IDataEntityProperty prop = (IDataEntityProperty)entity.getDataEntityType().getProperties().get((Object)entryName);
                if (entryName == null || !(prop instanceof EntryProp)) continue;
                DynamicObjectCollection entryEntity = entity.getDynamicObjectCollection(prop);
                DynamicObjectJsonParser.fromJson(entryEntity, asstValue);
                deleteRecords.add(updateRecord.get("id"));
            }
        }
        try (TXHandle handle = TX.requiresNew();){
            try {
                SaveServiceHelper.save((DynamicObject[])dataMap.values().toArray(new DynamicObject[0]));
                DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bd_asstacttype_update"), (Object[])deleteRecords.toArray());
            }
            catch (Exception e) {
                handle.markRollback();
                logger.error((Throwable)e);
            }
        }
    }
}

