/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.ai;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.ext.fi.ai.presetcf.PresetCashFlowItemParam;
import kd.fi.bd.business.service.CashFlowItemPresetRelationService;
import kd.fi.bd.business.service.ExtOrgService;
import kd.fi.bd.business.vo.PresetCashFlowItemVO;
import kd.fi.bd.util.PerformanceMonitor;

public class PresetCashItemUtil {
    public static final String MAINITEM = "mainitem";
    public static final String SUPPITEM = "suppitem";
    public static final String CREATEORG = "createorg";
    public static final String ISLEAF = "isleaf";
    public static final String ID = "id";
    public static final String ASSIST_ENTRY = "checkitementry";
    public static final String ASSIST_ITEM = "asstactitem";
    public static final String LONGNUMBER = "longnumber";
    public static final String ASSGRP = "assgrp";
    public static final String MASTER_ITEM = "1";
    public static final String SUPPLEMENTARY_ITEM = "3";

    private PresetCashItemUtil() {
    }

    public static List<Long> getAllSuperiorOrgIds(Long useorgId, boolean isIncludeCurOrg) {
        return ExtOrgService.getAllSuperiorOrgs("10", useorgId, isIncludeCurOrg);
    }

    public static List<Object> getUsedPresetIds(Long curOrg, Long accounttableId) {
        return CashFlowItemPresetRelationService.getAvailableRelations(curOrg, accounttableId).stream().map(PresetCashFlowItemVO::getId).collect(Collectors.toList());
    }

    public static Map<String, Long> getCashFlowItemIds(DynamicObject acct, long assgrp, String direction, long orgId) {
        String dc = "debitlocal".equals(direction) ? MASTER_ITEM : "-1";
        long accountTableId = acct.getLong("accounttable_id");
        PresetCashFlowItemParam mainCfItemPresetParam = PresetCashFlowItemParam.create(acct.getLong(ID), acct.getString(LONGNUMBER), assgrp, null, dc, MASTER_ITEM);
        PresetCashFlowItemParam suppCfItemPresetParam = PresetCashFlowItemParam.create(acct.getLong(ID), acct.getString(LONGNUMBER), assgrp, null, dc, SUPPLEMENTARY_ITEM);
        Map<PresetCashFlowItemParam, Long> paramItemMap = PresetCashItemUtil.batchGetCashFlowItemIds(Arrays.asList(mainCfItemPresetParam, suppCfItemPresetParam), orgId, accountTableId);
        HashMap<String, Long> result = new HashMap<String, Long>(4);
        result.put(MAINITEM, paramItemMap.getOrDefault(mainCfItemPresetParam, 0L));
        result.put(SUPPITEM, paramItemMap.getOrDefault(suppCfItemPresetParam, 0L));
        return result;
    }

    public static Map<PresetCashFlowItemParam, Long> batchGetCashFlowItemIds(List<PresetCashFlowItemParam> paramList, long orgId, long actTabId) {
        long maxPeriodId = (Long)ThreadCache.get((Object)"PresetCashItemUtil.getMaxPeriodId", () -> (Long)DB.query((DBRoute)DBRoute.of((String)"fi"), (String)"SELECT MAX(FID) MAXID FROM T_BD_PERIOD", r -> {
            r.next();
            return r.getLong("MAXID");
        }));
        return PresetCashItemUtil.batchGetCashFlowItemIds(paramList, orgId, actTabId, maxPeriodId);
    }

    public static Map<PresetCashFlowItemParam, Long> batchGetCashFlowItemIds(List<PresetCashFlowItemParam> paramList, long orgId, long actTabId, long periodId) {
        return PerformanceMonitor.watch(() -> CashFlowItemPresetRelationService.batchGetCashFlowItemIds(paramList, orgId, actTabId, periodId), 100, paramList);
    }
}

