/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.accounthealth;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class CheckContext {
    private Long accountTableId;
    Map<Long, Long> orgParentMap;
    private Set<Long> selectOrgs;

    public CheckContext(long accountTableId, Set<Long> selectOrgs) {
        this.accountTableId = accountTableId;
        if (CollectionUtils.isEmpty(selectOrgs)) {
            throw new KDBizException("");
        }
        this.selectOrgs = selectOrgs;
        this.orgParentMap = this.getValidSuperiorOrg();
    }

    private Map<Long, Long> getValidSuperiorOrg() {
        Set<ParentVO> pVos = this.selectOrgs.stream().map(x -> new ParentVO((long)x, (long)x, -1L)).collect(Collectors.toSet());
        int maxCycle = 1000;
        int index = 0;
        Set<ParentVO> notFoundParents = pVos;
        while (!notFoundParents.isEmpty()) {
            this.findValidParent(notFoundParents);
            notFoundParents = notFoundParents.stream().filter(x -> x.getParentId() < 0L).collect(Collectors.toSet());
            if (index++ <= maxCycle) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u9012\u5f52\u67e5\u627e\u4e0a\u7ea7\u7ec4\u7ec7\u5f02\u5e38\uff0c\u53ef\u80fd\u7ec4\u7ec7\u5c42\u7ea7\u4e0d\u6b63\u786e\u3002", (String)"CheckContext_0", (String)"fi-bd-common", (Object[])new Object[0]));
        }
        return pVos.stream().collect(Collectors.toMap(x -> x.getOriginOrgId(), x -> x.getParentId()));
    }

    private void findValidParent(Collection<ParentVO> vos) {
        Map parentPairs = OrgUnitServiceHelper.getDirectSuperiorOrg((String)"10", vos.stream().map(ParentVO::getCurOrgId).collect(Collectors.toList()));
        QFilter filter = new QFilter("org", "in", parentPairs.values());
        filter.and(new QFilter("view", "=", (Object)Long.parseLong("10")));
        DataSet ds = QueryServiceHelper.queryDataSet((String)"", (String)"bos_org_structure", (String)"isfreeze,org.enable enable, org.id orgid", (QFilter[])filter.toArray(), null);
        HashSet<Long> invalidParents = new HashSet<Long>(8);
        while (ds.hasNext()) {
            Row row = ds.next();
            boolean enable = row.getBoolean("enable");
            boolean isFreeze = row.getBoolean("isfreeze");
            if (enable && !isFreeze) continue;
            invalidParents.add(row.getLong("orgid"));
        }
        for (ParentVO vo : vos) {
            long pId = (Long)parentPairs.get(vo.getCurOrgId());
            if (!invalidParents.contains(pId)) {
                vo.setParentId(pId);
                continue;
            }
            vo.setCurOrgId(pId);
        }
    }

    public Long getAccountTableId() {
        return this.accountTableId;
    }

    public void setAccountTableId(Long accountTableId) {
        this.accountTableId = accountTableId;
    }

    public Map<Long, Long> getOrgParentMap() {
        return this.orgParentMap;
    }

    public Set<Long> getSelectOrgs() {
        return this.selectOrgs;
    }

    private static class ParentVO {
        private long originOrgId;
        private long curOrgId;
        private long parentId;

        public ParentVO(long originOrgId, long curOrgId, long parentId) {
            this.originOrgId = originOrgId;
            this.curOrgId = curOrgId;
            this.parentId = parentId;
        }

        public long getOriginOrgId() {
            return this.originOrgId;
        }

        public long getCurOrgId() {
            return this.curOrgId;
        }

        public long getParentId() {
            return this.parentId;
        }

        public void setCurOrgId(long curOrgId) {
            this.curOrgId = curOrgId;
        }

        public void setParentId(long parentId) {
            this.parentId = parentId;
        }
    }
}

