/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.accounthealth.accountrepair.repair;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.accounthealth.util.AccountCheckUtil;
import kd.fi.bd.accounthealth.vo.AccountRepairVO;
import kd.fi.bd.business.service.accountrepair.AccountRepairCommonService;
import kd.fi.bd.enums.AccountPropCategory;
import kd.fi.bd.enums.AccountPropDetail;
import kd.fi.bd.util.AccountVersionUtil;
import kd.fi.bd.util.BiTreeNode;
import kd.fi.bd.vo.AccountVO;
import kd.fi.bd.vo.AssistEntryVO;
import kd.fi.bd.vo.OrgVO;

public class AccountRepairContext
implements Serializable {
    private String repairType;
    private BiTreeNode<Long, OrgVO> treeNode;
    private Set<Long> needRepairOrgIds = new HashSet<Long>(8);
    private Map<Long, List<String>> orgRootAccNumberMap = new HashMap<Long, List<String>>(8);
    private Long accountTableId = 0L;
    private long operatorId;
    private Boolean isRealRepair;
    Table<Long, String, BiTreeNode<String, AccountVO>> orgToAccTreeTable = HashBasedTable.create();
    Table<Long, String, AccountRepairVO> accountRepairInfoTable = HashBasedTable.create();
    private Map<String, Set<Long>> firstNnumberToOrgs = new HashMap<String, Set<Long>>(8);
    private Table<Long, String, Set<String>> orgFirstNumberToRootNumbers = HashBasedTable.create();
    private Map<Long, Set<AssistEntryVO>> idToAssistMap = new HashMap<Long, Set<AssistEntryVO>>(8);
    private Date versionDate;
    private Map<Object, DynamicObject> assistIdDynObjMap = new HashMap<Object, DynamicObject>(8);
    private boolean isQtyControl = false;

    public AccountRepairContext() {
    }

    public AccountRepairContext(List<Object> selectRowIds, String repairType, Boolean isRealRepair, long operatorId) {
        this.repairType = repairType;
        this.isRealRepair = isRealRepair;
        this.operatorId = operatorId;
        this.initRepairParams(selectRowIds);
        this.buildOrgTreeNode();
        this.buildAccInfo();
        if (repairType.equals(AccountPropCategory.ASST.getType())) {
            Set accountIds = this.accountRepairInfoTable.values().stream().map(x -> x.getLastVersionId()).collect(Collectors.toSet());
            List batchIdList = Lists.partition(new ArrayList(accountIds), (int)1000);
            for (List accountIdList : batchIdList) {
                this.idToAssistMap.putAll(AccountRepairCommonService.batchGetAssist(accountIdList));
            }
            this.getAssistInfo();
        }
    }

    protected void getAssistInfo() {
        if (!CollectionUtils.isEmpty(this.idToAssistMap)) {
            Set assistIds = this.idToAssistMap.values().stream().flatMap(x -> x.stream().map(y -> y.getId())).collect(Collectors.toSet());
            List batchAssistIdList = Lists.partition(new ArrayList(assistIds), (int)1000);
            for (List assistList : batchAssistIdList) {
                Map assistIdDynObjInfo = BusinessDataServiceHelper.loadFromCache((Object[])assistList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_asstacttype"));
                if (CollectionUtils.isEmpty((Map)assistIdDynObjInfo)) continue;
                this.assistIdDynObjMap.putAll(assistIdDynObjInfo);
            }
        }
    }

    private void buildAccInfo() {
        Map<Long, BiTreeNode<Long, OrgVO>> nodeIdMap = BiTreeNode.toMap(this.treeNode);
        for (Long needRrepairOrg : this.needRepairOrgIds) {
            List<String> rootAccLongNumbers = this.orgRootAccNumberMap.get(needRrepairOrg);
            BiTreeNode<Long, OrgVO> currOrgTreeNode = nodeIdMap.get(needRrepairOrg);
            if (null == currOrgTreeNode) {
                return;
            }
            Long parentId = currOrgTreeNode.getParentId();
            ArrayList<Long> childOrgIds = new ArrayList<Long>(currOrgTreeNode.collect(BiTreeNode::getId));
            if (0L != parentId) {
                childOrgIds.add(parentId);
            }
            for (String rootAccLongNumber : rootAccLongNumbers) {
                String[] numbers = rootAccLongNumber.split("_");
                String pAccNumber = numbers.length > 1 ? numbers[numbers.length - 2] : numbers[0];
                String pAccLongNumber = numbers.length > 1 ? rootAccLongNumber.substring(0, rootAccLongNumber.lastIndexOf("_")) : rootAccLongNumber;
                BiTreeNode<String, AccountVO> accountTreeNode = AccountRepairCommonService.buildSubTreeByAccountNumber(this.accountTableId, pAccNumber, pAccLongNumber, childOrgIds);
                boolean includeCurrAcc = true;
                if (accountTreeNode != null) {
                    Map<String, BiTreeNode<String, AccountVO>> accountTreeNodeMap = BiTreeNode.toMap(accountTreeNode);
                    String currNumber = numbers[numbers.length - 1];
                    includeCurrAcc = accountTreeNodeMap.containsKey(currNumber);
                }
                if (accountTreeNode == null || !includeCurrAcc) {
                    String errMessage = ResManager.loadKDString((String)"\u6240\u9009\u7ec4\u7ec7\u79d1\u76ee\u6570\u636e\u53d1\u751f\u53d8\u52a8\uff0c\u8bf7\u91cd\u65b0\u70b9\u51fb\u5168\u91cf\u68c0\u67e5\u3002", (String)"AccountRepairContext_1", (String)"fi-bd-common", (Object[])new Object[0]);
                    throw new KDBizException(errMessage);
                }
                this.orgToAccTreeTable.put((Object)needRrepairOrg, (Object)pAccNumber, accountTreeNode);
                Table<Long, String, AccountRepairVO> accountRepairVOTable = AccountCheckUtil.getAllSubLatestAccountInfoInUseOrgRange(this.accountTableId, childOrgIds, AccountVersionUtil.getEndDate(), pAccLongNumber);
                this.accountRepairInfoTable.putAll(accountRepairVOTable);
            }
        }
    }

    protected void initRepairParams(List<Object> selectRowIds) {
        String[] checkDetails = new String[]{AccountPropDetail.JOURNAL.getType(), AccountPropDetail.AC_NOTICE.getType(), AccountPropDetail.MANUAL.getType(), AccountPropDetail.CHANGE_CURRENCY.getType(), AccountPropDetail.ACC_RUAL_DIRECTION.getType(), AccountPropDetail.ALLOW_ADD.getType()};
        String field = "accountid,id,longnumber,useorg.id,accounttable.id";
        QFilter qFilter = new QFilter("id", "in", selectRowIds);
        QFilter qtyFilter = new QFilter("entryentity.detailcategory", "=", (Object)AccountPropDetail.QTY.getType());
        if (QueryServiceHelper.exists((String)"bd_account_checkresult", (QFilter[])new QFilter[]{qFilter, qtyFilter})) {
            this.isQtyControl = true;
        }
        if (this.repairType.equals(AccountPropCategory.PROP.getType())) {
            qFilter.and(new QFilter("entryentity.detailcategory", "in", (Object)checkDetails));
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"get_need_repair_data", (String)"bd_account_checkresult", (String)field, (QFilter[])qFilter.toArray(), (String)"longnumber", (int)-1);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String longNumber = row.getString("longnumber");
                String[] numbers = longNumber.split("_");
                Long useOrgId = row.getLong("useorg.id");
                String firstNumber = numbers[0];
                this.firstNnumberToOrgs.computeIfAbsent(firstNumber, x -> new HashSet(8)).add(useOrgId);
                List<String> currOrgRootNumbers = this.orgRootAccNumberMap.get(useOrgId);
                HashSet<String> rootLongNumbers = (HashSet<String>)this.orgFirstNumberToRootNumbers.get((Object)useOrgId, (Object)firstNumber);
                if (CollectionUtils.isEmpty((Collection)rootLongNumbers)) {
                    rootLongNumbers = new HashSet<String>(8);
                }
                if (!CollectionUtils.isEmpty((Collection)this.orgRootAccNumberMap.get(useOrgId))) {
                    if (this.isRootNumber(longNumber, currOrgRootNumbers) && longNumber.startsWith(firstNumber)) {
                        rootLongNumbers.add(longNumber);
                        this.orgFirstNumberToRootNumbers.put((Object)useOrgId, (Object)firstNumber, rootLongNumbers);
                    }
                } else {
                    this.orgRootAccNumberMap.computeIfAbsent(useOrgId, org -> new ArrayList(8)).add(longNumber);
                    if (longNumber.startsWith(firstNumber)) {
                        rootLongNumbers.add(longNumber);
                        this.orgFirstNumberToRootNumbers.put((Object)useOrgId, (Object)firstNumber, rootLongNumbers);
                    }
                }
                this.needRepairOrgIds.add(useOrgId);
                if (this.accountTableId != 0L) continue;
                this.accountTableId = row.getLong("accounttable.id");
            }
        }
    }

    protected void buildOrgTreeNode() {
        if (this.needRepairOrgIds.size() == 1) {
            Long needRepairOrgId = this.needRepairOrgIds.iterator().next();
            QFilter orgFilter = new QFilter("view", "=", (Object)10);
            orgFilter.and("org", "=", (Object)needRepairOrgId);
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org_structure", (String)"isfreeze,org.enable,parent", (QFilter[])orgFilter.toArray());
            if (dynamicObject != null) {
                long parentId = dynamicObject.getLong("parent.id");
                Long directSuperiorOrg = AccountCheckUtil.getDirectSuperiorOrg(parentId);
                this.treeNode = AccountCheckUtil.buildSubTreeByOrgId(10, Optional.of(directSuperiorOrg));
            } else {
                this.treeNode = AccountCheckUtil.buildSubTreeByOrgId(10, Optional.of(needRepairOrgId));
            }
        } else {
            this.treeNode = AccountCheckUtil.buildSubTreeByOrgId(10, Optional.empty());
        }
    }

    protected boolean isRootNumber(String longNumber, List<String> currOrgRootNumbers) {
        boolean isRootNumber = true;
        for (String currLongNumber : currOrgRootNumbers) {
            if (!longNumber.startsWith(currLongNumber)) continue;
            isRootNumber = false;
            break;
        }
        if (isRootNumber) {
            currOrgRootNumbers.add(longNumber);
        }
        return isRootNumber;
    }

    public Boolean getRealRepair() {
        return this.isRealRepair;
    }

    public String getRepairType() {
        return this.repairType;
    }

    public BiTreeNode<Long, OrgVO> getTreeNode() {
        return this.treeNode;
    }

    public void setTreeNode(BiTreeNode<Long, OrgVO> treeNode) {
        this.treeNode = treeNode;
    }

    public Set<Long> getNeedRepairOrgIds() {
        return this.needRepairOrgIds;
    }

    public Map<Long, List<String>> getOrgRootAccNumberMap() {
        return this.orgRootAccNumberMap;
    }

    public Long getAccountTableId() {
        return this.accountTableId;
    }

    public void setAccountTableId(Long accountTableId) {
        this.accountTableId = accountTableId;
    }

    public Table<Long, String, BiTreeNode<String, AccountVO>> getOrgToAccTreeTable() {
        return this.orgToAccTreeTable;
    }

    public Table<Long, String, AccountRepairVO> getAccountRepairInfoTable() {
        return this.accountRepairInfoTable;
    }

    public Map<String, Set<Long>> getFirstNnumberToOrgs() {
        return this.firstNnumberToOrgs;
    }

    public Table<Long, String, Set<String>> getOrgFirstNumberToRootNumbers() {
        return this.orgFirstNumberToRootNumbers;
    }

    public long getOperatorId() {
        return this.operatorId;
    }

    public Map<Long, Set<AssistEntryVO>> getIdToAssistMap() {
        return this.idToAssistMap;
    }

    public void setRealRepair(Boolean realRepair) {
        this.isRealRepair = realRepair;
    }

    public void setRepairType(String repairType) {
        this.repairType = repairType;
    }

    public Date getVersionDate() {
        return this.versionDate;
    }

    public void setVersionDate(Date versionDate) {
        this.versionDate = versionDate;
    }

    public Map<Object, DynamicObject> getAssistIdDynObjMap() {
        return this.assistIdDynObjMap;
    }

    public boolean isQtyControl() {
        return this.isQtyControl;
    }
}

