/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.accounthealth.executor;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bd.accounthealth.executor.IAccountBuild;
import kd.fi.bd.util.AccountVersionUtil;
import kd.fi.bd.util.DebugTrace;

public class BuildDataExecutor
implements IAccountBuild {
    private static final Log log = LogFactory.getLog(BuildDataExecutor.class);

    @Override
    public Map<String, DynamicObject> build(long accountTable, long orgId) {
        return this.query(accountTable, orgId);
    }

    protected Map<String, DynamicObject> query(long accountTable, long orgId) {
        SqlBuilder sql = new SqlBuilder();
        sql.append(" select a.fid ", new Object[0]).append("id", new Object[0]);
        sql.append("  from  t_bd_account_u u ", new Object[0]);
        sql.append(" inner join t_bd_account a ON u.fdataid=a.fid ", new Object[0]);
        sql.append(" where a.faccounttableid= ? ", new Object[]{accountTable});
        sql.append(" and a.fenddate= ? ", new Object[]{AccountVersionUtil.getEndDate()});
        sql.append(" and u.FUSEORGID =? ", new Object[]{orgId});
        HashSet<Long> ids = new HashSet<Long>(8);
        try (DataSet dataSet = DB.queryDataSet((String)"BuildDataExecutor", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sql);){
            for (Row row : dataSet) {
                ids.add(row.getLong("id"));
            }
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"bd_accountview");
        DynamicObject[] accounts = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)dataEntityType);
        HashMap<String, DynamicObject> accountsNumMap = new HashMap<String, DynamicObject>(8);
        if (accounts != null && accounts.length > 0) {
            for (DynamicObject account : accounts) {
                accountsNumMap.compute(account.getString("longnumber"), (K, V) -> {
                    V = account;
                    return V;
                });
            }
        }
        if (DebugTrace.enable()) {
            log.info("build data org:{},acctTable:{},accountsNumMap:{}", new Object[]{orgId, accountTable, accountsNumMap});
        }
        return accountsNumMap;
    }
}

