/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.accounthealth.executor;

import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.bd.accounthealth.CheckResult;
import kd.fi.bd.accounthealth.IAccountChecker;
import kd.fi.bd.accounthealth.OrgInternalChecker;
import kd.fi.bd.accounthealth.executor.AbstractAccountCheck;
import kd.fi.bd.accounthealth.util.AccountPropCheckUtil;

public class CheckOwnOrgExecutor
extends AbstractAccountCheck {
    private static final Log logger = LogFactory.getLog(CheckOwnOrgExecutor.class);
    private static final String OWN_ORG_ACCOUNT = "0";

    @Override
    public boolean check(IAccountChecker accountChecker) {
        try {
            OrgInternalChecker internalChecker = (OrgInternalChecker)accountChecker;
            Map<String, DynamicObject> longNumberAccountMap = internalChecker.getLongNumberAccountMaps();
            Date date = new Date();
            for (Map.Entry<String, DynamicObject> entry : longNumberAccountMap.entrySet()) {
                DynamicObject paccount;
                String longNumber = entry.getKey();
                DynamicObject account = entry.getValue();
                String parentLongNumber = this.getParentLongNumber(longNumber);
                if (StringUtils.isEmpty((String)parentLongNumber) || (paccount = longNumberAccountMap.get(parentLongNumber)) == null) continue;
                Map<String, Object> accountProp = AccountPropCheckUtil.getAccountProp(account);
                Map<String, Object> parentProp = AccountPropCheckUtil.getAccountProp(paccount);
                List<CheckResult> checkResultList = AccountPropCheckUtil.validateAccountControlRelation(paccount.getString("number"), OWN_ORG_ACCOUNT, null, accountProp, parentProp);
                if (!CollectionUtils.isNotEmpty(checkResultList)) continue;
                DynamicObject healthCheckObj = this.buildCheckLog(account, internalChecker.getOrgId(), date, checkResultList);
                this.pushLog(healthCheckObj);
            }
        }
        catch (Exception e) {
            logger.info("checkOwn exception:", (Object)e);
            throw new KDBizException((Throwable)e, new ErrorCode("common", "%s"), new Object[]{e.getMessage()});
        }
        finally {
            this.persistCheckLog();
        }
        return true;
    }

    protected String getParentLongNumber(String longNumber) {
        int index = longNumber.lastIndexOf("_");
        if (index == -1) {
            return longNumber;
        }
        return longNumber.substring(0, index);
    }
}

