/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.accounthealth.executor;

import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bd.accounthealth.CheckResult;
import kd.fi.bd.accounthealth.IAccountChecker;
import kd.fi.bd.accounthealth.OrgCrossChecker;
import kd.fi.bd.accounthealth.executor.AbstractAccountCheck;
import kd.fi.bd.accounthealth.util.AccountPropCheckUtil;
import kd.fi.bd.util.BDUtil;
import org.apache.commons.collections4.CollectionUtils;

public class CheckSupOrgExecutor
extends AbstractAccountCheck {
    private static final Log logger = LogFactory.getLog(CheckSupOrgExecutor.class);
    private static final String SUP_ORG_ACCOUNT = "1";

    @Override
    public boolean check(IAccountChecker accountChecker) {
        try {
            OrgCrossChecker crosslChecker = (OrgCrossChecker)accountChecker;
            Map<String, DynamicObject> parentAccounts = crosslChecker.getParentLongNumberAccountMaps();
            Map<String, DynamicObject> accounts = crosslChecker.getLongNumberAccountMaps();
            Date date = new Date();
            for (Map.Entry<String, DynamicObject> child : accounts.entrySet()) {
                String longNumber = child.getKey();
                DynamicObject account = child.getValue();
                DynamicObject paccount = parentAccounts.get(longNumber);
                if (paccount == null || account.getLong("id") == paccount.getLong("id")) continue;
                Map<String, Object> accountProp = AccountPropCheckUtil.getAccountProp(account);
                Map<String, Object> parentProp = AccountPropCheckUtil.getAccountProp(paccount);
                DynamicObject parentOrg = BDUtil.getOrgById(crosslChecker.getParentOrgId());
                List<CheckResult> checkResultList = AccountPropCheckUtil.validateAccountControlRelation(account.getString("number"), SUP_ORG_ACCOUNT, parentOrg, accountProp, parentProp);
                if (!CollectionUtils.isNotEmpty(checkResultList)) continue;
                DynamicObject healthCheckObj = this.buildCheckLog(account, crosslChecker.getOrgId(), date, checkResultList);
                this.pushLog(healthCheckObj);
            }
        }
        catch (Exception e) {
            logger.info("checkSupOrg exception:", (Object)e);
            throw new KDBizException((Throwable)e, new ErrorCode("common", "%s"), new Object[]{e.getMessage()});
        }
        finally {
            this.persistCheckLog();
        }
        return false;
    }
}

