/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.accounthealth.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.bd.accounthealth.AccountCheckService;
import kd.fi.bd.accounthealth.CheckContext;
import kd.fi.bd.accounthealth.OrgCrossChecker;
import kd.fi.bd.accounthealth.OrgInternalChecker;
import kd.fi.bd.accounthealth.executor.BuildDataExecutor;
import kd.fi.bd.accounthealth.executor.CheckOwnOrgExecutor;
import kd.fi.bd.accounthealth.executor.CheckSupOrgExecutor;
import kd.fi.bd.business.BDGLServiceFactory;
import kd.fi.bd.business.vo.AccountHealthLogVO;
import kd.fi.bd.interfaces.service.AccountHealthLogService;
import kd.fi.bd.util.ContextUtil;

public class AccountCheckServiceImpl
implements AccountCheckService {
    private static Log logger = LogFactory.getLog(AccountCheckServiceImpl.class);
    private CheckContext context;
    private AccountHealthLogService accountHealthLogService = BDGLServiceFactory.getService(AccountHealthLogService.class);
    private static final String TYPE_CHECK = "0";

    public AccountCheckServiceImpl(CheckContext context) {
        this.context = context;
    }

    @Override
    public void check() {
        try {
            this.deleteHistoryRes();
            this.doCheckOwn();
            this.checkSupOrg();
            List<AccountHealthLogVO> healthLogVOList = this.generateLogList();
            this.accountHealthLogService.saveLog(healthLogVOList);
        }
        catch (Exception e) {
            logger.error("check exception:" + e.getMessage(), (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u68c0\u67e5\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AccountCheckServiceImpl_0", (String)"fi-bd-common", (Object[])new Object[0]));
        }
    }

    protected void doCheckOwn() {
        Set<Long> allOrgIds = this.context.getOrgParentMap().keySet();
        CountDownLatch cdl = new CountDownLatch(allOrgIds.size());
        for (Long childId : allOrgIds) {
            ThreadService.execute(() -> {
                try {
                    OrgInternalChecker accountChecker = new OrgInternalChecker(this.context.getAccountTableId(), childId, new BuildDataExecutor(), new CheckOwnOrgExecutor());
                    accountChecker.check();
                }
                catch (Exception e) {
                    logger.error("doCheckOwn ,Exception:" + e.getMessage(), (Throwable)e);
                    throw new KDBizException((Throwable)e, new ErrorCode("common", "%s"), new Object[]{e.getMessage()});
                }
                finally {
                    cdl.countDown();
                }
            }, (TaskType)TaskType.FIBD_ACCOUNT_HEALTH_CHECK_TASK);
        }
        try {
            boolean await = cdl.await(7200L, TimeUnit.SECONDS);
            if (!await) {
                logger.error("AccountCheckServiceImpl_doCheckOwn_timeOut");
            }
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage());
            throw new KDBizException((Throwable)e, new ErrorCode("common", "%s"), new Object[]{e.getMessage()});
        }
    }

    protected void checkSupOrg() {
        try {
            for (Map.Entry<Long, Long> entrySet : this.context.getOrgParentMap().entrySet()) {
                ThreadService.execute(() -> {
                    try {
                        OrgCrossChecker crossChecker = new OrgCrossChecker(this.context.getAccountTableId(), (Long)entrySet.getKey(), (Long)entrySet.getValue(), new BuildDataExecutor(), new CheckSupOrgExecutor());
                        crossChecker.check();
                    }
                    catch (Exception e) {
                        logger.error("checkSupOrg ,Exception:" + e.getMessage(), (Throwable)e);
                        throw new KDBizException((Throwable)e, new ErrorCode("common", "%s"), new Object[]{e.getMessage()});
                    }
                }, (TaskType)TaskType.FIBD_ACCOUNT_HEALTH_CHECK_TASK);
            }
        }
        catch (Exception e) {
            logger.error("checkSupOrg ,Exception:" + e.getMessage(), (Throwable)e);
            throw new KDBizException("checkSupOrg:" + e.getMessage());
        }
    }

    protected void deleteHistoryRes() {
        QFilter qFilter = new QFilter("useorg", "in", this.context.getSelectOrgs());
        qFilter.and(new QFilter("accounttable", "=", (Object)this.context.getAccountTableId()));
        DeleteServiceHelper.delete((String)"bd_account_checkresult", (QFilter[])qFilter.toArray());
    }

    protected List<AccountHealthLogVO> generateLogList() {
        ArrayList<AccountHealthLogVO> logList = new ArrayList<AccountHealthLogVO>(8);
        long userId = ContextUtil.getUserId();
        String requestId = RequestContext.get().getRequestId();
        for (long orgId : this.context.getSelectOrgs()) {
            AccountHealthLogVO logVO = new AccountHealthLogVO();
            logVO.setOrgId(orgId);
            logVO.setAccountTableId(this.context.getAccountTableId());
            logVO.setCreateTime(new Date());
            logVO.setCreater(userId);
            logVO.setRequestId(requestId);
            logVO.setOpType(TYPE_CHECK);
            logVO.setExeResult(ResManager.loadKDString((String)"\u5b8c\u6210", (String)"AccountCheckServiceImpl_1", (String)"fi-bd-common", (Object[])new Object[0]));
            logList.add(logVO);
        }
        return logList;
    }

    public CheckContext getContext() {
        return this.context;
    }

    public void setContext(CheckContext context) {
        this.context = context;
    }
}

