/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.accounthealth.impl;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bd.accounthealth.IAccountRepairService;
import kd.fi.bd.accounthealth.accountrepair.consts.AccountRepairConsts;
import kd.fi.bd.accounthealth.accountrepair.repair.AccountRepairContext;
import kd.fi.bd.accounthealth.util.AccountCheckUtil;
import kd.fi.bd.accounthealth.util.AccountPropControlCheckUntil;
import kd.fi.bd.accounthealth.util.AccountVersionRepairUtil;
import kd.fi.bd.accounthealth.vo.AccPropInfo;
import kd.fi.bd.accounthealth.vo.AccountRepairResVO;
import kd.fi.bd.accounthealth.vo.AccountRepairVO;
import kd.fi.bd.consts.BDCommonResource;
import kd.fi.bd.enums.AccountPropDetail;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.BiTreeNode;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.vo.AccountVO;
import kd.fi.bd.vo.OrgVO;
import org.apache.commons.collections4.ListUtils;

public class AccountRepairServiceImpl
implements IAccountRepairService {
    private static final Log logger = LogFactory.getLog(AccountRepairServiceImpl.class);
    private AccountRepairContext context;
    private long needRepairOrgId;
    private Set<String> rootAccNumbers;
    private Map<Long, Tuple<Long, String>> repairedAccountForOrgMap = new HashMap<Long, Tuple<Long, String>>(8);
    private Table<Long, Long, Boolean> repairedAccPropToOrgTable = HashBasedTable.create();
    private Map<String, List<Long>> fieldToAccIdMap = new HashMap<String, List<Long>>(8);
    private List<AccountRepairResVO> downloadDetails = new ArrayList<AccountRepairResVO>(8);
    private String parentAcc_Direction = null;
    private Map<String, Set<Long>> directionToAccIdMap = new HashMap<String, Set<Long>>(8);
    private Map<Long, BiTreeNode<Long, OrgVO>> treeNodeMap = new HashMap<Long, BiTreeNode<Long, OrgVO>>(8);
    private Map<Long, String> accIdToNumbers = new HashMap<Long, String>(8);
    private List<DynamicObject> taskResults = new ArrayList<DynamicObject>(8);
    private Map<Long, Set<String>> persionalizeNumberForOrg = new HashMap<Long, Set<String>>(8);

    @Override
    public List<AccountRepairResVO> accountRepairForProp(AccountRepairContext ctx, long needRepairOrgId, Set<String> rootAccNumbers) {
        this.context = ctx;
        BiTreeNode<Long, OrgVO> orgTreeNode = ctx.getTreeNode();
        this.treeNodeMap = BiTreeNode.toMap(orgTreeNode);
        this.needRepairOrgId = needRepairOrgId;
        this.rootAccNumbers = rootAccNumbers;
        this.doRepairProp(this.treeNodeMap.get(needRepairOrgId));
        if (ctx.getRealRepair().booleanValue()) {
            this.doFixScript();
            this.saveRepairScript();
        }
        return this.downloadDetails;
    }

    private void saveRepairScript() {
        if (!CollectionUtils.isEmpty(this.taskResults)) {
            SaveServiceHelper.save((DynamicObject[])this.taskResults.toArray(new DynamicObject[0]));
        }
    }

    private void doRepairProp(BiTreeNode<Long, OrgVO> orgTreeNode) {
        Optional<String> repairRes = this.repairAccountOnOgrNode(orgTreeNode);
        if (repairRes.isPresent()) {
            return;
        }
        List<BiTreeNode<Long, OrgVO>> child = orgTreeNode.getChild();
        if (CollectionUtils.isEmpty(child)) {
            return;
        }
        for (BiTreeNode<Long, OrgVO> childNode : child) {
            this.doRepairProp(childNode);
        }
    }

    private void doFixScript() {
        for (Map.Entry<String, List<Long>> entry : this.fieldToAccIdMap.entrySet()) {
            String field = entry.getKey();
            List<Long> accIds = entry.getValue();
            List batchIds = ListUtils.partition(accIds, (int)200);
            for (List accounts : batchIds) {
                Set<String> repairNumbers;
                SqlBuilder sqlBuilder;
                String script;
                if (AccountRepairConsts.REPAIR_CHECK_PROPS.contains(field)) {
                    script = AccountRepairConsts.getTrueScript(field);
                    sqlBuilder = new SqlBuilder();
                    sqlBuilder.appendIn(script, accounts.toArray());
                    DB.execute((DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder);
                    repairNumbers = this.summaryScript(accounts);
                    this.buildRepairLog(field, accounts, script, repairNumbers);
                }
                if (!AccountRepairConsts.REPAIR_UNCHECK_PROPS.contains(field)) continue;
                script = AccountRepairConsts.getFalseScript(field);
                sqlBuilder = new SqlBuilder();
                sqlBuilder.appendIn(script, accounts.toArray());
                DB.execute((DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder);
                repairNumbers = this.summaryScript(accounts);
                this.buildRepairLog(field, accounts, script, repairNumbers);
            }
        }
        for (Map.Entry<String, Collection<Long>> entry : this.directionToAccIdMap.entrySet()) {
            String accRualDirection = entry.getKey();
            Set accountIds = (Set)entry.getValue();
            String script = AccountRepairConsts.getFollowSupScript(accRualDirection);
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.appendIn(script, accountIds.toArray());
            DB.execute((DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder);
            Set<String> repairNumbers = this.summaryScript(new ArrayList<Long>(accountIds));
            this.buildRepairLog("faccrualdirection", new ArrayList<Long>(accountIds), script, repairNumbers);
        }
        this.fieldToAccIdMap.clear();
        this.directionToAccIdMap.clear();
    }

    private void buildRepairLog(String field, List<Long> accounts, String script, Set<String> repairNumbers) {
        DynamicObject repairScript = BusinessDataServiceHelper.newDynamicObject((String)"bd_account_script");
        repairScript.set("org", (Object)this.needRepairOrgId);
        String repairNumber = String.join((CharSequence)",", repairNumbers);
        if (repairNumber.length() > 500) {
            repairNumber = repairNumber.substring(0, 500);
        }
        repairScript.set("acctnumber", (Object)repairNumber);
        repairScript.set("accprop", (Object)field);
        if (script.length() > 249) {
            script = script.substring(0, 249);
        }
        repairScript.set("script", (Object)script);
        repairScript.set("operator", (Object)this.context.getOperatorId());
        repairScript.set("createtime", (Object)new Date());
        DynamicObjectCollection newColl = repairScript.getDynamicObjectCollection("entryentity");
        int seq = 1;
        for (Long account : accounts) {
            DynamicObject newRow = new DynamicObject(newColl.getDynamicObjectType());
            newRow.set("accountid", (Object)account);
            newRow.set("seq", (Object)seq);
            newColl.add((Object)newRow);
            ++seq;
        }
        this.taskResults.add(repairScript);
    }

    private Set<String> summaryScript(List<Long> accounts) {
        return accounts.stream().filter(x -> Objects.nonNull(this.accIdToNumbers.get(x))).map(x -> this.accIdToNumbers.get(x)).collect(Collectors.toSet());
    }

    private Optional<String> repairAccountOnOgrNode(BiTreeNode<Long, OrgVO> org) {
        List<String> orgRootAccNumbers = this.context.getOrgRootAccNumberMap().get(this.needRepairOrgId);
        if (CollectionUtils.isEmpty(orgRootAccNumbers)) {
            return Optional.empty();
        }
        for (String rootAccNumber : this.rootAccNumbers) {
            Optional<Boolean> res;
            String currNumber;
            String pAccNumber;
            String[] numbers = rootAccNumber.split("_");
            String string = pAccNumber = numbers.length > 1 ? numbers[numbers.length - 2] : numbers[0];
            BiTreeNode parentAccTreeNode = (BiTreeNode)this.context.getOrgToAccTreeTable().get((Object)this.needRepairOrgId, (Object)pAccNumber);
            Map parentAccTreeNodeMap = BiTreeNode.toMap(parentAccTreeNode);
            BiTreeNode<String, AccountVO> accountVOBiTreeNode = parentAccTreeNodeMap.get(currNumber = numbers[numbers.length - 1]);
            if (!Objects.nonNull(accountVOBiTreeNode) || !(res = this.repairForCurrAccountNode(org, accountVOBiTreeNode)).isPresent()) continue;
            return Optional.of(res.get().toString());
        }
        return Optional.empty();
    }

    private Optional<Boolean> repairForCurrAccountNode(BiTreeNode<Long, OrgVO> org, BiTreeNode<String, AccountVO> acc) {
        this.parentAcc_Direction = null;
        boolean repairRes = this.repairAccountOnOgrNode(org, acc);
        if (!repairRes) {
            return Optional.of(repairRes);
        }
        List<BiTreeNode<String, AccountVO>> childAccs = acc.getChild();
        if (CollectionUtils.isEmpty(childAccs)) {
            return Optional.empty();
        }
        for (BiTreeNode<String, AccountVO> childAcc : childAccs) {
            this.repairForCurrAccountNode(org, childAcc);
        }
        return Optional.empty();
    }

    private Boolean repairAccountOnOgrNode(BiTreeNode<Long, OrgVO> org, BiTreeNode<String, AccountVO> acc) {
        String number = acc.getId();
        Long orgId = org.getId();
        String orgName = org.getData().getName();
        Map accountRepairVOMap = this.context.getAccountRepairInfoTable().row((Object)orgId);
        if (CollectionUtils.isEmpty((Map)accountRepairVOMap)) {
            return true;
        }
        AccountRepairVO currAccountRepairVO = (AccountRepairVO)accountRepairVOMap.get(number);
        if (Objects.isNull(currAccountRepairVO)) {
            return true;
        }
        Long lastVersionId = currAccountRepairVO.getLastVersionId();
        this.accIdToNumbers.put(lastVersionId, number);
        Long createOrgId = currAccountRepairVO.getCreateOrgId();
        Tuple<String, String> createOrgInfo = this.getCreateOrgName(createOrgId);
        String createOrgName = (String)createOrgInfo.item2;
        Long pOrgId = org.getParentId();
        boolean isSame = false;
        if (this.repairedAccountForOrgMap.containsKey(lastVersionId) && this.context.getRealRepair().booleanValue()) {
            HashSet<Long> orgs = new HashSet<Long>(8);
            orgs.add(orgId);
            orgs.add(pOrgId);
            Map<Long, AccountRepairVO> accRepairInfoForOrgMap = AccountVersionRepairUtil.queryCurrAccInfo(number, orgs, this.context.getAccountTableId());
            Set createOrgs = accRepairInfoForOrgMap.entrySet().stream().map(x -> ((AccountRepairVO)x.getValue()).getCreateOrgId()).collect(Collectors.toSet());
            isSame = createOrgs.size() == 1;
            AccountRepairVO accountRepairVO = accRepairInfoForOrgMap.get(orgId);
            lastVersionId = accountRepairVO.getLastVersionId();
            createOrgId = accountRepairVO.getCreateOrgId();
            accountRepairVOMap.put(number, accountRepairVO);
            AccountRepairVO pOrgAccountRepairVO = accRepairInfoForOrgMap.get(pOrgId);
            if (this.isPersionalize(number, pOrgId)) {
                this.context.getAccountRepairInfoTable().row((Object)orgId).put(number, accountRepairVO);
                this.context.getAccountRepairInfoTable().row((Object)pOrgId).put(number, pOrgAccountRepairVO);
            }
            createOrgInfo = this.getCreateOrgName(createOrgId);
            createOrgName = (String)createOrgInfo.item2;
        }
        if (this.alreadyRepaired(number, this.treeNodeMap.get(orgId), lastVersionId, createOrgInfo, isSame)) {
            Tuple<Long, String> repairedOrgInfo = this.repairedAccountForOrgMap.get(lastVersionId);
            String repairProps = (String)repairedOrgInfo.item2;
            HashSet<String> props = new HashSet<String>(Arrays.asList(repairProps.split(",")));
            Long repairedOrgId = (Long)repairedOrgInfo.item1;
            String accRualDirection = ((AccountRepairVO)this.context.getAccountRepairInfoTable().row((Object)repairedOrgId).get(number)).getAccPropInfo().getAccRualDirection();
            AccountVersionRepairUtil.reSetAccProp(props, ((AccountRepairVO)accountRepairVOMap.get(number)).getAccPropInfo(), accRualDirection);
            return true;
        }
        this.accIdToNumbers.put(lastVersionId, number);
        Map parentOrgAccRepairMap = this.context.getAccountRepairInfoTable().row((Object)org.getParentId());
        AccountRepairVO pOrgAccountRepairVO = (AccountRepairVO)parentOrgAccRepairMap.get(number);
        HashSet<String> reapirPropNames = new HashSet<String>(8);
        Set<String> needRepairProps = this.beforeCheckPropControl(accountRepairVOMap, acc, pOrgAccountRepairVO, reapirPropNames);
        if (CollectionUtils.isEmpty(needRepairProps)) {
            String desc = ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7(%s)\u5f53\u524d\u79d1\u76ee\u5c5e\u6027\u5df2\u7ecf\u6ee1\u8db3\u4e0a\u4e0b\u7ea7\u7ba1\u63a7\u3002", (String)"AccountRepairServiceImpl_1", (String)"fi-bd-common", (Object[])new Object[]{orgName});
            this.workOuterToRepairDetail(number, desc, BDCommonResource.getSuccessText(), String.valueOf(createOrgId), String.valueOf(orgId), null, lastVersionId);
            return true;
        }
        this.repairedAccountForOrgMap.put(lastVersionId, (Tuple<Long, String>)new Tuple((Object)orgId, (Object)String.join((CharSequence)",", needRepairProps)));
        if (!this.context.getRealRepair().booleanValue()) {
            String propNames = String.join((CharSequence)",", reapirPropNames);
            this.downloadDetails.add(new AccountRepairResVO("", "", createOrgName, orgName, "", number, propNames, null, lastVersionId));
            return true;
        }
        Optional<String> repairRes = this.repairData(org, lastVersionId, needRepairProps, createOrgId, number);
        this.repairedAccPropToOrgTable.put((Object)orgId, (Object)lastVersionId, (Object)(!repairRes.isPresent() ? 1 : 0));
        String result = repairRes.isPresent() ? BDCommonResource.getFailedText() : BDCommonResource.getSuccessText();
        String description = repairRes.isPresent() ? repairRes.get() : "";
        this.workOuterToRepairDetail(number, description, result, String.valueOf(createOrgId), String.valueOf(orgId), String.join((CharSequence)",", reapirPropNames), lastVersionId);
        if (repairRes.isPresent()) {
            return false;
        }
        return true;
    }

    private boolean isPersionalize(String number, long orgId) {
        Set<String> persionalizeNumbers = this.persionalizeNumberForOrg.get(orgId);
        return !CollectionUtils.isEmpty(persionalizeNumbers) && persionalizeNumbers.contains(number);
    }

    private Tuple<String, String> getCreateOrgName(Long createOrgId) {
        BiTreeNode<Long, OrgVO> createOrgNode = this.treeNodeMap.get(createOrgId);
        if (createOrgNode == null) {
            DynamicObject orgDy = BDUtil.getOrgById(createOrgId);
            String createOrgName = orgDy.getString("name");
            return Tuple.create((Object)String.valueOf(createOrgId), (Object)createOrgName);
        }
        String createOrgName = this.treeNodeMap.get(createOrgId).getData().getName();
        return Tuple.create((Object)String.valueOf(createOrgId), (Object)createOrgName);
    }

    private boolean alreadyRepaired(String number, BiTreeNode<Long, OrgVO> orgNode, Long lastVersionId, Tuple<String, String> createOrgInfo, boolean isSame) {
        if (this.repairedAccountForOrgMap.containsKey(lastVersionId) && isSame) {
            Tuple<Long, String> repairedOrgInfo = this.repairedAccountForOrgMap.get(lastVersionId);
            Long repairedOrgId = (Long)repairedOrgInfo.item1;
            String repairedOrgName = this.treeNodeMap.get(repairedOrgId).getData().getName();
            if (!this.context.getRealRepair().booleanValue()) {
                String props = (String)repairedOrgInfo.item2;
                Set<String> propNames = AccountCheckUtil.getPropNameByType(props);
                this.downloadDetails.add(new AccountRepairResVO("", "", (String)createOrgInfo.item2, orgNode.getData().getName(), "", number, String.join((CharSequence)",", propNames), null, lastVersionId));
            } else {
                Boolean repairRes = (Boolean)this.repairedAccPropToOrgTable.get((Object)repairedOrgId, (Object)lastVersionId);
                String result = Objects.nonNull(repairRes) && repairRes != false ? BDCommonResource.getSuccessText() : BDCommonResource.getFailedText();
                String messDesc = ResManager.loadKDString((String)"\u7531\u4e8e%1$s\u8be5\u79d1\u76ee%2$s\uff0c\u5f53\u524d\u79d1\u76ee\u7ec4\u7ec7\u4e5f\u4fee\u590d%3$s\u3002", (String)"AccountRepairServiceImpl_0", (String)"fi-bd-common", (Object[])new Object[]{repairedOrgName, result, result});
                String props = (String)repairedOrgInfo.item2;
                Set<String> propNames = AccountCheckUtil.getPropNameByType(props);
                this.workOuterToRepairDetail(number, messDesc, result, (String)createOrgInfo.item1, String.valueOf(orgNode.getId()), String.join((CharSequence)",", propNames), lastVersionId);
            }
            return true;
        }
        return false;
    }

    private void workOuterToRepairDetail(String accNumber, String desc, String repairRes, String createOrgName, String orgName, String props, long lastVersionId) {
        if (this.context.getRealRepair().booleanValue()) {
            this.downloadDetails.add(new AccountRepairResVO(repairRes, desc, createOrgName, orgName, "", accNumber, props, null, lastVersionId));
        }
    }

    private Optional<String> repairData(BiTreeNode<Long, OrgVO> treeNode, Long lastVersionId, Set<String> needRepairProps, Long createOrgId, String number) {
        Long orgId = treeNode.getId();
        if (DebugTrace.enable()) {
            logger.info("currNode#orgId:{}   ### createOrgId: {}, lastVersionId: {}", new Object[]{orgId, createOrgId, lastVersionId});
        }
        if (Objects.equals(orgId, createOrgId)) {
            if (needRepairProps.contains(AccountPropDetail.AC_NOTICE.getType()) && !AccountVersionRepairUtil.checkAcNotice(lastVersionId)) {
                String errMess = ResManager.loadKDString((String)"\u5f53\u524d\u79d1\u76ee\u4e3a\u53d1\u9001\u5f80\u6765\u901a\u77e5\u5355\u79d1\u76ee\uff0c\u6838\u7b97\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AccountRepairServiceImpl_3", (String)"fi-bd-common", (Object[])new Object[0]);
                return Optional.of(errMess);
            }
            Optional<String> personalizeResult = AccountVersionRepairUtil.autoPersonalizedAccountOnOuterOrg(lastVersionId);
            if (personalizeResult.isPresent()) {
                return personalizeResult;
            }
            for (String repairProp : needRepairProps) {
                String DBFiled = AccountCheckUtil.matchDBFiled(repairProp);
                this.fieldToAccIdMap.computeIfAbsent(DBFiled, x -> new ArrayList(8)).add(lastVersionId);
                if (!repairProp.equals(AccountPropDetail.ACC_RUAL_DIRECTION.getType()) || !StringUtils.isNotBlank((CharSequence)this.parentAcc_Direction)) continue;
                this.directionToAccIdMap.computeIfAbsent(this.parentAcc_Direction, x -> new HashSet(8)).add(lastVersionId);
            }
        } else {
            Optional<String> personResult = AccountVersionRepairUtil.autoPersonalizedAccountOnOuterOrg(needRepairProps, lastVersionId, orgId, treeNode.getData(), this.context.getRepairType(), this.parentAcc_Direction);
            if (personResult.isPresent()) {
                return personResult;
            }
            this.persionalizeNumberForOrg.computeIfAbsent(orgId, accNumber -> new HashSet(8)).add(number);
        }
        return Optional.empty();
    }

    private Set<String> beforeCheckPropControl(Map<String, AccountRepairVO> currAccountRepairVOMap, BiTreeNode<String, AccountVO> acc, AccountRepairVO pOrgAccountRepairVO, Set<String> repairPropNames) {
        String parentNumber;
        HashSet<String> repairProps = new HashSet<String>(8);
        String number = acc.getId();
        AccPropInfo accountPropInfo = currAccountRepairVOMap.get(number).getAccPropInfo();
        if (!Objects.isNull(pOrgAccountRepairVO)) {
            AccPropInfo pOrgAccPropInfo = pOrgAccountRepairVO.getAccPropInfo();
            repairProps.addAll(AccountPropControlCheckUntil.repairPropControlCheck(accountPropInfo, pOrgAccPropInfo, repairPropNames));
            String pOrgAccRualDirection = pOrgAccPropInfo.getAccRualDirection();
            if (!"nocontrol".equals(pOrgAccRualDirection) && repairProps.contains(AccountPropDetail.ACC_RUAL_DIRECTION.getType())) {
                this.parentAcc_Direction = pOrgAccRualDirection;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(parentNumber = acc.getParentId()))) {
            AccountRepairVO currOrgPAccInfo = currAccountRepairVOMap.get(parentNumber);
            AccPropInfo pAccPropInfo = currOrgPAccInfo.getAccPropInfo();
            repairProps.addAll(AccountPropControlCheckUntil.repairPropControlCheck(accountPropInfo, pAccPropInfo, repairPropNames));
        }
        if (!CollectionUtils.isEmpty(repairProps)) {
            AccountVersionRepairUtil.reSetAccProp(repairProps, accountPropInfo, this.parentAcc_Direction);
        }
        return repairProps;
    }

    @Override
    public List<AccountRepairResVO> accountRepairForAssist(AccountRepairContext ctx, long needRepairOrgId, Set<String> rootAccNumbers) {
        return null;
    }
}

