/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.accounthealth.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.accounthealth.vo.AccPropInfo;
import kd.fi.bd.accounthealth.vo.AccountRepairVO;
import kd.fi.bd.enums.AccountPropDetail;
import kd.fi.bd.util.AccountVersionUtil;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.BiTreeNode;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.vo.OrgVO;

public class AccountCheckUtil {
    private static final Log LOGGER = LogFactory.getLog(AccountCheckUtil.class);

    public static Table<Long, String, AccountRepairVO> getAllSubLatestAccountInfoInUseOrgRange(Long accountTableId, List<Long> unmodifiedUseOrgIds, Date versionDate, String longNumber) {
        HashBasedTable accountRepairInfoTable = HashBasedTable.create();
        if (unmodifiedUseOrgIds == null || unmodifiedUseOrgIds.isEmpty()) {
            return accountRepairInfoTable;
        }
        HashSet<Long> useOrgIdList = new HashSet<Long>(unmodifiedUseOrgIds);
        if (Objects.isNull(versionDate)) {
            versionDate = AccountVersionUtil.getStartDate();
        }
        String globalShareStrategy = "5";
        String selectFileds = "a.fid,a.fnumber,a.fctrlstrategy,u.fuseorgid,a.fcreateorgid,a.fenddate,a.fisjournal,a.fischangecurrency,a.facnotice,a.faccrualdirection,a.fisallowca,a.fismanual, a.fisqty,a.fisassist,a.faccheck";
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select ", new Object[0]).append(selectFileds, new Object[0]).append(" FROM t_bd_account AS a ", new Object[0]);
        sqlBuilder.append("LEFT JOIN t_bd_account_u AS u ON u.fdataid = a.fid ", new Object[0]);
        sqlBuilder.appendIn("where u.fuseorgid ", useOrgIdList.toArray());
        sqlBuilder.append(" and a.faccounttableid = ? ", new Object[]{accountTableId});
        sqlBuilder.append(" AND a.fenddate = ? ", new Object[]{versionDate});
        sqlBuilder.append(" AND a.flongnumber LIKE ? ", new Object[]{longNumber + "%"});
        try (DataSet accountDataSet = DB.queryDataSet((String)(BDUtil.class.getName() + "#getAllSubLatestAccountInfoInUseOrgRange"), (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder);){
            for (Row row : accountDataSet) {
                String ctrlStrategy = row.getString("fctrlstrategy");
                String number = row.getString("fnumber");
                if (globalShareStrategy.equals(ctrlStrategy)) {
                    Iterator iterator = useOrgIdList.iterator();
                    while (iterator.hasNext()) {
                        long useOrgId = (Long)iterator.next();
                        AccountCheckUtil.getRepairAccountInfo((Table<Long, String, AccountRepairVO>)accountRepairInfoTable, row, number, useOrgId);
                    }
                    continue;
                }
                Long useOrgId = row.getLong("fuseorgid");
                if (useOrgId == null || useOrgId == 0L) continue;
                AccountCheckUtil.getRepairAccountInfo((Table<Long, String, AccountRepairVO>)accountRepairInfoTable, row, number, useOrgId);
            }
        }
        return accountRepairInfoTable;
    }

    protected static void getRepairAccountInfo(Table<Long, String, AccountRepairVO> accountRepairInfoTable, Row row, String number, Long useOrgId) {
        AccountRepairVO accountRepairVO = (AccountRepairVO)accountRepairInfoTable.get((Object)useOrgId, (Object)number);
        if (Objects.isNull(accountRepairVO)) {
            accountRepairVO = new AccountRepairVO(useOrgId, number);
        }
        String accountNumber = row.getString("fnumber");
        Long accountId = row.getLong("fid");
        Long createOrgId = row.getLong("fcreateorgid");
        Boolean journal = row.getBoolean("fisjournal");
        Boolean changeCurrency = row.getBoolean("fischangecurrency");
        Boolean acNotice = row.getBoolean("facnotice");
        String accRualDirection = row.getString("faccrualdirection");
        Boolean allowca = row.getBoolean("fisallowca");
        Boolean manual = row.getBoolean("fismanual");
        Boolean isQty = row.getBoolean("fisqty");
        accountRepairVO.setCreateOrgId(createOrgId);
        accountRepairVO.setLastVersionId(accountId);
        accountRepairVO.setNumber(accountNumber);
        AccPropInfo accPropInfo = accountRepairVO.getAccPropInfo();
        if (Objects.isNull(accPropInfo)) {
            accPropInfo = new AccPropInfo(journal, changeCurrency, acNotice, accRualDirection, allowca, manual, (Tuple<Boolean, Boolean>)Tuple.create((Object)isQty, (Object)false));
            accountRepairVO.setAccPropInfo(accPropInfo);
        }
        accountRepairInfoTable.put((Object)useOrgId, (Object)number, (Object)accountRepairVO);
    }

    public static BiTreeNode<Long, OrgVO> buildSubTreeByOrgId(int orgViewId, Optional<Long> rootOrgId) {
        String cacheKey = String.format("BDUtil.buildSubTreeByOrgId_viewId:%s_rootOrgId:%s", orgViewId, rootOrgId.isPresent() ? rootOrgId.get() : "");
        return (BiTreeNode)ThreadCache.get((Object)cacheKey, () -> {
            HashMap<Long, BiTreeNode<Long, OrgVO>> orgIndex = new HashMap<Long, BiTreeNode<Long, OrgVO>>(8);
            HashMap<Long, Long> childToParentIdMap = new HashMap<Long, Long>(8);
            BiTreeNode<Long, OrgVO> _rootNode = null;
            long tick = System.currentTimeMillis();
            if (DebugTrace.enable()) {
                LOGGER.info("BDUtil.buildSubTreeByOrgId param: orgViewId:{}, rootOrgId:{}", (Object)orgViewId, rootOrgId.isPresent() ? rootOrgId.get() : "");
            }
            try (DataSet orgDataSet = QueryServiceHelper.queryDataSet((String)"BDUtil.buildSubTreeByOrgId", (String)"bos_org_structure", (String)"org,parent,level,org.name name,org.enable,isfreeze", (QFilter[])new QFilter[]{new QFilter("view.treetype", "=", (Object)"10"), new QFilter("view", "=", (Object)orgViewId)}, (String)"level asc");){
                for (Row row : orgDataSet) {
                    Long orgId = row.getLong("org");
                    Long parentId = row.getLong("parent");
                    Integer level = row.getInteger("level");
                    childToParentIdMap.put(orgId, parentId);
                    if (Objects.nonNull(orgIndex.get(orgId))) continue;
                    Boolean isFreeze = row.getBoolean("isfreeze");
                    Boolean enable = row.getBoolean("org.enable");
                    if (isFreeze.booleanValue() || null == enable || !enable.booleanValue()) continue;
                    if (Objects.isNull(_rootNode)) {
                        if (rootOrgId.isPresent() && !Objects.equals(orgId, rootOrgId.get())) continue;
                        _rootNode = new BiTreeNode<Long, OrgVO>(orgId, new OrgVO(row.getString("name"), level));
                        orgIndex.put(orgId, _rootNode);
                        continue;
                    }
                    if (!Objects.nonNull(parentId = AccountCheckUtil.getRealParentOrg(orgIndex, childToParentIdMap, parentId)) || !orgIndex.containsKey(parentId)) continue;
                    BiTreeNode parentNode = (BiTreeNode)orgIndex.get(parentId);
                    Preconditions.checkState((boolean)Objects.nonNull(parentNode));
                    BiTreeNode<Long, OrgVO> orgNode = new BiTreeNode<Long, OrgVO>(orgId, new OrgVO(row.getString("name"), level));
                    orgIndex.put(orgId, orgNode);
                    orgNode.setParent(parentNode);
                }
            }
            if (DebugTrace.enable()) {
                LOGGER.info("BDUtil.buildSubTreeByOrgId result tree: {}", (Object)_rootNode.showFormatTree("\n", x -> x.getData().toString()));
            }
            LOGGER.info("kd.fi.bd.util.BDUtil.buildSubTreeByOrgId cost " + (System.currentTimeMillis() - tick));
            return _rootNode;
        }, (boolean)true);
    }

    protected static Long getRealParentOrg(Map<Long, BiTreeNode<Long, OrgVO>> orgIndex, Map<Long, Long> childToParentIdMap, Long parentId) {
        Long parent = 0L;
        if (Objects.isNull(parentId)) {
            return parent;
        }
        if (!orgIndex.containsKey(parentId) && parentId != 0L) {
            Long groundPOrgId = childToParentIdMap.get(parentId);
            parent = AccountCheckUtil.getRealParentOrg(orgIndex, childToParentIdMap, groundPOrgId);
        } else {
            parent = parentId;
        }
        return parent;
    }

    public static Set<Long> listAllChildOrgs(long rootOrgId, boolean isIncludeSelf) {
        HashSet<Long> childOrgIds = new HashSet<Long>(8);
        BiTreeNode<Long, OrgVO> treeNode = AccountCheckUtil.buildSubTreeByOrgId(10, Optional.of(rootOrgId));
        if (Objects.isNull(treeNode)) {
            LOGGER.info("The current organization isn't A accounting organization. orgId: {}", (Object)rootOrgId);
            return childOrgIds;
        }
        childOrgIds = new HashSet<Long>(treeNode.collect(BiTreeNode::getId));
        if (!isIncludeSelf) {
            childOrgIds.remove(rootOrgId);
        }
        return childOrgIds;
    }

    public static String matchDBFiled(String propDetil) {
        String filed = "";
        switch (propDetil) {
            case "09": {
                filed = "fisjournal";
                break;
            }
            case "10": {
                filed = "fischangecurrency";
                break;
            }
            case "11": {
                filed = "facnotice";
                break;
            }
            case "12": {
                filed = "faccrualdirection";
                break;
            }
            case "14": {
                filed = "fisallowca";
                break;
            }
            case "15": {
                filed = "fismanual";
                break;
            }
        }
        return filed;
    }

    public static Long getDirectSuperiorOrg(long org) {
        QFilter filter = new QFilter("org", "=", (Object)org);
        filter.and(new QFilter("view", "=", (Object)Long.parseLong("10")));
        DynamicObject orgObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org_structure", (String)"isfreeze,org.enable,parent", (QFilter[])filter.toArray());
        if (ObjectUtils.isEmpty((Object)orgObj)) {
            return org;
        }
        boolean enable = orgObj.getBoolean("org.enable");
        boolean isFreeze = orgObj.getBoolean("isfreeze");
        long parentId = orgObj.getDynamicObject("parent") == null ? 0L : orgObj.getDynamicObject("parent").getLong("id");
        if (enable && !isFreeze) {
            return org;
        }
        long resId = AccountCheckUtil.getDirectSuperiorOrg(parentId);
        return resId;
    }

    public static DataSet queryAccountDataSet(String number, Set<Long> orgs, long accountTableId, String selectFields) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select ", new Object[0]).append(selectFields, new Object[0]);
        sqlBuilder.append(" from t_bd_account a inner join t_bd_Account_u u on a.fid = u.fdataid ", new Object[0]);
        sqlBuilder.append(" where a.faccounttableid = ? ", new Object[]{accountTableId});
        sqlBuilder.appendIn(" and u.fuseorgid ", orgs.toArray());
        sqlBuilder.append(" and a.fenddate = ? ", new Object[]{AccountVersionUtil.getEndDate()});
        sqlBuilder.append(" and a.fnumber = ? ", new Object[]{number});
        return DB.queryDataSet((String)"queryAccountDataSet", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder);
    }

    public static Set<String> getPropNameByType(String props) {
        String[] propTypes;
        HashSet<String> propNames = new HashSet<String>(2);
        if (StringUtils.isBlank((CharSequence)props)) {
            return propNames;
        }
        for (String prop : propTypes = props.split(",")) {
            propNames.add(AccountCheckUtil.matchPropNameByType(prop));
        }
        return propNames;
    }

    private static String matchPropNameByType(String prop) {
        String propName = "";
        switch (prop) {
            case "09": {
                propName = AccountPropDetail.JOURNAL.getName();
                break;
            }
            case "10": {
                propName = AccountPropDetail.CHANGE_CURRENCY.getName();
                break;
            }
            case "11": {
                propName = AccountPropDetail.AC_NOTICE.getName();
                break;
            }
            case "12": {
                propName = AccountPropDetail.ACC_RUAL_DIRECTION.getName();
                break;
            }
            case "14": {
                propName = AccountPropDetail.ALLOW_ADD.getName();
                break;
            }
            case "15": {
                propName = AccountPropDetail.MANUAL.getName();
                break;
            }
        }
        return propName;
    }
}

