/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.accounthealth.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.util.DateUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.bd.accounthealth.util.AccountCheckUtil;
import kd.fi.bd.accounthealth.vo.AccPropInfo;
import kd.fi.bd.accounthealth.vo.AccountRepairVO;
import kd.fi.bd.consts.AccountOperationType;
import kd.fi.bd.consts.OperationLogEntry;
import kd.fi.bd.enums.AccountPropCategory;
import kd.fi.bd.util.AccountOperationLogUtil;
import kd.fi.bd.util.AccountVersionOpVars;
import kd.fi.bd.util.AccountVersionPersonalizeUtil;
import kd.fi.bd.util.AccountVersionUtil;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.BiTreeNode;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.vo.OrgVO;
import org.apache.commons.lang3.StringUtils;

public class AccountVersionRepairUtil {
    private static Log LOG = LogFactory.getLog(AccountVersionPersonalizeUtil.class);

    public static Optional<String> autoPersonalizedAccountOnOuterOrg(long accId) {
        BiTreeNode<Long, OrgVO> fullOrgTree = AccountCheckUtil.buildSubTreeByOrgId(10, Optional.empty());
        Map<Long, BiTreeNode<Long, OrgVO>> nodeIdMap = BiTreeNode.toMap(fullOrgTree);
        return AccountVersionRepairUtil.autoPersonalizedAccountOnOuterOrg(accId, nodeIdMap);
    }

    public static Optional<String> autoPersonalizedAccountOnOuterOrg(Set<String> needRepairProps, long accId, Long orgId, OrgVO orgVO, String repairType, String parentAcc_Direction) {
        DynamicObject dynamicObject = AccountVersionRepairUtil.buildPersonalizedAccount(accId, orgId, needRepairProps, repairType, parentAcc_Direction);
        OperateOption personalizeOp = OperateOption.create();
        personalizeOp.setVariableValue("isPersonalizeData", "1");
        AccountVersionOpVars.setAutoAssignChildAfterVersioned(personalizeOp, true);
        AccountVersionOpVars.setIsFromRepairOrAssignView(personalizeOp, true);
        OperationResult personalizeResult = OperationServiceHelper.executeOperate((String)"save", (String)"bd_accountview", (DynamicObject[])new DynamicObject[]{dynamicObject}, (OperateOption)personalizeOp);
        if (!personalizeResult.isSuccess()) {
            String failedMsg = BDUtil.buildOperationResultFailedMsg(personalizeResult, false);
            return Optional.of(failedMsg);
        }
        return Optional.empty();
    }

    public static Optional<String> autoPersonalizedAccountOnOuterOrg(long accId, Map<Long, BiTreeNode<Long, OrgVO>> nodeIdMap) {
        List<DynamicObject> personalizedAccs = AccountVersionRepairUtil.checkAndBuildPersonalizedAccounts(accId, nodeIdMap);
        if (!personalizedAccs.isEmpty()) {
            return AccountVersionRepairUtil.callPersonizedOperation(personalizedAccs, nodeIdMap);
        }
        return Optional.empty();
    }

    public static Optional<String> autoPersonalizedAccountOnOuterOrg(Set<Long> accIds) {
        BiTreeNode<Long, OrgVO> fullOrgTree = AccountCheckUtil.buildSubTreeByOrgId(10, Optional.empty());
        Map<Long, BiTreeNode<Long, OrgVO>> nodeIdMap = BiTreeNode.toMap(fullOrgTree);
        ArrayList<DynamicObject> personalizedAccs = new ArrayList<DynamicObject>(8);
        for (Long accId : accIds) {
            List<DynamicObject> partAccs = AccountVersionRepairUtil.checkAndBuildPersonalizedAccounts(accId, nodeIdMap);
            personalizedAccs.addAll(partAccs);
        }
        if (!personalizedAccs.isEmpty()) {
            return AccountVersionRepairUtil.callPersonizedOperation(personalizedAccs, nodeIdMap);
        }
        return Optional.empty();
    }

    public static List<DynamicObject> checkAndBuildPersonalizedAccounts(long accId, Map<Long, BiTreeNode<Long, OrgVO>> nodeIdMap) {
        DynamicObject account = QueryServiceHelper.queryOne((String)"bd_accountview", (String)String.join((CharSequence)",", "number", "enddate", "createorg_id"), (QFilter[])new QFilter("id", "=", (Object)accId).toArray());
        if (account == null) {
            LOG.info("account not exists id:" + accId);
            return Collections.emptyList();
        }
        if (AccountVersionUtil.getEndDate().compareTo(account.getDate("enddate")) != 0) {
            LOG.info("account is not latest version: " + account.getDate("enddate") + ", give up auto personalized.");
            return Collections.EMPTY_LIST;
        }
        long createOrgId = account.getLong("createorg_id");
        String accNumber = account.getString("number");
        List<Long> workOuterOrgs = AccountVersionRepairUtil.computeNeedPersonalizedOrgs(accId, accNumber, createOrgId, nodeIdMap);
        if (DebugTrace.enable()) {
            LOG.info(String.format("personalize_outer real account: %s(%s) - Orgs: %s", accId, accNumber, String.join((CharSequence)",", workOuterOrgs.stream().map(x -> String.valueOf(x)).collect(Collectors.toList()))));
        }
        if (!CollectionUtils.isEmpty(workOuterOrgs)) {
            return workOuterOrgs.stream().map(orgId -> AccountVersionRepairUtil.buildPersonalizedAccount(accId, orgId, new HashSet<String>(8), null, null)).collect(Collectors.toList());
        }
        return Collections.EMPTY_LIST;
    }

    private static DynamicObject buildPersonalizedAccount(long accountId, long useOrgId, Set<String> needRepairProps, String repairType, String parentAcc_Direction) {
        DynamicObject useOrg;
        DynamicObject accountFromDb = BusinessDataServiceHelper.loadSingle((Object)accountId, (String)"bd_accountview");
        if (DebugTrace.enable()) {
            LOG.info(String.format("check_account_version start: startDate: %s, endDate: %s, full data: %s", DateUtils.formatString((Date)accountFromDb.getDate("startdate"), (String)"yyyy-MM-dd HH:mm:ss"), DateUtils.formatString((Date)accountFromDb.getDate("enddate"), (String)"yyyy-MM-dd HH:mm:ss"), accountFromDb.toString()));
        }
        if (null == (useOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)useOrgId, (String)"bos_org", (String)"id,number,name"))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\uff08ID=%s\uff09\u5df2\u7ecf\u4e0d\u5b58\u5728\uff0c\u8981\u5148\u6e05\u9664\u810f\u6570\u636e\u624d\u80fd\u7ee7\u7eed\u64cd\u4f5c\u3002", (String)"AccountVersionPersonalizeUtil_2", (String)"fi-bd-common", (Object[])new Object[0]), useOrgId));
        }
        accountFromDb.set("useorg", (Object)useOrg);
        accountFromDb.set("useorg_id", (Object)useOrg.getLong("id"));
        if (StringUtils.isNotBlank((CharSequence)repairType) && AccountPropCategory.PROP.getType().equals(repairType)) {
            AccountVersionRepairUtil.propReair(accountFromDb, needRepairProps, parentAcc_Direction);
        }
        return accountFromDb;
    }

    private static List<Long> computeNeedPersonalizedOrgs(long accId, String accNumber, long createOrgId, Map<Long, BiTreeNode<Long, OrgVO>> nodeIdMap) {
        Set<Long> assignRawOrgIds = AccountVersionUtil.queryAssignedRawOrgIds(accId);
        assignRawOrgIds.add(createOrgId);
        Set<Long> accountingOrgs = BDUtil.getValidAccountingOrgs();
        assignRawOrgIds.retainAll(accountingOrgs);
        if (CollectionUtils.isEmpty(assignRawOrgIds) || !assignRawOrgIds.contains(createOrgId)) {
            return Collections.EMPTY_LIST;
        }
        assignRawOrgIds.remove(createOrgId);
        HashSet<Long> childOrgIds = new HashSet<Long>(nodeIdMap.get(createOrgId).collect(BiTreeNode::getId));
        assignRawOrgIds.removeAll(childOrgIds);
        Set<Long> outerOrgs = assignRawOrgIds;
        if (DebugTrace.enable()) {
            LOG.info(String.format("personalize_outer init account: %s(%s) - Orgs: %s", accId, accNumber, String.join((CharSequence)",", outerOrgs.stream().map(x -> String.valueOf(x)).collect(Collectors.toList()))));
        }
        if (!outerOrgs.isEmpty()) {
            List<Long> workOuterOrgs = outerOrgs.stream().filter(outerOrgId -> {
                BiTreeNode outerOrgNode = (BiTreeNode)nodeIdMap.get(outerOrgId);
                if (null == outerOrgNode) {
                    return true;
                }
                List<Long> supervisorOrgIds = outerOrgNode.collectOnAncestors(BiTreeNode::getId);
                supervisorOrgIds.retainAll(outerOrgs);
                return supervisorOrgIds.isEmpty();
            }).collect(Collectors.toList());
            return workOuterOrgs;
        }
        return Collections.EMPTY_LIST;
    }

    private static Optional<String> callPersonizedOperation(List<DynamicObject> personalizedAccs, Map<Long, BiTreeNode<Long, OrgVO>> nodeIdMap) {
        long tick = System.currentTimeMillis();
        OperateOption personalizeOp = OperateOption.create();
        personalizeOp.setVariableValue("isPersonalizeData", "1");
        AccountVersionOpVars.setAutoAssignChildAfterVersioned(personalizeOp, true);
        AccountVersionOpVars.setIsFromRepairOrAssignView(personalizeOp, true);
        for (DynamicObject acc : personalizedAccs) {
            long opTick = System.currentTimeMillis();
            OperationResult personalizeResult = OperationServiceHelper.executeOperate((String)"save", (String)"bd_accountview", (DynamicObject[])new DynamicObject[]{acc}, (OperateOption)personalizeOp);
            String orgName = "";
            if (null != nodeIdMap.get(acc.getLong("useorg_id"))) {
                orgName = nodeIdMap.get(acc.getLong("useorg_id")).getData().getName();
            }
            String accNum = acc.getString("number");
            LOG.info(String.format("personalize_outer account done on account: %s on org: %s, cost %s", accNum, orgName, System.currentTimeMillis() - opTick));
            OperationLogEntry entry = new OperationLogEntry(acc.getLong("useorg_id"), acc.getLong("id"), AccountOperationType.PERSONAL, Boolean.TRUE);
            AccountOperationLogUtil.addLogEntryRow(entry);
            if (personalizeResult.isSuccess()) continue;
            String failedMsg = BDUtil.buildOperationResultFailedMsg(personalizeResult, false);
            LOG.info(String.format("batch_personalized_account failed on account: %s on org: %s for %s", accNum, orgName, failedMsg));
            String errMsg = String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5bf9\u7ba1\u63a7\u8303\u56f4\u5916\u7ec4\u7ec7%1$s\u7684\u79d1\u76ee%2$s\u4e2a\u6027\u5316\u5904\u7406\u65f6\u5931\u8d25: \"%3$s\"\uff0c\u8bf7\u624b\u52a8\u4e2a\u6027\u5316\u7ec4\u7ec7\uff1a%4$s\uff0c\u79d1\u76ee\uff1a%5$s\u540e\u518d\u91cd\u65b0\u6267\u884c\u672c\u6b21\u7684\u7248\u672c\u5316\u3002", (String)"AccountVersionPersonalizeUtil_1", (String)"fi-bd-common", (Object[])new Object[0]), orgName, accNum, failedMsg, orgName, accNum);
            entry.setSuccess(Boolean.FALSE);
            entry.setLog(errMsg);
            return Optional.of(errMsg);
        }
        LOG.info(String.format("auto_personalized account size: %s cost: %s", personalizedAccs.size(), System.currentTimeMillis() - tick));
        return Optional.empty();
    }

    protected static void propReair(DynamicObject account, Set<String> repairProps, String parentAcc_Direction) {
        Iterator<String> iterator = repairProps.iterator();
        while (iterator.hasNext()) {
            String repairProp;
            switch (repairProp = iterator.next()) {
                case "09": {
                    account.set("isjournal", (Object)true);
                    break;
                }
                case "10": {
                    account.set("ischangecurrency", (Object)true);
                    break;
                }
                case "11": {
                    account.set("acnotice", (Object)true);
                    break;
                }
                case "12": {
                    if (!StringUtils.isNotBlank((CharSequence)parentAcc_Direction)) break;
                    account.set("accrualdirection", (Object)parentAcc_Direction);
                    break;
                }
                case "14": {
                    account.set("isallowca", (Object)false);
                    break;
                }
                case "15": {
                    account.set("ismanual", (Object)false);
                }
            }
        }
    }

    public static void reSetAccProp(Set<String> needRepairProps, AccPropInfo accPropInfo, String parentAcc_Direction) {
        Iterator<String> iterator = needRepairProps.iterator();
        while (iterator.hasNext()) {
            String repairProp;
            switch (repairProp = iterator.next()) {
                case "09": {
                    accPropInfo.setJournal(true);
                    break;
                }
                case "10": {
                    accPropInfo.setChangeCurrency(true);
                    break;
                }
                case "11": {
                    accPropInfo.setAcNotice(true);
                    break;
                }
                case "12": {
                    if (!StringUtils.isNotBlank((CharSequence)parentAcc_Direction)) break;
                    accPropInfo.setAccRualDirection(parentAcc_Direction);
                    break;
                }
                case "14": {
                    accPropInfo.setAllowca(false);
                    break;
                }
                case "15": {
                    accPropInfo.setManual(false);
                }
            }
        }
    }

    public static boolean checkAcNotice(long accId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select top 1 fid from t_bd_accountasstactitem where fid = ? ", new Object[]{accId});
        try (DataSet dataSet = DB.queryDataSet((String)"AccountVersionRepairUtil#checkAcNotice", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder);){
            boolean bl = dataSet.hasNext();
            return bl;
        }
    }

    public static Map<Long, AccountRepairVO> queryCurrAccInfo(String number, Set<Long> orgs, long accTableId) {
        String selectFields = "a.fid,a.fnumber,a.fctrlstrategy,u.fuseorgid,a.fcreateorgid,a.fenddate,a.fisjournal,a.fischangecurrency,a.facnotice,a.faccrualdirection,a.fisallowca,a.fismanual, a.fisqty";
        HashMap<Long, AccountRepairVO> accRepairInfoForOrgMap = new HashMap<Long, AccountRepairVO>(8);
        try (DataSet dataSet = AccountCheckUtil.queryAccountDataSet(number, orgs, accTableId, selectFields);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long useOrgId = row.getLong("fuseorgid");
                AccountRepairVO accountRepairVO = new AccountRepairVO(useOrgId, number);
                String accountNumber = row.getString("fnumber");
                Long accountId = row.getLong("fid");
                Long createOrgId = row.getLong("fcreateorgid");
                Boolean journal = row.getBoolean("fisjournal");
                Boolean changeCurrency = row.getBoolean("fischangecurrency");
                Boolean acNotice = row.getBoolean("facnotice");
                String accRualDirection = row.getString("faccrualdirection");
                Boolean allowca = row.getBoolean("fisallowca");
                Boolean manual = row.getBoolean("fismanual");
                Boolean isQty = row.getBoolean("fisqty");
                accountRepairVO.setCreateOrgId(createOrgId);
                accountRepairVO.setLastVersionId(accountId);
                accountRepairVO.setNumber(accountNumber);
                AccPropInfo accPropInfo = new AccPropInfo(journal, changeCurrency, acNotice, accRualDirection, allowca, manual, (Tuple<Boolean, Boolean>)Tuple.create((Object)isQty, (Object)false));
                accountRepairVO.setAccPropInfo(accPropInfo);
                accRepairInfoForOrgMap.put(useOrgId, accountRepairVO);
            }
        }
        return accRepairInfoForOrgMap;
    }
}

