/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.accountoplog;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.util.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;

public class AccountOpLogCheckTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(AccountOpLogCheckTask.class);

    public void execute(RequestContext context, Map<String, Object> params) throws KDException {
        DynamicObjectCollection bookEntity;
        String tenantId = context.getTenantId();
        String tenantName = context.getTenantInfo().getName();
        log.info("current tenantInfo " + tenantId + tenantName);
        int maxCount = Integer.parseInt(params.get("defaultcount").toString());
        QFilter qFilter = null;
        if (StringUtils.isNotBlank((CharSequence)params.get("cleartime").toString())) {
            try {
                Timestamp cleartime = new Timestamp(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(params.get("cleartime").toString()).getTime());
                qFilter = new QFilter("optime", "<=", (Object)cleartime);
            }
            catch (ParseException e) {
                log.info("select data exception: analysis clearTime exception: " + params.get("cleartime"));
                return;
            }
        }
        if ((bookEntity = QueryServiceHelper.query((String)"bd_account_oplog", (String)"id", (QFilter[])new QFilter[]{qFilter}, (String)"id desc", (int)maxCount)).isEmpty()) {
            return;
        }
        HashSet<Long> deleteIdSet = new HashSet<Long>(8);
        for (DynamicObject dynamicObject : bookEntity) {
            deleteIdSet.add(dynamicObject.getLong("id"));
        }
        try (TXHandle tx = TX.requiresNew();){
            try {
                QFilter deleteFilter = new QFilter("id", "in", deleteIdSet);
                int deleteRes = DeleteServiceHelper.delete((String)"bd_account_oplog", (QFilter[])new QFilter[]{deleteFilter});
                log.info("maintenance result: " + deleteRes);
                if (deleteRes == 0) {
                    tx.markRollback();
                }
            }
            catch (Exception th) {
                log.info("maintenance data exception: " + ExceptionUtils.getExceptionStackTraceMessage((Exception)th));
                tx.markRollback();
            }
        }
    }
}

