/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.accounttableref;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.bd.accounttableref.DisableParam;
import kd.fi.bd.accounttableref.SingleOrgExcuteResult;
import kd.fi.bd.accounttableref.SingleOrgExcutor;
import kd.fi.bd.accounttableref.VirtualOrgExcuteParam;
import kd.fi.bd.accounttableref.VirtualOrgExcutor;
import kd.fi.bd.util.ContextUtil;

public class AccountTableRefOpService {
    private static Object excute(long orgId, Date date, long accountTableRefId, String op, String taskId) {
        try {
            switch (op) {
                case "1": {
                    List<SingleOrgExcuteResult> results = VirtualOrgExcutor.getInstance().enable(VirtualOrgExcuteParam.create(orgId, date, accountTableRefId, null, taskId));
                    return AccountTableRefOpService.createReprot(results, orgId, date, accountTableRefId, "1");
                }
                case "3": {
                    List<SingleOrgExcuteResult> results = VirtualOrgExcutor.getInstance().disable(VirtualOrgExcuteParam.create(orgId, date, accountTableRefId, DisableParam.getDeleteDisableParam(), taskId));
                    return AccountTableRefOpService.createReprot(results, orgId, date, accountTableRefId, "3");
                }
                case "2": {
                    List<SingleOrgExcuteResult> results = VirtualOrgExcutor.getInstance().disable(VirtualOrgExcuteParam.create(orgId, date, accountTableRefId, DisableParam.getFakeDisableParam(), taskId));
                    return AccountTableRefOpService.createReprot(results, orgId, date, accountTableRefId, "2");
                }
                case "4": {
                    List<SingleOrgExcuteResult> results = VirtualOrgExcutor.getInstance().disable(VirtualOrgExcuteParam.create(orgId, date, accountTableRefId, DisableParam.getRealDisableParam(), taskId));
                    boolean isFail = results.stream().anyMatch(x -> !x.getCommonResult().isSuccess());
                    if (!isFail) {
                        results.addAll(VirtualOrgExcutor.getInstance().enable(VirtualOrgExcuteParam.create(orgId, date, accountTableRefId, null, taskId)));
                    }
                    return AccountTableRefOpService.createReprot(results, orgId, date, accountTableRefId, "4");
                }
                case "5": {
                    List<SingleOrgExcuteResult> results = Collections.singletonList(SingleOrgExcutor.getInstance().balTrans(orgId, accountTableRefId, date));
                    return AccountTableRefOpService.createReprot(results, orgId, date, accountTableRefId, "5");
                }
            }
            return null;
        }
        catch (KDBizException e) {
            return AccountTableRefOpService.createFailReprot(orgId, date, accountTableRefId, op, e.getMessage());
        }
        catch (Exception e) {
            AccountTableRefOpService.createFailReprot(orgId, date, accountTableRefId, op, ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            throw e;
        }
    }

    public static Object enable(long orgId, Date enableDate, long accountTableRefId, String taskId) {
        return AccountTableRefOpService.excute(orgId, enableDate, accountTableRefId, "1", taskId);
    }

    public static Object deleteRecord(long orgId, Date disableDate, long accountTableRefId, String taskId) {
        return AccountTableRefOpService.excute(orgId, disableDate, accountTableRefId, "3", taskId);
    }

    public static Object disable(long orgId, Date disableDate, long accountTableRefId, String taskId) {
        return AccountTableRefOpService.excute(orgId, disableDate, accountTableRefId, "2", taskId);
    }

    public static Object reEnable(long orgId, Date enableDate, long accountTableRefId, String taskId) {
        return AccountTableRefOpService.excute(orgId, enableDate, accountTableRefId, "4", taskId);
    }

    public static Object balTrans(long orgId, Date enableDate, long accountTableRefId, String taskId) {
        return AccountTableRefOpService.excute(orgId, enableDate, accountTableRefId, "5", taskId);
    }

    public static Tuple<Boolean, Object> restoreAfterSave(DynamicObject saveData, long orgId, boolean isPersonalized) {
        if (saveData == null) {
            return null;
        }
        long id = saveData.getLong("id");
        long accountTableRefMasterId = saveData.getLong("masterid");
        if (id <= 0L && accountTableRefMasterId <= 0L) {
            return null;
        }
        long accountTableRefId = id > 0L ? id : accountTableRefMasterId;
        try {
            VirtualOrgExcuteParam virtualOrgExcuteParam = VirtualOrgExcuteParam.createRestoreParam(saveData, orgId, isPersonalized);
            List<SingleOrgExcuteResult> results = VirtualOrgExcutor.getInstance().disable(virtualOrgExcuteParam);
            boolean isFail = results.stream().anyMatch(x -> !x.getCommonResult().isSuccess());
            return new Tuple((Object)(!isFail ? 1 : 0), AccountTableRefOpService.createReprot(results, orgId, saveData.getDate("enabledate"), accountTableRefId, "6"));
        }
        catch (KDBizException e) {
            return new Tuple((Object)Boolean.FALSE, AccountTableRefOpService.createFailReprot(orgId, saveData.getDate("enabledate"), accountTableRefId, "6", e.getMessage()));
        }
        catch (Exception e) {
            AccountTableRefOpService.createFailReprot(orgId, saveData.getDate("enabledate"), accountTableRefId, "6", ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            throw e;
        }
    }

    private static Object createReprot(List<SingleOrgExcuteResult> results, long orgId, Date date, long accountTableRefId, String op) {
        DynamicObject[] saveResult;
        DynamicObject report = AccountTableRefOpService.getNewReport(orgId, date, accountTableRefId, op);
        DynamicObjectCollection entries = report.getDynamicObjectCollection("entryentity");
        if ("4".equals(op)) {
            Map<Long, List<SingleOrgExcuteResult>> orgResults = results.stream().collect(Collectors.groupingBy(x -> x.getParam().getOrgId()));
            for (Map.Entry entry : orgResults.entrySet()) {
                DynamicObject row = entries.addNew();
                Long childOrgId = (Long)entry.getKey();
                row.set("childorg", (Object)childOrgId);
                List<String> errorMsgs = ((List)entry.getValue()).stream().map(SingleOrgExcuteResult::getMsgStr).filter(StringUtils::isNotBlank).collect(Collectors.toList());
                boolean haveFail = ((List)entry.getValue()).stream().anyMatch(x -> !x.getCommonResult().isSuccess());
                if (errorMsgs.isEmpty() && !haveFail) {
                    row.set("result", (Object)"1");
                    continue;
                }
                String errorMsg = String.join((CharSequence)"\n", errorMsgs.toArray(new String[0]));
                if (errorMsg.length() > 255) {
                    errorMsg = errorMsg.substring(0, 252) + "...";
                }
                row.set("errormsg", (Object)errorMsg);
                row.set("result", (Object)(haveFail ? "0" : "1"));
            }
        } else {
            for (SingleOrgExcuteResult singleOrgExcuteResult : results) {
                DynamicObject row = entries.addNew();
                row.set("childorg", (Object)singleOrgExcuteResult.getParam().getOrgId());
                String errorMsgStr = singleOrgExcuteResult.getMsgStr();
                if (StringUtils.isNotBlank((CharSequence)errorMsgStr) || !singleOrgExcuteResult.getCommonResult().isSuccess()) {
                    if (errorMsgStr.length() > 255) {
                        errorMsgStr = errorMsgStr.substring(0, 252) + "...";
                    }
                    row.set("errormsg", (Object)errorMsgStr);
                    row.set("result", (Object)(singleOrgExcuteResult.getCommonResult().isSuccess() ? "1" : "0"));
                    continue;
                }
                row.set("result", (Object)"1");
            }
        }
        return (saveResult = (DynamicObject[])BusinessDataWriter.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bd_refop_report"), (Object[])new DynamicObject[]{report})).length == 0 ? Long.valueOf(0L) : saveResult[0].getPkValue();
    }

    private static Object createFailReprot(long orgId, Date date, long accountTableRefId, String op, String errorMsg) {
        DynamicObject report = AccountTableRefOpService.getNewReport(orgId, date, accountTableRefId, op);
        DynamicObjectCollection entries = report.getDynamicObjectCollection("entryentity");
        DynamicObject row = entries.addNew();
        row.set("childorg", (Object)orgId);
        if (errorMsg.length() > 255) {
            errorMsg = errorMsg.substring(0, 252) + "...";
        }
        row.set("errormsg", (Object)errorMsg);
        row.set("result", (Object)"0");
        DynamicObject[] saveResult = (DynamicObject[])BusinessDataWriter.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bd_refop_report"), (Object[])new DynamicObject[]{report});
        return saveResult.length == 0 ? Long.valueOf(0L) : saveResult[0].getPkValue();
    }

    private static DynamicObject getNewReport(long orgId, Date date, long accountTableRefId, String op) {
        BusinessDataServiceHelper.removeCache((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accttabref_record"));
        DynamicObject report = BusinessDataServiceHelper.newDynamicObject((String)"bd_refop_report");
        report.set("org", (Object)orgId);
        report.set("date", (Object)date);
        report.set("op", (Object)op);
        report.set("accttabref", (Object)accountTableRefId);
        report.set("opdate", (Object)new Date());
        report.set("user", (Object)ContextUtil.getUserId());
        DynamicObjectCollection entries = report.getDynamicObjectCollection("entryentity");
        entries.clear();
        return report;
    }
}

