/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.accounttableref;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.ext.fi.accountref.AccountTableRef;
import kd.bos.ext.fi.accountref.CheckResult;
import kd.bos.ext.fi.accountref.IAccountTableRefService;
import kd.bos.ext.fi.accountref.impl.AifsTargetsetImpl;
import kd.bos.ext.fi.accountref.impl.AnasysReportUtilImpl;
import kd.bos.ext.fi.accountref.impl.CommonFormImpl;
import kd.bos.ext.fi.accountref.impl.GlAcceditImpl;
import kd.bos.ext.fi.accountref.impl.MultColSchemeImpl;
import kd.bos.ext.fi.accountref.impl.ReciprocalSchemeImpl;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.fi.bd.accounttableref.AccountTableRefService;
import kd.fi.bd.accounttableref.ExcuteCommonResult;
import kd.fi.bd.accounttableref.SingleOrgExcuteParam;
import kd.fi.bd.util.ContextUtil;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.util.DebugTraceHelper;
import kd.fi.bd.util.QFBuilder;

public class AccountTableRefServiceExcutor {
    private static final Log LOG = LogFactory.getLog(AccountTableRefServiceExcutor.class);
    private static final String FIBD = "fibd";
    private static final String SERVICE_TASK = "kd.fi.bd.accounttableref.AccountTableRefServiceTask";
    private static final AccountTableRefService BOOK_SERVICE = new AccountTableRefService("fi", "gl", "GLAccountTableRefService");
    private static final List<AccountTableRefService> DEFAULT_SERVICES = new ArrayList<AccountTableRefService>(2);
    private static final List<AccountTableRefService> BAL_TRANS_SERVICES = new ArrayList<AccountTableRefService>(2);
    private static final Map<String, IAccountTableRefService> SERVICE_IMPLS = new HashMap<String, IAccountTableRefService>(8);
    private static final AccountTableRefServiceExcutor INSTANCE;

    private AccountTableRefServiceExcutor() {
    }

    public static AccountTableRefServiceExcutor getInstance() {
        return INSTANCE;
    }

    protected ServiceExcuteResult excuteEnableCheckService(SingleOrgExcuteParam excuteParam) {
        return this.excuteCheckService(excuteParam.getOrgId(), excuteParam.getExcuteDate(), excuteParam.getAccountTableRef(), "enableCheck", true);
    }

    protected ServiceExcuteResult excuteDisableCheckService(SingleOrgExcuteParam excuteParam, boolean withBook) {
        return this.excuteCheckService(excuteParam.getOrgId(), excuteParam.getExcuteDate(), excuteParam.getAccountTableRef(), "disableCheck", withBook);
    }

    protected ServiceExcuteResult excuteEnableService(SingleOrgExcuteParam excuteParam) {
        return this.excuteService(excuteParam.getOrgId(), excuteParam.getExcuteDate(), excuteParam.getAccountTableRef(), "enable", true);
    }

    protected ServiceExcuteResult excuteDisableService(SingleOrgExcuteParam excuteParam, boolean withBook) {
        return this.excuteService(excuteParam.getOrgId(), excuteParam.getExcuteDate(), excuteParam.getAccountTableRef(), "disable", withBook);
    }

    public ServiceExcuteResult excuteEnableService(long orgId, Date date, AccountTableRef accountIdRef) {
        return this.excuteService(orgId, date, accountIdRef, "enable", "enableCheck", true);
    }

    public ServiceExcuteResult excuteEnableService(long orgId, Date date, AccountTableRef accountIdRef, boolean withBook) {
        return this.excuteService(orgId, date, accountIdRef, "enable", "enableCheck", withBook);
    }

    public ServiceExcuteResult excuteDisableService(long orgId, Date date, AccountTableRef accountIdRef) {
        return this.excuteService(orgId, date, accountIdRef, "disable", "disableCheck", true);
    }

    public ServiceExcuteResult excuteDisableService(long orgId, Date date, AccountTableRef accountIdRef, boolean withBook) {
        return this.excuteService(orgId, date, accountIdRef, "disable", "disableCheck", withBook);
    }

    private ServiceExcuteResult excuteService(long orgId, Date date, AccountTableRef accountIdRef, String op, String opCheck, boolean withBook) {
        ServiceExcuteResult result = this.excuteCheckService(orgId, date, accountIdRef, opCheck, withBook);
        if (result.getCommonResult().isSuccess() && Objects.isNull(result.getException())) {
            return this.excuteService(orgId, date, accountIdRef, op, withBook);
        }
        return result;
    }

    private ServiceExcuteResult excuteCheckService(long orgId, Date date, AccountTableRef accountIdRef, String opCheck, boolean withBook) {
        Object bookCheckResult;
        ServiceExcuteResult result = new ServiceExcuteResult();
        if (withBook && !((CheckResult)(bookCheckResult = AccountTableRefServiceExcutor.invokeCheckService(BOOK_SERVICE, opCheck, orgId, date, accountIdRef))).isSuccess()) {
            result.getCommonResult().addMsg(((CheckResult)bookCheckResult).getMessage());
            result.getCommonResult().setSuccess(false);
            return result;
        }
        for (AccountTableRefService defaultService : DEFAULT_SERVICES) {
            CheckResult defaultServiceCheckResult = AccountTableRefServiceExcutor.invokeCheckService(defaultService, opCheck, orgId, date, accountIdRef);
            if (defaultServiceCheckResult.isSuccess()) continue;
            result.getCommonResult().addMsg(defaultServiceCheckResult.getMessage());
            result.getCommonResult().setSuccess(false);
            return result;
        }
        List<AccountTableRefService> registerServices = AccountTableRefServiceExcutor.getTxServices();
        for (AccountTableRefService accountTableRefService : registerServices) {
            IAccountTableRefService serviceImpl = SERVICE_IMPLS.get(accountTableRefService.toString());
            CheckResult checkResult = Objects.isNull(serviceImpl) ? AccountTableRefServiceExcutor.invokeCheckService(accountTableRefService, opCheck, orgId, date, accountIdRef) : ("enableCheck".equals(opCheck) ? serviceImpl.enableCheck(orgId, date, accountIdRef) : serviceImpl.disableCheck(orgId, date, accountIdRef));
            if (Objects.isNull(checkResult) || checkResult.isSuccess()) continue;
            result.getCommonResult().setSuccess(false);
            result.getCommonResult().addMsg(checkResult.getMessage());
        }
        return result;
    }

    private ServiceExcuteResult excuteService(long orgId, Date date, AccountTableRef accountIdRef, String op, boolean withBook) {
        ServiceExcuteResult result = new ServiceExcuteResult();
        if (withBook) {
            AccountTableRefServiceExcutor.invokeExcuteService(BOOK_SERVICE, op, orgId, date, accountIdRef);
        }
        for (AccountTableRefService defaultService : DEFAULT_SERVICES) {
            AccountTableRefServiceExcutor.invokeExcuteService(defaultService, op, orgId, date, accountIdRef);
        }
        List<AccountTableRefService> registerServices = AccountTableRefServiceExcutor.getTxServices();
        AccountTableRefServiceExcutor.excuteServices(registerServices, orgId, date, accountIdRef, op);
        return result;
    }

    public void excuteBalTransService(long orgId, Date date, AccountTableRef accountIdRef) {
        for (AccountTableRefService accountTableRefService : BAL_TRANS_SERVICES) {
            AccountTableRefServiceExcutor.invokeExcuteService(accountTableRefService, "enable", orgId, date, accountIdRef);
        }
    }

    public String excuteServiceTask(long orgId, Date date, AccountTableRef accountIdRef, String op) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setName(ResManager.loadKDString((String)"\u6267\u884c\u201c\u79d1\u76ee\u8868\u7248\u672c\u5316\u201d\u63a5\u53e3\u540e\u53f0\u64cd\u4f5c", (String)"AccountTableRefServiceExcutor_0", (String)"fi-bd-common", (Object[])new Object[0]));
        jobInfo.setJobType(JobType.BIZ);
        jobInfo.setRunByUserId(ContextUtil.getUserId());
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setAppId(FIBD);
        jobInfo.setTaskClassname(SERVICE_TASK);
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("orgId", orgId);
        params.put("date", SerializationUtils.serializeToBase64((Object)date));
        params.put("accountIdRef", SerializationUtils.serializeToBase64((Object)accountIdRef));
        params.put("op", op);
        jobInfo.setParams(params);
        return ScheduleServiceHelper.dispatch((JobInfo)jobInfo);
    }

    public ServiceExcuteResult excuteNonTxService(long orgId, Date date, AccountTableRef accountIdRef, String op) {
        if (DebugTrace.enable()) {
            LOG.info("excuteNonTxService on org: {}, date: {}, accountIdRef: {}, op: {}", new Object[]{orgId, date, DebugTraceHelper.toString(accountIdRef), op});
        }
        ServiceExcuteResult result = new ServiceExcuteResult();
        List<AccountTableRefService> registerServices = AccountTableRefServiceExcutor.getNonTxServices();
        String opCheck = "enable".equals(op) ? "enableCheck" : "disableCheck";
        for (AccountTableRefService accountTableRefService : registerServices) {
            IAccountTableRefService serviceImpl = SERVICE_IMPLS.get(accountTableRefService.toString());
            CheckResult checkResult = Objects.isNull(serviceImpl) ? AccountTableRefServiceExcutor.invokeCheckService(accountTableRefService, opCheck, orgId, date, accountIdRef) : ("enable".equals(op) ? serviceImpl.enableCheck(orgId, date, accountIdRef) : serviceImpl.disableCheck(orgId, date, accountIdRef));
            if (!Objects.isNull(checkResult) && !checkResult.isSuccess()) {
                result.getCommonResult().setSuccess(false);
                result.getCommonResult().addMsg(checkResult.getMessage());
            }
            if (!DebugTrace.enable()) continue;
            LOG.info("excuteNonTxService on service: {}, impl: {}, check result: {}", new Object[]{accountTableRefService.toString(), null == serviceImpl ? "null" : serviceImpl.getClass().getName(), DebugTraceHelper.toString(checkResult)});
        }
        if (DebugTrace.enable()) {
            LOG.info("excuteNonTxService service check final result: {}", (Object)DebugTraceHelper.toString(result.getCommonResult()));
        }
        if (result.getCommonResult().isSuccess()) {
            AccountTableRefServiceExcutor.excuteServices(registerServices, orgId, date, accountIdRef, op);
        }
        return result;
    }

    private static void excuteServices(List<AccountTableRefService> registerServices, long orgId, Date date, AccountTableRef accountIdRef, String op) {
        for (AccountTableRefService accountTableRefService : registerServices) {
            IAccountTableRefService serviceImpl = SERVICE_IMPLS.get(accountTableRefService.toString());
            if (DebugTrace.enable()) {
                LOG.info("excuteNonTxService start_execute_service: {}, impl: {}", (Object)accountTableRefService.toString(), (Object)(null == serviceImpl ? "null" : serviceImpl.getClass().getName()));
            }
            if (Objects.isNull(serviceImpl)) {
                AccountTableRefServiceExcutor.invokeExcuteService(accountTableRefService, op, orgId, date, accountIdRef);
            } else if ("enable".equals(op)) {
                serviceImpl.enable(orgId, date, accountIdRef);
            } else {
                serviceImpl.disable(orgId, date, accountIdRef);
            }
            if (!DebugTrace.enable()) continue;
            LOG.info("excuteNonTxService finished_execute_service: {}, impl: {}", (Object)accountTableRefService.toString(), (Object)(null == serviceImpl ? "null" : serviceImpl.getClass().getName()));
        }
    }

    private static List<AccountTableRefService> getNonTxServices() {
        return AccountTableRefServiceExcutor.getServices(Boolean.FALSE);
    }

    private static List<AccountTableRefService> getTxServices() {
        return AccountTableRefServiceExcutor.getServices(Boolean.TRUE);
    }

    private static List<AccountTableRefService> getServices(Boolean isConsistent) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("enable", "=", Boolean.TRUE);
        qfBuilder.add("isconsistent", "=", isConsistent);
        Map serviceDynObjs = BusinessDataServiceHelper.loadFromCache((String)"bd_service_register", (QFilter[])qfBuilder.toArray());
        return serviceDynObjs.values().stream().map(x -> new AccountTableRefService(x.getString("bizcloud"), x.getString("bizapp"), x.getString("service"))).collect(Collectors.toList());
    }

    private static CheckResult invokeCheckService(AccountTableRefService accountTableRefService, String opCheck, Object orgId, Object date, Object accountIdRef) {
        return (CheckResult)DispatchServiceHelper.invokeBizService((String)accountTableRefService.getCloud(), (String)accountTableRefService.getApp(), (String)accountTableRefService.getServiceName(), (String)opCheck, (Object[])new Object[]{orgId, date, accountIdRef});
    }

    private static void invokeExcuteService(AccountTableRefService accountTableRefService, String op, Object orgId, Object date, Object accountIdRef) {
        if (DebugTrace.enable()) {
            LOG.info("excuteNonTxService call_execute_service on {}", (Object)accountTableRefService.toString());
        }
        DispatchServiceHelper.invokeBizService((String)accountTableRefService.getCloud(), (String)accountTableRefService.getApp(), (String)accountTableRefService.getServiceName(), (String)op, (Object[])new Object[]{orgId, date, accountIdRef});
    }

    static {
        DEFAULT_SERVICES.add(new AccountTableRefService("fi", "gl", "BalanceTransferService"));
        DEFAULT_SERVICES.add(new AccountTableRefService("fi", "gl", "AcccurrentTransferService"));
        BAL_TRANS_SERVICES.add(new AccountTableRefService("fi", "gl", "BalanceTransBalService"));
        BAL_TRANS_SERVICES.add(new AccountTableRefService("fi", "gl", "AcccurrentTransRecordService"));
        SERVICE_IMPLS.put("fi-bd-CommonFormImpl", new CommonFormImpl());
        SERVICE_IMPLS.put("fi-bd-GlAcceditImpl", new GlAcceditImpl());
        SERVICE_IMPLS.put("fi-bd-AifsTargetsetImpl", new AifsTargetsetImpl());
        SERVICE_IMPLS.put("fi-bd-MultColSchemeImpl", new MultColSchemeImpl());
        SERVICE_IMPLS.put("fi-bd-ReciprocalSchemeImpl", new ReciprocalSchemeImpl());
        SERVICE_IMPLS.put("fi-bd-AnasysReportUtilImpl", new AnasysReportUtilImpl());
        INSTANCE = new AccountTableRefServiceExcutor();
    }

    public static class ServiceExcuteResult {
        private ExcuteCommonResult commonResult = new ExcuteCommonResult();
        private Exception e;

        public ExcuteCommonResult getCommonResult() {
            return this.commonResult;
        }

        public void setCommonResult(ExcuteCommonResult commonResult) {
            this.commonResult = commonResult;
        }

        public Exception getException() {
            return this.e;
        }

        public void setException(Exception e) {
            this.e = e;
        }
    }
}

