/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.accounttableref;

import java.text.Format;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatTypes;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.ext.fi.accountref.AccountTableRef;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.bd.accounttableref.AccountTableRefServiceExcutor;
import kd.fi.bd.accounttableref.ExcuteCommonResult;
import kd.fi.bd.accounttableref.ShareLockExcutor;
import kd.fi.bd.accounttableref.SingleOrgExcuteParam;
import kd.fi.bd.accounttableref.SingleOrgExcuteResult;
import kd.fi.bd.util.AccountVersionUtil;
import kd.fi.bd.util.ContextUtil;

public class SingleOrgExcutor {
    private static final SingleOrgExcutor EXCUTOR = new SingleOrgExcutor();

    private SingleOrgExcutor() {
    }

    protected static SingleOrgExcutor getInstance() {
        return EXCUTOR;
    }

    protected ExcuteCommonResult enableValidate(SingleOrgExcuteParam excuteParam) {
        DynamicObjectCollection orgRecords;
        ExcuteCommonResult result = new ExcuteCommonResult();
        result.setSuccess(true);
        Format format = FormatFactory.get((FormatTypes)FormatTypes.Date).getFormat(InteServiceHelper.getUserFormat((Long)ContextUtil.getUserId()));
        DynamicObject accountTableRefDO = excuteParam.getAccountTableRefDO();
        if (Objects.isNull(accountTableRefDO)) {
            result.setSuccess(false);
            result.addMsg(String.format(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e0b\u5f53\u524d\u79d1\u76ee\u8868\u7248\u672c\u5316\u57fa\u7840\u8d44\u6599\u7684\u542f\u7528\u65e5\u671f\u4e0e\u4e0a\u7ea7\u7ec4\u7ec7\u4e0d\u4e00\u81f4\uff1a%s", (String)"SingleOrgExcutor_0", (String)"fi-bd-common", (Object[])new Object[0]), format.format(excuteParam.getExcuteDate())));
            return result;
        }
        QFilter orgFilter = new QFilter("org", "=", (Object)excuteParam.getOrgId());
        QFilter dateLargeFilter = new QFilter("enabledate", ">=", (Object)excuteParam.getExcuteDate());
        AccountTableRef accountTableRef = excuteParam.getAccountTableRef();
        if (Objects.nonNull(accountTableRef) && accountTableRef.getOldAccountTableId() > 0L) {
            long oldAccountTableId = accountTableRef.getOldAccountTableId();
            dateLargeFilter.and(new QFilter("oldaccttab", "=", (Object)oldAccountTableId));
        }
        if ((orgRecords = QueryServiceHelper.query((String)"bd_accttabref_record", (String)String.join((CharSequence)",", "enabledate", "accountref.masterid", "enablestatus", "oldaccttab"), (QFilter[])new QFilter[]{orgFilter, dateLargeFilter})).stream().anyMatch(x -> x.getDate("enabledate").compareTo(excuteParam.getExcuteDate()) > 0)) {
            result.setSuccess(false);
            result.addMsg(String.format(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u5f53\u524d\u542f\u7528\u65e5\u671f\u201c%s\u201d \u4e4b\u540e\u5b58\u5728\u79d1\u76ee\u8868\u7248\u672c\u5316\u542f\u7528\u8bb0\u5f55\u3002", (String)"SingleOrgExcutor_1", (String)"fi-bd-common", (Object[])new Object[0]), format.format(excuteParam.getExcuteDate())));
            return result;
        }
        Map<Long, String> masterIdStatus = orgRecords.stream().filter(x -> x.getLong("oldaccttab") == accountTableRefDO.getLong("oldacttable_id")).collect(Collectors.toMap(x -> x.getLong("accountref.masterid"), x -> x.getString("enablestatus")));
        if (masterIdStatus.containsKey(excuteParam.getAccountTableRefMasterId())) {
            if (masterIdStatus.size() != 1) {
                result.setSuccess(false);
                result.addMsg(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u5f53\u524d\u6240\u9009\u79d1\u76ee\u8868\u7248\u672c\u5316\u7684\u57fa\u7840\u8d44\u6599\u6e90\u79d1\u76ee\u8868\u5b58\u5728\u542f\u7528\u8bb0\u5f55\u3002", (String)"SingleOrgExcutor_2", (String)"fi-bd-common", (Object[])new Object[0]));
                return result;
            }
            String status = masterIdStatus.get(excuteParam.getAccountTableRefMasterId());
            if ("C".equals(status)) {
                result.setSuccess(true);
                result.addMsg(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u5f53\u524d\u6240\u9009\u79d1\u76ee\u8868\u7248\u672c\u5316\u57fa\u7840\u8d44\u6599\u5df2\u542f\u7528\u8fc7\uff0c\u65e0\u9700\u518d\u6b21\u542f\u7528\u3002", (String)"SingleOrgExcutor_3", (String)"fi-bd-common", (Object[])new Object[0]));
                return result;
            }
        } else if (masterIdStatus.size() > 0) {
            result.setSuccess(false);
            result.addMsg(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u5f53\u524d\u6240\u9009\u79d1\u76ee\u8868\u7248\u672c\u5316\u7684\u57fa\u7840\u8d44\u6599\u6e90\u79d1\u76ee\u8868\u5b58\u5728\u542f\u7528\u8bb0\u5f55\u3002", (String)"SingleOrgExcutor_2", (String)"fi-bd-common", (Object[])new Object[0]));
            return result;
        }
        if (PermissionServiceHelper.checkPermission((Long)ContextUtil.getUserId(), (Long)excuteParam.getOrgId(), (String)"10", (String)"fibd", (String)"bd_accounttableref", (String)"4730fc5d000000ac") == 0) {
            result.setSuccess(false);
            result.addMsg(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u8be5\u7ec4\u7ec7\u542f\u7528\u7684\u6743\u9650\u3002", (String)"SingleOrgExcutor_4", (String)"fi-bd-common", (Object[])new Object[0]));
            return result;
        }
        AccountTableRefServiceExcutor.ServiceExcuteResult checkResult = AccountTableRefServiceExcutor.getInstance().excuteEnableCheckService(excuteParam);
        Exception exception = checkResult.getException();
        if (!Objects.isNull(exception)) {
            throw new KDException((Throwable)exception, new ErrorCode("ACCOUNT_REF_SERVICE_ERROR", ResManager.loadKDString((String)"\u63a5\u53e3\u6267\u884c\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\u3002", (String)"SingleOrgExcutor_5", (String)"fi-bd-common", (Object[])new Object[0])), new Object[0]);
        }
        if (!checkResult.getCommonResult().isSuccess()) {
            return checkResult.getCommonResult();
        }
        return result;
    }

    protected SingleOrgExcuteResult enable(SingleOrgExcuteParam excuteParam) {
        SingleOrgExcuteResult excuteResult = ShareLockExcutor.requireLock(excuteParam, () -> this.doEnable(excuteParam));
        if (Objects.isNull(excuteResult)) {
            return SingleOrgExcutor.createNonLockResult(excuteParam);
        }
        return excuteResult;
    }

    private SingleOrgExcuteResult doEnable(SingleOrgExcuteParam excuteParam) {
        AccountTableRefServiceExcutor.ServiceExcuteResult serviceExcuteResult;
        Exception exception;
        SingleOrgExcuteResult result = new SingleOrgExcuteResult(excuteParam);
        ExcuteCommonResult commonResult = this.enableValidate(excuteParam);
        result.setCommonResult(commonResult);
        if (!commonResult.isSuccess() || !commonResult.getMsgs().isEmpty()) {
            return result;
        }
        if (!Objects.isNull(excuteParam.getDisableParam())) {
            result = this.doDisable(excuteParam);
            if (!result.getCommonResult().isSuccess()) {
                return result;
            }
            excuteParam.setDisableParam(null);
        }
        if (!Objects.isNull(exception = (serviceExcuteResult = AccountTableRefServiceExcutor.getInstance().excuteEnableService(excuteParam)).getException())) {
            throw new KDException((Throwable)exception, new ErrorCode("ACCOUNT_REF_SERVICE_ERROR", ResManager.loadKDString((String)"\u63a5\u53e3\u6267\u884c\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\u3002", (String)"SingleOrgExcutor_5", (String)"fi-bd-common", (Object[])new Object[0])), new Object[0]);
        }
        if (!serviceExcuteResult.getCommonResult().isSuccess()) {
            result.setCommonResult(serviceExcuteResult.getCommonResult());
            return result;
        }
        AccountTableRefServiceExcutor.getInstance().excuteServiceTask(excuteParam.getOrgId(), excuteParam.getExcuteDate(), excuteParam.getAccountTableRef(), "enable");
        long oldAcctTabId = excuteParam.getAccountTableRefDO().getLong("oldacttable_id");
        QFilter orgFilter = new QFilter("org", "=", (Object)excuteParam.getOrgId());
        QFilter dateFilter = new QFilter("enabledate", "=", (Object)excuteParam.getExcuteDate());
        QFilter masterEqualsFilter = new QFilter("accountref.masterid", "=", (Object)excuteParam.getAccountTableRefMasterId());
        boolean isUpdate = true;
        DynamicObject recordDO = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_accttabref_record", (QFilter[])new QFilter[]{orgFilter, masterEqualsFilter, dateFilter});
        if (Objects.isNull(recordDO)) {
            isUpdate = false;
            recordDO = BusinessDataServiceHelper.newDynamicObject((String)"bd_accttabref_record");
        }
        if (result.getCommonResult().isSuccess()) {
            recordDO.set("enablestatus", (Object)"C");
            recordDO.set("org", (Object)excuteParam.getOrgId());
            recordDO.set("accountref", (Object)excuteParam.getAccountTableRefDO().getLong("id"));
            recordDO.set("enabledate", (Object)excuteParam.getExcuteDate());
            recordDO.set("oldaccttab", (Object)oldAcctTabId);
            recordDO.set("newaccttab", (Object)excuteParam.getAccountTableRefDO().getLong("newacttable_id"));
            recordDO.set("disabledate", (Object)AccountVersionUtil.getEndDate());
            if (isUpdate) {
                BusinessDataWriter.update((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bd_accttabref_record"), (Object[])new DynamicObject[]{recordDO});
            } else {
                BusinessDataWriter.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bd_accttabref_record"), (Object[])new DynamicObject[]{recordDO});
            }
            QFilter dateLessFilter = new QFilter("enabledate", "<=", (Object)excuteParam.getExcuteDate());
            QFilter dateLargeFilter = new QFilter("disabledate", ">", (Object)excuteParam.getExcuteDate());
            QFilter newTableFilter = new QFilter("newaccttab", "=", (Object)oldAcctTabId);
            Map oldTabEnableRecords = BusinessDataServiceHelper.loadFromCache((String)"bd_accttabref_record", (QFilter[])new QFilter[]{orgFilter, dateLessFilter, dateLargeFilter, newTableFilter});
            ArrayList values = new ArrayList(oldTabEnableRecords.values());
            for (DynamicObject oldTabRecord : values) {
                oldTabRecord.set("disabledate", (Object)excuteParam.getExcuteDate());
            }
            BusinessDataWriter.update((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bd_accttabref_record"), (Object[])values.toArray(new DynamicObject[0]));
        }
        return result;
    }

    protected ExcuteCommonResult disableValidate(SingleOrgExcuteParam excuteParam) {
        Date disableDate;
        ExcuteCommonResult result = new ExcuteCommonResult();
        result.setSuccess(true);
        DynamicObject accountTableRefDO = excuteParam.getAccountTableRefDO();
        if (Objects.isNull(accountTableRefDO)) {
            result.setSuccess(false);
            result.addMsg(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e0b\u6ca1\u6709\u5f53\u524d\u6240\u9009\u79d1\u76ee\u8868\u7248\u672c\u5316\u57fa\u7840\u8d44\u6599\u7684\u4f7f\u7528\u6743\u3002", (String)"SingleOrgExcutor_6", (String)"fi-bd-common", (Object[])new Object[0]));
            return result;
        }
        QFilter orgFilter = new QFilter("org", "=", (Object)excuteParam.getOrgId());
        QFilter dateEqualsFilter = new QFilter("enabledate", "=", (Object)excuteParam.getExcuteDate());
        QFilter masterEqualsFilter = new QFilter("accountref.masterid", "=", (Object)excuteParam.getAccountTableRefMasterId());
        DynamicObject record = QueryServiceHelper.queryOne((String)"bd_accttabref_record", (String)String.join((CharSequence)",", "oldaccttab", "newaccttab", "enablestatus", "disabledate"), (QFilter[])new QFilter[]{orgFilter, dateEqualsFilter, masterEqualsFilter});
        if (Objects.isNull(record)) {
            result.setSuccess(true);
            result.addMsg(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e0b\u5f53\u524d\u65e5\u671f\u6ca1\u6709\u5f53\u524d\u6240\u9009\u79d1\u76ee\u8868\u7248\u672c\u5316\u57fa\u7840\u8d44\u6599\u7684\u542f\u7528\u8bb0\u5f55\uff0c\u65e0\u9700\u53cd\u542f\u7528\u3002", (String)"SingleOrgExcutor_7", (String)"fi-bd-common", (Object[])new Object[0]));
            return result;
        }
        String existsStatus = record.getString("enablestatus");
        if (!excuteParam.getDisableParam().isDeleteRecord()) {
            if (excuteParam.getDisableParam().isRealDisable()) {
                if (Objects.equals("E", existsStatus)) {
                    result.setSuccess(true);
                    result.addMsg(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u6240\u9009\u79d1\u76ee\u8868\u7248\u672c\u5316\u57fa\u7840\u8d44\u6599\u5df2\u7ecf\u53cd\u542f\u7528\uff0c\u65e0\u9700\u518d\u6b21\u53cd\u542f\u7528\u3002", (String)"SingleOrgExcutor_8", (String)"fi-bd-common", (Object[])new Object[0]));
                    return result;
                }
            } else if (Objects.equals("D", existsStatus)) {
                result.setSuccess(true);
                result.addMsg(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u6240\u9009\u79d1\u76ee\u8868\u7248\u672c\u5316\u57fa\u7840\u8d44\u6599\u5df2\u7ecf\u53cd\u542f\u7528\uff0c\u65e0\u9700\u518d\u6b21\u53cd\u542f\u7528\u3002", (String)"SingleOrgExcutor_8", (String)"fi-bd-common", (Object[])new Object[0]));
                return result;
            }
        } else if (!Objects.equals("C", existsStatus)) {
            result.setSuccess(false);
            result.addMsg(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u6240\u9009\u79d1\u76ee\u8868\u7248\u672c\u5316\u57fa\u7840\u8d44\u6599\u672a\u542f\u7528\uff0c\u4e0d\u80fd\u53cd\u542f\u7528\u5e76\u8fd8\u539f\u6570\u636e\u3002", (String)"SingleOrgExcutor_13", (String)"fi-bd-common", (Object[])new Object[0]));
            return result;
        }
        if ((disableDate = record.getDate("disabledate")).compareTo(AccountVersionUtil.getEndDate()) < 0) {
            result.setSuccess(false);
            Format format = FormatFactory.get((FormatTypes)FormatTypes.Date).getFormat(InteServiceHelper.getUserFormat((Long)ContextUtil.getUserId()));
            result.addMsg(String.format(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u5f53\u524d\u542f\u7528\u65e5\u671f\u201c%s\u201d \u4e4b\u540e\u5b58\u5728\u79d1\u76ee\u8868\u7248\u672c\u5316\u542f\u7528\u8bb0\u5f55\u3002", (String)"SingleOrgExcutor_1", (String)"fi-bd-common", (Object[])new Object[0]), format.format(excuteParam.getExcuteDate())));
            return result;
        }
        if (PermissionServiceHelper.checkPermission((Long)ContextUtil.getUserId(), (Long)excuteParam.getOrgId(), (String)"10", (String)"fibd", (String)"bd_accounttableref", (String)"47150e89000000ac") == 0) {
            result.setSuccess(false);
            result.addMsg(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u8be5\u7ec4\u7ec7\u53cd\u542f\u7528\u7684\u6743\u9650\u3002", (String)"SingleOrgExcutor_9", (String)"fi-bd-common", (Object[])new Object[0]));
            return result;
        }
        if (excuteParam.getDisableParam().isRealDisable() && (excuteParam.getDisableParam().isDeleteRecord() || excuteParam.isRefChanged())) {
            AccountTableRefServiceExcutor.ServiceExcuteResult checkResult = AccountTableRefServiceExcutor.getInstance().excuteDisableCheckService(excuteParam, excuteParam.isAccountTableChanged());
            Exception exception = checkResult.getException();
            if (!Objects.isNull(exception)) {
                throw new KDException((Throwable)exception, new ErrorCode("ACCOUNT_REF_SERVICE_ERROR", ResManager.loadKDString((String)"\u63a5\u53e3\u6267\u884c\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\u3002", (String)"SingleOrgExcutor_5", (String)"fi-bd-common", (Object[])new Object[0])), new Object[0]);
            }
            if (!checkResult.getCommonResult().isSuccess()) {
                return checkResult.getCommonResult();
            }
        }
        return result;
    }

    protected SingleOrgExcuteResult disable(SingleOrgExcuteParam excuteParam) {
        SingleOrgExcuteResult excuteResult = ShareLockExcutor.requireLock(excuteParam, () -> this.doDisable(excuteParam));
        if (Objects.isNull(excuteResult)) {
            return SingleOrgExcutor.createNonLockResult(excuteParam);
        }
        return excuteResult;
    }

    private SingleOrgExcuteResult doDisable(SingleOrgExcuteParam excuteParam) {
        ExcuteCommonResult disableValidateResult = this.disableValidate(excuteParam);
        SingleOrgExcuteResult result = new SingleOrgExcuteResult(excuteParam);
        result.setCommonResult(disableValidateResult);
        if (!disableValidateResult.isSuccess() || !disableValidateResult.getMsgs().isEmpty()) {
            return result;
        }
        QFilter orgFilter = new QFilter("org", "=", (Object)excuteParam.getOrgId());
        QFilter dateFilter = new QFilter("enabledate", "=", (Object)excuteParam.getExcuteDate());
        QFilter masterEqualsFilter = new QFilter("accountref.masterid", "=", (Object)excuteParam.getAccountTableRefMasterId());
        if (excuteParam.getDisableParam().isRealDisable()) {
            if (excuteParam.isRefChanged() || excuteParam.getDisableParam().isDeleteRecord()) {
                AccountTableRefServiceExcutor.ServiceExcuteResult serviceExcuteResult = AccountTableRefServiceExcutor.getInstance().excuteDisableService(excuteParam, excuteParam.isAccountTableChanged());
                Exception exception = serviceExcuteResult.getException();
                if (!Objects.isNull(exception)) {
                    throw new KDException((Throwable)exception, new ErrorCode("ACCOUNT_REF_SERVICE_ERROR", ResManager.loadKDString((String)"\u63a5\u53e3\u6267\u884c\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\u3002", (String)"SingleOrgExcutor_5", (String)"fi-bd-common", (Object[])new Object[0])), new Object[0]);
                }
                if (!serviceExcuteResult.getCommonResult().isSuccess()) {
                    result.setCommonResult(serviceExcuteResult.getCommonResult());
                    return result;
                }
                AccountTableRefServiceExcutor.getInstance().excuteServiceTask(excuteParam.getOrgId(), excuteParam.getExcuteDate(), excuteParam.getAccountTableRef(), "disable");
            }
            if (excuteParam.getDisableParam().isDeleteRecord()) {
                QFilter disableDateEuqalsEnableDateFilter = new QFilter("disabledate", "=", (Object)excuteParam.getExcuteDate());
                QFilter newTabEuqalsOldTabFilter = new QFilter("newaccttab", "=", (Object)excuteParam.getAccountTableRefDO().getLong("oldacttable_id"));
                Map lastRecordDynObjs = BusinessDataServiceHelper.loadFromCache((String)"bd_accttabref_record", (QFilter[])new QFilter[]{orgFilter, disableDateEuqalsEnableDateFilter, newTabEuqalsOldTabFilter});
                Collection lastRecords = lastRecordDynObjs.values();
                for (DynamicObject lastRecord : lastRecords) {
                    lastRecord.set("disabledate", (Object)AccountVersionUtil.getEndDate());
                }
                BusinessDataWriter.update((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bd_accttabref_record"), (Object[])lastRecords.toArray(new DynamicObject[0]));
                DeleteServiceHelper.delete((String)"bd_accttabref_record", (QFilter[])new QFilter[]{orgFilter, dateFilter, masterEqualsFilter});
            }
        } else {
            DynamicObject recordDO = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_accttabref_record", (QFilter[])new QFilter[]{orgFilter, dateFilter, masterEqualsFilter});
            if (!Objects.isNull(recordDO)) {
                recordDO.set("enablestatus", (Object)"D");
                BusinessDataWriter.update((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bd_accttabref_record"), (Object[])new DynamicObject[]{recordDO});
            }
        }
        return result;
    }

    protected SingleOrgExcuteResult balTrans(long orgId, long accountTableRefId, Date date) {
        if (!QueryServiceHelper.exists((String)"bd_accounttableref", (Object)accountTableRefId)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524dID\u201c%s\u201d\u5bf9\u5e94\u7684\u79d1\u76ee\u8868\u7248\u672c\u5316\u5173\u7cfb\u5df2\u7ecf\u4e0d\u5b58\u5728\uff0c\u6570\u636e\u53ef\u80fd\u88ab\u5220\u9664\u3002", (String)"SingleOrgExcutor_10", (String)"fi-bd-common", (Object[])new Object[0]), accountTableRefId));
        }
        long accountTableRefMasterId = BusinessDataServiceHelper.loadSingle((Object)accountTableRefId, (String)"bd_accounttableref", (String)"masterid").getLong("masterid");
        SingleOrgExcuteParam param = SingleOrgExcuteParam.create(orgId, date, accountTableRefMasterId, null);
        if (Objects.isNull(param.getAccountTableRefDO())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u6ca1\u6709\u8be5\u65b0\u79d1\u76ee\u5bf9\u7167\u5173\u7cfb\u4f7f\u7528\u6743\u3002", (String)"SingleOrgExcutor_11", (String)"fi-bd-common", (Object[])new Object[0]));
        }
        SingleOrgExcuteResult result = ShareLockExcutor.requireLock(param, () -> {
            SingleOrgExcuteResult excuteResult = new SingleOrgExcuteResult(param);
            AccountTableRefServiceExcutor.getInstance().excuteBalTransService(param.getOrgId(), param.getExcuteDate(), param.getAccountTableRef());
            return excuteResult;
        });
        if (Objects.isNull(result)) {
            return SingleOrgExcutor.createNonLockResult(param);
        }
        return result;
    }

    private static SingleOrgExcuteResult createNonLockResult(SingleOrgExcuteParam param) {
        return SingleOrgExcutor.createFailResult(param, Collections.singletonList(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u5f53\u524d\u6e90\u79d1\u76ee\u8868\u6b63\u5728\u8fdb\u884c\u5176\u4ed6\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u518d\u5c1d\u8bd5\u3002", (String)"SingleOrgExcutor_12", (String)"fi-bd-common", (Object[])new Object[0])));
    }

    private static SingleOrgExcuteResult createFailResult(SingleOrgExcuteParam param, List<String> errorMsgs) {
        SingleOrgExcuteResult excuteResult = new SingleOrgExcuteResult(param);
        excuteResult.getCommonResult().addMsgs(errorMsgs);
        excuteResult.getCommonResult().setSuccess(false);
        return excuteResult;
    }
}

