/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.accversion;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bd.accversion.AssistAddingContext;
import kd.fi.bd.consts.BDCommonResource;
import kd.fi.bd.enhance.treetask.AccountContext;
import kd.fi.bd.enhance.treetask.DependBiTreeNode;
import kd.fi.bd.enhance.treetask.ITaskService;
import kd.fi.bd.enums.PeriodStateEnum;
import kd.fi.bd.util.AccountBizCheckUtil;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.BiTreeNode;
import kd.fi.bd.util.TaskExecutionResult;
import kd.fi.bd.vo.AccountOrgPairVO;
import kd.fi.bd.vo.AccountVO;
import kd.fi.bd.vo.MessageVO;
import kd.fi.bd.vo.OrgAccOwnershipVO;
import kd.fi.bd.vo.OrgVO;

public class AccountAddingAssistValidateTaskImpl
implements ITaskService<TaskExecutionResult<AccountOrgPairVO>, AccountContext> {
    private static final Log LOG = LogFactory.getLog(AccountAddingAssistValidateTaskImpl.class);
    protected RequestContext requestContext = RequestContext.get();

    @Override
    public TaskExecutionResult<AccountOrgPairVO> buildExceptionResult(AccountContext taskContext, Exception e) {
        Tuple<BiTreeNode<String, AccountVO>, BiTreeNode<Long, OrgVO>> accOrgInfo = taskContext.getData();
        String accNumber = (String)((BiTreeNode)accOrgInfo.item1).getId();
        long orgId = (Long)((BiTreeNode)accOrgInfo.item2).getId();
        AccountOrgPairVO pairVO = new AccountOrgPairVO(accNumber, orgId);
        return TaskExecutionResult.failed(pairVO, BDCommonResource.getMessageConstantsE006Text(BDUtil.buildExceptionMsg(e, 20, true), RequestContext.get().getTraceId()), "E004");
    }

    @Override
    public TaskExecutionResult<AccountOrgPairVO> buildFastFailResult(AccountContext taskContext) {
        Tuple<BiTreeNode<String, AccountVO>, BiTreeNode<Long, OrgVO>> accOrgInfo = taskContext.getData();
        String accNumber = (String)((BiTreeNode)accOrgInfo.item1).getId();
        long orgId = (Long)((BiTreeNode)accOrgInfo.item2).getId();
        AccountOrgPairVO pairVO = new AccountOrgPairVO(accNumber, orgId);
        LOG.info(String.format("AccOrgNodeRecursiveTask execute auto-failed: acc: %s,  org: %s", accNumber, orgId));
        return TaskExecutionResult.fastFail(pairVO, BDCommonResource.getMessageConstantsE003Text(), "E003");
    }

    @Override
    public Optional<TaskExecutionResult<AccountOrgPairVO>> validateBeforeExecution(AccountContext taskContext) {
        Tuple<BiTreeNode<String, AccountVO>, BiTreeNode<Long, OrgVO>> data = taskContext.getData();
        BiTreeNode accountNode = (BiTreeNode)data.item1;
        BiTreeNode orgNode = (BiTreeNode)data.item2;
        AssistAddingContext context = taskContext.getAssistAddingContext();
        Optional<MessageVO> validateMsg = this.isValidBeforeExecution(accountNode, orgNode, context);
        if (validateMsg.isPresent()) {
            LOG.info(String.format("AccOrgNodeRecursiveTask org : %s, account \uff1a%s, validate msg is : %s", orgNode.getId(), accountNode.getId(), validateMsg.get()));
            if (validateMsg.get().getType() == MessageVO.Type.FAILED) {
                return Optional.of(TaskExecutionResult.failed(new AccountOrgPairVO((String)accountNode.getId(), (Long)orgNode.getId()), validateMsg.get().getName(), validateMsg.get().getCode()));
            }
            if (validateMsg.get().getType() == MessageVO.Type.SKIP) {
                return Optional.of(TaskExecutionResult.skipped(new AccountOrgPairVO((String)accountNode.getId(), (Long)orgNode.getId()), validateMsg.get().getName(), validateMsg.get().getCode()));
            }
            if (validateMsg.get().getType() == MessageVO.Type.DELAY) {
                DependBiTreeNode curNode = (DependBiTreeNode)taskContext.getBindNode();
                while (Objects.nonNull(curNode.getParent())) {
                    curNode = (DependBiTreeNode)curNode.getParent();
                    if (!((String)accountNode.getId()).equals(((AccountContext)curNode.getData()).getAccountNumber()) || validateMsg.get().getProxyOrgId().longValue() != ((AccountContext)curNode.getData()).getOrgId()) continue;
                    ((DependBiTreeNode)taskContext.getBindNode()).setProxyNode(curNode);
                    break;
                }
                return Optional.of(TaskExecutionResult.delay(new AccountOrgPairVO((String)accountNode.getId(), (Long)orgNode.getId()), validateMsg.get().getName(), validateMsg.get().getCode()));
            }
            return Optional.of(TaskExecutionResult.failed(new AccountOrgPairVO((String)accountNode.getId(), (Long)orgNode.getId()), validateMsg.get().getName(), validateMsg.get().getCode()));
        }
        LOG.info(String.format("AccOrgNodeRecursiveTask org : %s, account \uff1a%s, validate success", orgNode.getId(), accountNode.getId()));
        return Optional.empty();
    }

    @Override
    public TaskExecutionResult<AccountOrgPairVO> execute(AccountContext taskContext) {
        Tuple<BiTreeNode<String, AccountVO>, BiTreeNode<Long, OrgVO>> data = taskContext.getData();
        return this.validateBeforeExecution(taskContext).orElseGet(() -> {
            BiTreeNode accountNode = (BiTreeNode)data.item1;
            BiTreeNode orgNode = (BiTreeNode)data.item2;
            return new TaskExecutionResult<AccountOrgPairVO>(new AccountOrgPairVO((String)accountNode.getId(), (Long)orgNode.getId()));
        });
    }

    private Optional<MessageVO> isValidBeforeExecution(BiTreeNode<String, AccountVO> accountNode, BiTreeNode<Long, OrgVO> orgNode, AssistAddingContext context) {
        boolean isVersionedAfterDate;
        if (this.getClass() != AccountAddingAssistValidateTaskImpl.class && accountNode.getParent() == null && orgNode.getParent() == null) {
            return Optional.of(MessageVO.of("S006", BDCommonResource.getMeesageConstantsS006Text(), MessageVO.Type.SKIP));
        }
        Date versionDate = context.getVersionDate();
        AccountVO account = accountNode.getData();
        String accountNumber = account.getNumber();
        long orgId = orgNode.getId();
        OrgVO org = orgNode.getData();
        Optional<DynamicObject> accDyn = this.getCurrentAccountDynObj(accountNumber, orgId, context);
        if (!accDyn.isPresent()) {
            return Optional.of(MessageVO.of("S001", String.format(BDCommonResource.getMessageConstantsS001Text(), org.getName(), accountNumber), MessageVO.Type.SKIP));
        }
        long accountId = accDyn.get().getLong("id");
        boolean isCreateOrgId = this.isCreateOrgId(accDyn.get(), orgId);
        boolean isIncludeAssist = this.isIncludeAssist(orgId, accountNumber, context.getOrgIdAccountIncudeAssistMap());
        if (isIncludeAssist) {
            return Optional.of(MessageVO.of("S002", String.format(BDCommonResource.getMessageConstantsS002Text(), org.getName(), accountNumber), MessageVO.Type.SKIP));
        }
        PeriodStateEnum stateEnum = BDUtil.getCurVersionState(context.getPeriodMap(), context.getPeriodTypeIds(), versionDate, accDyn.get().getDate("startdate"));
        if (PeriodStateEnum.BOTH == stateEnum) {
            return Optional.of(MessageVO.of("E005", BDCommonResource.getMessageConstantsE005Text(), MessageVO.Type.FAILED));
        }
        if (PeriodStateEnum.ALL_NO == stateEnum && (isVersionedAfterDate = this.isVersionAferDate(accDyn.get(), versionDate))) {
            return Optional.of(MessageVO.of("E001", BDCommonResource.getMessageConstantsE001Text(), MessageVO.Type.FAILED));
        }
        Optional<String> isAfterDateExistsBiz = this.isBizAfterDate(orgId, accDyn.get().getLong("id"), context);
        if (isAfterDateExistsBiz.isPresent()) {
            return Optional.of(MessageVO.of("E002", BDCommonResource.getMessageConstantsE002Text() + isAfterDateExistsBiz.get(), MessageVO.Type.FAILED));
        }
        if (!isCreateOrgId) {
            long callPersonalizeOpOrgId = this.getCallPersonalizeOpOrgId(orgNode, accountId, context);
            DynamicObject orgDyn = context.getOrgIdDynObjMap().get(callPersonalizeOpOrgId);
            if (callPersonalizeOpOrgId != orgId) {
                return Optional.of(MessageVO.ofDelay("S004", String.format(BDCommonResource.getMessageConstantsS004Text(), org.getName(), accountNumber, orgDyn.getString("name")), callPersonalizeOpOrgId));
            }
        }
        return Optional.empty();
    }

    protected Optional<DynamicObject> getCurrentAccountDynObj(String accountNumber, Long orgId, AssistAddingContext context) {
        Optional<Long> accountId = context.tryGetAccountIdByOrgAndAccNum(orgId, accountNumber);
        if (!accountId.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(context.getAccountIdDynObjMap().get(accountId.get()));
    }

    private boolean isIncludeAssist(long orgId, String accountNumber, Map<Long, Map<String, Boolean>> orgIdAccountIncudeAssistMap) {
        Map<String, Boolean> numberResultMap = orgIdAccountIncudeAssistMap.get(orgId);
        if (numberResultMap == null) {
            return false;
        }
        return numberResultMap.getOrDefault(accountNumber, Boolean.FALSE);
    }

    private boolean isVersionAferDate(DynamicObject accountDynObj, Date versionDate) {
        return accountDynObj.getDate("startdate").compareTo(versionDate) >= 0;
    }

    private Optional<String> isBizAfterDate(long orgId, long accountId, AssistAddingContext context) {
        Integer bizType = (Integer)context.getOrgIdAccountIdBizTable().get((Object)orgId, (Object)accountId);
        if (bizType != null && bizType > 0) {
            return Optional.of(AccountBizCheckUtil.BizType.withTypes(bizType).stream().map(AccountBizCheckUtil.BizType::getDesc).collect(Collectors.joining("\uff0c")));
        }
        return Optional.empty();
    }

    private boolean isCreateOrgId(DynamicObject accountDynObj, long useOrgId) {
        return accountDynObj.getLong("createorg_id") == useOrgId;
    }

    private long getCallPersonalizeOpOrgId(BiTreeNode<Long, OrgVO> orgNode, long accountId, AssistAddingContext context) {
        ArrayList<Long> parentUseOrgIdList = new ArrayList<Long>(10);
        this.getParentUseOrgIdList(orgNode, accountId, context, parentUseOrgIdList);
        if (parentUseOrgIdList.isEmpty()) {
            return orgNode.getId();
        }
        return (Long)parentUseOrgIdList.get(parentUseOrgIdList.size() - 1);
    }

    private void getParentUseOrgIdList(BiTreeNode<Long, OrgVO> sonNode, long accountId, AssistAddingContext context, List<Long> parentUseOrgIdList) {
        BiTreeNode parent = sonNode.getParent();
        if (parent != null) {
            boolean accountUseableOnOrg = this.isAccountUseableOnOrg(accountId, (Long)parent.getId(), context);
            if (!accountUseableOnOrg) {
                return;
            }
            parentUseOrgIdList.add((Long)parent.getId());
            this.getParentUseOrgIdList(parent, accountId, context, parentUseOrgIdList);
        }
    }

    protected boolean isAccountUseableOnOrg(long accountId, long orgId, AssistAddingContext context) {
        OrgAccOwnershipVO ownershipVO = context.getOrgAccNumberShip().get(orgId);
        if (Objects.isNull(ownershipVO)) {
            return false;
        }
        Map<String, Long> accountNumberIdMap = ownershipVO.getNumberLatestAccId();
        return accountNumberIdMap.containsValue(accountId);
    }
}

